/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.expression;

import flash.tools.debugger.expression.AddExp;
import flash.tools.debugger.expression.AndExp;
import flash.tools.debugger.expression.AssignmentExp;
import flash.tools.debugger.expression.DivExp;
import flash.tools.debugger.expression.DotExp;
import flash.tools.debugger.expression.EqExp;
import flash.tools.debugger.expression.GTEqExp;
import flash.tools.debugger.expression.GTExp;
import flash.tools.debugger.expression.IndirectionExp;
import flash.tools.debugger.expression.LShiftExp;
import flash.tools.debugger.expression.LTEqExp;
import flash.tools.debugger.expression.LTExp;
import flash.tools.debugger.expression.LogicAndExp;
import flash.tools.debugger.expression.LogicNotExp;
import flash.tools.debugger.expression.LogicOrExp;
import flash.tools.debugger.expression.ModExp;
import flash.tools.debugger.expression.MultExp;
import flash.tools.debugger.expression.NeqExp;
import flash.tools.debugger.expression.NonTerminalExp;
import flash.tools.debugger.expression.NotExp;
import flash.tools.debugger.expression.OrExp;
import flash.tools.debugger.expression.RShiftExp;
import flash.tools.debugger.expression.SubExp;
import flash.tools.debugger.expression.SubscriptExp;
import flash.tools.debugger.expression.UnknownOperationException;
import flash.tools.debugger.expression.XorExp;
import flash.util.Trace;
import java.util.HashMap;

public class Operator {
    public final int precedence;
    public final String name;
    public final String token;
    private final Class expressionNodeClass;
    private static HashMap mapTokenToOperator;
    public static final Operator CLOSE_BRACKET;
    public static final Operator CLOSE_PAREN;
    public static final Operator OPEN_BRACKET;
    public static final Operator OPEN_PAREN;
    public static final Operator UNKNOWN;
    public static final Operator ASSIGNMENT;
    public static final Operator LOGICAL_OR;
    public static final Operator LOGICAL_AND;
    public static final Operator BITWISE_OR;
    public static final Operator BITWISE_XOR;
    public static final Operator BITWISE_AND;
    public static final Operator RELATION_EQ;
    public static final Operator RELATION_NEQ;
    public static final Operator RELATION_LT;
    public static final Operator RELATION_GT;
    public static final Operator RELATION_LTEQ;
    public static final Operator RELATION_GTEQ;
    public static final Operator BITWISE_LSHIFT;
    public static final Operator BITWISE_RSHIFT;
    public static final Operator ARITH_ADD;
    public static final Operator ARITH_SUB;
    public static final Operator ARITH_MULT;
    public static final Operator ARITH_DIV;
    public static final Operator ARITH_MOD;
    public static final Operator INDIRECTION;
    public static final Operator LOGICAL_NOT;
    public static final Operator BITWISE_NOT;
    public static final Operator DIRECT_SELECT;
    public static final Operator SUBSCRIPT;
    static final /* synthetic */ boolean $assertionsDisabled;

    private Operator(int precedence, String name, String token, Class expressionNodeClass) {
        if (!$assertionsDisabled && name == null && token == null) {
            throw new AssertionError((Object)"Either the name or the token must be non-null");
        }
        if (!$assertionsDisabled && expressionNodeClass != null && !NonTerminalExp.class.isAssignableFrom(expressionNodeClass)) {
            throw new AssertionError((Object)"expressionNodeClass must be a subclass of NonTerminalExp");
        }
        if (token == null) {
            token = "";
        }
        if (name == null) {
            name = token;
        }
        this.precedence = precedence;
        this.name = name;
        this.token = token;
        this.expressionNodeClass = expressionNodeClass;
        if (token.length() > 0) {
            mapTokenToOperator.put(token, this);
        }
    }

    public String toString() {
        return this.name;
    }

    public NonTerminalExp createExpNode() throws UnknownOperationException {
        NonTerminalExp node;
        block5: {
            node = null;
            if (this.expressionNodeClass == null) {
                throw new UnknownOperationException(this);
            }
            try {
                node = (NonTerminalExp)this.expressionNodeClass.newInstance();
            }
            catch (InstantiationException e) {
                if (Trace.error) {
                    Trace.trace(e.getLocalizedMessage());
                }
            }
            catch (IllegalAccessException e) {
                if (!Trace.error) break block5;
                Trace.trace(e.getLocalizedMessage());
            }
        }
        return node;
    }

    public static Operator opFor(char firstCh, char secondCh, boolean isIndirectionOperatorAllowed) {
        String s = "" + firstCh + secondCh;
        Operator op = (Operator)mapTokenToOperator.get(s);
        if (op == null && (op = (Operator)mapTokenToOperator.get(s = "" + firstCh)) == null) {
            op = UNKNOWN;
        }
        if (isIndirectionOperatorAllowed && op == ARITH_MULT && (secondCh == '#' || Character.isJavaIdentifierStart(secondCh))) {
            op = INDIRECTION;
        }
        return op;
    }

    static {
        $assertionsDisabled = !Operator.class.desiredAssertionStatus();
        mapTokenToOperator = new HashMap();
        CLOSE_BRACKET = new Operator(-2, null, "]", null);
        CLOSE_PAREN = new Operator(-2, null, ")", null);
        OPEN_BRACKET = new Operator(-1, null, "[", null);
        OPEN_PAREN = new Operator(-1, null, "(", null);
        UNKNOWN = new Operator(0, "Operator.UNKNOWN", null, null);
        ASSIGNMENT = new Operator(2, null, "=", AssignmentExp.class);
        LOGICAL_OR = new Operator(4, null, "||", LogicOrExp.class);
        LOGICAL_AND = new Operator(5, null, "&&", LogicAndExp.class);
        BITWISE_OR = new Operator(6, null, "|", OrExp.class);
        BITWISE_XOR = new Operator(7, null, "^", XorExp.class);
        BITWISE_AND = new Operator(8, null, "&", AndExp.class);
        RELATION_EQ = new Operator(9, null, "==", EqExp.class);
        RELATION_NEQ = new Operator(9, null, "!=", NeqExp.class);
        RELATION_LT = new Operator(10, null, "<", LTExp.class);
        RELATION_GT = new Operator(10, null, ">", GTExp.class);
        RELATION_LTEQ = new Operator(10, null, "<=", LTEqExp.class);
        RELATION_GTEQ = new Operator(10, null, ">=", GTEqExp.class);
        BITWISE_LSHIFT = new Operator(11, null, "<<", LShiftExp.class);
        BITWISE_RSHIFT = new Operator(11, null, ">>", RShiftExp.class);
        ARITH_ADD = new Operator(12, null, "+", AddExp.class);
        ARITH_SUB = new Operator(12, null, "-", SubExp.class);
        ARITH_MULT = new Operator(13, null, "*", MultExp.class);
        ARITH_DIV = new Operator(13, null, "/", DivExp.class);
        ARITH_MOD = new Operator(13, null, "%", ModExp.class);
        INDIRECTION = new Operator(15, "Operator.INDIRECTION", null, IndirectionExp.class);
        LOGICAL_NOT = new Operator(15, null, "!", LogicNotExp.class);
        BITWISE_NOT = new Operator(15, null, "~", NotExp.class);
        DIRECT_SELECT = new Operator(17, null, ".", DotExp.class);
        SUBSCRIPT = new Operator(17, "Operator.SUBSCRIPT", null, SubscriptExp.class);
    }
}

