/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.util;

import flash.localization.LocalizationManager;
import flex2.compiler.CompilerException;
import flex2.compiler.ILocalizableMessage;
import flex2.compiler.util.ThreadLocalToolkit;

public class CompilerMessage
extends CompilerException
implements ILocalizableMessage {
    public String level;
    public String path;
    public int line;
    public int column;
    private boolean isPathAvailable;

    public CompilerMessage(String level, String path, int line, int col) {
        this.level = level;
        this.path = path;
        this.line = line;
        this.column = col;
        this.isPathAvailable = true;
    }

    public String getLevel() {
        return this.level;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public int getColumn() {
        return this.column;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public Exception getExceptionDetail() {
        return null;
    }

    public String getMessage() {
        String msg = super.getMessage();
        if (msg != null) {
            return msg;
        }
        LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
        if (l10n == null) {
            return null;
        }
        return l10n.getLocalizedTextString((Object)this);
    }

    public String toString() {
        return this.getMessage();
    }

    public boolean isPathAvailable() {
        return this.isPathAvailable;
    }

    protected void noPath() {
        this.isPathAvailable = false;
    }

    public static class CompilerInfo
    extends CompilerMessage {
        public CompilerInfo() {
            super("info", null, -1, -1);
        }
    }

    public static class CompilerWarning
    extends CompilerMessage {
        public CompilerWarning() {
            super("warning", null, -1, -1);
        }
    }

    public static class CompilerError
    extends CompilerMessage {
        public CompilerError() {
            super("error", null, -1, -1);
        }
    }
}

