/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.config;

import flash.localization.LocalizationManager;
import flex2.compiler.ILocalizableMessage;
import flex2.compiler.util.ThreadLocalToolkit;

public class ConfigurationException
extends Exception
implements ILocalizableMessage {
    public String var = null;
    public String source = null;
    public int line = -1;

    public ConfigurationException(String msg) {
        super(msg);
    }

    public ConfigurationException(String var, String source, int line) {
        this.var = var;
        this.source = source;
        this.line = line;
    }

    public String getLevel() {
        return "error";
    }

    public String getPath() {
        return this.source;
    }

    public void setPath(String path) {
        this.source = path;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public int getColumn() {
        return -1;
    }

    public void setColumn(int column) {
    }

    public Exception getExceptionDetail() {
        return null;
    }

    public boolean isPathAvailable() {
        return true;
    }

    public String getMessage() {
        String msg = super.getMessage();
        if (msg != null && msg.length() > 0) {
            return msg;
        }
        LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
        if (l10n == null) {
            return null;
        }
        return l10n.getLocalizedTextString((Object)this);
    }

    public String toString() {
        return this.getMessage();
    }

    public static class BadDefinition
    extends ConfigurationException {
        public String argument;

        public BadDefinition(String argument, String var, String source, int line) {
            super(var, source, line);
            this.argument = argument;
        }
    }

    public static class FileTooBig
    extends ConfigurationException {
        public String path;

        public FileTooBig(String path, String var, String source, int line) {
            super(var, source, line);
            this.path = path;
        }
    }

    public static class BadVersion
    extends ConfigurationException {
        public String version;

        public BadVersion(String version, String var) {
            super(var, null, -1);
            this.version = version;
        }
    }

    public static class BadAppendValue
    extends ConfigurationException {
        public BadAppendValue(String var, String source, int line) {
            super(var, source, line);
        }
    }

    public static class UnexpectedArgument
    extends ConfigurationException {
        public String argument;
        public String expected;

        public UnexpectedArgument(String expected, String argument, String var, String source, int line) {
            super(var, source, line);
            this.expected = expected;
            this.argument = argument;
        }
    }

    public static class MissingArgument
    extends ConfigurationException {
        public String argument;

        public MissingArgument(String argument, String var, String source, int line) {
            super(var, source, line);
            this.argument = argument;
        }
    }

    public static class UnexpectedCDATA
    extends ConfigurationException {
        public UnexpectedCDATA(String source, int line) {
            super(null, source, line);
        }
    }

    public static class IncorrectElement
    extends ConfigurationException {
        public String expected;
        public String found;

        public IncorrectElement(String expected, String found, String source, int line) {
            super(null, source, line);
            this.expected = expected;
            this.found = found;
        }
    }

    public static class UnexpectedElement
    extends ConfigurationException {
        public String found;

        public UnexpectedElement(String found, String source, int line) {
            super(null, source, line);
            this.found = found;
        }
    }

    public static class NotAFile
    extends ConfigurationException {
        public String path;

        public NotAFile(String path, String var, String source, int line) {
            super(var, source, line);
            this.path = path;
        }
    }

    public static class NotDirectory
    extends ConfigurationException {
        public String path;

        public NotDirectory(String path, String var, String source, int line) {
            super(var, source, line);
            this.path = path;
        }
    }

    public static class IOError
    extends ConfigurationIOError {
        public IOError(String path) {
            super(path, null, null, -1);
        }
    }

    public static class ConfigurationIOError
    extends ConfigurationException {
        public String path;

        public ConfigurationIOError(String path, String var, String source, int line) {
            super(var, source, line);
            this.path = path;
        }
    }

    public static class TypeMismatch
    extends BadValue {
        public static final String BOOLEAN = "Boolean";
        public static final String INTEGER = "Integer";
        public static final String LONG = "Long";
        public String id;

        public TypeMismatch(String type, String value, String var, String source, int line) {
            super(value, var, source, line);
            this.id = type;
        }
    }

    public static class BadValue
    extends ConfigurationException {
        public String value;

        public BadValue(String value, String var, String source, int line) {
            super(var, source, line);
            this.value = value;
        }
    }

    public static class OtherThrowable
    extends ConfigurationException {
        public Throwable throwable;

        public OtherThrowable(Throwable t, String var, String source, int line) {
            super(var, source, line);
            this.throwable = t;
        }
    }

    public static class MissingRequirement
    extends ConfigurationException {
        public String required;

        public MissingRequirement(String required, String var, String source, int line) {
            super(null, source, line);
            this.required = required;
        }
    }

    public static class VariableMissingRequirement
    extends ConfigurationException {
        public String required;

        public VariableMissingRequirement(String required, String var, String source, int line) {
            super(var, source, line);
            this.required = required;
        }
    }

    public static class IncorrectArgumentCount
    extends ConfigurationException {
        public int expected;
        public int passed;

        public IncorrectArgumentCount(int expected, int passed, String var, String source, int line) {
            super(var, source, line);
            this.expected = expected;
            this.passed = passed;
        }
    }

    public static class Token
    extends ConfigurationException {
        public static final String MISSING_DELIMITER = "MissingDelimiter";
        public static final String MULTIPLE_VALUES = "MultipleValues";
        public static final String UNKNOWN_TOKEN = "UnknownToken";
        public static final String RECURSION_LIMIT = "RecursionLimit";
        public static final String INSUFFICIENT_ARGS = "InsufficientArgs";
        public String id;
        public String token;

        public Token(String id, String token, String var, String source, int line) {
            super(var, source, line);
            this.token = token;
            this.id = id;
        }
    }

    public static class AmbiguousParse
    extends ConfigurationException {
        public String defaultvar;

        public AmbiguousParse(String defaultvar, String var, String source, int line) {
            super(var, source, line);
            this.defaultvar = defaultvar;
        }
    }

    public static class InterspersedDefaults
    extends ConfigurationException {
        public InterspersedDefaults(String var, String source, int line) {
            super(var, source, line);
        }
    }

    public static class UnexpectedDefaults
    extends ConfigurationException {
        public UnexpectedDefaults(String var, String source, int line) {
            super(var, source, line);
        }
    }

    public static class IllegalMultipleSet
    extends ConfigurationException {
        public IllegalMultipleSet(String var, String source, int line) {
            super(var, source, line);
        }
    }

    public static class UnknownVariable
    extends ConfigurationException {
        public UnknownVariable(String var, String source, int line) {
            super(var, source, line);
        }
    }
}

