/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3.genext;

import flex2.compiler.SymbolTable;
import flex2.compiler.as3.binding.ClassInfo;
import flex2.compiler.as3.reflect.NodeMagic;
import flex2.compiler.util.MultiName;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.QName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.asc.parser.DefinitionNode;
import macromedia.asc.parser.FunctionDefinitionNode;
import macromedia.asc.parser.VariableDefinitionNode;
import macromedia.asc.util.Context;

public abstract class GenerativeClassInfo {
    private String className;
    private Map accessorMap;
    private ClassInfo classInfo;
    protected Context context;
    protected SymbolTable symbolTable;
    static /* synthetic */ Class class$flex2$compiler$as3$genext$GenerativeClassInfo;

    public GenerativeClassInfo(Context context, SymbolTable symbolTable) {
        this.context = context;
        this.symbolTable = symbolTable;
    }

    public abstract boolean needsAdditionalInterfaces();

    public void addAccessorVariable(VariableDefinitionNode node, boolean explicit) {
        if (this.accessorMap == null) {
            this.accessorMap = new LinkedHashMap();
        }
        QName qName = new QName(NodeMagic.getUserNamespace(node), NodeMagic.getVariableName(node));
        VariableInfo variableInfo = new VariableInfo(qName, node, explicit);
        if (node.attrs != null && node.attrs.hasAttribute("static")) {
            variableInfo.isStatic = true;
        }
        this.accessorMap.put(qName, variableInfo);
    }

    public void addAccessorFunction(FunctionDefinitionNode node, boolean explicit, boolean isGetter) {
        QName qName;
        AccessorInfo info;
        if (this.accessorMap == null) {
            this.accessorMap = new HashMap();
        }
        if ((info = (AccessorInfo)this.accessorMap.get(qName = new QName(NodeMagic.getUserNamespace(node), NodeMagic.getFunctionName(node)))) == null || !(info instanceof GetterSetterInfo)) {
            info = new GetterSetterInfo(qName, node, explicit);
            this.accessorMap.put(qName, info);
        }
        if (isGetter) {
            ((GetterSetterInfo)info).setGetterInfo(node);
        } else {
            ((GetterSetterInfo)info).setSetterInfo(node);
        }
    }

    public void removeAccessor(QName qName) {
        if (this.accessorMap != null) {
            this.accessorMap.remove(qName);
        }
    }

    public abstract void removeOriginalMetaData(DefinitionNode var1);

    public boolean hasAccessor(String id) {
        return this.hasAccessor(new QName(id));
    }

    public boolean hasAccessor(QName qName) {
        return this.accessorMap != null && this.accessorMap.containsKey(qName);
    }

    public AccessorInfo getAccessor(String id) {
        return this.getAccessor(new QName(id));
    }

    public AccessorInfo getAccessor(QName qName) {
        AccessorInfo result = null;
        if (this.accessorMap != null) {
            result = (AccessorInfo)this.accessorMap.get(qName);
        }
        return result;
    }

    public Map getAccessors() {
        return this.accessorMap;
    }

    public ClassInfo getClassInfo() {
        return this.classInfo;
    }

    public String getClassName() {
        return this.className;
    }

    public Set getImports() {
        HashSet<String> imports = new HashSet<String>();
        if (this.accessorMap != null) {
            boolean addAllImports = false;
            Iterator<Object> iterator = this.accessorMap.values().iterator();
            while (iterator.hasNext()) {
                AccessorInfo accessorInfo = (AccessorInfo)iterator.next();
                String typeName = accessorInfo.getTypeName();
                MultiName multiName = this.classInfo.getMultiName(typeName);
                if (multiName.getNamespace().length == 1) {
                    QName qName = multiName.getQName(0);
                    String className = qName.getLocalPart();
                    int lessThanIndex = className.indexOf("<");
                    if (lessThanIndex != -1) {
                        int greaterThanIndex = className.lastIndexOf(">");
                        if (greaterThanIndex == -1) continue;
                        String elementTypeName = className.substring(lessThanIndex + 1, greaterThanIndex);
                        imports.add(NameFormatter.toDot(elementTypeName));
                        continue;
                    }
                    imports.add(NameFormatter.toDot(qName));
                    continue;
                }
                addAllImports = true;
            }
            if (addAllImports) {
                iterator = this.classInfo.getImports().iterator();
                while (iterator.hasNext()) {
                    imports.add(iterator.next() + ".*");
                }
            }
        }
        return imports;
    }

    public void setClassInfo(ClassInfo classInfo) {
        this.classInfo = classInfo;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    private static String mangledPrefix(String s) {
        return "_" + Math.abs(s.hashCode());
    }

    public static String mangledName(String s) {
        return GenerativeClassInfo.mangledPrefix(s) + s;
    }

    private String toString(QName qName) {
        String namespace = qName.getNamespace();
        String result = namespace != null && namespace.length() > 0 ? namespace + "." + qName.getLocalPart() : qName.getLocalPart();
        return result;
    }

    public class GetterSetterInfo
    extends AccessorInfo {
        private int getterPos;
        private int setterPos;
        private List getterMetaData;
        private List setterMetaData;
        static final /* synthetic */ boolean $assertionsDisabled;

        public GetterSetterInfo(QName qName, FunctionDefinitionNode node, boolean isExplicit) {
            super(qName, null, node, isExplicit);
            this.setterPos = -1;
            this.getterPos = -1;
            this.setterMetaData = null;
            this.getterMetaData = null;
        }

        public void setGetterInfo(FunctionDefinitionNode node) {
            if (!$assertionsDisabled && !NodeMagic.functionIsGetter(node)) {
                throw new AssertionError();
            }
            this.typeName = NodeMagic.getFunctionTypeName(node);
            this.getterPos = node.pos();
            this.getterMetaData = NodeMagic.getMetaData(node);
        }

        public void setSetterInfo(FunctionDefinitionNode node) {
            if (!$assertionsDisabled && !NodeMagic.functionIsSetter(node)) {
                throw new AssertionError();
            }
            this.typeName = NodeMagic.getFunctionParamTypeName(node, 0);
            this.setterPos = node.pos();
            this.setterMetaData = NodeMagic.getMetaData(node);
        }

        public int getGetterPosition() {
            return this.getterPos;
        }

        public int getSetterPosition() {
            return this.setterPos;
        }

        public List getGetterMetaData() {
            return this.getterMetaData != null ? this.getterMetaData : Collections.EMPTY_LIST;
        }

        public List getSetterMetaData() {
            return this.setterMetaData != null ? this.setterMetaData : Collections.EMPTY_LIST;
        }

        public boolean getIsFunction() {
            return true;
        }

        static {
            $assertionsDisabled = !(class$flex2$compiler$as3$genext$GenerativeClassInfo == null ? (class$flex2$compiler$as3$genext$GenerativeClassInfo = GenerativeClassInfo.class$("flex2.compiler.as3.genext.GenerativeClassInfo")) : class$flex2$compiler$as3$genext$GenerativeClassInfo).desiredAssertionStatus();
        }
    }

    public class VariableInfo
    extends AccessorInfo {
        private int position;
        private List metaData;

        public VariableInfo(QName qName, VariableDefinitionNode node, boolean isExplicit) {
            super(qName, NodeMagic.getVariableTypeName(node), node, isExplicit);
            this.position = node.pos();
            this.metaData = NodeMagic.getMetaData(node);
        }

        public int getPosition() {
            return this.position;
        }

        public List getMetaData() {
            return this.metaData;
        }

        public boolean getIsFunction() {
            return false;
        }
    }

    public abstract class AccessorInfo {
        private QName qName;
        private String backingPrefix;
        protected String typeName;
        private ArrayList attributes;
        private boolean isExplicit;
        public boolean isStatic;
        private DefinitionNode definitionNode;

        public AccessorInfo(QName qName, String typeName, DefinitionNode definitionNode, boolean isExplicit) {
            this.qName = qName;
            this.backingPrefix = GenerativeClassInfo.mangledPrefix(qName.getLocalPart());
            this.typeName = typeName;
            this.definitionNode = definitionNode;
            this.isExplicit = isExplicit;
            List attributes = NodeMagic.getAttributes(definitionNode);
            this.attributes = attributes instanceof ArrayList ? (ArrayList)attributes : new ArrayList(attributes);
        }

        public String getPropertyName() {
            return this.qName.getLocalPart();
        }

        public String getUserNamespace() {
            return this.qName.getNamespace();
        }

        public String getBackingPrefix() {
            return this.backingPrefix;
        }

        public String getBackingPropertyName() {
            return this.backingPrefix + this.qName.getLocalPart();
        }

        public String getTypeName() {
            return this.typeName;
        }

        public List getAttributes() {
            return this.attributes;
        }

        public String getAttributeString() {
            String result = "";
            if (this.attributes != null) {
                Iterator iter = this.attributes.iterator();
                while (iter.hasNext()) {
                    result = result + iter.next() + " ";
                }
                result = result.trim();
            }
            return result;
        }

        public boolean getIsExplicit() {
            return this.isExplicit;
        }

        public boolean getIsStatic() {
            return this.isStatic;
        }

        public abstract boolean getIsFunction();

        protected String getQualifier() {
            return this.getUserNamespace().length() > 0 ? this.getUserNamespace() + "::" : "";
        }

        public String getQualifiedPropertyName() {
            return this.getQualifier() + this.getPropertyName();
        }

        public String getQualifiedBackingPropertyName() {
            return this.getQualifier() + this.getBackingPropertyName();
        }

        public DefinitionNode getDefinitionNode() {
            return this.definitionNode;
        }
    }
}

