/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools.oem;

import flex2.compiler.CompilerException;
import flex2.compiler.CompilerSwcContext;
import flex2.compiler.FileSpec;
import flex2.compiler.LicenseException;
import flex2.compiler.ResourceBundlePath;
import flex2.compiler.ResourceContainer;
import flex2.compiler.SourceList;
import flex2.compiler.SourcePath;
import flex2.compiler.SymbolTable;
import flex2.compiler.Transcoder;
import flex2.compiler.common.CompilerConfiguration;
import flex2.compiler.common.FontsConfiguration;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.i18n.I18nUtils;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.LocalFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.SwcCache;
import flex2.compiler.swc.SwcException;
import flex2.compiler.util.CompilerControl;
import flex2.compiler.util.MimeMappings;
import flex2.compiler.util.NameMappings;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.linker.ConsoleApplication;
import flex2.linker.FlexMovie;
import flex2.linker.LinkerException;
import flex2.linker.SimpleMovie;
import flex2.tools.API;
import flex2.tools.Compiler;
import flex2.tools.PostLink;
import flex2.tools.PreLink;
import flex2.tools.ToolsConfiguration;
import flex2.tools.oem.Builder;
import flex2.tools.oem.Configuration;
import flex2.tools.oem.LibraryCache;
import flex2.tools.oem.Logger;
import flex2.tools.oem.PathResolver;
import flex2.tools.oem.ProgressMeter;
import flex2.tools.oem.Report;
import flex2.tools.oem.VirtualLocalFile;
import flex2.tools.oem.internal.ApplicationCompilerConfiguration;
import flex2.tools.oem.internal.ApplicationData;
import flex2.tools.oem.internal.OEMConfiguration;
import flex2.tools.oem.internal.OEMReport;
import flex2.tools.oem.internal.OEMUtil;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class Application
implements Builder {
    private List files;
    private OEMConfiguration configuration;
    private Logger logger;
    private File output;
    private MimeMappings mimeMappings;
    private ProgressMeter meter;
    protected PathResolver resolver;
    private CompilerControl cc;
    private LibraryCache librarySwcCache;
    private boolean isGeneratedTargetFile;
    private ApplicationData data;
    private String cacheName;
    private String configurationReport;
    private List messages;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Application(File file) throws FileNotFoundException {
        this(file, null);
    }

    public Application(File file, LibraryCache cache) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException(FileUtil.getCanonicalPath(file));
        }
        this.init(new VirtualFile[]{new LocalFile(FileUtil.getCanonicalFile(file))});
        this.librarySwcCache = cache;
    }

    public Application(VirtualLocalFile file) {
        this.init(new VirtualFile[]{file});
    }

    public Application(VirtualLocalFile[] files) {
        this.init(files);
    }

    public Application() {
        this.init(new VirtualFile[0]);
    }

    private void init(VirtualFile[] files) {
        this.files = new ArrayList(files.length);
        int length = files.length;
        for (int i = 0; i < length; ++i) {
            this.files.add(files[i]);
        }
        this.configuration = null;
        this.logger = null;
        this.output = null;
        this.mimeMappings = new MimeMappings();
        this.meter = null;
        this.resolver = null;
        this.cc = new CompilerControl();
        this.isGeneratedTargetFile = false;
        this.data = null;
        this.cacheName = null;
        this.configurationReport = null;
        this.messages = new ArrayList();
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = (OEMConfiguration)configuration;
    }

    public Configuration getDefaultConfiguration() {
        return this.getDefaultConfiguration(false);
    }

    private Configuration getDefaultConfiguration(boolean processDefaults) {
        return OEMUtil.getApplicationConfiguration(this.constructCommandLine(null), false, OEMUtil.getLogger(this.logger, this.messages), this.resolver, this.mimeMappings, processDefaults);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public File getOutput() {
        return this.output;
    }

    public void setSupportedFileExtensions(String mimeType, String[] extensions) {
        this.mimeMappings.set(mimeType, extensions);
    }

    public void setProgressMeter(ProgressMeter meter) {
        this.meter = meter;
    }

    public void setPathResolver(PathResolver resolver) {
        this.resolver = resolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long build(boolean incremental) throws IOException {
        if (this.output != null) {
            Exception ex22;
            long l;
            OutputStream out;
            ByteArrayOutputStream tempOut;
            block19: {
                InputStream tempIn = null;
                tempOut = null;
                out = null;
                long size = 0L;
                try {
                    int result = this.compile(incremental);
                    if (result == 0 || result == Integer.MAX_VALUE || result == 1) {
                        tempOut = new ByteArrayOutputStream();
                        size = result == 1 || result == Integer.MAX_VALUE ? this.link(tempOut) : this.encode(tempOut);
                        tempOut.flush();
                        if (size > 0L) {
                            tempIn = new ByteArrayInputStream(tempOut.toByteArray());
                            out = new BufferedOutputStream(new FileOutputStream(this.output));
                            FileUtil.streamOutput(tempIn, out);
                        }
                    }
                    l = size;
                    Object var11_8 = null;
                    if (tempIn == null) break block19;
                }
                catch (Throwable throwable) {
                    Exception ex22;
                    Object var11_9 = null;
                    if (tempIn != null) {
                        try {
                            tempIn.close();
                        }
                        catch (Exception ex22) {
                            // empty catch block
                        }
                    }
                    if (tempOut != null) {
                        try {
                            tempOut.close();
                        }
                        catch (Exception ex22) {
                            // empty catch block
                        }
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Exception ex22) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                try {
                    tempIn.close();
                }
                catch (Exception ex22) {
                    // empty catch block
                }
            }
            if (tempOut != null) {
                try {
                    tempOut.close();
                }
                catch (Exception ex22) {
                    // empty catch block
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception ex22) {
                    // empty catch block
                }
            }
            return l;
        }
        return 0L;
    }

    public long build(OutputStream out, boolean incremental) throws IOException {
        int result = this.compile(incremental);
        if (result == 1 || result == Integer.MAX_VALUE) {
            return this.link(out);
        }
        if (result == 0) {
            return this.encode(out);
        }
        return 0L;
    }

    public void stop() {
        this.cc.stop();
    }

    public void clean() {
        this.clean(true, true, true, true, true);
    }

    public void load(InputStream in) throws IOException {
        this.cacheName = OEMUtil.load(in, this.cacheName);
        this.clean(true, false, false);
    }

    public long save(OutputStream out) throws IOException {
        return OEMUtil.save(out, this.cacheName, this.data);
    }

    public Report getReport() {
        OEMUtil.setupLocalizationManager();
        return new OEMReport(this.data == null ? null : this.data.sources, this.data == null ? null : this.data.movie, this.data == null ? null : this.data.configuration, this.configurationReport, this.messages);
    }

    private void setupFontManager(OEMConfiguration c) {
        if (c.configuration != null && this.data != null) {
            FontsConfiguration fontsConfiguration = c.configuration.getCompilerConfiguration().getFontsConfiguration();
            fontsConfiguration.setTopLevelManager(this.data.fontManager);
        }
    }

    private boolean setupSourceContainers(OEMConfiguration c) {
        ToolsConfiguration configuration = c.configuration;
        CompilerConfiguration compilerConfig = configuration.getCompilerConfiguration();
        VirtualFile[] asClasspath = compilerConfig.getSourcePath();
        boolean result = false;
        try {
            if (this.files.size() == 0) {
                ApplicationCompilerConfiguration acc = (ApplicationCompilerConfiguration)c.configuration;
                this.files.add(flex2.compiler.API.getVirtualFile(acc.getTargetFile()));
                this.isGeneratedTargetFile = true;
            } else if (this.isGeneratedTargetFile) {
                I18nUtils.regenerateResourceModule((ApplicationCompilerConfiguration)c.configuration);
            }
            VirtualFile targetFile = (VirtualFile)this.files.get(this.files.size() - 1);
            API.checkSupportedTargetMimeType(targetFile);
            this.data.fileSpec = new FileSpec(Collections.EMPTY_LIST, API.getFileSpecMimeTypes());
            this.data.sourceList = new SourceList(this.files, asClasspath, targetFile, API.getSourcePathMimeTypes());
            this.data.sourcePath = new SourcePath(asClasspath, targetFile, API.getSourcePathMimeTypes(), compilerConfig.allowSourcePathOverlap());
            this.data.resources = new ResourceContainer();
            this.data.bundlePath = new ResourceBundlePath(compilerConfig, targetFile);
            if (this.data.sources != null) {
                this.data.sources.clear();
            }
            if (this.data.units != null) {
                this.data.units.clear();
            }
            if (this.data.swcDefSignatureChecksums != null) {
                this.data.swcDefSignatureChecksums.clear();
            }
            if (this.data.swcFileChecksums != null) {
                this.data.swcFileChecksums.clear();
            }
            result = true;
        }
        catch (CompilerException ex) {
            if (!$assertionsDisabled && ThreadLocalToolkit.errorCount() <= 0) {
                throw new AssertionError();
            }
        }
        catch (ConfigurationException e) {
            ThreadLocalToolkit.logInfo(e.getMessage());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean loadCompilationUnits(OEMConfiguration c, CompilerSwcContext swcContext, int[] checksums) {
        ToolsConfiguration configuration = c.configuration;
        if (this.data.cacheName == null) {
            return true;
        }
        RandomAccessFile cacheFile = null;
        cacheFile = new RandomAccessFile(this.data.cacheName, "r");
        this.data.sources = new ArrayList();
        this.data.units = new ArrayList();
        this.data.swcDefSignatureChecksums = new HashMap();
        this.data.swcFileChecksums = new HashMap();
        flex2.compiler.API.loadCompilationUnits(configuration, this.data.fileSpec, this.data.sourceList, this.data.sourcePath, this.data.resources, this.data.bundlePath, this.data.sources, this.data.units, checksums, this.data.swcDefSignatureChecksums, this.data.swcFileChecksums, cacheFile, this.data.cacheName, this.data.fontManager);
        Object var9_6 = null;
        if (cacheFile == null) return true;
        try {
            cacheFile.close();
            return true;
        }
        catch (IOException ex2) {}
        return true;
        {
            catch (FileNotFoundException ex) {
                ThreadLocalToolkit.logInfo(ex.getMessage());
                Object var9_7 = null;
                if (cacheFile == null) return true;
                try {
                    cacheFile.close();
                    return true;
                }
                catch (IOException ex2) {}
                return true;
            }
            catch (IOException ex) {
                ThreadLocalToolkit.logInfo(ex.getMessage());
                if (!this.setupSourceContainers(c)) {
                    boolean bl = false;
                    Object var9_8 = null;
                    if (cacheFile == null) return bl;
                    try {
                        cacheFile.close();
                        return bl;
                    }
                    catch (IOException ex2) {
                        // empty catch block
                    }
                    return bl;
                }
                try {
                    Object var9_9 = null;
                    if (cacheFile == null) return true;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    if (cacheFile == null) throw throwable;
                    try {
                        cacheFile.close();
                        throw throwable;
                    }
                    catch (IOException ex2) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    cacheFile.close();
                    return true;
                }
                catch (IOException ex2) {}
                return true;
            }
        }
    }

    protected int compile(boolean incremental) {
        this.messages.clear();
        if (this.data == null || !incremental) {
            return this.recompile(false);
        }
        OEMConfiguration c = this.configuration == null ? (OEMConfiguration)this.getDefaultConfiguration(true) : OEMUtil.getApplicationConfiguration(this.constructCommandLine(this.configuration), this.configuration.keepLinkReport(), OEMUtil.getLogger(this.logger, this.messages), this.resolver, this.mimeMappings);
        if (c == null) {
            this.clean(false, false, false);
            return -1;
        }
        if (this.configuration != null && this.configuration.keepConfigurationReport()) {
            this.configurationReport = OEMUtil.formatConfigurationBuffer(c.cfgbuf);
        }
        this.setupFontManager(c);
        if (this.configuration != null) {
            this.configuration.cfgbuf = c.cfgbuf;
        }
        this.cc.run();
        OEMUtil.init(OEMUtil.getLogger(this.logger, this.messages), this.mimeMappings, this.meter, this.resolver, this.cc);
        Map licenseMap = OEMUtil.getLicenseMap(c.configuration);
        flex2.compiler.API.setupHeadless(c.configuration);
        CompilerConfiguration compilerConfig = c.configuration.getCompilerConfiguration();
        NameMappings mappings = flex2.compiler.API.getNameMappings(c.configuration);
        Transcoder[] transcoders = API.getTranscoders(c.configuration);
        flex2.compiler.Compiler[] compilers = API.getCompilers(compilerConfig, mappings, transcoders);
        CompilerSwcContext swcContext = new CompilerSwcContext(false, true, c.configuration.getCompatibilityVersionString());
        try {
            swcContext.load(compilerConfig.getLibraryPath(), flex2.compiler.common.Configuration.getAllExcludedLibraries(compilerConfig, c.configuration), compilerConfig.getThemeFiles(), compilerConfig.getIncludeLibraries(), mappings, I18nUtils.getTranslationFormat(compilerConfig), this.data.swcCache);
        }
        catch (SwcException ex) {
            this.clean(false, false, false);
            return -1;
        }
        if (this.librarySwcCache != null && this.librarySwcCache.getSwcCache() != this.data.swcCache) {
            this.librarySwcCache.setSwcCache(this.data.swcCache);
        }
        this.data.includes = new HashSet(swcContext.getIncludes());
        this.data.excludes = new HashSet(swcContext.getExterns());
        c.configuration.addExterns(swcContext.getExterns());
        c.configuration.addIncludes(swcContext.getIncludes());
        c.configuration.getCompilerConfiguration().addDefaultsCssFiles(swcContext.getDefaultsStyleSheets());
        c.configuration.getCompilerConfiguration().addThemeCssFiles(swcContext.getThemeStyleSheets());
        if (OEMUtil.isRecompilationNeeded(this.data, swcContext, c)) {
            this.data.resources = new ResourceContainer();
            this.clean(true, false, false);
            return this.recompile(true);
        }
        this.data.sourcePath.clearCache();
        this.data.bundlePath.clearCache();
        this.data.resources.refresh();
        int count = flex2.compiler.API.validateCompilationUnits(this.data.fileSpec, this.data.sourceList, this.data.sourcePath, this.data.bundlePath, this.data.resources, swcContext, this.data.perCompileData, false, c.configuration);
        if (count > 0 || this.data.swcChecksum != swcContext.checksum()) {
            this.data.configuration = c.configuration;
            this.data.linkChecksum = c.cfgbuf.link_checksum_ts();
            this.data.swcChecksum = swcContext.checksum();
            SymbolTable symbolTable = new SymbolTable(this.data.perCompileData);
            this.data.sources = new ArrayList();
            this.data.units = this.compile(compilers, swcContext, symbolTable, licenseMap, this.data.sources, c);
            boolean forcedToStop = flex2.compiler.API.forcedToStop();
            if (this.data.units == null || forcedToStop) {
                this.data.sources = null;
            }
            this.clean(false, false, false);
            return this.data.units != null && !forcedToStop ? 1 : -1;
        }
        int retVal = 0;
        if (this.data != null) {
            flex2.compiler.API.displayWarnings(this.data.units);
            if (this.data.linkChecksum != c.cfgbuf.link_checksum_ts()) {
                retVal = Integer.MAX_VALUE;
            }
        } else {
            retVal = Integer.MAX_VALUE;
        }
        this.data.linkChecksum = c.cfgbuf.link_checksum_ts();
        this.data.swcChecksum = swcContext.checksum();
        if (flex2.compiler.API.forcedToStop()) {
            retVal = -1;
        }
        if (retVal == Integer.MAX_VALUE) {
            this.clean(false, false, false, false, false);
        } else {
            this.clean(false, false, false);
        }
        return retVal;
    }

    private int recompile(boolean fullRecompile) {
        OEMConfiguration c = this.configuration == null ? (OEMConfiguration)this.getDefaultConfiguration(true) : OEMUtil.getApplicationConfiguration(this.constructCommandLine(this.configuration), this.configuration.keepLinkReport(), OEMUtil.getLogger(this.logger, this.messages), this.resolver, this.mimeMappings);
        if (c == null) {
            this.clean(false, false, false);
            return -1;
        }
        if (this.configuration != null && this.configuration.keepConfigurationReport()) {
            this.configurationReport = OEMUtil.formatConfigurationBuffer(c.cfgbuf);
        }
        if (this.configuration != null) {
            this.configuration.cfgbuf = c.cfgbuf;
        }
        this.cc.run();
        OEMUtil.init(OEMUtil.getLogger(this.logger, this.messages), this.mimeMappings, this.meter, this.resolver, this.cc);
        Map licenseMap = OEMUtil.getLicenseMap(c.configuration);
        this.data = new ApplicationData();
        this.data.configuration = c.configuration;
        this.data.cacheName = this.cacheName;
        flex2.compiler.API.setupHeadless(c.configuration);
        CompilerConfiguration compilerConfig = c.configuration.getCompilerConfiguration();
        NameMappings mappings = flex2.compiler.API.getNameMappings(c.configuration);
        this.data.fontManager = compilerConfig.getFontsConfiguration().getTopLevelManager();
        Transcoder[] transcoders = API.getTranscoders(c.configuration);
        flex2.compiler.Compiler[] compilers = API.getCompilers(compilerConfig, mappings, transcoders);
        if (!this.setupSourceContainers(c)) {
            this.clean(true, false, false);
            return -1;
        }
        if (this.librarySwcCache != null) {
            this.data.swcCache = this.librarySwcCache.getSwcCache();
            if (this.data.swcCache != null) {
                this.data.swcCache.cleanExtraData();
            }
        }
        if (this.data.swcCache == null) {
            this.data.swcCache = new SwcCache();
        }
        CompilerSwcContext swcContext = new CompilerSwcContext(true, true, c.configuration.getCompatibilityVersionString());
        try {
            swcContext.load(compilerConfig.getLibraryPath(), flex2.compiler.common.Configuration.getAllExcludedLibraries(compilerConfig, c.configuration), compilerConfig.getThemeFiles(), compilerConfig.getIncludeLibraries(), mappings, I18nUtils.getTranslationFormat(compilerConfig), this.data.swcCache);
        }
        catch (SwcException ex) {
            this.clean(false, false, false);
            return -1;
        }
        if (this.librarySwcCache != null && this.librarySwcCache.getSwcCache() != this.data.swcCache) {
            this.librarySwcCache.setSwcCache(this.data.swcCache);
        }
        this.data.includes = new HashSet(swcContext.getIncludes());
        this.data.excludes = new HashSet(swcContext.getExterns());
        c.configuration.addExterns(swcContext.getExterns());
        c.configuration.addIncludes(swcContext.getIncludes());
        c.configuration.getCompilerConfiguration().addDefaultsCssFiles(swcContext.getDefaultsStyleSheets());
        c.configuration.getCompilerConfiguration().addThemeCssFiles(swcContext.getThemeStyleSheets());
        this.data.cmdChecksum = c.cfgbuf.checksum_ts();
        this.data.linkChecksum = c.cfgbuf.link_checksum_ts();
        this.data.swcChecksum = swcContext.checksum();
        int[] checksums = new int[]{0, this.data.cmdChecksum, this.data.linkChecksum, this.data.swcChecksum};
        if (!fullRecompile) {
            if (!this.loadCompilationUnits(c, swcContext, checksums)) {
                this.clean(true, false, false);
                return -1;
            }
            this.data.checksum = checksums[0];
            if (this.data.units != null && this.data.units.size() > 0 && OEMUtil.isRecompilationNeeded(this.data, swcContext, c) && !this.setupSourceContainers(c)) {
                this.clean(true, false, false);
                return -1;
            }
        }
        int count = flex2.compiler.API.validateCompilationUnits(this.data.fileSpec, this.data.sourceList, this.data.sourcePath, this.data.bundlePath, this.data.resources, swcContext, null, false, c.configuration);
        SymbolTable symbolTable = SymbolTable.newSymbolTable(c.configuration);
        this.data.perCompileData = symbolTable.perCompileData;
        this.data.sources = new ArrayList();
        this.data.units = this.compile(compilers, swcContext, symbolTable, licenseMap, this.data.sources, c);
        this.data.checksum = OEMUtil.calculateChecksum(this.data, swcContext, c);
        boolean forcedToStop = flex2.compiler.API.forcedToStop();
        this.clean(this.data.units == null || forcedToStop, false, false);
        return this.data == null || this.data.units == null || forcedToStop ? -1 : 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List compile(flex2.compiler.Compiler[] compilers, CompilerSwcContext swcContext, SymbolTable symbolTable, Map licenseMap, List sources, OEMConfiguration OEMConfig) {
        List units = null;
        try {
            try {
                ApplicationCompilerConfiguration config = (ApplicationCompilerConfiguration)this.data.configuration;
                VirtualFile projector = config.getProjector();
                if (projector != null && projector.getName().endsWith("avmplus.exe")) {
                    units = flex2.compiler.API.compile(this.data.fileSpec, this.data.sourceList, null, this.data.sourcePath, this.data.resources, this.data.bundlePath, swcContext, symbolTable, this.data.configuration, compilers, null, licenseMap, sources);
                }
                units = flex2.compiler.API.compile(this.data.fileSpec, this.data.sourceList, null, this.data.sourcePath, this.data.resources, this.data.bundlePath, swcContext, symbolTable, this.data.configuration, compilers, new PreLink(), licenseMap, sources);
            }
            catch (LicenseException ex) {
                ThreadLocalToolkit.logError(ex.getMessage());
                Object var11_13 = null;
                this.data.sourcePath.clearCache();
                this.data.bundlePath.clearCache();
                this.data.resources.refresh();
                OEMUtil.saveSwcFileChecksums(swcContext, this.data, this.data.configuration);
                OEMUtil.saveSignatureChecksums(units, this.data, this.data.configuration);
                return units;
            }
            catch (CompilerException ex) {
                if (!$assertionsDisabled && ThreadLocalToolkit.errorCount() <= 0) {
                    throw new AssertionError();
                }
                Object var11_14 = null;
                this.data.sourcePath.clearCache();
                this.data.bundlePath.clearCache();
                this.data.resources.refresh();
                OEMUtil.saveSwcFileChecksums(swcContext, this.data, this.data.configuration);
                OEMUtil.saveSignatureChecksums(units, this.data, this.data.configuration);
                return units;
            }
            Object var11_12 = null;
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            this.data.sourcePath.clearCache();
            this.data.bundlePath.clearCache();
            this.data.resources.refresh();
            OEMUtil.saveSwcFileChecksums(swcContext, this.data, this.data.configuration);
            OEMUtil.saveSignatureChecksums(units, this.data, this.data.configuration);
            throw throwable;
        }
        this.data.sourcePath.clearCache();
        this.data.bundlePath.clearCache();
        this.data.resources.refresh();
        OEMUtil.saveSwcFileChecksums(swcContext, this.data, this.data.configuration);
        OEMUtil.saveSignatureChecksums(units, this.data, this.data.configuration);
        return units;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long link(OutputStream out) throws IOException {
        if (this.data == null || this.data.units == null) {
            return 0L;
        }
        boolean hasChanged = this.configuration == null ? false : this.configuration.hasChanged();
        flex2.compiler.common.Configuration config = null;
        if (hasChanged) {
            OEMConfiguration c = OEMUtil.getLinkerConfiguration(this.configuration.getLinkerOptions(), this.configuration.keepLinkReport(), OEMUtil.getLogger(this.logger, this.messages), this.mimeMappings, this.resolver, this.data.configuration, this.configuration.newLinkerOptionsAfterCompile, this.data.includes, this.data.excludes);
            if (c == null) {
                this.clean(false, false, false, false, false);
                return 0L;
            }
            config = c.configuration;
        } else {
            config = this.data.configuration;
        }
        long size = 0L;
        try {
            OEMUtil.init(OEMUtil.getLogger(this.logger, this.messages), this.mimeMappings, this.meter, this.resolver, this.cc);
            ApplicationCompilerConfiguration appConfig = (ApplicationCompilerConfiguration)this.data.configuration;
            VirtualFile projector = appConfig.getProjector();
            if (projector != null && projector.getName().endsWith("avmplus.exe")) {
                ConsoleApplication temp = this.data.app;
                this.data.app = flex2.linker.API.linkConsole(this.data.units, new PostLink(config), config);
                size = this.encodeConsoleProjector(projector, out);
                if (hasChanged && temp != null) {
                    this.data.app = temp;
                }
            } else {
                SimpleMovie temp = this.data.movie;
                this.data.movie = (FlexMovie)flex2.linker.API.link(this.data.units, new PostLink(config), config);
                long l = size = projector == null ? this.encode(out) : this.encodeProjector(projector, out);
                if (hasChanged && temp != null) {
                    this.data.movie = temp;
                }
            }
        }
        catch (LinkerException ex) {
            if (!$assertionsDisabled && ThreadLocalToolkit.errorCount() <= 0) {
                throw new AssertionError();
            }
        }
        finally {
            this.clean(false, false, false, true, false);
        }
        return size;
    }

    private long encode(OutputStream out) throws IOException {
        if (this.data == null || this.data.units == null || this.data.movie == null) {
            return 0L;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        flex2.compiler.API.encode(this.data.movie, (OutputStream)baos);
        long size = baos.size();
        baos.writeTo(out);
        out.flush();
        return size;
    }

    private long encodeProjector(VirtualFile projector, OutputStream out) throws IOException {
        if (this.data == null || this.data.units == null || this.data.movie == null) {
            return 0L;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        flex2.compiler.API.encode(this.data.movie, (OutputStream)baos);
        return Compiler.createProjector(projector, baos, out);
    }

    private long encodeConsoleProjector(VirtualFile projector, OutputStream out) throws IOException {
        if (this.data == null || this.data.units == null || this.data.app == null) {
            return 0L;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        flex2.compiler.API.encode(this.data.app, (OutputStream)baos);
        return Compiler.createProjector(projector, baos, out);
    }

    private void clean(boolean cleanData, boolean cleanCache, boolean cleanOutput) {
        this.clean(cleanData, cleanCache, cleanOutput, true, false);
    }

    private void clean(boolean cleanData, boolean cleanCache, boolean cleanOutput, boolean cleanConfig, boolean cleanMessages) {
        OEMUtil.clean();
        if (this.configuration != null && cleanConfig) {
            this.configuration.reset();
        }
        if (cleanData) {
            this.data = null;
            this.configurationReport = null;
        }
        if (cleanCache && this.cacheName != null) {
            File dead = FileUtil.openFile(this.cacheName);
            if (dead != null && dead.exists()) {
                dead.delete();
            }
            this.cacheName = null;
        }
        if (cleanOutput && this.output != null && this.output.exists()) {
            this.output.delete();
        }
        if (cleanMessages) {
            this.messages.clear();
        }
    }

    private String[] constructCommandLine(OEMConfiguration c) {
        String[] options = c != null ? c.getCompilerOptions() : new String[]{};
        String[] args = new String[options.length + this.files.size() + 1];
        System.arraycopy(options, 0, args, 0, options.length);
        args[options.length] = "--file-specs";
        int size = this.files.size();
        for (int i = 0; i < size; ++i) {
            args[options.length + 1 + i] = ((VirtualFile)this.files.get(i)).getName();
        }
        return args;
    }

    public LibraryCache getSwcCache() {
        return this.librarySwcCache;
    }

    public void setSwcCache(LibraryCache swcCache) {
        this.librarySwcCache = swcCache;
    }

    static {
        int len;
        $assertionsDisabled = !Application.class.desiredAssertionStatus();
        File[] list = null;
        try {
            File tempDir = File.createTempFile("Flex2_", "").getParentFile();
            list = tempDir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.startsWith("Flex2_");
                }
            });
        }
        catch (Throwable e) {
            // empty catch block
        }
        int n = len = list == null ? 0 : list.length;
        for (int i = 0; i < len; ++i) {
            try {
                list[i].delete();
                continue;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        URL url = Application.class.getProtectionDomain().getCodeSource().getLocation();
        try {
            File f = new File(new URI(url.toExternalForm()));
            if (f.getAbsolutePath().endsWith("flex-compiler-oem.jar")) {
                String applicationHome = f.getParentFile().getParent();
                System.setProperty("application.home", applicationHome);
            }
        }
        catch (URISyntaxException ex) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

