/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import macromedia.asc.util.ByteList;
import macromedia.asc.util.Decimal128Context;
import macromedia.asc.util.DenselyPackedDecimal;

public class Decimal128 {
    private static final byte DEC_NAN = 1;
    private static final byte DEC_SNAN = 2;
    private static final byte DEC_INF = 4;
    private static final byte DEC_NEG = 8;
    private static final byte DEC_SPECIAL = 7;
    private byte flags;
    private BigDecimal value;
    public static final int MAX_PRECISION = 34;
    public static final BigDecimal BigDecimalZERO = new BigDecimal("0");
    public static final Decimal128 ZERO = new Decimal128(BigDecimalZERO, 0);
    public static final Decimal128 NEGZERO = new Decimal128(BigDecimalZERO, 8);
    public static final Decimal128 ONE = new Decimal128(new BigDecimal("1"), 0);
    public static final Decimal128 NEG1 = new Decimal128(new BigDecimal("-1"), 8);
    public static final Decimal128 NaN = new Decimal128(BigDecimalZERO, 1);
    public static final Decimal128 INFINITY = new Decimal128(BigDecimalZERO, 4);
    public static final Decimal128 NEGINFINITY = new Decimal128(BigDecimalZERO, 12);
    private static final int[] mask = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023};
    private static final int DECIMAL128_Pmax = 34;
    private static final int DECIMAL128_Emax = 6144;
    private static final int DECIMAL128_Emin = -6143;
    private static final int DECIMAL128_Bias = 6176;
    private static final int DECIMAL128_Ehigh = 12287;

    private Decimal128() {
        this.flags = 0;
        this.value = BigDecimalZERO;
    }

    private Decimal128(BigDecimal val, byte flagval) {
        this.value = val;
        this.flags = flagval;
    }

    public Decimal128(String str) {
        this.flags = 0;
        this.parseDecimalNumber(str.toCharArray(), Decimal128Context.DECIMAL128);
    }

    public Decimal128(String str, Decimal128Context ctx) {
        this.flags = 0;
        this.parseDecimalNumber(str.toCharArray(), ctx);
    }

    public Decimal128(char[] in) {
        this.flags = 0;
        this.parseDecimalNumber(in, Decimal128Context.DECIMAL128);
    }

    public Decimal128(char[] in, Decimal128Context ctx) {
        this.flags = 0;
        this.parseDecimalNumber(in, ctx);
    }

    private void parseDecimalNumber(char[] in, Decimal128Context ctx) {
        block11: {
            boolean seenS = false;
            this.value = BigDecimalZERO;
            for (int i = 0; i < in.length; ++i) {
                char c = in[i];
                if (Character.isDigit(c) || c == '.') {
                    if (seenS) {
                        break;
                    }
                    break block11;
                }
                if (c == '+') {
                    if (!seenS) continue;
                    break;
                }
                if (c == '-') {
                    if (seenS) break;
                    this.flags = (byte)8;
                    continue;
                }
                if (c == 'S' || c == 's') {
                    if (seenS) break;
                    seenS = true;
                    continue;
                }
                if (c == 'N') {
                    if (i + 2 >= in.length || in[i + 1] != 'a' || in[i + 2] != 'N') break;
                    this.flags = (byte)(this.flags | (seenS ? 2 : 1));
                    if (i + 3 < in.length) {
                        for (int j = i + 3; j < in.length; ++j) {
                            if (Character.isDigit(in[j])) continue;
                            throw new IllegalArgumentException("invalid NaN payload");
                        }
                        this.value = new BigDecimal(in, i + 3, in.length - (i + 3), ctx.mathCtx());
                        if (this.value.precision() > 33) {
                            this.value = BigDecimalZERO;
                        }
                    }
                    return;
                }
                if (c != 'I') continue;
                if (seenS) break;
                if (i + 8 == in.length && in[i + 1] == 'n' && in[i + 2] == 'f' && in[i + 3] == 'i' && in[i + 4] == 'n' && in[i + 5] == 'i' && in[i + 6] == 't' && in[i + 7] == 'y') {
                    this.flags = (byte)(this.flags | 4);
                    return;
                }
                if (i + 3 != in.length || in[i + 1] != 'n' || in[i + 2] != 'f') break;
                this.flags = (byte)(this.flags | 4);
                return;
            }
            throw new IllegalArgumentException("invalid decimal literal");
        }
        this.value = new BigDecimal(in, ctx.mathCtx());
        this.ClampOverflow(ctx);
    }

    public Decimal128(int val) {
        this.flags = (byte)(val >= 0 ? 0 : 8);
        this.value = new BigDecimal(val, MathContext.DECIMAL128);
    }

    public Decimal128(int val, Decimal128Context ctx) {
        this.flags = (byte)(val >= 0 ? 0 : 8);
        this.value = new BigDecimal(val, ctx.mathCtx());
    }

    public Decimal128(double val) {
        this.flags = (byte)(val >= 0.0 ? 0 : 8);
        this.value = BigDecimalZERO;
        if (Double.isNaN(val)) {
            this.flags = (byte)(this.flags | 1);
        } else if (Double.isInfinite(val)) {
            this.flags = (byte)(this.flags | 4);
        } else {
            this.value = new BigDecimal(val, MathContext.DECIMAL128);
        }
    }

    public Decimal128(double val, Decimal128Context ctx) {
        this.flags = (byte)(val >= 0.0 ? 0 : 8);
        this.value = BigDecimalZERO;
        if (Double.isNaN(val)) {
            this.flags = (byte)(this.flags | 1);
        } else if (Double.isInfinite(val)) {
            this.flags = (byte)(this.flags | 4);
        } else {
            this.value = new BigDecimal(val, ctx.mathCtx());
        }
    }

    public Decimal128(long val) {
        this.flags = (byte)(val >= 0L ? 0 : 8);
        this.value = new BigDecimal(val, MathContext.DECIMAL128);
    }

    public Decimal128(long val, Decimal128Context ctx) {
        this.flags = (byte)(val >= 0L ? 0 : 8);
        this.value = new BigDecimal(val, ctx.mathCtx());
    }

    /*
     * Enabled aggressive block sorting
     */
    public byte[] toIEEE(Decimal128Context ctx) {
        IEEERep ieee = new IEEERep(this);
        if ((this.flags & 8) != 0) {
            ieee.setNeg();
        }
        if ((this.flags & 7) != 0) {
            if ((this.flags & 4) != 0) {
                ieee.setInfinite();
                return ieee.getRep();
            }
        } else {
            char[] coefficient = this.value.abs().unscaledValue().toString().toCharArray();
            int exponent = -this.value.scale();
            int digits = coefficient.length;
            int ae = exponent + digits - 1;
            if (digits > 34 || ae > 6144 || ae < -6143) {
                Decimal128 n2 = this.add(ZERO, Decimal128Context.DECIMAL128);
                if ((n2.flags & 4) != 0) {
                    ieee.setInfinite();
                    return ieee.getRep();
                }
                coefficient = n2.value.abs().unscaledValue().toString().toCharArray();
                exponent = -n2.value.scale();
                digits = coefficient.length;
            }
            if (this.value.compareTo(BigDecimalZERO) == 0) {
                int exp;
                if (exponent < -6176) {
                    exp = 0;
                    ctx.status |= 0x400;
                } else {
                    exp = exponent + 6176;
                    if (exp > 12287) {
                        exp = 12287;
                        ctx.status |= 0x400;
                    }
                }
                ieee.setExponent(exp);
                return ieee.getRep();
            }
            int exp = exponent + 6176;
            if (exp > 12287) {
                int k;
                int shift = exp - 12287;
                exp = 12287;
                ctx.status |= 0x400;
                char[] newCoef = new char[digits + shift];
                for (k = 0; k < digits; ++k) {
                    newCoef[k] = coefficient[k];
                }
                for (k = digits; k < digits + shift; ++k) {
                    newCoef[k] = 48;
                }
                coefficient = newCoef;
                digits += shift;
            }
            ieee.setExponent(exp);
            int i = digits - 1;
            while (i >= 0) {
                short dval;
                switch (i) {
                    case 0: {
                        dval = (short)(coefficient[0] - 48);
                        break;
                    }
                    case 1: {
                        dval = (short)(10 * (coefficient[0] - 48) + (coefficient[1] - 48));
                        break;
                    }
                    default: {
                        dval = (short)(100 * (coefficient[i - 2] - 48) + 10 * (coefficient[i - 1] - 48) + (coefficient[i] - 48));
                    }
                }
                ieee.addUnit(dval);
                i -= 3;
            }
            return ieee.getRep();
        }
        ieee.setNaN((this.flags & 2) != 0);
        if (this.value == BigDecimalZERO) return ieee.getRep();
        char[] payload = this.value.abs().unscaledValue().toString().toCharArray();
        int digits = payload.length;
        ieee.setExponent(0);
        int i = digits - 1;
        while (i >= 0) {
            short dval;
            switch (i) {
                case 0: {
                    dval = (short)(payload[0] - 48);
                    break;
                }
                case 1: {
                    dval = (short)(10 * (payload[0] - 48) + (payload[1] - 48));
                    break;
                }
                default: {
                    dval = (short)(100 * (payload[i - 2] - 48) + 10 * (payload[i - 1] - 48) + (payload[i] - 48));
                }
            }
            ieee.addUnit(dval);
            i -= 3;
        }
        return ieee.getRep();
    }

    public byte[] toIEEE() {
        return this.toIEEE(Decimal128Context.DECIMAL128);
    }

    public ByteList toByteList(ByteList result) {
        byte[] rep = this.toIEEE();
        if (result == null) {
            result = new ByteList(16);
        }
        result.set(rep, 16);
        return result;
    }

    public Decimal128(ByteList rep) {
        byte[] reparray = rep.toByteArray();
        this.initFromIEEE(reparray);
    }

    public Decimal128(byte[] rep) {
        this.initFromIEEE(rep);
    }

    private void initFromIEEE(byte[] rep) {
        if (rep.length != 16) {
            throw new IllegalArgumentException("Decimal128 needs 16 bytes for representation");
        }
        IEEERep ieee = new IEEERep(this, rep);
        this.flags = ieee.isNegative() ? (byte)8 : (byte)0;
        if (ieee.isNaN()) {
            this.value = BigDecimalZERO;
            this.flags = ieee.isSNaN() ? (byte)(this.flags | 2) : (byte)(this.flags | 1);
        } else if (ieee.isInfinite()) {
            this.value = BigDecimalZERO;
            this.flags = (byte)(this.flags | 4);
            return;
        }
        byte[] thousand = new byte[]{3, -24};
        BigInteger THOUSAND = new BigInteger(thousand);
        BigInteger coefficient = BigInteger.ZERO;
        boolean leadingZeroes = true;
        for (int i = 0; i < 12; ++i) {
            short unit = ieee.getUnit();
            if (leadingZeroes && unit == 0) continue;
            if (leadingZeroes) {
                leadingZeroes = false;
            } else {
                coefficient = THOUSAND.multiply(coefficient);
            }
            byte[] unitBytes = new byte[]{(byte)(unit >>> 8), (byte)(unit & 0xFF)};
            BigInteger bigUnit = new BigInteger(unitBytes);
            coefficient = coefficient.add(bigUnit);
        }
        int scale = ieee.isNaN() ? 0 : -(ieee.getExponent() - 6176);
        this.value = new BigDecimal(coefficient, scale);
        if ((this.flags & 0xB) == 8) {
            this.value = this.value.negate(MathContext.DECIMAL128);
        }
    }

    public int intValue() {
        if ((this.flags & 7) != 0) {
            throw new ArithmeticException("no valid integer value");
        }
        return this.value.intValue();
    }

    public long longValue() {
        if ((this.flags & 7) != 0) {
            throw new ArithmeticException("no valid long value");
        }
        return this.value.longValue();
    }

    public double doubleValue() {
        if ((this.flags & 3) != 0) {
            return Double.NaN;
        }
        if ((this.flags & 4) != 0) {
            if ((this.flags & 8) != 0) {
                return Double.NEGATIVE_INFINITY;
            }
            return Double.POSITIVE_INFINITY;
        }
        return this.value.doubleValue();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        if ((this.flags & 7) != 0 && (this.flags & 8) != 0) {
            result.append('-');
        }
        if ((this.flags & 3) != 0) {
            if ((this.flags & 2) != 0) {
                result.append("S");
            }
            result.append("NaN");
            if (this.value.compareTo(BigDecimalZERO) != 0) {
                result.append(this.value.toString());
            }
        } else if ((this.flags & 4) != 0) {
            result.append("Infinity");
        } else {
            if ((this.flags & 8) != 0 && this.value.compareTo(BigDecimalZERO) == 0) {
                result.append('-');
            }
            result.append(this.value.toString());
        }
        return result.toString();
    }

    public String toEngineeringString() {
        if ((this.flags & 3) != 0) {
            return "NaN";
        }
        if ((this.flags & 4) != 0) {
            return "Infinity";
        }
        return this.value.toEngineeringString();
    }

    public boolean isNaN() {
        return (this.flags & 3) != 0;
    }

    public boolean isQNaN() {
        return (this.flags & 1) != 0;
    }

    public boolean isSNaN() {
        return (this.flags & 2) != 0;
    }

    public boolean isFinite() {
        return (this.flags & 4) == 0;
    }

    public boolean isNegative() {
        return (this.flags & 8) != 0;
    }

    private Decimal128 opNaNs(Decimal128 operand, Decimal128Context ctx) {
        Decimal128 lhs = this;
        if ((this.flags & 2) != 0) {
            ctx.status |= 0x40000080;
        } else if (operand != null && (operand.flags & 2) != 0) {
            lhs = operand;
            ctx.status |= 0x40000080;
        } else if ((this.flags & 1) == 0) {
            lhs = operand;
        }
        Decimal128 result = new Decimal128(lhs.value, lhs.flags);
        result.flags = (byte)(result.flags & 0xFFFFFFFD);
        result.flags = (byte)(result.flags | 1);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void ClampOverflow(Decimal128Context ctx) {
        BigDecimal resultVal;
        if ((this.flags & 7) != 0) {
            return;
        }
        int MINSCALE = -6111;
        int MAXSCALE = 6176;
        int scale = this.value.scale();
        if (scale > 6176) {
            int delta;
            int numPrecision = this.value.precision();
            if (numPrecision - (delta = scale - 6176) < 1) {
                this.value = new BigDecimal(BigInteger.ZERO, 6176);
                return;
            }
            resultVal = this.value.setScale(6176, ctx.getRoundingMode());
        } else {
            int delta;
            if (scale >= -6111) {
                return;
            }
            int numPrecision = this.value.precision();
            if (numPrecision + (delta = -6111 - scale) <= ctx.getPrecision() || this.value.compareTo(BigDecimalZERO) == 0) {
                resultVal = this.value.setScale(-6111, ctx.getRoundingMode());
            } else {
                BigInteger NINE;
                RoundingMode mode = ctx.getRoundingMode();
                if ((this.flags & 8) != 0) {
                    if (mode != RoundingMode.CEILING && mode != RoundingMode.DOWN) {
                        this.flags = (byte)12;
                        this.value = BigDecimalZERO;
                        return;
                    }
                } else if (mode != RoundingMode.FLOOR && mode != RoundingMode.DOWN) {
                    this.flags = (byte)4;
                    this.value = BigDecimalZERO;
                    return;
                }
                byte[] nine = new byte[]{9};
                BigInteger total = NINE = new BigInteger(nine);
                for (int i = 1; i < ctx.getPrecision(); ++i) {
                    total = NINE.add(total.multiply(BigInteger.TEN));
                }
                resultVal = new BigDecimal(total, -6111);
                if ((this.flags & 8) != 0) {
                    resultVal = resultVal.negate(ctx.mathCtx());
                }
            }
        }
        this.value = resultVal;
    }

    public Decimal128 abs() {
        return this.abs(Decimal128Context.DECIMAL128);
    }

    public Decimal128 abs(Decimal128Context ctx) {
        Decimal128 result = new Decimal128();
        result.flags = this.flags;
        result.flags = (byte)(result.flags & 0xFFFFFFF7);
        result.value = this.value.abs(ctx.mathCtx());
        return result;
    }

    public Decimal128 add(Decimal128 addend) {
        return this.add(addend, Decimal128Context.DECIMAL128);
    }

    public Decimal128 add(Decimal128 addend, Decimal128Context ctx) {
        int specialbits = (addend.flags | this.flags) & 7;
        if (specialbits != 0) {
            if ((specialbits & 3) != 0) {
                Decimal128 result = this.opNaNs(addend, ctx);
                return result;
            }
            Decimal128 result = new Decimal128();
            if ((this.flags & 4) != 0) {
                if ((addend.flags & 4) != 0 && ((this.flags ^ addend.flags) & 8) != 0) {
                    ctx.status |= 0x80;
                    result.flags = 1;
                    return result;
                }
                result.flags = this.flags;
            } else {
                result.flags = addend.flags;
            }
            return result;
        }
        Decimal128 result = new Decimal128();
        result.value = this.value.add(addend.value, ctx.mathCtx());
        if (result.value.compareTo(BigDecimalZERO) < 0) {
            result.flags = (byte)(result.flags | 8);
        }
        result.ClampOverflow(ctx);
        return result;
    }

    public boolean equals(Decimal128 num) {
        Decimal128 comp = this.compareTo(num, Decimal128Context.DECIMAL128);
        return comp == ZERO;
    }

    public boolean greaterThan(Decimal128 num) {
        Decimal128 comp = this.compareTo(num, Decimal128Context.DECIMAL128);
        return comp == ONE;
    }

    public boolean greaterThanOrEqual(Decimal128 num) {
        Decimal128 comp = this.compareTo(num, Decimal128Context.DECIMAL128);
        return comp == ONE || comp == ZERO;
    }

    public boolean lessThan(Decimal128 num) {
        Decimal128 comp = this.compareTo(num, Decimal128Context.DECIMAL128);
        return comp == NEG1;
    }

    public boolean lessThanOrEqual(Decimal128 num) {
        Decimal128 comp = this.compareTo(num, Decimal128Context.DECIMAL128);
        return comp == NEG1 || comp == ZERO;
    }

    private Decimal128 compareTo(Decimal128 val, Decimal128Context ctx) {
        if (((this.flags | val.flags) & 3) != 0) {
            return this.opNaNs(val, ctx);
        }
        if ((this.flags & 4) != 0) {
            if ((this.flags & 8) != 0) {
                if ((val.flags & 0xC) == 12) {
                    ctx.status |= 0x80;
                    return NaN;
                }
                return NEG1;
            }
            if ((val.flags & 0xC) == 4) {
                ctx.status |= 0x80;
                return NaN;
            }
            return ONE;
        }
        if ((val.flags & 4) != 0) {
            if ((val.flags & 8) != 0) {
                return ONE;
            }
            return NEG1;
        }
        switch (this.value.compareTo(val.value)) {
            case 1: {
                return ONE;
            }
            case -1: {
                return NEG1;
            }
        }
        return ZERO;
    }

    public Decimal128 divide(Decimal128 divisor) {
        return this.divide(divisor, Decimal128Context.DECIMAL128);
    }

    public Decimal128 divide(Decimal128 divisor, Decimal128Context ctx) {
        boolean differentsigns = ((this.flags ^ divisor.flags) & 8) != 0;
        int specialbits = (divisor.flags | this.flags) & 7;
        if (specialbits != 0) {
            if ((specialbits & 3) != 0) {
                return this.opNaNs(divisor, ctx);
            }
            Decimal128 result = new Decimal128();
            if ((this.flags & 4) != 0) {
                if ((divisor.flags & 4) != 0) {
                    ctx.status |= 0x80;
                    result.flags = 1;
                } else {
                    result.flags = (byte)4;
                    if (differentsigns) {
                        result.flags = (byte)(result.flags | 8);
                    }
                }
            } else {
                result.value = BigDecimalZERO.setScale(6176);
                if (differentsigns) {
                    result.flags = (byte)8;
                }
            }
            return result;
        }
        Decimal128 result = new Decimal128();
        if (divisor.value.compareTo(BigDecimalZERO) == 0) {
            if (this.value.compareTo(BigDecimalZERO) == 0) {
                ctx.status |= 0x80;
                result.flags = 1;
            } else {
                result.value = BigDecimalZERO;
                result.flags = (byte)(result.flags | 4);
            }
        } else {
            result.value = this.value.divide(divisor.value, ctx.mathCtx());
        }
        if (differentsigns) {
            result.flags = (byte)(result.flags | 8);
        }
        result.ClampOverflow(ctx);
        return result;
    }

    public Decimal128 multiply(Decimal128 multiplicand) {
        return this.multiply(multiplicand, Decimal128Context.DECIMAL128);
    }

    public Decimal128 multiply(Decimal128 multiplicand, Decimal128Context ctx) {
        boolean differentsigns = ((this.flags ^ multiplicand.flags) & 8) != 0;
        int specialbits = (multiplicand.flags | this.flags) & 7;
        if (specialbits != 0) {
            if ((specialbits & 3) != 0) {
                Decimal128 result = this.opNaNs(multiplicand, ctx);
                return result;
            }
            Decimal128 result = new Decimal128();
            if ((this.flags & 4) != 0) {
                if ((multiplicand.flags & 4) == 0 && multiplicand.value.compareTo(BigDecimalZERO) == 0) {
                    ctx.status |= 0x80;
                    result.flags = 1;
                    return result;
                }
            } else if (this.value.compareTo(BigDecimalZERO) == 0) {
                ctx.status |= 0x80;
                result.flags = 1;
                return result;
            }
            result.flags = (byte)4;
            if (differentsigns) {
                result.flags = (byte)(result.flags | 8);
            }
            return result;
        }
        Decimal128 result = new Decimal128();
        result.value = this.value.multiply(multiplicand.value, ctx.mathCtx());
        if (differentsigns) {
            result.flags = (byte)(result.flags | 8);
        }
        result.ClampOverflow(ctx);
        return result;
    }

    public Decimal128 remainder(Decimal128 divisor) {
        return this.remainder(divisor, Decimal128Context.DECIMAL128);
    }

    public Decimal128 remainder(Decimal128 divisor, Decimal128Context ctx) {
        boolean differentsigns = ((this.flags ^ divisor.flags) & 8) != 0;
        int specialbits = (divisor.flags | this.flags) & 7;
        if (specialbits != 0) {
            if ((specialbits & 3) != 0) {
                return this.opNaNs(divisor, ctx);
            }
            Decimal128 result = new Decimal128();
            if ((this.flags & 4) != 0 || (divisor.flags & 4) == 0 && divisor.value.compareTo(BigDecimalZERO) == 0) {
                ctx.status |= 0x80;
                result.flags = 1;
            } else {
                result.value = this.value;
                if (differentsigns) {
                    result.flags = (byte)8;
                }
            }
            return result;
        }
        Decimal128 result = new Decimal128();
        if (divisor.value.compareTo(BigDecimalZERO) == 0) {
            result.flags = 1;
        } else if (this.value.compareTo(BigDecimalZERO) == 0) {
            result.value = this.value;
        } else {
            try {
                if (ctx.mathCtx().getPrecision() == 34) {
                    result.value = this.value.remainder(divisor.value, ctx.mathCtx());
                } else {
                    result.value = this.value.remainder(divisor.value, Decimal128Context.DECIMAL128.mathCtx());
                    result.value = result.value.add(BigDecimalZERO, ctx.mathCtx());
                }
            }
            catch (ArithmeticException e) {
                result.flags = 1;
            }
        }
        if (differentsigns) {
            result.flags = (byte)(result.flags | 8);
        }
        result.ClampOverflow(ctx);
        return result;
    }

    public Decimal128 subtract(Decimal128 subtrahend) {
        return this.subtract(subtrahend, Decimal128Context.DECIMAL128);
    }

    public Decimal128 subtract(Decimal128 subtrahend, Decimal128Context ctx) {
        int specialbits = (subtrahend.flags | this.flags) & 7;
        if (specialbits != 0) {
            if ((specialbits & 3) != 0) {
                Decimal128 result = this.opNaNs(subtrahend, ctx);
                return result;
            }
            Decimal128 result = new Decimal128();
            if ((this.flags & 4) != 0) {
                if ((subtrahend.flags & 4) != 0 && ((this.flags ^ subtrahend.flags) & 8) == 0) {
                    ctx.status |= 0x80;
                    result.flags = 1;
                    return result;
                }
                result.flags = this.flags;
            } else {
                result.flags = subtrahend.flags;
                result.flags = (byte)(result.flags ^ 8);
            }
            return result;
        }
        Decimal128 result = new Decimal128();
        result.value = this.value.subtract(subtrahend.value, ctx.mathCtx());
        if (result.value.compareTo(BigDecimalZERO) < 0) {
            result.flags = (byte)(result.flags | 8);
        }
        result.ClampOverflow(ctx);
        return result;
    }

    public int hashCode() {
        return this.value.hashCode() ^ this.flags;
    }

    private class IEEERep {
        int[] data = new int[]{0, 0, 0, 0};
        boolean negative = false;
        boolean qNaN = false;
        boolean sNaN = false;
        boolean infinite = false;
        boolean finalized = false;
        int exponent;
        short topDigit;
        int currentDatum;
        int currentShift;
        int totalDigits;
        int currentBit;
        final /* synthetic */ Decimal128 this$0;

        /*
         * WARNING - void declaration
         */
        IEEERep(Decimal128 decimal128) {
            void arg0;
            this.this$0 = arg0;
            this.topDigit = 0;
            this.currentDatum = 3;
            this.currentShift = 0;
            this.totalDigits = 0;
        }

        void setNeg() {
            this.negative = true;
        }

        void setNaN(boolean signalling) {
            if (signalling) {
                this.sNaN = true;
            } else {
                this.qNaN = true;
            }
        }

        void setInfinite() {
            this.infinite = true;
        }

        void setExponent(int exp) {
            this.exponent = exp;
        }

        void addUnit(short unit) {
            if (this.totalDigits == 34) {
                throw new IllegalArgumentException("trying to add more than 34 digits to IEEE128");
            }
            if (this.totalDigits == 33) {
                if (unit > 9) {
                    throw new IllegalArgumentException("trying to add more than 34 digits to IEEE128");
                }
                this.topDigit = unit;
                ++this.totalDigits;
                return;
            }
            this.totalDigits += 3;
            short dpd = DenselyPackedDecimal.Bin2DPD(unit);
            if (this.currentShift <= 22) {
                int n = this.currentDatum;
                this.data[n] = this.data[n] | dpd << this.currentShift;
                this.currentShift += 10;
            } else {
                int onThis = 32 - this.currentShift;
                if (onThis != 0) {
                    int n = this.currentDatum;
                    this.data[n] = this.data[n] | dpd << this.currentShift;
                }
                int n = this.currentDatum - 1;
                this.data[n] = this.data[n] | dpd >>> onThis;
                --this.currentDatum;
                this.currentShift = 10 - onThis;
            }
        }

        byte[] getRep() {
            if (!this.finalized) {
                int combo = 0;
                if (this.negative) {
                    this.data[0] = this.data[0] | Integer.MIN_VALUE;
                }
                if (this.infinite) {
                    combo = 30;
                } else if (this.sNaN || this.qNaN) {
                    combo = 31;
                    this.exponent = this.sNaN ? 2048 : 0;
                } else {
                    combo = this.topDigit < 8 ? this.topDigit | this.exponent >>> 9 & 0x18 : 0x18 | (this.exponent >>> 12 & 3) << 1 | this.topDigit - 8;
                }
                this.data[0] = this.data[0] | (combo << 26 | (this.exponent & 0xFFF) << 14);
                this.finalized = true;
            }
            byte[] result = new byte[16];
            int ndx = 0;
            for (int i = 0; i < 16; i += 4) {
                int datum = this.data[ndx++];
                result[i] = (byte)(datum >>> 24);
                result[i + 1] = (byte)(datum >>> 16 & 0xFF);
                result[i + 2] = (byte)(datum >>> 8 & 0xFF);
                result[i + 3] = (byte)(datum & 0xFF);
            }
            return result;
        }

        /*
         * WARNING - void declaration
         */
        IEEERep(Decimal128 decimal128, byte[] byArray) {
            int combo;
            void arg0;
            this.this$0 = arg0;
            int ndx = 0;
            for (int i = 0; i < 16; i += 4) {
                void rep;
                this.data[ndx++] = ((rep[i] & 0xFF) << 24) + ((rep[i + 1] & 0xFF) << 16) + ((rep[i + 2] & 0xFF) << 8) + (rep[i + 3] & 0xFF);
            }
            if ((this.data[0] & Integer.MIN_VALUE) != 0) {
                this.negative = true;
            }
            if ((combo = this.data[0] >> 26 & 0x1F) == 30) {
                this.infinite = true;
            } else if (combo == 31) {
                if ((this.data[0] & 0x2000000) != 0) {
                    this.sNaN = true;
                } else {
                    this.qNaN = true;
                }
            } else {
                int expmsb;
                if ((combo & 0x18) == 24) {
                    expmsb = combo >> 1 & 3;
                    this.topDigit = (short)(8 + (combo & 1));
                } else {
                    expmsb = combo >>> 3;
                    this.topDigit = (short)(combo & 7);
                }
                this.exponent = this.data[0] >>> 14 & 0xFFF | expmsb << 12;
            }
            this.currentDatum = -1;
        }

        short getUnit() {
            short result = 0;
            if (this.currentDatum == -1) {
                this.currentDatum = 0;
                this.currentBit = 14;
                return this.topDigit;
            }
            if (this.currentDatum > 3) {
                throw new IllegalArgumentException("trying to read more than 34 digits from IEEE128");
            }
            if (this.currentBit >= 10) {
                result = (short)(this.data[this.currentDatum] >>> this.currentBit - 10 & 0x3FF);
                this.currentBit -= 10;
            } else {
                int overlap = 10 - this.currentBit;
                if (this.currentBit != 0) {
                    result = (short)((this.data[this.currentDatum] & mask[this.currentBit]) << overlap);
                }
                result = (short)(result | (short)(this.data[++this.currentDatum] >>> 32 - overlap));
                this.currentBit = 32 - overlap;
            }
            return DenselyPackedDecimal.DPD2Bin(result);
        }

        boolean isInfinite() {
            return this.infinite;
        }

        boolean isNaN() {
            return this.qNaN | this.sNaN;
        }

        boolean isSNaN() {
            return this.sNaN;
        }

        boolean isNegative() {
            return this.negative;
        }

        int getExponent() {
            return this.exponent;
        }
    }
}

