/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.util;

import java.io.IOException;
import java.io.Writer;
import org.apache.batik.dom.util.HashTable;
import org.apache.batik.xml.XMLUtilities;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DOMUtilities
extends XMLUtilities {
    protected DOMUtilities() {
    }

    public static void writeDocument(Document doc, Writer w) throws IOException {
        for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
            DOMUtilities.writeNode(n, w);
        }
    }

    public static void writeNode(Node n, Writer w) throws IOException {
        switch (n.getNodeType()) {
            case 1: {
                Node c;
                w.write("<");
                w.write(n.getNodeName());
                if (n.hasAttributes()) {
                    NamedNodeMap attr = n.getAttributes();
                    int len = attr.getLength();
                    for (int i = 0; i < len; ++i) {
                        Attr a = (Attr)attr.item(i);
                        w.write(" ");
                        w.write(a.getNodeName());
                        w.write("=\"");
                        w.write(DOMUtilities.contentToString(a.getNodeValue()));
                        w.write("\"");
                    }
                }
                if ((c = n.getFirstChild()) != null) {
                    w.write(">");
                    while (c != null) {
                        DOMUtilities.writeNode(c, w);
                        c = c.getNextSibling();
                    }
                    w.write("</");
                    w.write(n.getNodeName());
                    w.write(">");
                    break;
                }
                w.write("/>");
                break;
            }
            case 3: {
                w.write(DOMUtilities.contentToString(n.getNodeValue()));
                break;
            }
            case 4: {
                w.write("<![CDATA[");
                w.write(n.getNodeValue());
                w.write("]]>");
                break;
            }
            case 5: {
                w.write("&");
                w.write(n.getNodeName());
                w.write(";");
                break;
            }
            case 7: {
                w.write("<?");
                w.write(n.getNodeName());
                w.write(" ");
                w.write(n.getNodeValue());
                w.write("?>");
                break;
            }
            case 8: {
                w.write("<!--");
                w.write(n.getNodeValue());
                w.write("-->");
                break;
            }
            case 10: {
                DocumentType dt = (DocumentType)n;
                w.write("<!DOCTYPE ");
                w.write(n.getOwnerDocument().getDocumentElement().getNodeName());
                String pubID = dt.getPublicId();
                if (pubID != null) {
                    w.write(" PUBLIC \"" + dt.getNodeName() + "\" \"" + pubID + "\">");
                    break;
                }
                String sysID = dt.getSystemId();
                if (sysID == null) break;
                w.write(" SYSTEM \"" + sysID + "\">");
                break;
            }
            default: {
                throw new Error("Internal error (" + n.getNodeType() + ")");
            }
        }
    }

    public static String contentToString(String s) {
        StringBuffer result = new StringBuffer();
        block7: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    result.append("&lt;");
                    continue block7;
                }
                case '>': {
                    result.append("&gt;");
                    continue block7;
                }
                case '&': {
                    result.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    result.append("&apos;");
                    continue block7;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    public static Document deepCloneDocument(Document doc, DOMImplementation impl) {
        Element root = doc.getDocumentElement();
        Document result = impl.createDocument(root.getNamespaceURI(), root.getNodeName(), null);
        Element rroot = result.getDocumentElement();
        boolean before = true;
        for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n == root) {
                before = false;
                if (root.hasAttributes()) {
                    NamedNodeMap attr = root.getAttributes();
                    int len = attr.getLength();
                    for (int i = 0; i < len; ++i) {
                        rroot.setAttributeNode((Attr)result.importNode(attr.item(i), true));
                    }
                }
                for (Node c = root.getFirstChild(); c != null; c = c.getNextSibling()) {
                    rroot.appendChild(result.importNode(c, true));
                }
                continue;
            }
            if (n.getNodeType() == 10) continue;
            if (before) {
                result.insertBefore(result.importNode(n, true), rroot);
                continue;
            }
            result.appendChild(result.importNode(n, true));
        }
        return result;
    }

    public static boolean isValidName(String s) {
        int m;
        char c = s.charAt(0);
        int d = c / 32;
        if ((NAME_FIRST_CHARACTER[d] & 1 << (m = c % 32)) == 0) {
            return false;
        }
        int len = s.length();
        for (int i = 1; i < len; ++i) {
            c = s.charAt(i);
            d = c / 32;
            if ((NAME_CHARACTER[d] & 1 << (m = c % 32)) != 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidPrefix(String s) {
        return s.indexOf(58) == -1;
    }

    public static String getPrefix(String s) {
        int i = s.indexOf(58);
        return i == -1 || i == s.length() - 1 ? null : s.substring(0, i);
    }

    public static String getLocalName(String s) {
        int i = s.indexOf(58);
        return i == -1 || i == s.length() - 1 ? s : s.substring(i + 1);
    }

    public static void parseStyleSheetPIData(String data, HashTable table) {
        char c;
        int i;
        for (i = 0; i < data.length() && XMLUtilities.isXMLSpace(c = data.charAt(i)); ++i) {
        }
        while (i < data.length()) {
            int m;
            c = data.charAt(i);
            int d = c / 32;
            if ((NAME_FIRST_CHARACTER[d] & 1 << (m = c % 32)) == 0) {
                throw new DOMException(5, "Wrong name initial:  " + c);
            }
            StringBuffer ident = new StringBuffer();
            ident.append(c);
            while (++i < data.length() && (NAME_CHARACTER[d = (c = data.charAt(i)) / 32] & 1 << (m = c % 32)) != 0) {
                ident.append(c);
            }
            if (i >= data.length()) {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + data);
            }
            while (i < data.length() && XMLUtilities.isXMLSpace(c = data.charAt(i))) {
                ++i;
            }
            if (i >= data.length()) {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + data);
            }
            if (data.charAt(i) != '=') {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + data);
            }
            ++i;
            while (i < data.length() && XMLUtilities.isXMLSpace(c = data.charAt(i))) {
                ++i;
            }
            if (i >= data.length()) {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + data);
            }
            c = data.charAt(i);
            ++i;
            StringBuffer value = new StringBuffer();
            if (c == '\'') {
                while (i < data.length() && (c = data.charAt(i)) != '\'') {
                    value.append(c);
                    ++i;
                }
                if (i >= data.length()) {
                    throw new DOMException(12, "Wrong xml-stylesheet data: " + data);
                }
            } else if (c == '\"') {
                while (i < data.length() && (c = data.charAt(i)) != '\"') {
                    value.append(c);
                    ++i;
                }
                if (i >= data.length()) {
                    throw new DOMException(12, "Wrong xml-stylesheet data: " + data);
                }
            } else {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + data);
            }
            table.put(ident.toString().intern(), value.toString());
            ++i;
            while (i < data.length() && XMLUtilities.isXMLSpace(c = data.charAt(i))) {
                ++i;
            }
        }
    }
}

