/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge.svg12;

import java.awt.Shape;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.SVGAElementBridge;
import org.apache.batik.bridge.SVGTextElementBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.TextUtilities;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.value.ComputedValue;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.ValueConstants;
import org.apache.batik.css.engine.value.svg12.LineHeightValue;
import org.apache.batik.css.engine.value.svg12.SVG12ValueConstants;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.dom.util.XMLSupport;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.flow.BlockInfo;
import org.apache.batik.gvt.flow.FlowTextNode;
import org.apache.batik.gvt.flow.RegionInfo;
import org.apache.batik.gvt.flow.TextLineBreaks;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.TextPath;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.EventTarget;

public class SVGFlowRootElementBridge
extends SVGTextElementBridge {
    public static final AttributedCharacterIterator.Attribute FLOW_PARAGRAPH = GVTAttributedCharacterIterator.TextAttribute.FLOW_PARAGRAPH;
    public static final AttributedCharacterIterator.Attribute FLOW_EMPTY_PARAGRAPH = GVTAttributedCharacterIterator.TextAttribute.FLOW_EMPTY_PARAGRAPH;
    public static final AttributedCharacterIterator.Attribute FLOW_LINE_BREAK = GVTAttributedCharacterIterator.TextAttribute.FLOW_LINE_BREAK;
    public static final AttributedCharacterIterator.Attribute FLOW_REGIONS = GVTAttributedCharacterIterator.TextAttribute.FLOW_REGIONS;
    public static final AttributedCharacterIterator.Attribute LINE_HEIGHT = GVTAttributedCharacterIterator.TextAttribute.LINE_HEIGHT;
    protected int startLen;
    protected static final GVTAttributedCharacterIterator.TextAttribute TEXTPATH = GVTAttributedCharacterIterator.TextAttribute.TEXTPATH;
    protected static final GVTAttributedCharacterIterator.TextAttribute ANCHOR_TYPE = GVTAttributedCharacterIterator.TextAttribute.ANCHOR_TYPE;
    protected static final GVTAttributedCharacterIterator.TextAttribute LETTER_SPACING = GVTAttributedCharacterIterator.TextAttribute.LETTER_SPACING;
    protected static final GVTAttributedCharacterIterator.TextAttribute WORD_SPACING = GVTAttributedCharacterIterator.TextAttribute.WORD_SPACING;
    protected static final GVTAttributedCharacterIterator.TextAttribute KERNING = GVTAttributedCharacterIterator.TextAttribute.KERNING;
    int marginTopIndex = -1;
    int marginRightIndex = -1;
    int marginBottomIndex = -1;
    int marginLeftIndex = -1;
    int indentIndex = -1;
    int textAlignIndex = -1;
    int lineHeightIndex = -1;

    public String getNamespaceURI() {
        return "http://www.w3.org/2000/svg";
    }

    public String getLocalName() {
        return "flowRoot";
    }

    public Bridge getInstance() {
        return new SVGFlowRootElementBridge();
    }

    public boolean isComposite() {
        return false;
    }

    protected GraphicsNode instantiateGraphicsNode() {
        return new FlowTextNode();
    }

    protected Point2D getLocation(BridgeContext ctx, Element e) {
        return new Point2D.Float(0.0f, 0.0f);
    }

    protected boolean isTextElement(Element e) {
        if (!"http://www.w3.org/2000/svg".equals(e.getNamespaceURI())) {
            return false;
        }
        String nodeName = e.getLocalName();
        return nodeName.equals("flowDiv") || nodeName.equals("flowLine") || nodeName.equals("flowPara") || nodeName.equals("flowRegionBreak") || nodeName.equals("flowSpan");
    }

    protected boolean isTextChild(Element e) {
        if (!"http://www.w3.org/2000/svg".equals(e.getNamespaceURI())) {
            return false;
        }
        String nodeName = e.getLocalName();
        return nodeName.equals("a") || nodeName.equals("flowLine") || nodeName.equals("flowPara") || nodeName.equals("flowRegionBreak") || nodeName.equals("flowSpan");
    }

    protected void computeLaidoutText(BridgeContext ctx, Element e, GraphicsNode node) {
        super.computeLaidoutText(ctx, this.getFlowDivElement(e), node);
    }

    protected AttributedString buildAttributedString(BridgeContext ctx, Element element) {
        List rgns = this.getRegions(ctx, element);
        AttributedString ret = this.getFlowDiv(ctx, element);
        ret.addAttribute(FLOW_REGIONS, rgns, 0, 1);
        TextLineBreaks.findLineBrk((AttributedString)ret);
        return ret;
    }

    protected void dumpACIWord(AttributedString as) {
        String chars = "";
        String brkStr = "";
        AttributedCharacterIterator aci = as.getIterator();
        AttributedCharacterIterator.Attribute WORD_LIMIT = TextLineBreaks.WORD_LIMIT;
        char ch = aci.current();
        while (ch != '\uffff') {
            chars = chars + ch + "  ";
            int w = (Integer)aci.getAttribute(WORD_LIMIT);
            brkStr = w >= 10 ? brkStr + "" + w + " " : brkStr + "" + w + "  ";
            ch = aci.next();
        }
        System.out.println(chars);
        System.out.println(brkStr);
    }

    protected Element getFlowDivElement(Element elem) {
        String eNS = elem.getNamespaceURI();
        if (!eNS.equals("http://www.w3.org/2000/svg")) {
            return null;
        }
        String nodeName = elem.getLocalName();
        if (nodeName.equals("flowDiv")) {
            return elem;
        }
        if (!nodeName.equals("flowRoot")) {
            return null;
        }
        for (Node n = elem.getFirstChild(); n != null; n = n.getNextSibling()) {
            Element e;
            String ln;
            String nNS;
            if (n.getNodeType() != 1 || !"http://www.w3.org/2000/svg".equals(nNS = n.getNamespaceURI()) || !(ln = (e = (Element)n).getLocalName()).equals("flowDiv")) continue;
            return e;
        }
        return null;
    }

    protected AttributedString getFlowDiv(BridgeContext ctx, Element element) {
        Element flowDiv = this.getFlowDivElement(element);
        if (flowDiv == null) {
            return null;
        }
        return this.gatherFlowPara(ctx, flowDiv);
    }

    protected AttributedString gatherFlowPara(BridgeContext ctx, Element div) {
        SVGTextElementBridge.AttributedStringBuffer asb = new SVGTextElementBridge.AttributedStringBuffer();
        ArrayList<Integer> paraEnds = new ArrayList<Integer>();
        ArrayList<Element> paraElems = new ArrayList<Element>();
        ArrayList lnLocs = new ArrayList();
        for (Node n = div.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1 || !this.getNamespaceURI().equals(n.getNamespaceURI())) continue;
            Element e = (Element)n;
            String ln = e.getLocalName();
            if (ln.equals("flowPara")) {
                this.fillAttributedStringBuffer(ctx, e, true, null, asb, lnLocs);
                paraElems.add(e);
                paraEnds.add(new Integer(asb.length()));
                continue;
            }
            if (!ln.equals("flowRegionBreak")) continue;
            this.fillAttributedStringBuffer(ctx, e, true, null, asb, lnLocs);
            paraElems.add(e);
            paraEnds.add(new Integer(asb.length()));
        }
        AttributedString ret = asb.toAttributedString();
        int prevLN = 0;
        Iterator lnIter = lnLocs.iterator();
        while (lnIter.hasNext()) {
            int nextLN = (Integer)lnIter.next();
            if (nextLN == prevLN) continue;
            ret.addAttribute(FLOW_LINE_BREAK, new Object(), prevLN, nextLN);
            prevLN = nextLN;
        }
        int start = 0;
        LinkedList<BlockInfo> emptyPara = null;
        for (int i = 0; i < paraElems.size(); ++i) {
            Element elem = (Element)paraElems.get(i);
            int end = (Integer)paraEnds.get(i);
            if (start == end) {
                if (emptyPara == null) {
                    emptyPara = new LinkedList<BlockInfo>();
                }
                emptyPara.add(this.makeBlockInfo(ctx, elem));
            } else {
                ret.addAttribute(FLOW_PARAGRAPH, this.makeBlockInfo(ctx, elem), start, end);
                if (emptyPara != null) {
                    ret.addAttribute(FLOW_EMPTY_PARAGRAPH, emptyPara, start, end);
                    emptyPara = null;
                }
            }
            start = end;
        }
        return ret;
    }

    protected List getRegions(BridgeContext ctx, Element element) {
        element = (Element)element.getParentNode();
        LinkedList ret = new LinkedList();
        for (Node n = element.getFirstChild(); n != null; n = n.getNextSibling()) {
            Element e;
            String ln;
            if (n.getNodeType() != 1 || !"http://www.w3.org/2000/svg".equals(n.getNamespaceURI()) || !"flowRegion".equals(ln = (e = (Element)n).getLocalName())) continue;
            float verticalAlignment = 0.0f;
            this.gatherRegionInfo(ctx, e, verticalAlignment, ret);
        }
        return ret;
    }

    protected void gatherRegionInfo(BridgeContext ctx, Element rgn, float verticalAlign, List regions) {
        GVTBuilder builder = ctx.getGVTBuilder();
        for (Node n = rgn.getFirstChild(); n != null; n = n.getNextSibling()) {
            Shape s;
            Element e;
            GraphicsNode gn;
            if (n.getNodeType() != 1 || !this.getNamespaceURI().equals(n.getNamespaceURI()) || (gn = builder.build(ctx, e = (Element)n)) == null || (s = gn.getOutline()) == null) continue;
            AffineTransform at = gn.getTransform();
            if (at != null) {
                s = at.createTransformedShape(s);
            }
            regions.add(new RegionInfo(s, verticalAlign));
        }
    }

    protected void fillAttributedStringBuffer(BridgeContext ctx, Element element, boolean top, Integer bidiLevel, SVGTextElementBridge.AttributedStringBuffer asb, List lnLocs) {
        int len;
        if (!SVGUtilities.matchUserAgent(element, ctx.getUserAgent()) || !CSSUtilities.convertDisplay(element)) {
            return;
        }
        String s = XMLSupport.getXMLSpace((Element)element);
        boolean preserve = s.equals("preserve");
        Element nodeElement = element;
        if (top) {
            this.endLimit = this.startLen = asb.length();
        }
        if (preserve) {
            this.endLimit = this.startLen;
        }
        Map map = this.getAttributeMap(ctx, element, null, bidiLevel);
        Object o = map.get(TextAttribute.BIDI_EMBEDDING);
        Integer subBidiLevel = bidiLevel;
        if (o != null) {
            subBidiLevel = (Integer)o;
        }
        int lineBreak = -1;
        if (lnLocs.size() != 0) {
            lineBreak = (Integer)lnLocs.get(lnLocs.size() - 1);
        }
        block4: for (Node n = element.getFirstChild(); n != null; n = n.getNextSibling()) {
            boolean prevEndsWithSpace;
            if (preserve) {
                prevEndsWithSpace = false;
            } else {
                len = asb.length();
                if (len == this.startLen) {
                    prevEndsWithSpace = true;
                } else {
                    Integer i;
                    prevEndsWithSpace = asb.getLastChar() == 32;
                    int idx = lnLocs.size() - 1;
                    if (!prevEndsWithSpace && idx >= 0 && (i = (Integer)lnLocs.get(idx)) == len) {
                        prevEndsWithSpace = true;
                    }
                }
            }
            switch (n.getNodeType()) {
                case 1: {
                    if (!"http://www.w3.org/2000/svg".equals(n.getNamespaceURI())) continue block4;
                    nodeElement = (Element)n;
                    String ln = n.getLocalName();
                    if (ln.equals("flowLine")) {
                        this.fillAttributedStringBuffer(ctx, nodeElement, false, subBidiLevel, asb, lnLocs);
                        lineBreak = asb.length();
                        lnLocs.add(new Integer(lineBreak));
                        continue block4;
                    }
                    if (ln.equals("flowSpan") || ln.equals("altGlyph")) {
                        this.fillAttributedStringBuffer(ctx, nodeElement, false, subBidiLevel, asb, lnLocs);
                        continue block4;
                    }
                    if (ln.equals("a")) {
                        if (ctx.isInteractive()) {
                            EventTarget target = (EventTarget)((Object)nodeElement);
                            UserAgent ua = ctx.getUserAgent();
                            target.addEventListener("click", new SVGAElementBridge.AnchorListener(ua), false);
                            target.addEventListener("mouseover", new SVGAElementBridge.CursorMouseOverListener(ua), false);
                            target.addEventListener("mouseout", new SVGAElementBridge.CursorMouseOutListener(ua), false);
                        }
                        this.fillAttributedStringBuffer(ctx, nodeElement, false, subBidiLevel, asb, lnLocs);
                        continue block4;
                    }
                    if (!ln.equals("tref")) continue block4;
                    String uriStr = XLinkSupport.getXLinkHref((Element)((Element)n));
                    Element ref = ctx.getReferencedElement((Element)n, uriStr);
                    s = TextUtilities.getElementContent(ref);
                    if ((s = this.normalizeString(s, preserve, prevEndsWithSpace)) == null) continue block4;
                    Map m = this.getAttributeMap(ctx, nodeElement, null, bidiLevel);
                    asb.append(s, m);
                    continue block4;
                }
                case 3: 
                case 4: {
                    s = n.getNodeValue();
                    s = this.normalizeString(s, preserve, prevEndsWithSpace);
                    asb.append(s, map);
                    if (!preserve) continue block4;
                    this.endLimit = asb.length();
                }
            }
        }
        if (top) {
            while (this.endLimit < asb.length() && asb.getLastChar() == 32) {
                Integer i;
                int idx = lnLocs.size() - 1;
                len = asb.length();
                if (idx >= 0 && (i = (Integer)lnLocs.get(idx)) >= len) {
                    i = new Integer(len - 1);
                    lnLocs.set(idx, i);
                    --idx;
                    while (idx >= 0 && (i = (Integer)lnLocs.get(idx)) >= len - 1) {
                        lnLocs.remove(idx);
                        --idx;
                    }
                }
                asb.stripLast();
            }
        }
    }

    protected Map getAttributeMap(BridgeContext ctx, Element element, TextPath textPath, Integer bidiLevel) {
        Map result = super.getAttributeMap(ctx, element, textPath, bidiLevel);
        float fontSize = TextUtilities.convertFontSize(element).floatValue();
        float lineHeight = this.getLineHeight(ctx, element, fontSize);
        result.put(LINE_HEIGHT, new Float(lineHeight));
        return result;
    }

    protected void checkMap(Map attrs) {
        if (attrs.containsKey(TEXTPATH)) {
            return;
        }
        if (attrs.containsKey(ANCHOR_TYPE)) {
            return;
        }
        if (attrs.containsKey(LETTER_SPACING)) {
            return;
        }
        if (attrs.containsKey(WORD_SPACING)) {
            return;
        }
        if (attrs.containsKey(KERNING)) {
            return;
        }
    }

    protected void initCSSPropertyIndexes(Element e) {
        CSSEngine eng = CSSUtilities.getCSSEngine(e);
        this.marginTopIndex = eng.getPropertyIndex("margin-top");
        this.marginRightIndex = eng.getPropertyIndex("margin-right");
        this.marginBottomIndex = eng.getPropertyIndex("margin-bottom");
        this.marginLeftIndex = eng.getPropertyIndex("margin-left");
        this.indentIndex = eng.getPropertyIndex("indent");
        this.textAlignIndex = eng.getPropertyIndex("text-align");
        this.lineHeightIndex = eng.getPropertyIndex("line-height");
    }

    public BlockInfo makeBlockInfo(BridgeContext ctx, Element element) {
        if (this.marginTopIndex == -1) {
            this.initCSSPropertyIndexes(element);
        }
        Value v = CSSUtilities.getComputedStyle(element, this.marginTopIndex);
        float top = v.getFloatValue();
        v = CSSUtilities.getComputedStyle(element, this.marginRightIndex);
        float right = v.getFloatValue();
        v = CSSUtilities.getComputedStyle(element, this.marginBottomIndex);
        float bottom = v.getFloatValue();
        v = CSSUtilities.getComputedStyle(element, this.marginLeftIndex);
        float left = v.getFloatValue();
        v = CSSUtilities.getComputedStyle(element, this.indentIndex);
        float indent = v.getFloatValue();
        v = CSSUtilities.getComputedStyle(element, this.textAlignIndex);
        if (v == ValueConstants.INHERIT_VALUE) {
            v = CSSUtilities.getComputedStyle(element, 11);
            v = v == ValueConstants.LTR_VALUE ? SVG12ValueConstants.START_VALUE : SVG12ValueConstants.END_VALUE;
        }
        int textAlign = v == SVG12ValueConstants.START_VALUE ? 0 : (v == SVG12ValueConstants.MIDDLE_VALUE ? 1 : (v == SVG12ValueConstants.END_VALUE ? 2 : 3));
        Map fontAttrs = this.getFontProperties(ctx, element, null);
        Float fs = (Float)fontAttrs.get(TextAttribute.SIZE);
        float fontSize = fs.floatValue();
        float lineHeight = this.getLineHeight(ctx, element, fontSize);
        List fontFamilyList = this.getFontFamilyList(element, ctx);
        String ln = element.getLocalName();
        boolean rgnBr = ln.equals("flowRegionBreak");
        return new BlockInfo(top, right, bottom, left, indent, textAlign, lineHeight, fontFamilyList, fontAttrs, rgnBr);
    }

    protected float getLineHeight(BridgeContext ctx, Element element, float fontSize) {
        Value v;
        if (this.lineHeightIndex == -1) {
            this.initCSSPropertyIndexes(element);
        }
        if ((v = CSSUtilities.getComputedStyle(element, this.lineHeightIndex)) == ValueConstants.INHERIT_VALUE || v == SVG12ValueConstants.NORMAL_VALUE) {
            return fontSize * 1.1f;
        }
        float lineHeight = v.getFloatValue();
        if (v instanceof ComputedValue) {
            v = ((ComputedValue)v).getComputedValue();
        }
        if (v instanceof LineHeightValue && ((LineHeightValue)v).getFontSizeRelative()) {
            lineHeight *= fontSize;
        }
        return lineHeight;
    }
}

