/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Iterator;
import java.util.Vector;
import org.apache.batik.ext.awt.image.GraphicsUtil;

public class IndexImage {
    public static BufferedImage getIndexedImage(BufferedImage bi, int nColors) {
        int bits;
        int w = bi.getWidth();
        int h = bi.getHeight();
        Vector[] colors = new Vector[4096];
        int rgb = 0;
        for (int i_w = 0; i_w < w; ++i_w) {
            block1: for (int i_h = 0; i_h < h; ++i_h) {
                rgb = bi.getRGB(i_w, i_h) & 0xFFFFFF;
                int idx = (rgb & 0xF00000) >>> 12 | (rgb & 0xF000) >>> 8 | (rgb & 0xF0) >>> 4;
                Vector<Counter> v = colors[idx];
                if (v == null) {
                    v = new Vector<Counter>();
                    v.add(new Counter(rgb));
                    colors[idx] = v;
                    continue;
                }
                Iterator i = v.iterator();
                while (i.hasNext()) {
                    if (!((Counter)i.next()).add(rgb)) continue;
                    continue block1;
                }
                v.add(new Counter(rgb));
            }
        }
        int nCubes = 1;
        int fCube = 0;
        Cube[] cubes = new Cube[nColors];
        cubes[0] = new Cube(colors, w * h);
        while (nCubes < nColors) {
            int i;
            while (cubes[fCube].isDone() && ++fCube != nCubes) {
            }
            if (fCube == nCubes) break;
            Cube c = cubes[fCube];
            Cube nc = c.split();
            if (nc == null) continue;
            if (nc.count > c.count) {
                Cube tmp = c;
                c = nc;
                nc = tmp;
            }
            int j = fCube;
            int cnt = c.count;
            for (i = fCube + 1; i < nCubes && cubes[i].count >= cnt; ++i) {
                cubes[j++] = cubes[i];
            }
            cubes[j++] = c;
            cnt = nc.count;
            while (j < nCubes && cubes[j].count >= cnt) {
                ++j;
            }
            for (i = nCubes; i > j; --i) {
                cubes[i] = cubes[i - 1];
            }
            cubes[j++] = nc;
            ++nCubes;
        }
        byte[] r = new byte[nCubes];
        byte[] g = new byte[nCubes];
        byte[] b = new byte[nCubes];
        for (int i = 0; i < nCubes; ++i) {
            int val = cubes[i].averageColor();
            r[i] = (byte)(val >> 16 & 0xFF);
            g[i] = (byte)(val >> 8 & 0xFF);
            b[i] = (byte)(val & 0xFF);
        }
        IndexColorModel icm = new IndexColorModel(8, nCubes, r, g, b);
        BufferedImage indexed = new BufferedImage(w, h, 13, icm);
        Graphics2D g2d = indexed.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2d.drawImage((Image)bi, 0, 0, null);
        g2d.dispose();
        for (bits = 1; bits <= 8 && 1 << bits < nCubes; ++bits) {
        }
        if (bits > 4) {
            return indexed;
        }
        if (bits == 3) {
            bits = 4;
        }
        IndexColorModel cm = new IndexColorModel(bits, nCubes, r, g, b);
        MultiPixelPackedSampleModel sm = new MultiPixelPackedSampleModel(0, w, h, bits);
        WritableRaster ras = Raster.createWritableRaster(sm, new Point(0, 0));
        bi = indexed;
        indexed = new BufferedImage(cm, ras, bi.isAlphaPremultiplied(), null);
        GraphicsUtil.copyData(bi, indexed);
        return indexed;
    }

    private static class Cube {
        int[] min = new int[]{0, 0, 0};
        int[] max = new int[]{255, 255, 255};
        boolean done = false;
        Vector[] colors = null;
        int count = 0;
        static final int RED = 0;
        static final int GRN = 1;
        static final int BLU = 2;

        public Cube(Vector[] colors, int count) {
            this.colors = colors;
            this.count = count;
        }

        public boolean isDone() {
            return this.done;
        }

        public Cube split() {
            int c1;
            int splitChannel;
            int c0;
            int dr = this.max[0] - this.min[0] + 1;
            int dg = this.max[1] - this.min[1] + 1;
            int db = this.max[2] - this.min[2] + 1;
            if (dr >= dg) {
                c0 = 1;
                if (dr >= db) {
                    splitChannel = 0;
                    c1 = 2;
                } else {
                    splitChannel = 2;
                    c1 = 0;
                }
            } else if (dg >= db) {
                splitChannel = 1;
                c0 = 0;
                c1 = 2;
            } else {
                splitChannel = 2;
                c0 = 0;
                c1 = 1;
            }
            Cube ret = this.splitChannel(splitChannel, c0, c1);
            if (ret != null) {
                return ret;
            }
            ret = this.splitChannel(c0, splitChannel, c1);
            if (ret != null) {
                return ret;
            }
            ret = this.splitChannel(c1, splitChannel, c0);
            if (ret != null) {
                return ret;
            }
            this.done = true;
            return null;
        }

        public Cube splitChannel(int splitChannel, int c0, int c1) {
            if (this.min[splitChannel] == this.max[splitChannel]) {
                return null;
            }
            int splitSh4 = (2 - splitChannel) * 4;
            int c0Sh4 = (2 - c0) * 4;
            int c1Sh4 = (2 - c1) * 4;
            int half = this.count / 2;
            int[] counts = new int[256];
            int tcount = 0;
            int[] minIdx = new int[]{this.min[0] >> 4, this.min[1] >> 4, this.min[2] >> 4};
            int[] maxIdx = new int[]{this.max[0] >> 4, this.max[1] >> 4, this.max[2] >> 4};
            int minR = this.min[0];
            int minG = this.min[1];
            int minB = this.min[2];
            int maxR = this.max[0];
            int maxG = this.max[1];
            int maxB = this.max[2];
            int val = 0;
            int[] vals = new int[]{0, 0, 0};
            for (int i = minIdx[splitChannel]; i <= maxIdx[splitChannel]; ++i) {
                int idx1 = i << splitSh4;
                for (int j = minIdx[c0]; j <= maxIdx[c0]; ++j) {
                    int idx2 = idx1 | j << c0Sh4;
                    for (int k = minIdx[c1]; k <= maxIdx[c1]; ++k) {
                        int idx = idx2 | k << c1Sh4;
                        Vector v = this.colors[idx];
                        if (v == null) continue;
                        Iterator itr = v.iterator();
                        while (itr.hasNext()) {
                            Counter c = (Counter)itr.next();
                            val = c.val;
                            vals[0] = (val & 0xFF0000) >> 16;
                            vals[1] = (val & 0xFF00) >> 8;
                            vals[2] = val & 0xFF;
                            if (vals[0] < minR || vals[0] > maxR || vals[1] < minG || vals[1] > maxG || vals[2] < minB || vals[2] > maxB) continue;
                            int n = vals[splitChannel];
                            counts[n] = counts[n] + c.count;
                            tcount += c.count;
                        }
                    }
                }
                if (tcount >= half) break;
            }
            tcount = 0;
            int lastAdd = -1;
            int splitLo = this.min[splitChannel];
            int splitHi = this.max[splitChannel];
            for (int i = this.min[splitChannel]; i <= this.max[splitChannel]; ++i) {
                int c = counts[i];
                if (c == 0) {
                    if (tcount != 0 || i >= this.max[splitChannel]) continue;
                    this.min[splitChannel] = i + 1;
                    continue;
                }
                if (tcount + c < half) {
                    lastAdd = i;
                    tcount += c;
                    continue;
                }
                if (half - tcount <= tcount + c - half) {
                    if (lastAdd == -1) {
                        if (c == this.count) {
                            this.max[splitChannel] = i;
                            return null;
                        }
                        splitLo = i;
                        splitHi = i + 1;
                        break;
                    }
                    splitLo = lastAdd;
                    splitHi = i;
                    break;
                }
                if (i == this.max[splitChannel]) {
                    if (c == this.count) {
                        return null;
                    }
                    splitLo = lastAdd;
                    splitHi = i;
                    break;
                }
                tcount += c;
                splitLo = i;
                splitHi = i + 1;
                break;
            }
            Cube ret = new Cube(this.colors, tcount);
            this.count -= tcount;
            ret.min[splitChannel] = this.min[splitChannel];
            ret.max[splitChannel] = splitLo;
            this.min[splitChannel] = splitHi;
            ret.min[c0] = this.min[c0];
            ret.max[c0] = this.max[c0];
            ret.min[c1] = this.min[c1];
            ret.max[c1] = this.max[c1];
            return ret;
        }

        public int averageColor() {
            if (this.count == 0) {
                return 0;
            }
            float red = 0.0f;
            float grn = 0.0f;
            float blu = 0.0f;
            int minR = this.min[0];
            int minG = this.min[1];
            int minB = this.min[2];
            int maxR = this.max[0];
            int maxG = this.max[1];
            int maxB = this.max[2];
            int[] minIdx = new int[]{minR >> 4, minG >> 4, minB >> 4};
            int[] maxIdx = new int[]{maxR >> 4, maxG >> 4, maxB >> 4};
            for (int i = minIdx[0]; i <= maxIdx[0]; ++i) {
                int idx1 = i << 8;
                for (int j = minIdx[1]; j <= maxIdx[1]; ++j) {
                    int idx2 = idx1 | j << 4;
                    for (int k = minIdx[2]; k <= maxIdx[2]; ++k) {
                        int idx = idx2 | k;
                        Vector v = this.colors[idx];
                        if (v == null) continue;
                        Iterator itr = v.iterator();
                        while (itr.hasNext()) {
                            Counter c = (Counter)itr.next();
                            int val = c.val;
                            int ired = (val & 0xFF0000) >> 16;
                            int igrn = (val & 0xFF00) >> 8;
                            int iblu = val & 0xFF;
                            if (ired < minR || ired > maxR || igrn < minG || igrn > maxG || iblu < minB || iblu > maxB) continue;
                            float weight = (float)c.count / (float)this.count;
                            red += (float)ired * weight;
                            grn += (float)igrn * weight;
                            blu += (float)iblu * weight;
                        }
                    }
                }
            }
            return (int)((double)red + 0.5) << 16 | (int)((double)grn + 0.5) << 8 | (int)((double)blu + 0.5);
        }
    }

    private static class Counter {
        public int val;
        public int count = 1;

        public Counter(int val) {
            this.val = val;
        }

        public boolean add(int val) {
            if (this.val != val) {
                return false;
            }
            ++this.count;
            return true;
        }
    }
}

