/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.swc;

import flash.util.Trace;
import flex2.compiler.io.VirtualZipFile;
import flex2.compiler.io.ZipFileHolder;
import flex2.compiler.swc.SwcDynamicArchive;
import flex2.compiler.swc.SwcException;
import flex2.compiler.swc.zip.ZipEntry;
import flex2.compiler.swc.zip.ZipFile;
import flex2.compiler.util.MimeMappings;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;

public class SwcLazyReadArchive
extends SwcDynamicArchive {
    private ZipFile zipFile;

    public SwcLazyReadArchive(String path) {
        super(path);
    }

    public void load() {
        try {
            File file = new File(this.path);
            this.zipFile = new ZipFile(file);
            ZipFileHolder holder = new ZipFileHolder(this.zipFile, this.path);
            Enumeration e = this.zipFile.getEntries();
            while (e.hasMoreElements()) {
                ZipEntry ze = (ZipEntry)e.nextElement();
                VirtualZipFile f = new VirtualZipFile(holder, MimeMappings.getMimeType(ze.getName()), this.path + "$" + ze.getName(), ze.getName());
                this.files.put(ze.getName(), f);
            }
        }
        catch (SwcException.UnknownZipFormat e) {
            throw new SwcException.NotASwcFile(this.path);
        }
        catch (SwcException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SwcException.FilesNotRead(e.getMessage());
        }
    }

    public void close() {
        block2: {
            try {
                this.zipFile.close();
            }
            catch (IOException ioe) {
                if (!Trace.error) break block2;
                ioe.printStackTrace();
            }
        }
    }
}

