/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.config;

import flex2.compiler.config.ConfigurationBuffer;
import flex2.compiler.util.CompilerMessage;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ConfigurationInfo {
    private int argcount = -2;
    private String[] argnames;
    private Class[] argtypes;
    private Method setter;
    private Method getter;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ConfigurationInfo() {
        this.argcount = -2;
        this.argnames = null;
    }

    public ConfigurationInfo(int argcount) {
        this.argcount = argcount;
        this.argnames = null;
    }

    public ConfigurationInfo(String[] argnames) {
        this.argcount = argnames.length;
        this.argnames = argnames;
    }

    public ConfigurationInfo(int argcount, String argname) {
        this.argcount = argcount;
        this.argnames = new String[]{argname};
    }

    public ConfigurationInfo(int argcount, String[] argnames) {
        this.argcount = argcount;
        this.argnames = argnames;
    }

    public final int getArgCount() {
        return this.argcount;
    }

    private static String classToArgName(Class c) {
        String className = c.getName();
        if (className.startsWith("java.lang.")) {
            className = className.substring("java.lang.".length());
        }
        return className.toLowerCase();
    }

    public String getArgName(int argnum) {
        if (this.argnames == null || this.argnames.length == 0) {
            return ConfigurationInfo.classToArgName(this.getArgType(argnum));
        }
        if (argnum >= this.argnames.length) {
            return this.argnames[this.argnames.length - 1];
        }
        return this.argnames[argnum];
    }

    public final Class getArgType(int argnum) {
        if (argnum >= this.argtypes.length) {
            return this.argtypes[this.argtypes.length - 1];
        }
        return this.argtypes[argnum];
    }

    public String[] getPrerequisites() {
        return null;
    }

    public String[] getSoftPrerequisites() {
        return null;
    }

    public boolean allowMultiple() {
        return false;
    }

    public String[] getAliases() {
        return null;
    }

    public boolean isAdvanced() {
        return false;
    }

    public boolean isHidden() {
        return false;
    }

    public boolean isDisplayed() {
        return true;
    }

    public boolean isRequired() {
        return false;
    }

    public boolean isGreedy() {
        return false;
    }

    public boolean isPath() {
        return false;
    }

    public boolean doChecksum() {
        return true;
    }

    public CompilerMessage.CompilerWarning getDeprecatedMessage() {
        return null;
    }

    public boolean isDeprecated() {
        return false;
    }

    public String getDeprecatedReplacement() {
        return null;
    }

    public String getDeprecatedSince() {
        return null;
    }

    protected final void setSetterMethod(Method setter) {
        Class<?>[] pt = setter.getParameterTypes();
        if (!$assertionsDisabled && pt.length < 2) {
            throw new AssertionError((Object)"coding error: config setter must take at least 2 args!");
        }
        this.setter = setter;
        if (pt.length == 2) {
            Class<?> c = pt[1];
            if (ConfigurationBuffer.isSupportedListType(c)) {
                if (this.argcount == -2) {
                    this.argcount = -1;
                }
                this.argtypes = new Class[]{String.class};
                return;
            }
            if (ConfigurationBuffer.isSupportedValueType(c)) {
                if (!$assertionsDisabled && this.argcount != -2) {
                    throw new AssertionError((Object)"coding error: value object setter cannot override argcount");
                }
                if (!$assertionsDisabled && this.argnames != null) {
                    throw new AssertionError((Object)"coding error: value object setter cannot override argnames");
                }
                Field[] fields = c.getFields();
                this.argcount = fields.length;
                if (!$assertionsDisabled && this.argcount <= 0) {
                    throw new AssertionError((Object)("coding error: " + setter + " value object " + c.getName() + " must contain at least one public field"));
                }
                this.argnames = new String[fields.length];
                this.argtypes = new Class[fields.length];
                for (int f = 0; f < fields.length; ++f) {
                    this.argnames[f] = ConfigurationBuffer.c2h(fields[f].getName());
                    this.argtypes[f] = fields[f].getType();
                }
                return;
            }
        }
        if (!$assertionsDisabled && this.argcount != -2 && this.argcount != pt.length - 1) {
            throw new AssertionError((Object)"coding error: the argument count must match the number of setter arguments");
        }
        this.argcount = pt.length - 1;
        this.argtypes = new Class[pt.length - 1];
        for (int i = 1; i < pt.length; ++i) {
            if (!$assertionsDisabled && !ConfigurationBuffer.isSupportedSimpleType(pt[i])) {
                throw new AssertionError((Object)("coding error: " + setter.getClass().getName() + "." + setter.getName() + " parameter " + i + " is not a supported type!"));
            }
            this.argtypes[i - 1] = pt[i];
        }
    }

    protected final Method getSetterMethod() {
        return this.setter;
    }

    protected final void setGetterMethod(Method getter) {
        this.getter = getter;
    }

    protected final Method getGetterMethod() {
        return this.getter;
    }

    static {
        $assertionsDisabled = !ConfigurationInfo.class.desiredAssertionStatus();
    }
}

