/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.commons.collections.primitives.AbstractIntArrayList;

public class UnsignedShortArrayList
extends AbstractIntArrayList
implements Serializable {
    private transient short[] _data = null;
    private int _size = 0;
    public static final int MAX_VALUE = 65535;
    public static final int MIN_VALUE = 0;

    public UnsignedShortArrayList() {
        this(8);
    }

    public UnsignedShortArrayList(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity=" + capacity);
        }
        this._data = new short[capacity];
    }

    public int capacity() {
        return this._data.length;
    }

    public int size() {
        return this._size;
    }

    public int getInt(int index) {
        this.checkRange(index);
        return this.toInt(this._data[index]);
    }

    public boolean containsInt(int value) {
        this.assertValidUnsignedShort(value);
        return -1 != this.indexOfInt(value);
    }

    public int indexOfInt(int value) {
        this.assertValidUnsignedShort(value);
        short ivalue = this.fromInt(value);
        int i = 0;
        while (i < this._size) {
            if (ivalue == this._data[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOfInt(int value) {
        this.assertValidUnsignedShort(value);
        short ivalue = this.fromInt(value);
        int i = this._size - 1;
        while (i >= 0) {
            if (ivalue == this._data[i]) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public int setInt(int index, int value) {
        this.assertValidUnsignedShort(value);
        this.checkRange(index);
        int old = this.toInt(this._data[index]);
        this._data[index] = this.fromInt(value);
        return old;
    }

    public boolean addInt(int value) {
        this.assertValidUnsignedShort(value);
        this.ensureCapacity(this._size + 1);
        this._data[this._size++] = this.fromInt(value);
        return true;
    }

    public void addInt(int index, int value) {
        this.assertValidUnsignedShort(value);
        this.checkRangeIncludingEndpoint(index);
        this.ensureCapacity(this._size + 1);
        int numtomove = this._size - index;
        System.arraycopy(this._data, index, this._data, index + 1, numtomove);
        this._data[index] = this.fromInt(value);
        ++this._size;
    }

    public void clear() {
        ++this.modCount;
        this._size = 0;
    }

    public int removeIntAt(int index) {
        this.checkRange(index);
        ++this.modCount;
        int oldval = this.toInt(this._data[index]);
        int numtomove = this._size - index - 1;
        if (numtomove > 0) {
            System.arraycopy(this._data, index + 1, this._data, index, numtomove);
        }
        --this._size;
        return oldval;
    }

    public boolean removeInt(int value) {
        this.assertValidUnsignedShort(value);
        int index = this.indexOfInt(value);
        if (-1 == index) {
            return false;
        }
        this.removeIntAt(index);
        return true;
    }

    public void ensureCapacity(int mincap) {
        ++this.modCount;
        if (mincap > this._data.length) {
            int newcap = this._data.length * 3 / 2 + 1;
            short[] olddata = this._data;
            this._data = new short[newcap < mincap ? mincap : newcap];
            System.arraycopy(olddata, 0, this._data, 0, this._size);
        }
    }

    public void trimToSize() {
        ++this.modCount;
        if (this._size < this._data.length) {
            short[] olddata = this._data;
            this._data = new short[this._size];
            System.arraycopy(olddata, 0, this._data, 0, this._size);
        }
    }

    private final int toInt(short value) {
        return value & 0xFFFF;
    }

    private final short fromInt(int value) {
        return (short)(value & 0xFFFF);
    }

    private final void assertValidUnsignedShort(int value) throws IllegalArgumentException {
        if (value > 65535) {
            throw new IllegalArgumentException(value + " > " + 65535);
        }
        if (value < 0) {
            throw new IllegalArgumentException(value + " < " + 0);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this._data.length);
        int i = 0;
        while (i < this._size) {
            out.writeShort(this._data[i]);
            ++i;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._data = new short[in.readInt()];
        int i = 0;
        while (i < this._size) {
            this._data[i] = in.readShort();
            ++i;
        }
    }

    private final void checkRange(int index) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and less than " + this._size + ", found " + index);
        }
    }

    private final void checkRangeIncludingEndpoint(int index) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and at most " + this._size + ", found " + index);
        }
    }
}

