/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools;

import flex2.tools.Compc;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class CopyLocale {
    private File sdkDir;
    private String srcLocale;
    private String dstLocale;
    private String[] projects;
    private HashMap bundleNamesForProject = new HashMap();

    public static void main(String[] args) {
        CopyLocale copyLocale = new CopyLocale();
        copyLocale.run(args);
    }

    private CopyLocale() {
    }

    private void run(String[] args) {
        if (!this.checkArguments(args)) {
            return;
        }
        System.out.println("In Flex SDK at " + this.sdkDir + " ...");
        int n = this.projects.length;
        for (int i = 0; i < n; ++i) {
            this.copyPropertiesFiles(this.projects[i]);
            this.compileSWC(this.projects[i]);
        }
    }

    private boolean checkArguments(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage: copylocale src_locale dst_locale");
            return false;
        }
        boolean success = true;
        this.sdkDir = new File(System.getProperty("application.home"));
        this.srcLocale = args[0];
        this.dstLocale = args[1];
        File projectsDir = new File(this.sdkDir, "frameworks/projects");
        File[] projectDirs = projectsDir.listFiles();
        ArrayList<String> projectList = new ArrayList<String>();
        int n = projectDirs.length;
        for (int i = 0; i < n; ++i) {
            File projectDir = projectDirs[i];
            File bundlesDir = new File(projectDir, "bundles");
            if (!bundlesDir.exists()) continue;
            String project = projectDir.getName();
            projectList.add(project);
            File srcLocaleDir = new File(bundlesDir, this.srcLocale);
            File srcDir = new File(srcLocaleDir, "src");
            if (srcLocaleDir.exists() && srcDir.exists()) continue;
            System.err.println("Error: Directory \"" + srcDir + "\" does not exist");
            success = false;
        }
        this.projects = new String[projectList.size()];
        projectList.toArray(this.projects);
        return success;
    }

    private void copyPropertiesFiles(String project) {
        File bundlesDir = new File(this.sdkDir, "frameworks/projects/" + project + "/bundles");
        File fromSrcDir = new File(bundlesDir, this.srcLocale + "/src");
        File[] propertiesFiles = fromSrcDir.listFiles();
        ArrayList<String> bundleNameList = new ArrayList<String>();
        int m = propertiesFiles.length;
        for (int j = 0; j < m; ++j) {
            String name = propertiesFiles[j].getName();
            if (!name.endsWith(".properties")) continue;
            String bundleName = name.substring(0, name.length() - 11);
            bundleNameList.add(bundleName);
        }
        String[] bundleNames = new String[bundleNameList.size()];
        bundleNameList.toArray(bundleNames);
        this.bundleNamesForProject.put(project, bundleNames);
        File toSrcDir = new File(bundlesDir, this.dstLocale + "/src");
        int len = this.sdkDir.toString().length() + 1;
        System.out.println();
        System.out.println("Copying files from " + fromSrcDir.toString().substring(len));
        System.out.println("                to " + toSrcDir.toString().substring(len) + ":");
        System.out.println();
        try {
            this.copyDirectory(fromSrcDir, toSrcDir);
        }
        catch (IOException e) {
            System.err.println("Error: Can't copy .properties files");
        }
    }

    public void copyDirectory(File fromDir, File toDir) throws IOException {
        if (fromDir.isDirectory()) {
            toDir.mkdirs();
            String[] children = fromDir.list();
            int n = children.length;
            for (int i = 0; i < n; ++i) {
                this.copyDirectory(new File(fromDir, children[i]), new File(toDir, children[i]));
            }
        } else {
            int length;
            System.out.println(fromDir.getName());
            FileInputStream in = new FileInputStream(fromDir);
            FileOutputStream out = new FileOutputStream(toDir);
            byte[] buffer = new byte[32768];
            while ((length = in.read(buffer)) > 0) {
                out.write(buffer, 0, length);
            }
            in.close();
            out.close();
        }
    }

    private void compileSWC(String project) {
        File srcDir = new File(this.sdkDir, "frameworks/projects/" + project + "/bundles/" + this.dstLocale + "/src");
        String bundleNameString = "";
        String[] bundleNames = (String[])this.bundleNamesForProject.get(project);
        int n = bundleNames.length;
        for (int i = 0; i < n; ++i) {
            bundleNameString = bundleNameString + bundleNames[i];
            if (i >= n - 1) continue;
            bundleNameString = bundleNameString + ",";
        }
        File outputDir = new File(this.sdkDir, "frameworks/locale/" + this.dstLocale);
        File outputSWC = new File(outputDir, project + "_rb.swc");
        int len = this.sdkDir.toString().length() + 1;
        System.out.println();
        System.out.println("Compiling resource bundle SWC " + outputSWC.toString().substring(len) + ":");
        System.out.println();
        String[] args = new String[]{"-locale=" + this.dstLocale, "-source-path", srcDir.toString(), "-include-resource-bundles=" + bundleNameString, "-output", outputSWC.toString()};
        outputDir.mkdirs();
        Compc.compc((String[])args);
    }
}

