/*
 * Decompiled with CFR 0.152.
 */
package primitives;

import dialogs.ParameterDescription;
import export.ExportInterface;
import geom.GeometricDistances;
import geom.MapCoordinates;
import globals.Globals;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.io.IOException;
import java.util.Vector;
import primitives.GraphicPrimitive;
import primitives.StrokeStyle;

public final class PrimitivePCBLine
extends GraphicPrimitive {
    private int width;
    static final int N_POINTS = 4;
    static StrokeStyle pcbStrokeStyle;
    private int xa;
    private int ya;
    private int xb;
    private int yb;
    private int x1;
    private int y1;
    private int x2;
    private int y2;
    private int wi_pix;
    private Stroke stroke;
    private int xbpap1;
    private int ybpap1;

    public int getControlPointNumber() {
        return 4;
    }

    public PrimitivePCBLine() {
        this.width = 0;
        this.initPrimitive(-1);
    }

    public PrimitivePCBLine(int x1, int y1, int x2, int y2, int w, int layer) {
        this.initPrimitive(-1);
        this.virtualPoint[0].x = x1;
        this.virtualPoint[0].y = y1;
        this.virtualPoint[1].x = x2;
        this.virtualPoint[1].y = y2;
        this.virtualPoint[this.getNameVirtualPointNumber()].x = x1 + 5;
        this.virtualPoint[this.getNameVirtualPointNumber()].y = y1 + 5;
        this.virtualPoint[this.getValueVirtualPointNumber()].x = x1 + 5;
        this.virtualPoint[this.getValueVirtualPointNumber()].y = y1 + 10;
        this.width = w;
        this.setLayer(layer);
    }

    public final void draw(Graphics2D g, MapCoordinates coordSys, Vector layerV) {
        if (!this.selectLayer(g, layerV)) {
            return;
        }
        this.drawText(g, coordSys, layerV, -1);
        if (this.changed) {
            this.changed = false;
            this.x1 = coordSys.mapX(this.virtualPoint[0].x, this.virtualPoint[0].y);
            this.y1 = coordSys.mapY(this.virtualPoint[0].x, this.virtualPoint[0].y);
            this.x2 = coordSys.mapX(this.virtualPoint[1].x, this.virtualPoint[1].y);
            this.y2 = coordSys.mapY(this.virtualPoint[1].x, this.virtualPoint[1].y);
            this.wi_pix = Math.abs(coordSys.mapXi(this.virtualPoint[0].x, this.virtualPoint[0].y, false) - coordSys.mapXi(this.virtualPoint[0].x + this.width, this.virtualPoint[0].y + this.width, false));
            this.xa = Math.min(this.x1, this.x2) - this.wi_pix / 2;
            this.ya = Math.min(this.y1, this.y2) - this.wi_pix / 2;
            this.xb = Math.max(this.x1, this.x2) + this.wi_pix / 2;
            this.yb = Math.max(this.y1, this.y2) + this.wi_pix / 2;
            coordSys.trackPoint(this.xa, this.ya);
            coordSys.trackPoint(this.xb, this.yb);
            if (pcbStrokeStyle == null) {
                pcbStrokeStyle = new StrokeStyle();
            }
            this.stroke = pcbStrokeStyle.getStroke(this.wi_pix, 0);
            this.xbpap1 = this.xb - this.xa + 1;
            this.ybpap1 = this.yb - this.ya + 1;
        }
        if (!g.hitClip(this.xa, this.ya, this.xbpap1, this.ybpap1)) {
            return;
        }
        if (!this.stroke.equals(g.getStroke())) {
            g.setStroke(this.stroke);
        }
        g.drawLine(this.x1, this.y1, this.x2, this.y2);
    }

    public void parseTokens(String[] tokens, int N) throws IOException {
        this.changed = true;
        if (tokens[0].equals("PL")) {
            if (N < 6) {
                IOException E = new IOException("bad arguments on PL");
                throw E;
            }
            int x1 = this.virtualPoint[0].x = Integer.parseInt(tokens[1]);
            int y1 = this.virtualPoint[0].y = Integer.parseInt(tokens[2]);
            this.virtualPoint[1].x = Integer.parseInt(tokens[3]);
            this.virtualPoint[1].y = Integer.parseInt(tokens[4]);
            this.virtualPoint[this.getNameVirtualPointNumber()].x = x1 + 5;
            this.virtualPoint[this.getNameVirtualPointNumber()].y = y1 + 5;
            this.virtualPoint[this.getValueVirtualPointNumber()].x = x1 + 5;
            this.virtualPoint[this.getValueVirtualPointNumber()].y = y1 + 10;
            this.width = Integer.parseInt(tokens[5]);
            if (N > 6) {
                this.parseLayer(tokens[6]);
            }
        } else {
            IOException E = new IOException("PL: Invalid primitive:" + tokens[0] + " programming error?");
            throw E;
        }
    }

    public Vector getControls() {
        Vector v = super.getControls();
        ParameterDescription pd = new ParameterDescription();
        pd.parameter = new Integer(this.width);
        pd.description = Globals.messages.getString("ctrl_width");
        v.add(pd);
        return v;
    }

    public int setControls(Vector v) {
        int i = super.setControls(v);
        ParameterDescription pd = (ParameterDescription)v.get(i);
        ++i;
        if (pd.parameter instanceof Integer) {
            this.width = (Integer)pd.parameter;
        } else {
            System.out.println("Warning: unexpected parameter!" + pd);
        }
        return i;
    }

    public int getDistanceToPoint(int px, int py) {
        if (this.checkText(px, py)) {
            return 0;
        }
        int distance = GeometricDistances.pointToSegment(this.virtualPoint[0].x, this.virtualPoint[0].y, this.virtualPoint[1].x, this.virtualPoint[1].y, px, py) - this.width / 2;
        return distance < 0 ? 0 : distance;
    }

    public String toString(boolean extensions) {
        String s = "PL " + this.virtualPoint[0].x + " " + this.virtualPoint[0].y + " " + this.virtualPoint[1].x + " " + this.virtualPoint[1].y + " " + this.width + " " + this.getLayer() + "\n";
        s = s + this.saveText(extensions);
        return s;
    }

    public void export(ExportInterface exp, MapCoordinates cs) throws IOException {
        this.exportText(exp, cs, -1);
        exp.exportPCBLine(cs.mapX(this.virtualPoint[0].x, this.virtualPoint[0].y), cs.mapY(this.virtualPoint[0].x, this.virtualPoint[0].y), cs.mapX(this.virtualPoint[1].x, this.virtualPoint[1].y), cs.mapY(this.virtualPoint[1].x, this.virtualPoint[1].y), (int)((double)this.width * cs.getXMagnitude()), this.getLayer());
    }

    public int getNameVirtualPointNumber() {
        return 2;
    }

    public int getValueVirtualPointNumber() {
        return 3;
    }
}

