/*
 * Decompiled with CFR 0.152.
 */
package export;

import export.ExportInterface;
import globals.Globals;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JOptionPane;
import layers.LayerDesc;

public class ExportPDF
implements ExportInterface {
    private File fileExp;
    private File temp;
    private OutputStreamWriter fstream;
    private OutputStreamWriter fstreamt;
    private BufferedWriter out;
    private BufferedWriter outt;
    private boolean fontWarning;
    private String head;
    private String[] obj_PDF;
    private final int numOfObjects = 20;
    private String closeObject;
    private long fileLength;
    private Vector layerV;
    private int numberPath;
    private int xsize;
    private int ysize;
    private Color actualColor;
    private double actualWidth;
    private int actualDash;
    static final String[] dash = new String[]{"[5.0 10]", "[2.5 2.5]", "[1.0 1.0]", "[1.0 2.5]", "[1.0 2.5 2.5 2.5]"};

    public int cLe(double l) {
        return (int)l;
    }

    public ExportPDF(File f) throws IOException {
        this.fileExp = f;
        this.fstream = new OutputStreamWriter((OutputStream)new FileOutputStream(this.fileExp), "8859_1");
        this.temp = File.createTempFile("real", ".howto");
        this.temp.deleteOnExit();
        this.fstreamt = new OutputStreamWriter((OutputStream)new FileOutputStream(this.temp), "8859_1");
        this.obj_PDF = new String[20];
    }

    public void exportStart(Dimension totalSize, Vector la, int grid) throws IOException {
        this.layerV = la;
        this.out = new BufferedWriter(this.fstream);
        this.fontWarning = false;
        this.outt = new BufferedWriter(this.fstreamt);
        this.numberPath = 0;
        int wi = totalSize.width;
        int he = totalSize.height;
        double res_mult = 2.7777777777777777;
        int border = 5;
        this.head = "%PDF-1.4\n";
        this.obj_PDF[5] = "5 0 obj\n  <</Kids [4 0 R ]\n    /Count 1\n    /Type /Pages\n    /MediaBox [ 0 0  " + (int)((double)totalSize.width / res_mult + 1.0 + (double)border) + " " + (int)((double)totalSize.height / res_mult + 1.0 + (double)border) + " ]\n" + "  >> endobj\n";
        this.actualColor = null;
        this.actualWidth = -1.0;
        this.outt.write("   1 0 0 1 0 " + ((double)totalSize.height / res_mult + (double)border) + "  cm\n");
        this.outt.write("  " + 1.0 / res_mult + " 0  0 " + -1.0 / res_mult + " 0 0  cm\n");
        this.outt.write("1 J\n");
    }

    public void exportEnd() throws IOException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Date date = new Date();
        this.outt.close();
        this.fileLength = this.temp.length();
        this.writeFontDescription();
        this.obj_PDF[8] = "8 0 obj\n  <<\n    /Length " + this.fileLength + "\n" + "  >>\n" + "  stream\n";
        this.out.write(this.head + this.obj_PDF[5] + this.obj_PDF[6] + this.obj_PDF[7] + this.obj_PDF[8]);
        this.obj_PDF[4] = "4 0 obj\n<<\t\n  /Type /Page\n  /Parent 5 0 R\n  /Resources <<\n  /Font <<\n  /F1 6 0 R\n  /F2 7 0 R\n  /F3 9 0 R\n  /F4 10 0 R\n  /F5 11 0 R\n  /F6 12 0 R\n  /F7 13 0 R\n  /F8 14 0 R\n>>\n/ProcSet 2 0 R\n>>\n  /Contents 8 0 R\n>>\nendobj\n";
        this.obj_PDF[2] = "2 0 obj\n[ /PDF /Text  ]\nendobj\n";
        this.obj_PDF[1] = "1 0 obj\n<<\n  /Creator (FidoCadJ0.24, PDF export filter by Davide Bucci)\n  /Author (" + System.getProperty("user.name") + ")\n" + "  /Producer (FidoCadJ)\n" + ">>\n" + "endobj\n";
        this.obj_PDF[3] = "3 0 obj\n<<\n  /Pages 5 0 R\n  /Type /Catalog\n>>\nendobj\n";
        BufferedInputStream bufRead = new BufferedInputStream(new FileInputStream(this.temp));
        int c = 0;
        c = bufRead.read();
        while (c != -1) {
            this.out.write(c);
            c = bufRead.read();
        }
        bufRead.close();
        this.closeObject = "endstream\nendobj\n";
        this.out.write(this.closeObject + this.obj_PDF[4] + this.obj_PDF[2] + this.obj_PDF[1] + this.obj_PDF[3] + this.obj_PDF[9] + this.obj_PDF[10] + this.obj_PDF[11] + this.obj_PDF[12] + this.obj_PDF[13] + this.obj_PDF[14]);
        this.writeCrossReferenceTable();
        this.out.close();
        if (this.fontWarning) {
            JOptionPane.showMessageDialog(null, Globals.messages.getString("PDF_Font_error"));
        }
    }

    private void writeFontDescription() throws IOException {
        this.obj_PDF[6] = "6 0 obj\n  <<\t/Type /Font\n    /Subtype /Type1\n    /Name /F1\n    /BaseFont /Courier\n    /Encoding /WinAnsiEncoding\n  >> endobj\n";
        this.obj_PDF[7] = "7 0 obj\n  <<\t/Type /Font\n    /Subtype /Type1\n    /Name /F2\n    /BaseFont /Courier-Bold\n    /Encoding /WinAnsiEncoding\n  >> endobj\n";
        this.obj_PDF[9] = "9 0 obj\n  <<\t/Type /Font\n    /Subtype /Type1\n    /Name /F3\n    /BaseFont /Times-Roman\n    /Encoding /WinAnsiEncoding\n  >> endobj\n";
        this.obj_PDF[10] = "10 0 obj\n  <<\t/Type /Font\n    /Subtype /Type1\n    /Name /F4\n    /BaseFont /Times-Bold\n    /Encoding /WinAnsiEncoding\n  >> endobj\n";
        this.obj_PDF[11] = "11 0 obj\n  <<\t/Type /Font\n    /Subtype /Type1\n    /Name /F5\n    /BaseFont /Helvetica\n    /Encoding /WinAnsiEncoding\n  >> endobj\n";
        this.obj_PDF[12] = "12 0 obj\n  <<\t/Type /Font\n    /Subtype /Type1\n    /Name /F6\n    /BaseFont /Helvetica-Bold\n    /Encoding /WinAnsiEncoding\n  >> endobj\n";
        this.obj_PDF[13] = "13 0 obj\n  <<\t/Type /Font\n    /Subtype /Type1\n    /Name /F7\n    /BaseFont /Symbol\n    /Encoding /WinAnsiEncoding\n  >> endobj\n";
        this.obj_PDF[14] = "14 0 obj\n  <<\t/Type /Font\n    /Subtype /Type1\n    /Name /F8\n    /BaseFont /Symbol\n    /Encoding /WinAnsiEncoding\n  >> endobj\n";
    }

    private void writeCrossReferenceTable() throws IOException {
        this.out.write("xref \n0 15\n0000000000 65535 f \n" + this.addLeadZeros((long)(this.head.length() + this.obj_PDF[5].length() + this.obj_PDF[6].length() + this.obj_PDF[7].length() + this.obj_PDF[8].length()) + this.fileLength + (long)this.closeObject.length() + (long)this.obj_PDF[4].length() + (long)this.obj_PDF[2].length()) + " 00000 n \n" + this.addLeadZeros((long)(this.head.length() + this.obj_PDF[5].length() + this.obj_PDF[6].length() + this.obj_PDF[7].length() + this.obj_PDF[8].length()) + this.fileLength + (long)this.closeObject.length() + (long)this.obj_PDF[4].length()) + " 00000 n \n" + this.addLeadZeros((long)(this.head.length() + this.obj_PDF[5].length() + this.obj_PDF[6].length() + this.obj_PDF[7].length() + this.obj_PDF[8].length()) + this.fileLength + (long)this.closeObject.length() + (long)this.obj_PDF[4].length() + (long)this.obj_PDF[2].length() + (long)this.obj_PDF[1].length()) + " 00000 n \n" + this.addLeadZeros((long)(this.head.length() + this.obj_PDF[5].length() + this.obj_PDF[6].length() + this.obj_PDF[7].length() + this.obj_PDF[8].length()) + this.fileLength + (long)this.closeObject.length()) + " 00000 n \n" + this.addLeadZeros(this.head.length()) + " 00000 n \n" + this.addLeadZeros(this.head.length() + this.obj_PDF[5].length()) + " 00000 n \n" + this.addLeadZeros(this.head.length() + this.obj_PDF[5].length() + this.obj_PDF[6].length()) + " 00000 n \n" + this.addLeadZeros(this.head.length() + this.obj_PDF[5].length() + this.obj_PDF[6].length() + this.obj_PDF[7].length()) + " 00000 n \n" + this.addLeadZeros((long)(this.head.length() + this.obj_PDF[5].length() + this.obj_PDF[6].length() + this.obj_PDF[7].length() + this.obj_PDF[8].length()) + this.fileLength + (long)this.closeObject.length() + (long)this.obj_PDF[4].length() + (long)this.obj_PDF[2].length() + (long)this.obj_PDF[1].length() + (long)this.obj_PDF[3].length()) + " 00000 n \n" + this.addLeadZeros((long)(this.head.length() + this.obj_PDF[5].length() + this.obj_PDF[6].length() + this.obj_PDF[7].length() + this.obj_PDF[8].length()) + this.fileLength + (long)this.closeObject.length() + (long)this.obj_PDF[4].length() + (long)this.obj_PDF[2].length() + (long)this.obj_PDF[1].length() + (long)this.obj_PDF[3].length() + (long)this.obj_PDF[9].length()) + " 00000 n \n" + this.addLeadZeros((long)(this.head.length() + this.obj_PDF[5].length() + this.obj_PDF[6].length() + this.obj_PDF[7].length() + this.obj_PDF[8].length()) + this.fileLength + (long)this.closeObject.length() + (long)this.obj_PDF[4].length() + (long)this.obj_PDF[2].length() + (long)this.obj_PDF[1].length() + (long)this.obj_PDF[3].length() + (long)this.obj_PDF[9].length() + (long)this.obj_PDF[10].length()) + " 00000 n \n" + this.addLeadZeros((long)(this.head.length() + this.obj_PDF[5].length() + this.obj_PDF[6].length() + this.obj_PDF[7].length() + this.obj_PDF[8].length()) + this.fileLength + (long)this.closeObject.length() + (long)this.obj_PDF[4].length() + (long)this.obj_PDF[2].length() + (long)this.obj_PDF[1].length() + (long)this.obj_PDF[3].length() + (long)this.obj_PDF[9].length() + (long)this.obj_PDF[10].length() + (long)this.obj_PDF[11].length()) + " 00000 n \n" + this.addLeadZeros((long)(this.head.length() + this.obj_PDF[5].length() + this.obj_PDF[6].length() + this.obj_PDF[7].length() + this.obj_PDF[8].length()) + this.fileLength + (long)this.closeObject.length() + (long)this.obj_PDF[4].length() + (long)this.obj_PDF[2].length() + (long)this.obj_PDF[1].length() + (long)this.obj_PDF[3].length() + (long)this.obj_PDF[9].length() + (long)this.obj_PDF[10].length() + (long)this.obj_PDF[11].length() + (long)this.obj_PDF[12].length()) + " 00000 n \n" + this.addLeadZeros((long)(this.head.length() + this.obj_PDF[5].length() + this.obj_PDF[6].length() + this.obj_PDF[7].length() + this.obj_PDF[8].length()) + this.fileLength + (long)this.closeObject.length() + (long)this.obj_PDF[4].length() + (long)this.obj_PDF[2].length() + (long)this.obj_PDF[1].length() + (long)this.obj_PDF[3].length() + (long)this.obj_PDF[9].length() + (long)this.obj_PDF[10].length() + (long)this.obj_PDF[11].length() + (long)this.obj_PDF[12].length() + (long)this.obj_PDF[13].length()) + " 00000 n \n");
        this.out.write("trailer\n<<\n  /Size 15\n  /Root 3 0 R\n  /Info 1 0 R\n>>\nstartxref\n" + ((long)(this.head.length() + this.obj_PDF[5].length() + this.obj_PDF[6].length() + this.obj_PDF[7].length() + this.obj_PDF[8].length()) + this.fileLength + (long)this.closeObject.length() + (long)this.obj_PDF[4].length() + (long)this.obj_PDF[2].length() + (long)this.obj_PDF[1].length() + (long)this.obj_PDF[3].length() + (long)this.obj_PDF[9].length() + (long)this.obj_PDF[10].length() + (long)this.obj_PDF[11].length() + (long)this.obj_PDF[12].length() + (long)this.obj_PDF[13].length() + (long)this.obj_PDF[14].length()) + "\n%%EOF");
    }

    public void exportAdvText(int x, int y, int sizex, int sizey, String fontname, boolean isBold, boolean isMirrored, boolean isItalic, int orientation, int layer, String text) throws IOException {
        if (text.equals("")) {
            return;
        }
        LayerDesc l = (LayerDesc)this.layerV.get(layer);
        Color c = l.getColor();
        String bold = "";
        this.checkColorAndWidth(c, 0.33);
        this.outt.write("BT\n");
        int ys = (int)((double)(sizex * 12 / 7) + 0.5);
        if (fontname.equals("Courier") || fontname.equals("Courier New")) {
            if (isBold) {
                this.outt.write("/F2 " + ys + " Tf\n");
            } else {
                this.outt.write("/F1 " + ys + " Tf\n");
            }
        } else if (fontname.equals("Times") || fontname.equals("Times New Roman") || fontname.equals("Times Roman")) {
            if (isBold) {
                this.outt.write("/F4 " + ys + " Tf\n");
            } else {
                this.outt.write("/F3 " + ys + " Tf\n");
            }
        } else if (fontname.equals("Helvetica") || fontname.equals("Arial")) {
            if (isBold) {
                this.outt.write("/F6 " + ys + " Tf\n");
            } else {
                this.outt.write("/F5 " + ys + " Tf\n");
            }
        } else if (fontname.equals("Symbol")) {
            if (isBold) {
                this.outt.write("/F8 " + ys + " Tf\n");
            } else {
                this.outt.write("/F7 " + ys + " Tf\n");
            }
        } else {
            this.fontWarning = true;
            this.outt.write("/F4 " + ys + " Tf\n");
        }
        this.outt.write("q\n");
        this.outt.write("  1 0 0 1 " + this.roundTo(x) + " " + this.roundTo(y) + " cm\n");
        if (orientation != 0) {
            double alpha = (double)(isMirrored ? orientation : -orientation) / 180.0 * Math.PI;
            this.outt.write("  " + this.roundTo(Math.cos(alpha)) + " " + this.roundTo(Math.sin(alpha)) + " " + this.roundTo(-Math.sin(alpha)) + " " + this.roundTo(Math.cos(alpha)) + " 0 0 cm\n");
        }
        if (isMirrored) {
            this.outt.write("  -1 0 0 -1 0 0 cm\n");
        } else {
            this.outt.write("  1 0 0 -1 0 0 cm\n");
        }
        double ratio = sizey / sizex != 1 ? (double)sizey / (double)sizex * 22.0 / 40.0 : 1.0;
        this.outt.write("  1 0 0 " + this.roundTo(ratio) + " 0 " + (double)(-ys) * ratio * 0.8 + " cm\n");
        HashMap<String, String> subst = new HashMap<String, String>();
        subst.put("(", "\\050");
        subst.put(")", "\\051");
        text = Globals.substituteBizarreChars(text, subst);
        this.outt.write("  (" + text + ") Tj\n");
        this.outt.write("Q\nET\n");
    }

    public void exportBezier(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4, int layer, boolean arrowStart, boolean arrowEnd, int arrowStyle, int arrowLength, int arrowHalfWidth, int dashStyle, double strokeWidth) throws IOException {
        LayerDesc l = (LayerDesc)this.layerV.get(layer);
        Color c = l.getColor();
        this.checkColorAndWidth(c, strokeWidth);
        this.registerDash(dashStyle);
        this.outt.write("" + x1 + " " + y1 + " m \n");
        this.outt.write("" + x2 + " " + y2 + " " + x3 + " " + y3 + " " + x4 + " " + y4 + " c S\n");
        if (arrowStart) {
            this.exportArrow(x1, y1, x2, y2, arrowLength, arrowHalfWidth, arrowStyle);
        }
        if (arrowEnd) {
            this.exportArrow(x4, y4, x3, y3, arrowLength, arrowHalfWidth, arrowStyle);
        }
    }

    public void exportConnection(int x, int y, int layer, double node_size) throws IOException {
        LayerDesc l = (LayerDesc)this.layerV.get(layer);
        Color c = l.getColor();
        this.checkColorAndWidth(c, 0.33);
        this.ellipse((double)x - node_size / 2.0, (double)y - node_size / 2.0, (double)x + node_size / 2.0, (double)y + node_size / 2.0, true);
    }

    public void exportLine(double x1, double y1, double x2, double y2, int layer, boolean arrowStart, boolean arrowEnd, int arrowStyle, int arrowLength, int arrowHalfWidth, int dashStyle, double strokeWidth) throws IOException {
        LayerDesc l = (LayerDesc)this.layerV.get(layer);
        Color c = l.getColor();
        this.checkColorAndWidth(c, strokeWidth);
        this.registerDash(dashStyle);
        this.outt.write("  " + x1 + " " + y1 + " m " + x2 + " " + y2 + " l S\n");
        if (arrowStart) {
            this.exportArrow(x1, y1, x2, y2, arrowLength, arrowHalfWidth, arrowStyle);
        }
        if (arrowEnd) {
            this.exportArrow(x2, y2, x1, y1, arrowLength, arrowHalfWidth, arrowStyle);
        }
    }

    public boolean exportMacro(int x, int y, boolean isMirrored, int orientation, String macroName, String macroDesc, String name, int xn, int yn, String value, int xv, int yv, String font, int fontSize, Map m) throws IOException {
        return false;
    }

    public void exportOval(int x1, int y1, int x2, int y2, boolean isFilled, int layer, int dashStyle, double strokeWidth) throws IOException {
        LayerDesc l = (LayerDesc)this.layerV.get(layer);
        Color c = l.getColor();
        this.checkColorAndWidth(c, strokeWidth);
        this.registerDash(dashStyle);
        this.ellipse(x1, y1, x2, y2, isFilled);
    }

    public void exportPCBLine(int x1, int y1, int x2, int y2, int width, int layer) throws IOException {
        LayerDesc l = (LayerDesc)this.layerV.get(layer);
        Color c = l.getColor();
        this.checkColorAndWidth(c, width);
        this.registerDash(0);
        this.outt.write("  " + x1 + " " + y1 + " m " + x2 + " " + y2 + " l S\n");
    }

    public void exportPCBPad(int x, int y, int style, int six, int siy, int indiam, int layer, boolean onlyHole) throws IOException {
        LayerDesc l = (LayerDesc)this.layerV.get(layer);
        Color c = l.getColor();
        this.checkColorAndWidth(c, 0.33);
        if (!onlyHole) {
            switch (style) {
                default: {
                    this.ellipse((double)x - (double)six / 2.0, (double)y - (double)siy / 2.0, (double)x + (double)six / 2.0, (double)y + (double)siy / 2.0, true);
                    this.outt.write("f\n");
                    break;
                }
                case 2: {
                    this.roundRect((double)x - (double)six / 2.0, (double)y - (double)siy / 2.0, six, siy, 4.0, true);
                    break;
                }
                case 1: {
                    double xdd = (double)x - (double)six / 2.0;
                    double ydd = (double)y - (double)siy / 2.0;
                    this.outt.write("" + xdd + " " + ydd + " m\n");
                    this.outt.write("" + (xdd + (double)six) + " " + ydd + " l\n");
                    this.outt.write("" + (xdd + (double)six) + " " + (ydd + (double)siy) + " l\n");
                    this.outt.write("" + xdd + " " + (ydd + (double)siy) + " l\n");
                    this.outt.write("B\n");
                }
            }
        }
        this.checkColorAndWidth(Color.WHITE, 0.33);
        this.ellipse((double)x - (double)indiam / 2.0, (double)y - (double)indiam / 2.0, (double)x + (double)indiam / 2.0, (double)y + (double)indiam / 2.0, true);
        this.outt.write("f\n");
    }

    public void exportPolygon(Point2D.Double[] vertices, int nVertices, boolean isFilled, int layer, int dashStyle, double strokeWidth) throws IOException {
        LayerDesc l = (LayerDesc)this.layerV.get(layer);
        Color c = l.getColor();
        String fill_pattern = "";
        if (nVertices < 1) {
            return;
        }
        this.checkColorAndWidth(c, strokeWidth);
        this.registerDash(dashStyle);
        this.outt.write("  " + vertices[0].x + " " + vertices[0].y + " m\n");
        for (int i = 1; i < nVertices; ++i) {
            this.outt.write("  " + vertices[i].x + " " + vertices[i].y + " l\n");
        }
        if (isFilled) {
            this.outt.write("  f*\n");
        } else {
            this.outt.write("  s\n");
        }
    }

    public boolean exportCurve(Point2D.Double[] vertices, int nVertices, boolean isFilled, boolean isClosed, int layer, boolean arrowStart, boolean arrowEnd, int arrowStyle, int arrowLength, int arrowHalfWidth, int dashStyle, double strokeWidth) throws IOException {
        return false;
    }

    public void exportRectangle(int x1, int y1, int x2, int y2, boolean isFilled, int layer, int dashStyle, double strokeWidth) throws IOException {
        LayerDesc l = (LayerDesc)this.layerV.get(layer);
        Color c = l.getColor();
        this.checkColorAndWidth(c, strokeWidth);
        this.registerDash(dashStyle);
        this.outt.write("  " + x1 + " " + y1 + " m\n");
        this.outt.write("  " + x2 + " " + y1 + " l\n");
        this.outt.write("  " + x2 + " " + y2 + " l\n");
        this.outt.write("  " + x1 + " " + y2 + " l\n");
        if (isFilled) {
            this.outt.write("f\n");
        } else {
            this.outt.write("s\n");
        }
    }

    private void roundRect(double x1, double y1, double w, double h, double r, boolean filled) throws IOException {
        this.outt.write("" + (x1 + r) + " " + y1 + " m\n");
        this.outt.write("" + (x1 + w - r) + " " + y1 + " l\n");
        this.outt.write("" + (x1 + w) + " " + y1 + " " + (x1 + w) + " " + (y1 + r) + " y\n");
        this.outt.write("" + (x1 + w) + " " + (y1 + h - r) + " l\n");
        this.outt.write("" + (x1 + w) + " " + (y1 + h) + " " + (x1 + w - r) + " " + (y1 + h) + " y\n");
        this.outt.write("" + (x1 + r) + " " + (y1 + h) + " l\n");
        this.outt.write("" + x1 + " " + (y1 + h) + " " + x1 + " " + (y1 + h - r) + " y\n");
        this.outt.write("" + x1 + " " + (y1 + r) + " l\n");
        this.outt.write("" + x1 + " " + y1 + " " + (x1 + r) + " " + y1 + " y \n");
        this.outt.write("  " + (filled ? "f\n" : "s\n"));
    }

    private void ellipse(double x1, double y1, double x2, double y2, boolean filled) throws IOException {
        double cx = (x1 + x2) / 2.0;
        double cy = (y1 + y2) / 2.0;
        double rx = Math.abs(x2 - x1) / 2.0;
        double ry = Math.abs(y2 - y1) / 2.0;
        int NMAX = 32;
        double rr = 1.02;
        double tt = 1.01;
        this.outt.write("  " + this.roundTo(cx + rx) + " " + this.roundTo(cy) + " m\n");
        for (int i = 0; i < 32; ++i) {
            double alpha = Math.PI * 2 * (double)i / 32.0;
            double xA = cx + rx * Math.cos(alpha);
            double yA = cy + ry * Math.sin(alpha);
            double xB = cx + 1.02 * rx * Math.cos(alpha += 0.06544984694978735);
            double yB = cy + 1.02 * ry * Math.sin(alpha);
            double xC = cx + 1.01 * rx * Math.cos(alpha += 0.06544984694978735);
            double yC = cy + 1.01 * ry * Math.sin(alpha);
            double xD = cx + rx * Math.cos(alpha += 0.06544984694978735);
            double yD = cy + ry * Math.sin(alpha);
            this.outt.write(this.roundTo(xC) + " " + this.roundTo(yC) + " " + this.roundTo(xD) + " " + this.roundTo(yD) + " y\n");
        }
        this.outt.write("  " + (filled ? "f\n" : "s\n"));
    }

    private String addLeadZeros(long n) {
        String s = "" + n;
        while (s.length() < 10) {
            s = "0" + s;
        }
        return s;
    }

    private String roundTo(double n) {
        int ch = 2;
        return "" + (double)((int)(n * Math.pow(10.0, ch))) / Math.pow(10.0, ch);
    }

    private void checkColorAndWidth(Color c, double wl) throws IOException {
        if (c != this.actualColor) {
            this.outt.write("  " + this.roundTo((double)c.getRed() / 255.0) + " " + this.roundTo((double)c.getGreen() / 255.0) + " " + this.roundTo((double)c.getBlue() / 255.0) + " rg\n");
            this.outt.write("  " + this.roundTo((double)c.getRed() / 255.0) + " " + this.roundTo((double)c.getGreen() / 255.0) + " " + this.roundTo((double)c.getBlue() / 255.0) + " RG\n");
            this.actualColor = c;
        }
        if (wl != this.actualWidth) {
            this.outt.write("  " + wl + " w\n");
            this.actualWidth = wl;
        }
    }

    private void registerDash(int dashStyle) throws IOException {
        if (this.actualDash != dashStyle) {
            this.actualDash = dashStyle;
            if (dashStyle == 0) {
                this.outt.write("[] 0 d\n");
            } else {
                this.outt.write("" + dash[dashStyle] + " 0 d\n");
            }
        }
    }

    public void exportArrow(double x, double y, double xc, double yc, double l, double h, int style) throws IOException {
        double alpha = x != xc ? Math.atan((y - yc) / (x - xc)) : 1.5707963267948966 + (y - yc < 0.0 ? 0.0 : Math.PI);
        double x0 = x - l * Math.cos(alpha += x - xc > 0.0 ? 0.0 : Math.PI);
        double y0 = y - l * Math.sin(alpha);
        double x1 = x0 - h * Math.sin(alpha);
        double y1 = y0 + h * Math.cos(alpha);
        double x2 = x0 + h * Math.sin(alpha);
        double y2 = y0 - h * Math.cos(alpha);
        this.registerDash(0);
        this.outt.write("" + this.roundTo(x) + " " + this.roundTo(y) + " m\n");
        this.outt.write("" + this.roundTo(x1) + " " + this.roundTo(y1) + " l\n");
        this.outt.write("" + this.roundTo(x2) + " " + this.roundTo(y2) + " l\n");
        if ((style & 2) == 0) {
            this.outt.write("  f*\n");
        } else {
            this.outt.write("  s\n");
        }
        if ((style & 1) != 0) {
            double x3 = x - h * Math.sin(alpha);
            double y3 = y + h * Math.cos(alpha);
            double x4 = x + h * Math.sin(alpha);
            double y4 = y - h * Math.cos(alpha);
            this.outt.write("" + this.roundTo(x3) + " " + this.roundTo(y3) + " m\n" + this.roundTo(x4) + " " + this.roundTo(y4) + " l s\n");
        }
    }
}

