/*
 * Decompiled with CFR 0.152.
 */
package dialogs;

import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.KeyStroke;

public class DialogUtil {
    public static void center(Window frame) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Point center = ge.getCenterPoint();
        Rectangle bounds = ge.getMaximumWindowBounds();
        int w = frame.getWidth();
        int h = frame.getHeight();
        int x = center.x - w / 2;
        int y = center.y - h / 2;
        frame.setBounds(x, y, w, h);
        frame.validate();
    }

    public static void center(Window frame, double propX, double propY) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Point center = ge.getCenterPoint();
        Rectangle bounds = ge.getMaximumWindowBounds();
        int w = Math.max((int)((double)bounds.width * propX), Math.min(frame.getWidth(), bounds.width));
        int h = Math.max((int)((double)bounds.height * propY), Math.min(frame.getHeight(), bounds.height));
        int x = center.x - w / 2;
        int y = center.y - h / 2;
        frame.setBounds(x, y, w, h);
        frame.validate();
    }

    public static void center(Window frame, double propX, double propY, int minx, int miny) {
        int h;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Point center = ge.getCenterPoint();
        Rectangle bounds = ge.getMaximumWindowBounds();
        int w = Math.max((int)((double)bounds.width * propX), Math.min(frame.getWidth(), bounds.width));
        if (w < minx) {
            w = minx;
        }
        if ((h = Math.max((int)((double)bounds.height * propY), Math.min(frame.getHeight(), bounds.height))) < miny) {
            h = miny;
        }
        int x = center.x - w / 2;
        int y = center.y - h / 2;
        frame.setBounds(x, y, w, h);
        frame.validate();
    }

    public static void addCancelEscape(JDialog f, AbstractAction cancelAction) {
        String CANCEL_ACTION_KEY = "CANCEL_ACTION_KEY";
        int noModifiers = 0;
        KeyStroke escapeKey = KeyStroke.getKeyStroke(27, noModifiers, false);
        InputMap inputMap = f.getRootPane().getInputMap(1);
        inputMap.put(escapeKey, CANCEL_ACTION_KEY);
        f.getRootPane().getActionMap().put(CANCEL_ACTION_KEY, cancelAction);
    }

    public static GridBagConstraints createConst(int gridx, int gridy, int width, int height, int weightx, int weighty, int anch, int fill, Insets insets) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = gridx;
        constraints.gridy = gridy;
        constraints.gridwidth = width;
        constraints.gridheight = height;
        constraints.weightx = weightx;
        constraints.weighty = weighty;
        constraints.fill = fill;
        constraints.anchor = anch;
        constraints.insets = insets;
        return constraints;
    }
}

