/*
 * Decompiled with CFR 0.152.
 */
package dialogs;

import dialogs.DialogUtil;
import globals.Globals;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class DialogPrint
extends JDialog
implements ComponentListener {
    private static final int MIN_WIDTH = 400;
    private static final int MIN_HEIGHT = 350;
    private JCheckBox mirror_CB;
    private JCheckBox fit_CB;
    private JCheckBox bw_CB;
    private JCheckBox landscape_CB;
    private boolean export;

    public DialogPrint(JFrame parent) {
        super(parent, Globals.messages.getString("Print_dlg"), true);
        this.addComponentListener(this);
        this.export = false;
        this.getRootPane().putClientProperty("apple.awt.documentModalSheet", Boolean.TRUE);
        GridBagLayout bgl = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(bgl);
        constraints.insets.right = 30;
        JLabel empty = new JLabel("  ");
        constraints.weightx = 100.0;
        constraints.weighty = 100.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        contentPane.add((Component)empty, constraints);
        JLabel empty1 = new JLabel("  ");
        constraints.weightx = 100.0;
        constraints.weighty = 100.0;
        constraints.gridx = 3;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        contentPane.add((Component)empty1, constraints);
        this.mirror_CB = new JCheckBox(Globals.messages.getString("Mirror"));
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.anchor = 17;
        contentPane.add((Component)this.mirror_CB, constraints);
        this.fit_CB = new JCheckBox(Globals.messages.getString("FitPage"));
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.anchor = 17;
        contentPane.add((Component)this.fit_CB, constraints);
        this.bw_CB = new JCheckBox(Globals.messages.getString("B_W"));
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.anchor = 17;
        contentPane.add((Component)this.bw_CB, constraints);
        this.landscape_CB = new JCheckBox(Globals.messages.getString("Landscape"));
        constraints.gridx = 1;
        constraints.gridy = 3;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.anchor = 17;
        contentPane.add((Component)this.landscape_CB, constraints);
        JButton ok = new JButton(Globals.messages.getString("Ok_btn"));
        JButton cancel = new JButton(Globals.messages.getString("Cancel_btn"));
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 4;
        constraints.gridheight = 1;
        constraints.anchor = 13;
        Box b = Box.createHorizontalBox();
        b.add(Box.createHorizontalGlue());
        ok.setPreferredSize(cancel.getPreferredSize());
        if (Globals.okCancelWinOrder) {
            b.add(ok);
            b.add(Box.createHorizontalStrut(12));
            b.add(cancel);
        } else {
            b.add(cancel);
            b.add(Box.createHorizontalStrut(12));
            b.add(ok);
        }
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DialogPrint.this.export = true;
                DialogPrint.this.setVisible(false);
            }
        });
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DialogPrint.this.setVisible(false);
            }
        });
        AbstractAction cancelAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                DialogPrint.this.setVisible(false);
            }
        };
        contentPane.add((Component)b, constraints);
        DialogUtil.addCancelEscape(this, cancelAction);
        this.pack();
        DialogUtil.center(this);
        this.getRootPane().setDefaultButton(ok);
    }

    public void componentResized(ComponentEvent e) {
        int width = this.getWidth();
        int height = this.getHeight();
        boolean resize = false;
        if (width < 400) {
            resize = true;
            width = 400;
        }
        if (height < 350) {
            resize = true;
            height = 350;
        }
        if (resize) {
            this.setSize(width, height);
        }
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public boolean getMirror() {
        return this.mirror_CB.isSelected();
    }

    public boolean getFit() {
        return this.fit_CB.isSelected();
    }

    public boolean getLandscape() {
        return this.landscape_CB.isSelected();
    }

    public boolean getBW() {
        return this.bw_CB.isSelected();
    }

    public void setMirror(boolean m) {
        this.mirror_CB.setSelected(m);
    }

    public void setFit(boolean f) {
        this.fit_CB.setSelected(f);
    }

    public void setLandscape(boolean l) {
        this.landscape_CB.setSelected(l);
    }

    public void setBW(boolean l) {
        this.bw_CB.setSelected(l);
    }

    public boolean shouldPrint() {
        return this.export;
    }
}

