/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JViewport;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.MouseInputListener;

public class ScrollGlassPane
extends JPanel
implements ActionListener,
MouseInputListener,
SwingConstants {
    private static final Image img = MouseScrollIcon.iconToImage(new MouseScrollIcon());
    Component oldGlassPane = null;
    public Point location = null;
    private Timer movingTimer;
    private Point mouseLocation;
    private JViewport viewport;

    public ScrollGlassPane(Component oldGlassPane, JViewport viewport, Point location) {
        this.oldGlassPane = oldGlassPane;
        this.viewport = viewport;
        this.location = this.mouseLocation = location;
        this.setOpaque(false);
        ScrollGestureRecognizer.getInstance().stop();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.movingTimer = new Timer(100, this);
        this.movingTimer.setRepeats(true);
        this.movingTimer.start();
    }

    protected void paintComponent(Graphics g) {
        g.drawImage(img, this.location.x - 15, this.location.y - 15, this);
    }

    public void actionPerformed(ActionEvent e) {
        int deltax = (this.mouseLocation.x - this.location.x) / 4;
        int deltay = (this.mouseLocation.y - this.location.y) / 4;
        Point p = this.viewport.getViewPosition();
        p.translate(deltax, deltay);
        if (p.x < 0) {
            p.x = 0;
        } else if (p.x >= this.viewport.getView().getWidth() - this.viewport.getWidth()) {
            p.x = this.viewport.getView().getWidth() - this.viewport.getWidth();
        }
        if (p.y < 0) {
            p.y = 0;
        } else if (p.y >= this.viewport.getView().getHeight() - this.viewport.getHeight()) {
            p.y = this.viewport.getView().getHeight() - this.viewport.getHeight();
        }
        this.viewport.setViewPosition(p);
    }

    public void mousePressed(MouseEvent e) {
        this.movingTimer.stop();
        this.setVisible(false);
        JRootPane rootPane = SwingUtilities.getRootPane(this);
        rootPane.setGlassPane(this.oldGlassPane);
        ScrollGestureRecognizer.getInstance().start();
    }

    public void mouseClicked(MouseEvent e) {
        this.mousePressed(e);
    }

    public void mouseMoved(MouseEvent e) {
        this.mouseLocation = e.getPoint();
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }
}

