/*
 * Decompiled with CFR 0.152.
 */
import circuit.CircuitPanel;
import export.ExportGraphic;
import geom.MapCoordinates;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import primitives.MacroDesc;
import toolbars.ChangeSelectionListener;

public class MacroTree
extends JPanel
implements TreeSelectionListener,
DocumentListener,
KeyListener {
    private CircuitPanel previewPanel;
    private JTree tree;
    private JSplitPane splitPane;
    private DefaultMutableTreeNode top;
    private SearchField search;
    private Collection library;
    private ChangeSelectionListener selectionListener;
    private static boolean DEBUG = false;
    private int[] start;

    public MacroTree() {
        super(new GridLayout(1, 0));
    }

    public void updateLibraries(Map lib, Vector layers) {
        this.library = lib.values();
        this.top = new DefaultMutableTreeNode("Fidocad");
        this.createNodes(this.top);
        this.tree = new JTree(this.top);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        this.start = new int[1];
        JScrollPane treeView = new JScrollPane(this.tree);
        this.previewPanel = new CircuitPanel(false);
        this.previewPanel.P.setLayers(layers);
        this.previewPanel.P.setLibrary(lib);
        this.previewPanel.setGridVisibility(false);
        this.search = new SearchField();
        this.search.getDocument().addDocumentListener(this);
        this.search.addKeyListener(this);
        Box topbox = Box.createVerticalBox();
        topbox.add(this.search);
        topbox.add(treeView);
        if (this.splitPane != null) {
            this.remove(this.splitPane);
        }
        this.splitPane = new JSplitPane(0);
        this.splitPane.setTopComponent(topbox);
        this.splitPane.setBottomComponent(this.previewPanel);
        this.previewPanel.setMinimumSize(new Dimension(150, 100));
        treeView.setMinimumSize(new Dimension(150, 100));
        this.previewPanel.setPreferredSize(new Dimension(350, 300));
        treeView.setPreferredSize(new Dimension(350, 600));
        this.splitPane.setPreferredSize(new Dimension(350, 300));
        this.splitPane.setResizeWeight(0.9);
        this.add(this.splitPane);
    }

    public void setSelectionListener(ChangeSelectionListener l) {
        this.selectionListener = l;
    }

    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        Object nodeInfo = node.getUserObject();
        if (node.isLeaf()) {
            try {
                MacroDesc macro = (MacroDesc)nodeInfo;
                this.previewPanel.setCirc(new StringBuffer(macro.description));
                MapCoordinates m = ExportGraphic.calculateZoomToFit(this.previewPanel.P, this.previewPanel.getSize().width * 80 / 100, this.previewPanel.getSize().height * 80 / 100, true, true);
                m.setXCenter(m.getXCenter() + 10.0);
                m.setYCenter(m.getYCenter() + 10.0);
                this.previewPanel.setMapCoordinates(m);
                this.repaint();
                if (this.selectionListener != null) {
                    this.selectionListener.setSelectionState(13, macro.key);
                }
            }
            catch (Exception E) {
                // empty catch block
            }
        }
    }

    private void createNodes(DefaultMutableTreeNode top) {
        DefaultMutableTreeNode category = null;
        DefaultMutableTreeNode macro = null;
        Iterator it = this.library.iterator();
        HashMap<String, DefaultMutableTreeNode> categories = new HashMap<String, DefaultMutableTreeNode>();
        HashMap<String, DefaultMutableTreeNode> libraries = new HashMap<String, DefaultMutableTreeNode>();
        DefaultMutableTreeNode library_i = null;
        while (it.hasNext()) {
            MacroDesc val = (MacroDesc)it.next();
            macro = new DefaultMutableTreeNode(val);
            if (categories.get(val.category + "]" + val.library) != null) {
                if (val.category.equals("hidden")) continue;
                ((DefaultMutableTreeNode)categories.get(val.category + "]" + val.library)).add(macro);
                continue;
            }
            category = new DefaultMutableTreeNode(val.category.trim());
            if (libraries.get(val.library) != null) {
                if (!val.category.equals("hidden")) {
                    ((DefaultMutableTreeNode)libraries.get(val.library)).add(category);
                }
            } else {
                library_i = new DefaultMutableTreeNode(val.library.trim());
                top.add(library_i);
                if (!val.category.equals("hidden")) {
                    library_i.add(category);
                }
                libraries.put(val.library, library_i);
            }
            category.add(macro);
            categories.put(val.category + "]" + val.library, category);
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.start[0] = 0;
        this.searchAndSelect(this.search.getText().trim(), this.start, true);
    }

    public void removeUpdate(DocumentEvent e) {
        this.start[0] = 0;
        this.searchAndSelect(this.search.getText().trim(), this.start, true);
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 40) {
            this.searchAndSelect(this.search.getText().trim(), this.start, true);
            e.consume();
        }
        if (e.getKeyCode() == 38) {
            this.searchAndSelect(this.search.getText().trim(), this.start, false);
            e.consume();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    private void searchAndSelect(String what, int[] start, boolean forward) {
        DefaultMutableTreeNode nn;
        TreePath path = null;
        if (what.trim().equals("")) {
            return;
        }
        if (start[0] == 0) {
            for (int r = this.tree.getRowCount() - 1; r >= 1; --r) {
                this.tree.collapseRow(r);
            }
            this.tree.clearSelection();
        }
        if ((nn = this.searchNode(what, start, forward)) == null) {
            return;
        }
        path = new TreePath(nn.getPath());
        this.tree.scrollPathToVisible(path);
        this.tree.setSelectionPath(path);
        this.tree.expandPath(path);
    }

    public DefaultMutableTreeNode searchNode(String nodeStr, int[] start, boolean forward) {
        DefaultMutableTreeNode node = null;
        Enumeration<TreeNode> en = this.top.depthFirstEnumeration();
        if (forward) {
            int i;
            for (i = 0; i < start[0] && en.hasMoreElements(); ++i) {
                node = (DefaultMutableTreeNode)en.nextElement();
            }
            while (en.hasMoreElements()) {
                node = (DefaultMutableTreeNode)en.nextElement();
                ++i;
                if (!node.getUserObject().toString().matches("(?i).*(" + nodeStr + ").*")) continue;
                start[0] = i;
                return node;
            }
        } else {
            int i = 0;
            int oldi = 0;
            DefaultMutableTreeNode oldnode = null;
            while (en.hasMoreElements()) {
                node = (DefaultMutableTreeNode)en.nextElement();
                ++i;
                if (node.getUserObject().toString().matches("(?i).*(" + nodeStr + ").*")) {
                    if (i >= start[0]) {
                        if (oldnode != null) {
                            start[0] = oldi;
                        }
                        return oldnode;
                    }
                    oldnode = node;
                    oldi = i;
                }
                if (i < start[0]) continue;
                return oldnode;
            }
        }
        return null;
    }
}

