// (c) Copyright 2000 Justin F. Chapweske
// (c) Copyright 2000 Ry4an C. Brase

import com.onionnetworks.fec.*;
import com.onionnetworks.util.Util;

public class MathTest {

    public static FECMath fecMath = new FECMath(8);

    public static final void testGF() {
        // test gf tables.
        for (int i=0; i<= fecMath.gfSize; i++) {
            if (fecMath.gf_exp[fecMath.gf_log[i]] != i) {
                System.err.println("bad exp/log i "+i+" log "+
                                   (int) fecMath.gf_log[i]+" exp(log) "+
                                   (int) fecMath.gf_exp
                                   [fecMath.gf_log[i]]);
            } 
            if (i != 0 && fecMath.mul((char) i, 
                                            fecMath.inverse[i]) != 1) {
                System.err.println("bad mul/inv i "+i+" inv "+
                                   (int) fecMath.inverse[i]+
                                   " i*inv(i) "+(int) fecMath.mul
                                   ((char)i, fecMath.inverse[i]));
            } 
            if (fecMath.mul((char) 0,(char) i) != 0) {
                System.err.println("bad mul table 0,"+i);
            }
            if (fecMath.mul((char) i,(char) 0) != 0) {
                System.err.println("bad mul table "+i+",0");
            }
        }
    }

    public static final void testModnn() {
        for (int i=0; i<= (fecMath.gfSize*fecMath.gfSize); i++) {
            if (fecMath.modnn(i) != i % fecMath.gfSize) {
                System.err.println("bad modnn for "+i);
            }
        }
    }


    public static final void testAddMul() {
        // try a bunch of different sizes and offsets...
        for (int i=1;i<=fecMath.gfSize;i+=(fecMath.gfSize/3)) {
            for (int a=0;a<i-1;a+=(fecMath.gfSize/3)) {
                for (int b=1;b<i-a;b+=(fecMath.gfSize/5)) {
                    testAddMul(a,b,i);
                }
            }
        }
    }

    public static final void testAddMul(int off, int len, int size) {
        for (int i=0;i<=fecMath.gfSize;i+=(fecMath.gfSize/7)) {
            char[] src = new char[size];
            char[] dst = new char[size];
            // seed in some random data
            for (int a=off;a<(off+len);a++) {
                src[a] = fecMath.inverse[(char) a];
                dst[a] = fecMath.gf_exp[(char) a];
            }
            char[] orig = new char[dst.length];
            System.arraycopy(dst,off,orig,off,len);

            fecMath.addMul(dst,off,src,off,(char) i,len);
            for (int a=off;a<(off+len);a++) {
                char solvDst = (char) (orig[a] ^ fecMath.mul((char) i,
                                                                   src[a])); 
                char solvC = fecMath.mul(fecMath.inverse[src[a]],
                                               (char) (dst[a]^orig[a]));
                char solvSrc = fecMath.mul(fecMath.inverse[(char) i],
                                                 (char) (dst[a]^orig[a]));  
                char solvOrig =(char) (dst[a] ^ fecMath.mul((char) i,
                                                                  src[a]));
                // check straight
                if (solvDst != dst[a]) {
                    System.err.println("bad addMul for orig="+(int)orig[a]+
                                       ",src="+(int) src[a]+",c="+i+
                                       ",dst="+(int) dst[a]);
                } else if (solvC != (char) i && (solvOrig != orig[a] ||
                                                 (dst[a]^orig[a]) != 0)) {
                    // bad inverses
                    System.err.println("bad addMul for orig="+(int)orig[a]+
                                       ",src="+(int) src[a]+",c="+i+
                                       ",dst="+(int) dst[a]);
                }
            }
        }
    }

    public static final void testIdentity() {
	int k = 234;
	char[] matrix = fecMath.createGFMatrix(k,k);
        for (int i=0,col=0;col<k;col++,i += k+1) {
            matrix[i] = 1;
	}
	if (!fecMath.isIdentity(matrix,k)) {
	    System.err.println("bad isIdentity for k="+k);
	}
	matrix[23] = 2;
	if (fecMath.isIdentity(matrix,k)) {
	    System.err.println("bad isIdentity for k="+k);
	}
    }

    /**
     * Test matrix multiplication using the identity.
     * AI = A
     */
    public static final void testIdentMatMul() {
        for (int k=2;k<50;k+=13) {
            for (int n=2;n<60;n+=17) {
                // create identity matrix
                char[] ident = createIdentityMatrix(k);
                
                // create random matrix
                char[] matrix = createRandomMatrix(n,k);
                
                char[] result = fecMath.createGFMatrix(n,k);
                fecMath.matMul(matrix,ident,result,n,k,k);
                if (!Util.arraysEqual(matrix,0,result,0,n*k)) {
                    System.err.println("Shit! IdentMatMul is broken for n="+
                                       n+",k="+k);
                }
            }
        }
    }

    /**
     * Test the inversion of an identity matrix
     * (I)^-1 = I
     */
    public static final void testIdentMatInverse() {
        for (int k=2;k<83;k+=13) {
            char[] ident = createIdentityMatrix(k);
            char[] tmp = new char[ident.length];
            System.arraycopy(ident,0,tmp,0,tmp.length);
            fecMath.invertMatrix(ident,k);
            if (!Util.arraysEqual(ident,0,tmp,0,k*k)) {
                System.err.println("Shit! IdentInverse is broken for k="+k);
            }
        }
    }

    /**
     * Test that invertMatrix == invertVandermonde and 
     * A(A)^-1 == I
     */
    public static final void testVandermondeInverse() {
        for (int k=2;k<70;k+=23) {
          for (int n=k;n<k+90;n+=41) {
                char[] matrix = createVandermondeMatrix(n,k);
                char[] tmp = new char[matrix.length];
                char[] tmp2 = new char[matrix.length];
                System.arraycopy(matrix,0,tmp,0,tmp.length);

                fecMath.invertMatrix(tmp,k);
                fecMath.matMul(matrix,tmp,tmp2,n,k,k);
                if (!fecMath.isIdentity(tmp2,k)) {
                    System.err.println("Err! A(A)^-1 != I n="+n+",k="+k);
                }

                fecMath.invertVandermonde(matrix,k);
                
                if (!Util.arraysEqual(matrix,0,tmp,0,k*k)) {
                    System.err.println("Shit! VDMInverse is broken for k="+k+
                                       ",n="+n);
                }
            }
        }
    }

    
    public static final char[] createVandermondeMatrix(int n, int k) {
        /*
         * fill the matrix with powers of field elements, starting from 0.
         * The first row is special, cannot be computed with exp. table.
         */
        char[] result = fecMath.createGFMatrix(n, k);
        
        result[0] = 1;
	// first row should be 0's, fill in the rest.
	for (int pos = k, row = 0; row < n-1 ; row++, pos += k) {
            for (int col = 0 ; col < k ; col ++ ) {
                result[pos+col] = fecMath.gf_exp[fecMath.modnn
                                                       (row*col)];
	    }
        }
        return result;
    }
    
    public static final char[] createIdentityMatrix(int k) {
        // create identity matrix
	char[] ident = fecMath.createGFMatrix(k,k);
	for (int i=0,col=0;col<k;col++,i += k+1) {
	    ident[i] = 1;
	}
        return ident;
    }

    public static final char[] createRandomMatrix(int n, int k) {
	char[] matrix = fecMath.createGFMatrix(n,k);
	for (int i=0;i<matrix.length;i++) {
	    matrix[i] = fecMath.gf_exp[i%fecMath.gfSize+1];
	}
        return matrix;
    }

    public static final void printMatrix(char[] c, int rows, int cols) {
	int colWidth = new Integer(fecMath.gfSize).toString().length();
	for (int a=0;a<rows;a++) {
	    System.out.print("[");
	    for (int b=0;b<cols;b++) {
		Integer i = new Integer((int) c[a*cols+b]);
		System.err.print
		    (Util.getSpaces(colWidth-i.toString().length()+1)+i);
	    }
	    System.out.println("]");
	}
	System.out.println("");
    }

    public static void main(String[] args) {
        testGF();
        testModnn();
        testAddMul();
	testIdentity();
	testIdentMatMul();
        testIdentMatInverse();
        testVandermondeInverse();
    }
}
