import java.util.*;
import java.io.*;
import java.security.*;
import com.onionnetworks.fec.io.*;
import com.onionnetworks.util.*;
import org.apache.log4j.BasicConfigurator;

public class FECFileTest {
    
    public static final int k = 32;
    public static final int n = 256;
    public static final int packetSize = 1024;
    public static final String DIGEST_ALGORITHM = "sha";

    public static void main(String[] args) throws Exception {

        //	BasicConfigurator.configure();
        
	File sourceFile = new File(args[0]);
        
        System.out.println("Computing checksums");
        InputStream is = new FileInputStream(sourceFile);
        
        MessageDigest md = null;
        DigestInputStream dis = null; 
        BlockDigestInputStream bdis = null;
        
        try {
            md = MessageDigest.getInstance(DIGEST_ALGORITHM);
            dis = new DigestInputStream(is,md);
            bdis = new BlockDigestInputStream(dis,DIGEST_ALGORITHM,
                                              k*packetSize);
        } catch (NoSuchAlgorithmException e) {
            throw new IOException(e.getMessage());
        }
        
        byte[] b = new byte[8192];
        long fileLength = 0;
        int c = 0;
        // Read in the data and digest it.
        while ((c = bdis.read(b)) != -1) {
            fileLength += c;
        }
        bdis.finish();
        
        FECParameters params = new FECParameters(k,n,packetSize,
                                                 fileLength);
        FileIntegrity integrity = new FileIntegrityImpl
            (DIGEST_ALGORITHM,new Buffer(md.digest()),
             bdis.getBlockDigests(),
             params.getFileSize(),params.getUnexpandedBlockSize());
        
        
        System.out.println("checksums done doing our thang.");
        
        for (int i=0;i<100;i++) {
            
            FECFile server = new FECFile(sourceFile,"r",params);
            FECFile client = new FECFile(new File(args[1]),"rw",
                                         params,integrity);
            
            doIt(client,server,params);
            System.out.println(i);
        }
        System.out.println("All Good!");
        System.exit(0);
    }
    
    public static void doIt(FECFile client, FECFile server, 
                            FECParameters params) throws Exception {
     
        int[] stripeOrder = new int[n];
        for (int i=0;i<stripeOrder.length;i++) {
            stripeOrder[i] = i;
        }
        
        Buffer[] bufs = new Buffer[k];
        for (int i=0;i<k;i++) {
            bufs[i] = new Buffer(packetSize);
        }

        for (int i=0;i<params.getBlockCount();i++) {
            Util.shuffle(stripeOrder);
            int[] indexes = new int[k];
            System.arraycopy(stripeOrder,0,indexes,0,k);

            server.read(bufs,i,indexes);
            int l=0;
            for (int j=0;l<params.getUnexpandedPacketCount(i);j++) {
                if (!params.isPaddingPacket(i,indexes[j])) {
                    client.write(bufs[j],i,indexes[j]);
                    l++;
                }
            }
        }

        client.waitForFileDecoded();
        
        server.close();
        client.close();
    }
}
            
