/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.gui;

import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.StringWriter;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.helpers.QuietWriter;
import org.apache.log4j.helpers.TracerPrintWriter;
import org.apache.log4j.spi.LoggingEvent;

public class TextPaneAppender
extends AppenderSkeleton {
    JTextPane textpane;
    StyledDocument doc;
    TracerPrintWriter tp;
    StringWriter sw;
    QuietWriter qw;
    Hashtable attributes;
    Hashtable icons;
    private String label;
    private boolean fancy;
    final String LABEL_OPTION;
    final String COLOR_OPTION_FATAL;
    final String COLOR_OPTION_ERROR;
    final String COLOR_OPTION_WARN;
    final String COLOR_OPTION_INFO;
    final String COLOR_OPTION_DEBUG;
    final String COLOR_OPTION_BACKGROUND;
    final String FANCY_OPTION;
    final String FONT_NAME_OPTION;
    final String FONT_SIZE_OPTION;

    public static Image loadIcon(String string) {
        Image image = null;
        try {
            URL uRL = ClassLoader.getSystemResource(string);
            image = Toolkit.getDefaultToolkit().getImage(uRL);
        }
        catch (Exception exception) {
            System.out.println("Exception occured: " + exception.getMessage() + " - " + exception);
        }
        return image;
    }

    public void close() {
    }

    private void createAttributes() {
        Priority[] priorityArray = Priority.getAllPossiblePriorities();
        this.attributes = new Hashtable();
        int n = 0;
        while (n < priorityArray.length) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            this.attributes.put(priorityArray[n], simpleAttributeSet);
            StyleConstants.setFontSize(simpleAttributeSet, 14);
            ++n;
        }
        StyleConstants.setForeground((MutableAttributeSet)this.attributes.get(Priority.ERROR), Color.red);
        StyleConstants.setForeground((MutableAttributeSet)this.attributes.get(Priority.WARN), Color.orange);
        StyleConstants.setForeground((MutableAttributeSet)this.attributes.get(Priority.INFO), Color.gray);
        StyleConstants.setForeground((MutableAttributeSet)this.attributes.get(Priority.DEBUG), Color.black);
    }

    private void createIcons() {
        Priority[] priorityArray = Priority.getAllPossiblePriorities();
        this.icons = new Hashtable();
        int n = 0;
        while (n < priorityArray.length) {
            if (priorityArray[n].equals(Priority.FATAL)) {
                this.icons.put(priorityArray[n], new ImageIcon(TextPaneAppender.loadIcon("icons/RedFlag.gif")));
            }
            if (priorityArray[n].equals(Priority.ERROR)) {
                this.icons.put(priorityArray[n], new ImageIcon(TextPaneAppender.loadIcon("icons/RedFlag.gif")));
            }
            if (priorityArray[n].equals(Priority.WARN)) {
                this.icons.put(priorityArray[n], new ImageIcon(TextPaneAppender.loadIcon("icons/BlueFlag.gif")));
            }
            if (priorityArray[n].equals(Priority.INFO)) {
                this.icons.put(priorityArray[n], new ImageIcon(TextPaneAppender.loadIcon("icons/GreenFlag.gif")));
            }
            if (priorityArray[n].equals(Priority.DEBUG)) {
                this.icons.put(priorityArray[n], new ImageIcon(TextPaneAppender.loadIcon("icons/GreenFlag.gif")));
            }
            ++n;
        }
    }

    public void append(LoggingEvent loggingEvent) {
        String string = this.layout.format(loggingEvent);
        String string2 = "";
        if (loggingEvent.throwable != null) {
            loggingEvent.throwable.printStackTrace(this.tp);
            int n = 0;
            while (n < this.sw.getBuffer().length()) {
                if (this.sw.getBuffer().charAt(n) == '\t') {
                    this.sw.getBuffer().replace(n, n + 1, "        ");
                }
                ++n;
            }
            string2 = this.sw.toString();
            this.sw.getBuffer().delete(0, this.sw.getBuffer().length());
        }
        try {
            if (this.fancy) {
                this.textpane.setEditable(true);
                this.textpane.insertIcon((ImageIcon)this.icons.get(loggingEvent.priority));
                this.textpane.setEditable(false);
            }
            this.doc.insertString(this.doc.getLength(), string + string2, (MutableAttributeSet)this.attributes.get(loggingEvent.priority));
        }
        catch (BadLocationException badLocationException) {
            System.err.println(badLocationException);
        }
        this.textpane.setCaretPosition(this.doc.getLength());
    }

    public JTextPane getTextPane() {
        return this.textpane;
    }

    public String getLabel() {
        return this.label;
    }

    public String[] getOptionStrings() {
        return new String[]{"Label", "Color.Emerg", "Color.Error", "Color.Warn", "Color.Info", "Color.Debug", "Color.Background", "Fancy", "Font.Name", "Font.Size"};
    }

    private Color parseColor(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int[] nArray = new int[]{255, 255, 255, 255};
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            nArray[n] = Integer.parseInt(stringTokenizer.nextToken());
            ++n;
        }
        return new Color(nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setTextPane(JTextPane jTextPane) {
        this.textpane = jTextPane;
        jTextPane.setEditable(false);
        jTextPane.setBackground(Color.lightGray);
        this.doc = jTextPane.getStyledDocument();
    }

    private void setColor(Priority priority, String string) {
        StyleConstants.setForeground((MutableAttributeSet)this.attributes.get(priority), this.parseColor(string));
    }

    private void setFontSize(int n) {
        Enumeration enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            StyleConstants.setFontSize((MutableAttributeSet)enumeration.nextElement(), n);
        }
    }

    private void setFontName(String string) {
        Enumeration enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            StyleConstants.setFontFamily((MutableAttributeSet)enumeration.nextElement(), string);
        }
    }

    public void setOption(String string, String string2) {
        if (string.equalsIgnoreCase("Label")) {
            this.label = string2;
        }
        if (string.equalsIgnoreCase("Color.Emerg")) {
            this.setColor(Priority.FATAL, string2);
        }
        if (string.equalsIgnoreCase("Color.Error")) {
            this.setColor(Priority.ERROR, string2);
        }
        if (string.equalsIgnoreCase("Color.Warn")) {
            this.setColor(Priority.WARN, string2);
        }
        if (string.equalsIgnoreCase("Color.Info")) {
            this.setColor(Priority.INFO, string2);
        }
        if (string.equalsIgnoreCase("Color.Debug")) {
            this.setColor(Priority.DEBUG, string2);
        }
        if (string.equalsIgnoreCase("Color.Background")) {
            this.textpane.setBackground(this.parseColor(string2));
        }
        if (string.equalsIgnoreCase("Fancy")) {
            this.fancy = OptionConverter.toBoolean(string2, this.fancy);
        }
        if (string.equalsIgnoreCase("Font.Size")) {
            this.setFontSize(Integer.parseInt(string2));
        }
        if (string.equalsIgnoreCase("Font.Name")) {
            this.setFontName(string2);
        }
    }

    public boolean requiresLayout() {
        return true;
    }

    static /* synthetic */ String access$2(TextPaneAppender textPaneAppender) {
        return textPaneAppender.name;
    }

    public TextPaneAppender(Layout layout, String string) {
        this();
        this.layout = layout;
        this.name = string;
        this.setTextPane(new JTextPane());
        this.createAttributes();
        this.createIcons();
    }

    public TextPaneAppender() {
        this.LABEL_OPTION = "Label";
        this.COLOR_OPTION_FATAL = "Color.Emerg";
        this.COLOR_OPTION_ERROR = "Color.Error";
        this.COLOR_OPTION_WARN = "Color.Warn";
        this.COLOR_OPTION_INFO = "Color.Info";
        this.COLOR_OPTION_DEBUG = "Color.Debug";
        this.COLOR_OPTION_BACKGROUND = "Color.Background";
        this.FANCY_OPTION = "Fancy";
        this.FONT_NAME_OPTION = "Font.Name";
        this.FONT_SIZE_OPTION = "Font.Size";
        this.setTextPane(new JTextPane());
        this.createAttributes();
        this.createIcons();
        this.label = "";
        this.sw = new StringWriter();
        this.qw = new QuietWriter(this.sw, this.errorHandler);
        this.tp = new TracerPrintWriter(this.qw);
        this.fancy = true;
    }
}

