/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.CountingQuietWriter;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.LoggingEvent;

public class RollingFileAppender
extends FileAppender {
    public static final String MAX_FILE_SIZE_OPTION = "MaxFileSize";
    public static final String MAX_BACKUP_INDEX_OPTION = "MaxBackupIndex";
    protected long maxFileSize = 0xA00000L;
    protected int maxBackupIndex = 1;

    public String[] getOptionStrings() {
        return OptionConverter.concatanateArrays(super.getOptionStrings(), new String[]{MAX_FILE_SIZE_OPTION, MAX_BACKUP_INDEX_OPTION});
    }

    public synchronized void setFile(String string, boolean bl) throws IOException {
        super.setFile(string, bl);
        if (bl) {
            File file = new File(string);
            ((CountingQuietWriter)this.qw).setCount(file.length());
        }
    }

    public synchronized void rollOver() {
        if (this.maxBackupIndex > 0) {
            File file;
            File file2 = new File(this.fileName + "." + this.maxBackupIndex);
            if (file2.exists()) {
                file2.delete();
            }
            int n = this.maxBackupIndex - 1;
            while (n >= 1) {
                file2 = new File(this.fileName + "." + n);
                if (file2.exists()) {
                    file = new File(this.fileName + "." + (n + 1));
                    file2.renameTo(file);
                }
                --n;
            }
            file = new File(this.fileName + "." + "1");
            this.closeWriterIfOurs();
            file2 = new File(this.fileName);
            file2.renameTo(file);
        }
        try {
            this.setFile(this.fileName, false);
        }
        catch (IOException iOException) {
            System.err.println("setFile(" + this.fileName + ", false) call failed.");
            iOException.printStackTrace();
        }
    }

    public void setMaxBackupIndex(int n) {
        this.maxBackupIndex = n;
    }

    public void setMaxFileSize(long l) {
        this.maxFileSize = l;
    }

    public void setOption(String string, String string2) {
        super.setOption(string, string2);
        if (string.equalsIgnoreCase(MAX_FILE_SIZE_OPTION)) {
            this.maxFileSize = OptionConverter.toFileSize(string2, this.maxFileSize + 1L);
        } else if (string.equalsIgnoreCase(MAX_BACKUP_INDEX_OPTION)) {
            this.maxBackupIndex = OptionConverter.toInt(string2, this.maxBackupIndex);
        }
    }

    protected void setQWForFiles(Writer writer) {
        this.qw = new CountingQuietWriter(writer, this.errorHandler);
    }

    protected void subAppend(LoggingEvent loggingEvent) {
        super.subAppend(loggingEvent);
        if (this.fileName != null && ((CountingQuietWriter)this.qw).getCount() >= this.maxFileSize) {
            this.rollOver();
        }
    }

    public RollingFileAppender() {
    }

    public RollingFileAppender(Layout layout, OutputStream outputStream) {
        super(layout, outputStream);
    }

    public RollingFileAppender(Layout layout, Writer writer) {
        super(layout, writer);
    }

    public RollingFileAppender(Layout layout, String string, boolean bl) throws IOException {
        super(layout, string, bl);
    }

    public RollingFileAppender(Layout layout, String string) throws IOException {
        super(layout, string);
    }
}

