/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

public class Priority {
    static final int FATAL_INT = 50000;
    static final int ERROR_INT = 40000;
    static final int WARN_INT = 30000;
    static final int INFO_INT = 20000;
    static final int DEBUG_INT = 10000;
    public static final Priority FATAL = new Priority(50000, "FATAL", 0);
    public static final Priority ERROR = new Priority(40000, "ERROR", 3);
    public static final Priority WARN = new Priority(30000, "WARN", 4);
    public static final Priority INFO = new Priority(20000, "INFO", 5);
    public static final Priority DEBUG = new Priority(10000, "DEBUG", 6);
    int level;
    String levelStr;
    int syslogEquivalent;

    public final int getSyslogEquivalent() {
        return this.syslogEquivalent;
    }

    public final String toString() {
        return this.levelStr;
    }

    public final int toInt() {
        return this.level;
    }

    public boolean isGreaterOrEqual(Priority priority) {
        return this.level >= priority.level;
    }

    public static Priority[] getAllPossiblePriorities() {
        return new Priority[]{FATAL, ERROR, WARN, INFO, DEBUG};
    }

    public static Priority toPriority(String string) {
        return Priority.toPriority(string, DEBUG);
    }

    public static Priority toPriority(int n) {
        switch (n) {
            case 10000: {
                return DEBUG;
            }
            case 20000: {
                return INFO;
            }
            case 30000: {
                return WARN;
            }
            case 40000: {
                return ERROR;
            }
            case 50000: {
                return FATAL;
            }
        }
        return DEBUG;
    }

    public static Priority toPriority(String string, Priority priority) {
        if (string == null) {
            return priority;
        }
        String string2 = string.toUpperCase();
        if (string2.equals("DEBUG")) {
            return DEBUG;
        }
        if (string2.equals("INFO")) {
            return INFO;
        }
        if (string2.equals("WARN")) {
            return WARN;
        }
        if (string2.equals("ERROR")) {
            return ERROR;
        }
        if (string2.equals("FATAL")) {
            return FATAL;
        }
        return priority;
    }

    protected Priority(int n, String string, int n2) {
        this.level = n;
        this.levelStr = string;
        this.syslogEquivalent = n2;
    }
}

