#ifndef _MESSAGE_H_
#define _MESSAGE_H_

#include "main.h"

void messages_update (void);
void messages_render (void);
int messages_updated (void);
void messages_init (char const *filename);
void messages_exit (char const *filename);

#ifdef __GNUC__
void message (int delay, SAMPLE * sound, char const *format, ...) __attribute__ ((format (printf, 3, 4)));
void message_ex (int delay, SAMPLE * sound, int volume, int pitch, int panning, char const *format, ...) __attribute__ ((format (printf, 6, 7)));
#else
void message (int delay, SAMPLE * sound, char const *format, ...);
void message_ex (int delay, SAMPLE * sound, int volume, int pitch, int panning, char const *format, ...);
#endif

#endif
