Ext.data.JsonP.Ext_layout_SizeModel({"mixins":[],"code_type":"assignment","inheritable":false,"component":false,"meta":{"protected":true},"mixedInto":[],"uses":[],"aliases":{},"parentMixins":[],"superclasses":[],"members":{"event":[],"property":[{"meta":{"readonly":true},"owner":"Ext.layout.SizeModel","tagname":"property","name":"auto","id":"property-auto"},{"meta":{"readonly":true},"owner":"Ext.layout.SizeModel","tagname":"property","name":"calculated","id":"property-calculated"},{"meta":{"readonly":true},"owner":"Ext.layout.SizeModel","tagname":"property","name":"calculatedFromConfigured","id":"property-calculatedFromConfigured"},{"meta":{"readonly":true},"owner":"Ext.layout.SizeModel","tagname":"property","name":"calculatedFromNatural","id":"property-calculatedFromNatural"},{"meta":{"readonly":true},"owner":"Ext.layout.SizeModel","tagname":"property","name":"calculatedFromShrinkWrap","id":"property-calculatedFromShrinkWrap"},{"meta":{"readonly":true},"owner":"Ext.layout.SizeModel","tagname":"property","name":"configured","id":"property-configured"},{"meta":{"readonly":true},"owner":"Ext.layout.SizeModel","tagname":"property","name":"constrainedMax","id":"property-constrainedMax"},{"meta":{"readonly":true},"owner":"Ext.layout.SizeModel","tagname":"property","name":"constrainedMin","id":"property-constrainedMin"},{"meta":{"readonly":true},"owner":"Ext.layout.SizeModel","tagname":"property","name":"fixed","id":"property-fixed"},{"meta":{"readonly":true},"owner":"Ext.layout.SizeModel","tagname":"property","name":"name","id":"property-name"},{"meta":{"readonly":true},"owner":"Ext.layout.SizeModel","tagname":"property","name":"names","id":"property-names"},{"meta":{"readonly":true},"owner":"Ext.layout.SizeModel","tagname":"property","name":"natural","id":"property-natural"},{"meta":{"readonly":true},"owner":"Ext.layout.SizeModel","tagname":"property","name":"ordinal","id":"property-ordinal"},{"meta":{},"owner":"Ext.layout.SizeModel","tagname":"property","name":"pairsByHeightOrdinal","id":"property-pairsByHeightOrdinal"},{"meta":{"readonly":true},"owner":"Ext.layout.SizeModel","tagname":"property","name":"shrinkWrap","id":"property-shrinkWrap"}],"css_var":[],"method":[],"css_mixin":[],"cfg":[]},"tagname":"class","extends":null,"html":"<div><pre class=\"hierarchy\"><h4>Files</h4><div class='dependency'><a href='source/Layout.html#Ext-layout-SizeModel' target='_blank'>Layout.js</a></div></pre><div class='doc-contents'><p>This class describes a size determination strategy or algorithm used by the layout\nsystem. There are special instances of this class stored as static properties to\navoid needless object instantiation. These instances should be treated as readonly.</p>\n\n<ul>\n<li><code>calculated</code></li>\n<li><code>configured</code></li>\n<li><code>constrainedMax</code></li>\n<li><code>constrainedMin</code></li>\n<li><code>natural</code></li>\n<li><code>shrinkWrap</code></li>\n<li><code>calculatedFromConfigured</code></li>\n<li><code>calculatedFromNatural</code></li>\n<li><code>calculatedFromShrinkWrap</code></li>\n</ul>\n\n\n<p>Using one of these instances is simply:</p>\n\n<pre><code>  var calculated = <a href=\"#!/api/Ext.layout.SizeModel-property-calculated\" rel=\"Ext.layout.SizeModel-property-calculated\" class=\"docClass\">Ext.layout.SizeModel.calculated</a>;\n</code></pre>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-auto' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.layout.SizeModel'>Ext.layout.SizeModel</span><br/><a href='source/Layout.html#Ext-layout-SizeModel-property-auto' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.layout.SizeModel-property-auto' class='name not-expandable'>auto</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><strong class='readonly signature'>readonly</strong></div><div class='description'><div class='short'><p>True if the size is either <code>natural</code> or <code>shrinkWrap</code>, otherwise false.</p>\n</div><div class='long'><p>True if the size is either <code>natural</code> or <code>shrinkWrap</code>, otherwise false.</p>\n</div></div></div><div id='property-calculated' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.layout.SizeModel'>Ext.layout.SizeModel</span><br/><a href='source/Layout.html#Ext-layout-SizeModel-property-calculated' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.layout.SizeModel-property-calculated' class='name expandable'>calculated</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><strong class='readonly signature'>readonly</strong></div><div class='description'><div class='short'>True if the size is calculated by the ownerLayout. ...</div><div class='long'><p>True if the size is calculated by the <code>ownerLayout</code>.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='property-calculatedFromConfigured' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.layout.SizeModel'>Ext.layout.SizeModel</span><br/><a href='source/Layout.html#Ext-layout-SizeModel-property-calculatedFromConfigured' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.layout.SizeModel-property-calculatedFromConfigured' class='name expandable'>calculatedFromConfigured</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><strong class='readonly signature'>readonly</strong></div><div class='description'><div class='short'>True if the size is calculated by the ownerLayout based on a configured size. ...</div><div class='long'><p>True if the size is calculated by the <code>ownerLayout</code> based on a configured size.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='property-calculatedFromNatural' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.layout.SizeModel'>Ext.layout.SizeModel</span><br/><a href='source/Layout.html#Ext-layout-SizeModel-property-calculatedFromNatural' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.layout.SizeModel-property-calculatedFromNatural' class='name expandable'>calculatedFromNatural</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><strong class='readonly signature'>readonly</strong></div><div class='description'><div class='short'>True if the size is calculated by the ownerLayout based on natural size model\nresults. ...</div><div class='long'><p>True if the size is calculated by the <code>ownerLayout</code> based on <code>natural</code> size model\nresults.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='property-calculatedFromShrinkWrap' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.layout.SizeModel'>Ext.layout.SizeModel</span><br/><a href='source/Layout.html#Ext-layout-SizeModel-property-calculatedFromShrinkWrap' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.layout.SizeModel-property-calculatedFromShrinkWrap' class='name expandable'>calculatedFromShrinkWrap</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><strong class='readonly signature'>readonly</strong></div><div class='description'><div class='short'>True if the size is calculated by the ownerLayout based on shrinkWrap size model\nresults. ...</div><div class='long'><p>True if the size is calculated by the <code>ownerLayout</code> based on <code>shrinkWrap</code> size model\nresults.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='property-configured' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.layout.SizeModel'>Ext.layout.SizeModel</span><br/><a href='source/Layout.html#Ext-layout-SizeModel-property-configured' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.layout.SizeModel-property-configured' class='name expandable'>configured</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><strong class='readonly signature'>readonly</strong></div><div class='description'><div class='short'>True if the size is configured (e.g., by a width or minWidth). ...</div><div class='long'><p>True if the size is configured (e.g., by a <code>width</code> or <code>minWidth</code>). The names of\nconfiguration properties can be found in the <a href=\"#!/api/Ext.layout.SizeModel-property-names\" rel=\"Ext.layout.SizeModel-property-names\" class=\"docClass\">names</a> property.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='property-constrainedMax' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.layout.SizeModel'>Ext.layout.SizeModel</span><br/><a href='source/Layout.html#Ext-layout-SizeModel-property-constrainedMax' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.layout.SizeModel-property-constrainedMax' class='name expandable'>constrainedMax</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><strong class='readonly signature'>readonly</strong></div><div class='description'><div class='short'>True if the size is constrained by a maxWidth or maxHeight configuration. ...</div><div class='long'><p>True if the size is constrained by a <code>maxWidth</code> or <code>maxHeight</code> configuration. This\nis a flavor of <code>configured</code> (since <code>maxWidth</code> and <code>maxHeight</code> are config options).\nIf true, the <a href=\"#!/api/Ext.layout.SizeModel-property-names\" rel=\"Ext.layout.SizeModel-property-names\" class=\"docClass\">names</a> property will be defined as well.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='property-constrainedMin' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.layout.SizeModel'>Ext.layout.SizeModel</span><br/><a href='source/Layout.html#Ext-layout-SizeModel-property-constrainedMin' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.layout.SizeModel-property-constrainedMin' class='name expandable'>constrainedMin</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><strong class='readonly signature'>readonly</strong></div><div class='description'><div class='short'>True if the size is constrained by a minWidth or minHeight configuration. ...</div><div class='long'><p>True if the size is constrained by a <code>minWidth</code> or <code>minHeight</code> configuration. This\nis a flavor of <code>configured</code> (since <code>minWidth</code> and <code>minHeight</code> are config options).\nIf true, the <a href=\"#!/api/Ext.layout.SizeModel-property-names\" rel=\"Ext.layout.SizeModel-property-names\" class=\"docClass\">names</a> property will be defined as well.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='property-fixed' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.layout.SizeModel'>Ext.layout.SizeModel</span><br/><a href='source/Layout.html#Ext-layout-SizeModel-property-fixed' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.layout.SizeModel-property-fixed' class='name not-expandable'>fixed</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><strong class='readonly signature'>readonly</strong></div><div class='description'><div class='short'><p>True if the size is either <code>calculated</code> or <code>configured</code>, otherwise false.</p>\n</div><div class='long'><p>True if the size is either <code>calculated</code> or <code>configured</code>, otherwise false.</p>\n</div></div></div><div id='property-name' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.layout.SizeModel'>Ext.layout.SizeModel</span><br/><a href='source/Layout.html#Ext-layout-SizeModel-property-name' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.layout.SizeModel-property-name' class='name not-expandable'>name</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><strong class='readonly signature'>readonly</strong></div><div class='description'><div class='short'><p>The name of this size model (e.g., \"calculated\").</p>\n</div><div class='long'><p>The name of this size model (e.g., \"calculated\").</p>\n</div></div></div><div id='property-names' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.layout.SizeModel'>Ext.layout.SizeModel</span><br/><a href='source/Layout.html#Ext-layout-SizeModel-property-names' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.layout.SizeModel-property-names' class='name expandable'>names</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><strong class='readonly signature'>readonly</strong></div><div class='description'><div class='short'>An object with the config property names that determine the\nsize. ...</div><div class='long'><p>An object with the config property names that determine the\nsize.</p>\n<p>Defaults to: <code>null</code></p><ul><li><span class='pre'>width</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The width property name (e.g., 'width').</p>\n</div></li><li><span class='pre'>height</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The height property name (e.g., 'minHeight').</p>\n</div></li></ul></div></div></div><div id='property-natural' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.layout.SizeModel'>Ext.layout.SizeModel</span><br/><a href='source/Layout.html#Ext-layout-SizeModel-property-natural' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.layout.SizeModel-property-natural' class='name expandable'>natural</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><strong class='readonly signature'>readonly</strong></div><div class='description'><div class='short'>True if the size is determined by CSS and not by content. ...</div><div class='long'><p>True if the size is determined by CSS and not by content. Such sizes are assumed to\nbe dependent on the container box and measurement occurs on the outer-most element.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='property-ordinal' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.layout.SizeModel'>Ext.layout.SizeModel</span><br/><a href='source/Layout.html#Ext-layout-SizeModel-property-ordinal' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.layout.SizeModel-property-ordinal' class='name not-expandable'>ordinal</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><strong class='readonly signature'>readonly</strong></div><div class='description'><div class='short'><p>@prop {Number} ordinal\nThe 0-based ordinal for this <code>SizeModel</code> instance.</p>\n</div><div class='long'><p>@prop {Number} ordinal\nThe 0-based ordinal for this <code>SizeModel</code> instance.</p>\n</div></div></div><div id='property-pairsByHeightOrdinal' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.layout.SizeModel'>Ext.layout.SizeModel</span><br/><a href='source/Layout.html#Ext-layout-SizeModel-property-pairsByHeightOrdinal' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.layout.SizeModel-property-pairsByHeightOrdinal' class='name expandable'>pairsByHeightOrdinal</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>[]</span></div><div class='description'><div class='short'>An array of objects indexed by the ordinal of a height SizeModel on\na width SizeModel to yield an object describing b...</div><div class='long'><p>An array of objects indexed by the <a href=\"#!/api/Ext.layout.SizeModel-property-ordinal\" rel=\"Ext.layout.SizeModel-property-ordinal\" class=\"docClass\">ordinal</a> of a height <code>SizeModel</code> on\na width <code>SizeModel</code> to yield an object describing both height and width size\nmodels.</p>\n\n<p>Used like this:</p>\n\n<pre><code> widthModel.pairsByHeightOrdinal[heightModel.ordinal]\n</code></pre>\n\n<p>This provides a reusable object equivalent to the following:</p>\n\n<pre><code> {\n     width: widthModel,\n     height: heightModel\n }\n</code></pre>\n<ul><li><span class='pre'>width</span> : <a href=\"#!/api/Ext.layout.SizeModel\" rel=\"Ext.layout.SizeModel\" class=\"docClass\">Ext.layout.SizeModel</a><div class='sub-desc'><p>The <code>SizeModel</code> for\nthe width.</p>\n</div></li><li><span class='pre'>height</span> : <a href=\"#!/api/Ext.layout.SizeModel\" rel=\"Ext.layout.SizeModel\" class=\"docClass\">Ext.layout.SizeModel</a><div class='sub-desc'><p>The <code>SizeModel</code> for\nthe height.</p>\n</div></li></ul></div></div></div><div id='property-shrinkWrap' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.layout.SizeModel'>Ext.layout.SizeModel</span><br/><a href='source/Layout.html#Ext-layout-SizeModel-property-shrinkWrap' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.layout.SizeModel-property-shrinkWrap' class='name expandable'>shrinkWrap</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><strong class='readonly signature'>readonly</strong></div><div class='description'><div class='short'>True if the size is determined by content irrespective of the container box. ...</div><div class='long'><p>True if the size is determined by content irrespective of the container box.</p>\n<p>Defaults to: <code>false</code></p></div></div></div></div></div></div></div>","subclasses":[],"name":"Ext.layout.SizeModel","alternateClassNames":[],"inheritdoc":null,"files":[{"href":"Layout.html#Ext-layout-SizeModel","filename":"Layout.js"}],"html_meta":{"protected":null},"singleton":false,"id":"class-Ext.layout.SizeModel","statics":{"property":[],"event":[],"css_var":[],"method":[],"css_mixin":[],"cfg":[]},"requires":[]});