Ext.require(['*']);
Ext.onReady(function() {
	Ext.QuickTips.init();

	Ext.state.Manager.setProvider(Ext.create('Ext.state.CookieProvider'));

	var opticiansStore = Ext.create('Ext.data.Store', {
		fields: ['type'],
		data: [
			{'type': 'Glasses'},
			{'type': 'Contact Lenses'},
			{'type': 'Laser'}
		]
	});

	var viewport = Ext.create('Ext.Viewport', {
		id: 'border-example',
		layout: 'border',
		items: [
			Ext.create('Ext.Component', {
				region: 'north',
				height: 32, 
				autoEl: {
				tag: 'div',
				html: '<p>Opticians\' Dashboard</p>'
			}
			}), {
				region: 'south',
				id: 'southPanel',
				contentEl: 'south',
				split: true,
				height: 100,
				minSize: 100,
				maxSize: 200,
				collapsible: true,
				collapsed: true,
				title: 'South',
				margins: '0'
			}, {
				xtype: 'tabpanel',
				region: 'east',
				id: 'eastPanel',
				title: 'East Side',
				dockedItems: [{
					dock: 'top',
					xtype: 'toolbar',
					items: [ '->', {
					xtype: 'button',
					text: 'test',
					tooltip: 'Test Button'
				}]
			}
		],
		animCollapse: true,
		collapsible: true,
		split: true,
		width: 225, 
		minSize: 175,
		maxSize: 400,
		margins: '0 5 0 0',
		activeTab: 1,
		tabPosition: 'bottom',
		items: [{
			html: '<p>A TabPanel component can be a region.</p>',
			title: 'A Tab',
			autoScroll: true
			}, Ext.create('Ext.grid.PropertyGrid', {
				title: 'Eye Data',
				closable: true,
				id: 'easttab',
				source: {
					"Right Sphere": -3.25,
					"Left Sphere": -3.5,
					"Right Axis": 160,
					"Left Axis": 160,
					"Treated": Ext.Date.parse('10/15/2011', 'm/d/Y'),
					"Tested": false
				}
			})]
		}, {
			region: 'west',
			stateId: 'navigation-panel',
			id: 'westPanel', 
			title: 'West',
			split: true,
			width: 200,
			minWidth: 175,
			maxWidth: 400,
			collapsible: true,
			animCollapse: true,
			margins: '0 0 0 5',
			layout: 'accordion',
			items: [{
					contentEl: 'west',
					title: 'Navigation',
					id: 'navigation',
					iconCls: 'nav' 
				}, {
					title: 'Settings',
					id: 'settings',
					html: '<p>Some settings in here.</p>',
					iconCls: 'settings'
				}, {
					title: 'Information',
					id: 'information',
					html: '<p>Some info in here.</p>',
					iconCls: 'info'
				}]
			},
			Ext.create('Ext.tab.Panel', {
				region: 'center', 
				deferredRender: false,
				activeTab: 1,
				items: [{
				contentEl: 'center1',
				title: 'Close Me',
				id: 'centertab',
				closable: true,
				autoScroll: true
			}, {
				xtype: 'form',
				title: 'Appointment Form',
				bodyPadding: 10,
				store: opticiansStore,
				layout: 'anchor',
				renderTo: 'center2',
				defaults: {
					width: 280
				},
				defaultType: 'textfield',
				items: [{
					fieldLabel: 'Name',
					name: 'name',
					allowBlank: false,
				}, {
				xtype: 'fieldcontainer',
				layout: 'hbox',
				defaultType: 'radiofield',
				items: [
					{
						boxLabel: 'Male',
						name: 'sex'
					}, {
						boxLabel: 'Female',
						name: 'sex',
						margin: '0 10'
					}
				]
				}, {
					fieldLabel: 'E-mail',
					vtype: 'email'
				}, {
					xtype: 'combo',
					fieldLabel: 'Type',
					store: opticiansStore,
					displayField: 'type',
				}, {
					fieldLabel: 'Quantity',
					xtype: 'numberfield',
					allowDecimals: false,
					minValue: 0
				}, {
					xtype: 'datefield',
					fieldLabel: 'Date'
				}, {
					xtype: 'timefield',
					fieldLabel: 'Time'
				}, {
					xtype: 'textarea',
					fieldLabel: 'Notes',
					width: 320
				}, {
					xtype: 'checkbox',
					fieldLabel: 'Agreed to T&C?'
				}, {
					xtype: 'button',
					text: 'Submit',
					margin: '15 0',
					width: 100
				}]
			}]
		})
		]
	});
	
	var navigation = viewport.lookupComponent('navigation');
	var settings = viewport.lookupComponent('settings');
	var information = viewport.lookupComponent('information');
	
	var eastPanel = viewport.lookupComponent('eastPanel');
	var southPanel = viewport.lookupComponent('southPanel');
	var westPanel = viewport.lookupComponent('westPanel');
});