Ext.data.JsonP.Ext({"tagname":"class","html":"<div><pre class=\"hierarchy\"><h4>Files</h4><div class='dependency'><a href='source/Ext-more.html#Ext' target='_blank'>Ext-more.js</a></div><div class='dependency'><a href='source/Ext-more.html#Ext' target='_blank'>Ext-more.js</a></div><div class='dependency'><a href='source/Ext.html#Ext' target='_blank'>Ext.js</a></div></pre><div class='doc-contents'><p>The Ext namespace (global object) encapsulates all classes, singletons, and utility methods provided by Sencha's libraries.</p>\n Most user interface Components are at a lower level of nesting in the namespace, but many common utility functions are provided\n as direct properties of the Ext namespace.</p>\n\n<p> Also many frequently used methods from other classes are provided as shortcuts within the Ext namespace.\n For example <a href=\"#!/api/Ext-method-getCmp\" rel=\"Ext-method-getCmp\" class=\"docClass\">Ext.getCmp</a> aliases <a href=\"#!/api/Ext.ComponentManager-method-get\" rel=\"Ext.ComponentManager-method-get\" class=\"docClass\">Ext.ComponentManager.get</a>.</p>\n\n<p> Many applications are initiated with <a href=\"#!/api/Ext-method-onReady\" rel=\"Ext-method-onReady\" class=\"docClass\">Ext.onReady</a> which is called once the DOM is ready.\n This ensures all scripts have been loaded, preventing dependency issues. For example</p>\n\n<pre><code> Ext.onReady(function(){\n     new Ext.Component({\n         renderTo: document.body,\n         html: 'DOM ready!'\n     });\n });\n</code></pre>\n\n<p>For more information about how to use the Ext classes, see</p>\n\n<ul>\n<li><a href=\"http://www.sencha.com/learn/\">The Learning Center</a></li>\n<li><a href=\"http://www.sencha.com/learn/Ext_FAQ\">The FAQ</a></li>\n<li><a href=\"http://www.sencha.com/forum/\">The forums</a></li>\n</ul>\n\n</div><div class='members'><div id='m-property'><div class='definedBy'>Defined By</div><h3 class='members-title'>Properties</h3><div class='subsection'><div id='property-BLANK_IMAGE_URL' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-property-BLANK_IMAGE_URL' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-property-BLANK_IMAGE_URL' class='name expandable'>BLANK_IMAGE_URL</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>URL to a 1x1 transparent gif image used by Ext to create inline icons with CSS background images. ...</div><div class='long'><p>URL to a 1x1 transparent gif image used by Ext to create inline icons with CSS background images.\nIn older versions of IE, this defaults to \"http://sencha.com/s.gif\" and you should change this to a URL on your server.\nFor other browsers it uses an inline data URL.</p>\n</div></div></div><div id='property-SSL_SECURE_URL' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-property-SSL_SECURE_URL' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-property-SSL_SECURE_URL' class='name expandable'>SSL_SECURE_URL</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>URL to a blank file used by Ext when in secure mode for iframe src and onReady src to prevent\nthe IE insecure content...</div><div class='long'><p>URL to a blank file used by Ext when in secure mode for iframe src and onReady src to prevent\nthe IE insecure content warning (<tt>'about:blank'</tt>, except for IE in secure mode, which is <tt>'javascript:\"\"'</tt>).</p>\n</div></div></div><div id='property-USE_NATIVE_JSON' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-property-USE_NATIVE_JSON' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-property-USE_NATIVE_JSON' class='name expandable'>USE_NATIVE_JSON</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>Indicates whether to use native browser parsing for JSON methods. ...</div><div class='long'><p>Indicates whether to use native browser parsing for JSON methods.\nThis option is ignored if the browser does not support native JSON methods.\n<b>Note: Native JSON methods will not work with objects that have functions.\nAlso, property names must be quoted, otherwise the data will not parse.</b> (Defaults to false)</p>\n</div></div></div><div id='property-browser' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Browser.html#Ext-property-browser' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-property-browser' class='name not-expandable'>browser</a><span> : <a href=\"#!/api/Ext.env.Browser\" rel=\"Ext.env.Browser\" class=\"docClass\">Ext.env.Browser</a></span></div><div class='description'><div class='short'><p>Global convenient instance of <a href=\"#!/api/Ext.env.Browser\" rel=\"Ext.env.Browser\" class=\"docClass\">Ext.env.Browser</a>.</p>\n</div><div class='long'><p>Global convenient instance of <a href=\"#!/api/Ext.env.Browser\" rel=\"Ext.env.Browser\" class=\"docClass\">Ext.env.Browser</a>.</p>\n</div></div></div><div id='property-chromeVersion' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-property-chromeVersion' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-property-chromeVersion' class='name not-expandable'>chromeVersion</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>The current version of Chrome (0 if the browser is not Chrome).</p>\n</div><div class='long'><p>The current version of Chrome (0 if the browser is not Chrome).</p>\n</div></div></div><div id='property-enableFx' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-property-enableFx' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-property-enableFx' class='name not-expandable'>enableFx</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'><p>True if the <a href=\"#!/api/Ext.fx.Anim\" rel=\"Ext.fx.Anim\" class=\"docClass\">Ext.fx.Anim</a> Class is available</p>\n</div><div class='long'><p>True if the <a href=\"#!/api/Ext.fx.Anim\" rel=\"Ext.fx.Anim\" class=\"docClass\">Ext.fx.Anim</a> Class is available</p>\n</div></div></div><div id='property-enableGarbageCollector' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-property-enableGarbageCollector' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-property-enableGarbageCollector' class='name not-expandable'>enableGarbageCollector</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'><p>True to automatically uncache orphaned Ext.Elements periodically</p>\n</div><div class='long'><p>True to automatically uncache orphaned Ext.Elements periodically</p>\n</div></div></div><div id='property-enableListenerCollection' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-property-enableListenerCollection' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-property-enableListenerCollection' class='name not-expandable'>enableListenerCollection</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'><p>True to automatically purge event listeners during garbageCollection.</p>\n</div><div class='long'><p>True to automatically purge event listeners during garbageCollection.</p>\n</div></div></div><div id='property-enableNestedListenerRemoval' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-property-enableNestedListenerRemoval' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-property-enableNestedListenerRemoval' class='name expandable'>enableNestedListenerRemoval</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>EXPERIMENTAL - True to cascade listener removal to child elements when an element is removed. ...</div><div class='long'><p>EXPERIMENTAL - True to cascade listener removal to child elements when an element is removed.\nCurrently not optimized for performance.</p>\n</div></div></div><div id='property-enumerables' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext.html#Ext-property-enumerables' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-property-enumerables' class='name not-expandable'>enumerables</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]</span></div><div class='description'><div class='short'><p>An array containing extra enumerables for old browsers</p>\n</div><div class='long'><p>An array containing extra enumerables for old browsers</p>\n</div></div></div><div id='property-features' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/FeatureDetector.html#Ext-property-features' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-property-features' class='name not-expandable'>features</a><span> : <a href=\"#!/api/Ext.env.FeatureDetector\" rel=\"Ext.env.FeatureDetector\" class=\"docClass\">Ext.env.FeatureDetector</a></span></div><div class='description'><div class='short'><p>Global convenient instance of <a href=\"#!/api/Ext.env.FeatureDetector\" rel=\"Ext.env.FeatureDetector\" class=\"docClass\">Ext.env.FeatureDetector</a>.</p>\n</div><div class='long'><p>Global convenient instance of <a href=\"#!/api/Ext.env.FeatureDetector\" rel=\"Ext.env.FeatureDetector\" class=\"docClass\">Ext.env.FeatureDetector</a>.</p>\n</div></div></div><div id='property-firefoxVersion' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-property-firefoxVersion' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-property-firefoxVersion' class='name not-expandable'>firefoxVersion</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>The current version of Firefox (0 if the browser is not Firefox).</p>\n</div><div class='long'><p>The current version of Firefox (0 if the browser is not Firefox).</p>\n</div></div></div><div id='property-ieVersion' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-property-ieVersion' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-property-ieVersion' class='name expandable'>ieVersion</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The current version of IE (0 if the browser is not IE). ...</div><div class='long'><p>The current version of IE (0 if the browser is not IE). This does not account\nfor the documentMode of the current page, which is factored into <a href=\"#!/api/Ext-property-isIE7\" rel=\"Ext-property-isIE7\" class=\"docClass\">isIE7</a>,\n<a href=\"#!/api/Ext-property-isIE8\" rel=\"Ext-property-isIE8\" class=\"docClass\">isIE8</a> and <a href=\"#!/api/Ext-property-isIE9\" rel=\"Ext-property-isIE9\" class=\"docClass\">isIE9</a>. Thus this is not always true:</p>\n\n<pre><code> Ext.isIE8 == (Ext.ieVersion == 8)\n</code></pre>\n</div></div></div><div id='property-isChrome' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-property-isChrome' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-property-isChrome' class='name not-expandable'>isChrome</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'><p>True if the detected browser is Chrome.</p>\n</div><div class='long'><p>True if the detected browser is Chrome.</p>\n</div></div></div><div id='property-isFF3_0' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-property-isFF3_0' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-property-isFF3_0' class='name not-expandable'>isFF3_0</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'><p>True if the detected browser uses FireFox 3.0</p>\n</div><div class='long'><p>True if the detected browser uses FireFox 3.0</p>\n</div></div></div><div id='property-isFF3_5' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-property-isFF3_5' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-property-isFF3_5' class='name not-expandable'>isFF3_5</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'><p>True if the detected browser uses FireFox 3.5</p>\n</div><div class='long'><p>True if the detected browser uses FireFox 3.5</p>\n</div></div></div><div id='property-isFF3_6' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-property-isFF3_6' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-property-isFF3_6' class='name not-expandable'>isFF3_6</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'><p>True if the detected browser uses FireFox 3.6</p>\n</div><div class='long'><p>True if the detected browser uses FireFox 3.6</p>\n</div></div></div><div id='property-isFF4' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-property-isFF4' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-property-isFF4' class='name not-expandable'>isFF4</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'><p>True if the detected browser uses FireFox 4</p>\n</div><div class='long'><p>True if the detected browser uses FireFox 4</p>\n</div></div></div><div id='property-isFF5' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-property-isFF5' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-property-isFF5' class='name not-expandable'>isFF5</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'><p>True if the detected browser uses FireFox 5</p>\n</div><div class='long'><p>True if the detected browser uses FireFox 5</p>\n</div></div></div><div id='property-isGecko' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-property-isGecko' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-property-isGecko' class='name expandable'>isGecko</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>True if the detected browser uses the Gecko layout engine (e.g. ...</div><div class='long'><p>True if the detected browser uses the Gecko layout engine (e.g. Mozilla, Firefox).</p>\n</div></div></div><div id='property-isGecko3' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-property-isGecko3' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-property-isGecko3' class='name expandable'>isGecko3</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>True if the detected browser uses a Gecko 1.9+ layout engine (e.g. ...</div><div class='long'><p>True if the detected browser uses a Gecko 1.9+ layout engine (e.g. Firefox 3.x).</p>\n</div></div></div><div id='property-isGecko4' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-property-isGecko4' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-property-isGecko4' class='name expandable'>isGecko4</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>True if the detected browser uses a Gecko 2.0+ layout engine (e.g. ...</div><div class='long'><p>True if the detected browser uses a Gecko 2.0+ layout engine (e.g. Firefox 4.x).</p>\n</div></div></div><div id='property-isGecko5' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-property-isGecko5' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-property-isGecko5' class='name expandable'>isGecko5</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>True if the detected browser uses a Gecko 5.0+ layout engine (e.g. ...</div><div class='long'><p>True if the detected browser uses a Gecko 5.0+ layout engine (e.g. Firefox 5.x).</p>\n</div></div></div><div id='property-isIE' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-property-isIE' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-property-isIE' class='name not-expandable'>isIE</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'><p>True if the detected browser is Internet Explorer.</p>\n</div><div class='long'><p>True if the detected browser is Internet Explorer.</p>\n</div></div></div><div id='property-isIE6' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-property-isIE6' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-property-isIE6' class='name not-expandable'>isIE6</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'><p>True if the detected browser is Internet Explorer 6.x.</p>\n</div><div class='long'><p>True if the detected browser is Internet Explorer 6.x.</p>\n</div></div></div><div id='property-isIE7' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-property-isIE7' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-property-isIE7' class='name not-expandable'>isIE7</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'><p>True if the detected browser is Internet Explorer 7.x.</p>\n</div><div class='long'><p>True if the detected browser is Internet Explorer 7.x.</p>\n</div></div></div><div id='property-isIE8' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-property-isIE8' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-property-isIE8' class='name not-expandable'>isIE8</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'><p>True if the detected browser is Internet Explorer 8.x.</p>\n</div><div class='long'><p>True if the detected browser is Internet Explorer 8.x.</p>\n</div></div></div><div id='property-isIE9' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-property-isIE9' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-property-isIE9' class='name not-expandable'>isIE9</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'><p>True if the detected browser is Internet Explorer 9.x.</p>\n</div><div class='long'><p>True if the detected browser is Internet Explorer 9.x.</p>\n</div></div></div><div id='property-isLinux' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-property-isLinux' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-property-isLinux' class='name not-expandable'>isLinux</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'><p>True if the detected platform is Linux.</p>\n</div><div class='long'><p>True if the detected platform is Linux.</p>\n</div></div></div><div id='property-isMac' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-property-isMac' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-property-isMac' class='name not-expandable'>isMac</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'><p>True if the detected platform is Mac OS.</p>\n</div><div class='long'><p>True if the detected platform is Mac OS.</p>\n</div></div></div><div id='property-isOpera' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-property-isOpera' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-property-isOpera' class='name not-expandable'>isOpera</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'><p>True if the detected browser is Opera.</p>\n</div><div class='long'><p>True if the detected browser is Opera.</p>\n</div></div></div><div id='property-isOpera10_5' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-property-isOpera10_5' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-property-isOpera10_5' class='name not-expandable'>isOpera10_5</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'><p>True if the detected browser is Opera 10.5x.</p>\n</div><div class='long'><p>True if the detected browser is Opera 10.5x.</p>\n</div></div></div><div id='property-isReady' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-property-isReady' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-property-isReady' class='name not-expandable'>isReady</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'><p>True when the document is fully initialized and ready for action</p>\n</div><div class='long'><p>True when the document is fully initialized and ready for action</p>\n</div></div></div><div id='property-isSafari' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-property-isSafari' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-property-isSafari' class='name not-expandable'>isSafari</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'><p>True if the detected browser is Safari.</p>\n</div><div class='long'><p>True if the detected browser is Safari.</p>\n</div></div></div><div id='property-isSafari2' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-property-isSafari2' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-property-isSafari2' class='name not-expandable'>isSafari2</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'><p>True if the detected browser is Safari 2.x.</p>\n</div><div class='long'><p>True if the detected browser is Safari 2.x.</p>\n</div></div></div><div id='property-isSafari3' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-property-isSafari3' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-property-isSafari3' class='name not-expandable'>isSafari3</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'><p>True if the detected browser is Safari 3.x.</p>\n</div><div class='long'><p>True if the detected browser is Safari 3.x.</p>\n</div></div></div><div id='property-isSafari4' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-property-isSafari4' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-property-isSafari4' class='name not-expandable'>isSafari4</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'><p>True if the detected browser is Safari 4.x.</p>\n</div><div class='long'><p>True if the detected browser is Safari 4.x.</p>\n</div></div></div><div id='property-isSafari5' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-property-isSafari5' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-property-isSafari5' class='name not-expandable'>isSafari5</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'><p>True if the detected browser is Safari 5.x.</p>\n</div><div class='long'><p>True if the detected browser is Safari 5.x.</p>\n</div></div></div><div id='property-isSecure' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-property-isSecure' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-property-isSecure' class='name not-expandable'>isSecure</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'><p>True if the page is running over SSL</p>\n</div><div class='long'><p>True if the page is running over SSL</p>\n</div></div></div><div id='property-isWebKit' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-property-isWebKit' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-property-isWebKit' class='name not-expandable'>isWebKit</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'><p>True if the detected browser uses WebKit.</p>\n</div><div class='long'><p>True if the detected browser uses WebKit.</p>\n</div></div></div><div id='property-isWindows' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-property-isWindows' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-property-isWindows' class='name not-expandable'>isWindows</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'><p>True if the detected platform is Windows.</p>\n</div><div class='long'><p>True if the detected platform is Windows.</p>\n</div></div></div><div id='property-log' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-property-log' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-property-log' class='name expandable'>log</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span></div><div class='description'><div class='short'>Logs a message. ...</div><div class='long'><p>Logs a message. If a console is present it will be used. On Opera, the method\n\"opera.postError\" is called. In other cases, the message is logged to an array\n\"Ext.log.out\". An attached debugger can watch this array and view the log. The\nlog buffer is limited to a maximum of \"Ext.log.max\" entries (defaults to 250).\nThe <code>Ext.log.out</code> array can also be written to a popup window by entering the\nfollowing in the URL bar (a \"bookmarklet\"):</p>\n\n<p>   javascript:void(Ext.log.show());</p>\n\n<p>If additional parameters are passed, they are joined and appended to the message.\nA technique for tracing entry and exit of a function is this:</p>\n\n<pre><code> function foo () {\n     Ext.log({ indent: 1 }, '&gt;&gt; foo');\n\n     // log statements in here or methods called from here will be indented\n     // by one step\n\n     Ext.log({ outdent: 1 }, '&lt;&lt; foo');\n }\n</code></pre>\n\n<p>This method does nothing in a release build.</p>\n</div></div></div><div id='property-operaVersion' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-property-operaVersion' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-property-operaVersion' class='name not-expandable'>operaVersion</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>The current version of Opera (0 if the browser is not Opera).</p>\n</div><div class='long'><p>The current version of Opera (0 if the browser is not Opera).</p>\n</div></div></div><div id='property-os' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/OS.html#Ext-property-os' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-property-os' class='name not-expandable'>os</a><span> : <a href=\"#!/api/Ext.env.OS\" rel=\"Ext.env.OS\" class=\"docClass\">Ext.env.OS</a></span></div><div class='description'><div class='short'><p>Global convenient instance of <a href=\"#!/api/Ext.env.OS\" rel=\"Ext.env.OS\" class=\"docClass\">Ext.env.OS</a>.</p>\n</div><div class='long'><p>Global convenient instance of <a href=\"#!/api/Ext.env.OS\" rel=\"Ext.env.OS\" class=\"docClass\">Ext.env.OS</a>.</p>\n</div></div></div><div id='property-safariVersion' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-property-safariVersion' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-property-safariVersion' class='name not-expandable'>safariVersion</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>The current version of Safari (0 if the browser is not Safari).</p>\n</div><div class='long'><p>The current version of Safari (0 if the browser is not Safari).</p>\n</div></div></div><div id='property-scopeResetCSS' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-property-scopeResetCSS' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-property-scopeResetCSS' class='name expandable'>scopeResetCSS</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>True to scope the reset CSS to be just applied to Ext components. ...</div><div class='long'><p>True to scope the reset CSS to be just applied to Ext components. Note that this wraps root containers\nwith an additional element. Also remember that when you turn on this option, you have to use ext-all-scoped {\nunless you use the bootstrap.js to load your javascript, in which case it will be handled for you.</p>\n</div></div></div><div id='property-useShims' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-property-useShims' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-property-useShims' class='name expandable'>useShims</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>By default, Ext intelligently decides whether floating elements should be shimmed. ...</div><div class='long'><p>By default, Ext intelligently decides whether floating elements should be shimmed. If you are using flash,\nyou may want to set this to true.</p>\n</div></div></div><div id='property-webKitVersion' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-property-webKitVersion' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-property-webKitVersion' class='name not-expandable'>webKitVersion</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>The current version of WebKit (0 if the browser does not use WebKit).</p>\n</div><div class='long'><p>The current version of WebKit (0 if the browser does not use WebKit).</p>\n</div></div></div></div></div><div id='m-method'><div class='definedBy'>Defined By</div><h3 class='members-title'>Methods</h3><div class='subsection'><div id='method-addBehaviors' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-method-addBehaviors' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-addBehaviors' class='name expandable'>addBehaviors</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> obj</span> )</div><div class='description'><div class='short'>Applies event listeners to elements by selectors when the document is ready. ...</div><div class='long'><p>Applies event listeners to elements by selectors when the document is ready.\nThe event name is specified with an <tt>&#64;</tt> suffix.</p>\n\n<pre><code>Ext.addBehaviors({\n    // add a listener for click on all anchors in element with id foo\n    '#foo a&#64;click' : function(e, t){\n        // do something\n    },\n\n    // add the same listener to multiple selectors (separated by comma BEFORE the &#64;)\n    '#foo a, #bar span.some-class&#64;mouseover' : function(){\n        // do something\n    }\n});\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>obj</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The list of behaviors to apply</p>\n</div></li></ul></div></div></div><div id='method-application' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-method-application' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-application' class='name expandable'>application</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> config</span> )</div><div class='description'><div class='short'>Loads Ext.app.Application class and starts it up with given configuration after the page is ready. ...</div><div class='long'><p>Loads <a href=\"#!/api/Ext.app.Application\" rel=\"Ext.app.Application\" class=\"docClass\">Ext.app.Application</a> class and starts it up with given configuration after the page is ready.</p>\n\n<p>See <a href=\"#!/api/Ext.app.Application\" rel=\"Ext.app.Application\" class=\"docClass\">Ext.app.Application</a> for details.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-apply' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext.html#Ext-method-apply' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-apply' class='name expandable'>apply</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> object, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> config, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> defaults</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Copies all the properties of config to the specified object. ...</div><div class='long'><p>Copies all the properties of config to the specified object.\nNote that if recursive merging and cloning without referencing the original objects / arrays is needed, use\n<a href=\"#!/api/Ext.Object-method-merge\" rel=\"Ext.Object-method-merge\" class=\"docClass\">Ext.Object.merge</a> instead.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>object</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The receiver of the properties</p>\n</div></li><li><span class='pre'>config</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The source of the properties</p>\n</div></li><li><span class='pre'>defaults</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>A different object that will also be applied for default values</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>returns obj</p>\n</div></li></ul></div></div></div><div id='method-applyIf' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext.html#Ext-method-applyIf' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-applyIf' class='name expandable'>applyIf</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> object, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> config</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Copies all the properties of config to object if they don't already exist. ...</div><div class='long'><p>Copies all the properties of config to object if they don't already exist.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>object</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The receiver of the properties</p>\n</div></li><li><span class='pre'>config</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The source of the properties</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>returns obj</p>\n</div></li></ul></div></div></div><div id='method-bind' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Function2.html#Ext-method-bind' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-bind' class='name expandable'>bind</a>( <span class='pre'><a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> fn, [<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope], [<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a> args], [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> appendArgs]</span> ) : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></div><div class='description'><div class='short'>Create a new function from the provided fn, change this to the provided scope, optionally\noverrides arguments for the...</div><div class='long'><p>Create a new function from the provided <code>fn</code>, change <code>this</code> to the provided scope, optionally\noverrides arguments for the call. (Defaults to the arguments passed by the caller)</p>\n\n<p><a href=\"#!/api/Ext-method-bind\" rel=\"Ext-method-bind\" class=\"docClass\">Ext.bind</a> is alias for <a href=\"#!/api/Ext.Function-method-bind\" rel=\"Ext.Function-method-bind\" class=\"docClass\">Ext.Function.bind</a></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The function to delegate.</p>\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>The scope (<code>this</code> reference) in which the function is executed.\n<strong>If omitted, defaults to the browser window.</strong></p>\n</div></li><li><span class='pre'>args</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a> (optional)<div class='sub-desc'><p>Overrides arguments for the call. (Defaults to the arguments passed by the caller)</p>\n</div></li><li><span class='pre'>appendArgs</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>if True args are appended to call args instead of overriding,\nif a number the args are inserted at the specified position</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></span><div class='sub-desc'><p>The new function</p>\n</div></li></ul></div></div></div><div id='method-callback' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-method-callback' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-callback' class='name expandable'>callback</a>( <span class='pre'><a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> callback, [<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope], [<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a> args], [<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> delay]</span> )</div><div class='description'><div class='short'>Execute a callback function in a particular scope. ...</div><div class='long'><p>Execute a callback function in a particular scope. If no function is passed the call is ignored.</p>\n\n<p>For example, these lines are equivalent:</p>\n\n<pre><code>Ext.callback(myFunc, this, [arg1, arg2]);\nExt.isFunction(myFunc) &amp;&amp; myFunc.apply(this, [arg1, arg2]);\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>callback</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The callback to execute</p>\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>The scope to execute in</p>\n</div></li><li><span class='pre'>args</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a> (optional)<div class='sub-desc'><p>The arguments to pass to the function</p>\n</div></li><li><span class='pre'>delay</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>Pass a number to delay the call by a number of milliseconds.</p>\n</div></li></ul></div></div></div><div id='method-clean' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Array3.html#Ext-method-clean' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-clean' class='name expandable'>clean</a>( <span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a> array</span> ) : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><strong class='deprecated-signature'>deprecated</strong></div><div class='description'><div class='short'>Old alias to Ext.Array.clean\n\nFilter through an array and remove empty item as defined in Ext.isEmpty\n\nSee Ext.Array....</div><div class='long'><p>Old alias to <a href=\"#!/api/Ext.Array-method-clean\" rel=\"Ext.Array-method-clean\" class=\"docClass\">Ext.Array.clean</a></p>\n\n<p>Filter through an array and remove empty item as defined in <a href=\"#!/api/Ext-method-isEmpty\" rel=\"Ext-method-isEmpty\" class=\"docClass\">Ext.isEmpty</a></p>\n\n<p>See <a href=\"#!/api/Ext.Array-method-filter\" rel=\"Ext.Array-method-filter\" class=\"docClass\">Ext.Array.filter</a></p>\n<div class='deprecated'><p>This method has been <strong>deprecated</strong> since 4.0.0</p><p>Use <a href=\"#!/api/Ext.Array-method-clean\" rel=\"Ext.Array-method-clean\" class=\"docClass\">Ext.Array.clean</a> instead</p>\n</div><h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>array</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><div class='sub-desc'><p>results</p>\n</div></li></ul></div></div></div><div id='method-clone' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext.html#Ext-method-clone' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-clone' class='name expandable'>clone</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> item</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Clone almost any type of variable including array, object, DOM nodes and Date without keeping the old reference ...</div><div class='long'><p>Clone almost any type of variable including array, object, DOM nodes and Date without keeping the old reference</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>item</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The variable to clone</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>clone</p>\n</div></li></ul></div></div></div><div id='method-copyTo' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-method-copyTo' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-copyTo' class='name expandable'>copyTo</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> dest, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> source, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[] names, [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> usePrototypeKeys]</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Copies a set of named properties fom the source object to the destination object. ...</div><div class='long'><p>Copies a set of named properties fom the source object to the destination object.</p>\n\n<p>Example:</p>\n\n<pre><code>ImageComponent = Ext.extend(Ext.Component, {\n    initComponent: function() {\n        this.autoEl = { tag: 'img' };\n        MyComponent.superclass.initComponent.apply(this, arguments);\n        this.initialBox = Ext.copyTo({}, this.initialConfig, 'x,y,width,height');\n    }\n});\n</code></pre>\n\n<p>Important note: To borrow class prototype methods, use <a href=\"#!/api/Ext.Base-static-method-borrow\" rel=\"Ext.Base-static-method-borrow\" class=\"docClass\">Ext.Base.borrow</a> instead.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>dest</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The destination object.</p>\n</div></li><li><span class='pre'>source</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The source object.</p>\n</div></li><li><span class='pre'>names</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]<div class='sub-desc'><p>Either an Array of property names, or a comma-delimited list\nof property names to copy.</p>\n</div></li><li><span class='pre'>usePrototypeKeys</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>Defaults to false. Pass true to copy keys off of the prototype as well as the instance.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>The modified object.</p>\n</div></li></ul></div></div></div><div id='method-create' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/ClassManager.html#Ext-method-create' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-create' class='name expandable'>create</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> name, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>... args</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Instantiate a class by either full name, alias or alternate name. ...</div><div class='long'><p>Instantiate a class by either full name, alias or alternate name.</p>\n\n<p>If <a href=\"#!/api/Ext.Loader\" rel=\"Ext.Loader\" class=\"docClass\">Ext.Loader</a> is <a href=\"#!/api/Ext.Loader-method-setConfig\" rel=\"Ext.Loader-method-setConfig\" class=\"docClass\">enabled</a> and the class has not been defined yet, it will\nattempt to load the class via synchronous loading.</p>\n\n<p>For example, all these three lines return the same result:</p>\n\n<pre><code>// alias\nvar window = Ext.ClassManager.instantiate('widget.window', { width: 600, height: 800, ... });\n\n// alternate name\nvar window = Ext.ClassManager.instantiate('Ext.Window', { width: 600, height: 800, ... });\n\n// full class name\nvar window = Ext.ClassManager.instantiate('Ext.window.Window', { width: 600, height: 800, ... });\n</code></pre>\n\n<p><a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a> is alias for <a href=\"#!/api/Ext.ClassManager-method-instantiate\" rel=\"Ext.ClassManager-method-instantiate\" class=\"docClass\">Ext.ClassManager.instantiate</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li><li><span class='pre'>args</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>...<div class='sub-desc'><p>Additional arguments after the name will be passed to the class' constructor.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>instance</p>\n</div></li></ul></div></div></div><div id='method-createByAlias' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/ClassManager.html#Ext-method-createByAlias' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-createByAlias' class='name expandable'>createByAlias</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> alias, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>... args</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Instantiate a class by its alias. ...</div><div class='long'><p>Instantiate a class by its alias.</p>\n\n<p>If <a href=\"#!/api/Ext.Loader\" rel=\"Ext.Loader\" class=\"docClass\">Ext.Loader</a> is <a href=\"#!/api/Ext.Loader-method-setConfig\" rel=\"Ext.Loader-method-setConfig\" class=\"docClass\">enabled</a> and the class has not been defined yet, it will\nattempt to load the class via synchronous loading.</p>\n\n<pre><code>var window = Ext.ClassManager.instantiateByAlias('widget.window', { width: 600, height: 800, ... });\n</code></pre>\n\n<p><a href=\"#!/api/Ext-method-createByAlias\" rel=\"Ext-method-createByAlias\" class=\"docClass\">Ext.createByAlias</a> is alias for <a href=\"#!/api/Ext.ClassManager-method-instantiateByAlias\" rel=\"Ext.ClassManager-method-instantiateByAlias\" class=\"docClass\">Ext.ClassManager.instantiateByAlias</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>alias</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li><li><span class='pre'>args</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>...<div class='sub-desc'><p>Additional arguments after the alias will be passed to the\nclass constructor.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>instance</p>\n</div></li></ul></div></div></div><div id='method-createWidget' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/ClassManager.html#Ext-method-createWidget' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-createWidget' class='name expandable'>createWidget</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> name, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>... args</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='deprecated-signature'>deprecated</strong></div><div class='description'><div class='short'>Old name for widget. ...</div><div class='long'><p>Old name for <a href=\"#!/api/Ext-method-widget\" rel=\"Ext-method-widget\" class=\"docClass\">widget</a>.</p>\n\n<p>Convenient shorthand to create a widget by its xtype, also see <a href=\"#!/api/Ext.ClassManager-method-instantiateByAlias\" rel=\"Ext.ClassManager-method-instantiateByAlias\" class=\"docClass\">Ext.ClassManager.instantiateByAlias</a></p>\n\n<pre><code>var button = Ext.widget('button'); // Equivalent to Ext.create('widget.button')\nvar panel = Ext.widget('panel'); // Equivalent to Ext.create('widget.panel')\n</code></pre>\n<div class='deprecated'><p>This method has been <strong>deprecated</strong> since 4.0.0</p><p>Use <a href=\"#!/api/Ext-method-widget\" rel=\"Ext-method-widget\" class=\"docClass\">widget</a> instead.</p>\n</div><h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>xtype of the widget to create.</p>\n\n</div></li><li><span class='pre'>args</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>...<div class='sub-desc'><p>arguments for the widget constructor.</p>\n\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>widget instance</p>\n\n</div></li></ul></div></div></div><div id='method-decode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/JSON3.html#Ext-method-decode' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-decode' class='name expandable'>decode</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> json, [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> safe]</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Shorthand for Ext.JSON.decode\n\nDecodes (parses) a JSON string to an object. ...</div><div class='long'><p>Shorthand for <a href=\"#!/api/Ext.JSON-method-decode\" rel=\"Ext.JSON-method-decode\" class=\"docClass\">Ext.JSON.decode</a></p>\n\n<p>Decodes (parses) a JSON string to an object. If the JSON is invalid, this function throws a SyntaxError unless the safe option is set.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>json</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The JSON string</p>\n</div></li><li><span class='pre'>safe</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>Whether to return null or throw an exception if the JSON is invalid.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>The resulting object</p>\n</div></li></ul></div></div></div><div id='method-defer' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Function2.html#Ext-method-defer' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-defer' class='name expandable'>defer</a>( <span class='pre'><a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> fn, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> millis, [<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope], [<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a> args], [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> appendArgs]</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Calls this function after the number of millseconds specified, optionally in a specific scope. ...</div><div class='long'><p>Calls this function after the number of millseconds specified, optionally in a specific scope. Example usage:</p>\n\n<pre><code>var sayHi = function(name){\n    alert('Hi, ' + name);\n}\n\n// executes immediately:\nsayHi('Fred');\n\n// executes after 2 seconds:\nExt.Function.defer(sayHi, 2000, this, ['Fred']);\n\n// this syntax is sometimes useful for deferring\n// execution of an anonymous function:\nExt.Function.defer(function(){\n    alert('Anonymous');\n}, 100);\n</code></pre>\n\n<p><a href=\"#!/api/Ext-method-defer\" rel=\"Ext-method-defer\" class=\"docClass\">Ext.defer</a> is alias for <a href=\"#!/api/Ext.Function-method-defer\" rel=\"Ext.Function-method-defer\" class=\"docClass\">Ext.Function.defer</a></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The function to defer.</p>\n</div></li><li><span class='pre'>millis</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The number of milliseconds for the setTimeout call\n(if less than or equal to 0 the function is executed immediately)</p>\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>The scope (<code>this</code> reference) in which the function is executed.\n<strong>If omitted, defaults to the browser window.</strong></p>\n</div></li><li><span class='pre'>args</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a> (optional)<div class='sub-desc'><p>Overrides arguments for the call. (Defaults to the arguments passed by the caller)</p>\n</div></li><li><span class='pre'>appendArgs</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a>/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>if True args are appended to call args instead of overriding,\nif a number the args are inserted at the specified position</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>The timeout id that can be used with clearTimeout</p>\n</div></li></ul></div></div></div><div id='method-define' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/ClassManager.html#Ext-method-define' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-define' class='name expandable'>define</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> className, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> data, [<a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> createdFn]</span> ) : <a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a></div><div class='description'><div class='short'>Defines a class. ...</div><div class='long'><p>Defines a class.</p>\n\n<p><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a> and <a href=\"#!/api/Ext.ClassManager-method-create\" rel=\"Ext.ClassManager-method-create\" class=\"docClass\">Ext.ClassManager.create</a> are almost aliases\nof each other, with the only exception that Ext.define allows definition of <a href=\"#!/api/Ext.Class-cfg-override\" rel=\"Ext.Class-cfg-override\" class=\"docClass\">overrides</a>.\nTo avoid trouble, always use Ext.define.</p>\n\n<pre><code>Ext.define('My.awesome.Class', {\n    someProperty: 'something',\n    someMethod: function() { ... }\n    ...\n\n}, function() {\n    alert('Created!');\n    alert(this === My.awesome.Class); // alerts true\n\n    var myInstance = new this();\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>className</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The class name to create in string dot-namespaced format, for example:\n<code>My.very.awesome.Class</code>, <code>FeedViewer.plugin.CoolPager</code>. It is highly recommended to follow this simple convention:</p>\n\n<ul>\n<li>The root and the class name are 'CamelCased'</li>\n<li>Everything else is lower-cased</li>\n</ul>\n\n</div></li><li><span class='pre'>data</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The key-value pairs of properties to apply to this class. Property names can be of any valid\nstrings, except those in the reserved list below:</p>\n\n<ul>\n<li><a href=\"#!/api/Ext.Base-property-self\" rel=\"Ext.Base-property-self\" class=\"docClass\">self</a></li>\n<li><a href=\"#!/api/Ext.Class-cfg-alias\" rel=\"Ext.Class-cfg-alias\" class=\"docClass\">alias</a></li>\n<li><a href=\"#!/api/Ext.Class-cfg-alternateClassName\" rel=\"Ext.Class-cfg-alternateClassName\" class=\"docClass\">alternateClassName</a></li>\n<li><a href=\"#!/api/Ext.Class-cfg-config\" rel=\"Ext.Class-cfg-config\" class=\"docClass\">config</a></li>\n<li><a href=\"#!/api/Ext.Class-cfg-extend\" rel=\"Ext.Class-cfg-extend\" class=\"docClass\">extend</a></li>\n<li><a href=\"#!/api/Ext.Class-cfg-inheritableStatics\" rel=\"Ext.Class-cfg-inheritableStatics\" class=\"docClass\">inheritableStatics</a></li>\n<li><a href=\"#!/api/Ext.Class-cfg-mixins\" rel=\"Ext.Class-cfg-mixins\" class=\"docClass\">mixins</a></li>\n<li><a href=\"#!/api/Ext.Class-cfg-override\" rel=\"Ext.Class-cfg-override\" class=\"docClass\">override</a> (only when using <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>)</li>\n<li><a href=\"#!/api/Ext.Class-cfg-requires\" rel=\"Ext.Class-cfg-requires\" class=\"docClass\">requires</a></li>\n<li><a href=\"#!/api/Ext.Class-cfg-singleton\" rel=\"Ext.Class-cfg-singleton\" class=\"docClass\">singleton</a></li>\n<li><a href=\"#!/api/Ext.Class-cfg-statics\" rel=\"Ext.Class-cfg-statics\" class=\"docClass\">statics</a></li>\n<li><a href=\"#!/api/Ext.Class-cfg-uses\" rel=\"Ext.Class-cfg-uses\" class=\"docClass\">uses</a></li>\n</ul>\n\n</div></li><li><span class='pre'>createdFn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> (optional)<div class='sub-desc'><p>callback to execute after the class is created, the execution scope of which\n(<code>this</code>) will be the newly created class itself.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-destroy' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-method-destroy' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-destroy' class='name expandable'>destroy</a>( <span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>/<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>[]/<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>[]... arg1</span> )</div><div class='description'><div class='short'>Attempts to destroy any objects passed to it by removing all event listeners, removing them from the\nDOM (if applicab...</div><div class='long'><p>Attempts to destroy any objects passed to it by removing all event listeners, removing them from the\nDOM (if applicable) and calling their destroy functions (if available).  This method is primarily\nintended for arguments of type <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> and <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>, but any subclass of\n<a href=\"#!/api/Ext.util.Observable\" rel=\"Ext.util.Observable\" class=\"docClass\">Ext.util.Observable</a> can be passed in.  Any number of elements and/or components can be\npassed into this function in a single call as separate arguments.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>arg1</span> : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>/<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>[]/<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>[]...<div class='sub-desc'><p>An <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>, <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>, or an Array of either of these to destroy</p>\n</div></li></ul></div></div></div><div id='method-destroyMembers' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-method-destroyMembers' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-destroyMembers' class='name expandable'>destroyMembers</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> o, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>... args</span> )</div><div class='description'><div class='short'>Attempts to destroy and then remove a set of named properties of the passed object. ...</div><div class='long'><p>Attempts to destroy and then remove a set of named properties of the passed object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>o</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The object (most likely a Component) who's properties you wish to destroy.</p>\n</div></li><li><span class='pre'>args</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>...<div class='sub-desc'><p>One or more names of the properties to destroy and remove from the object.</p>\n</div></li></ul></div></div></div><div id='method-each' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Array3.html#Ext-method-each' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-each' class='name expandable'>each</a>( <span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/NodeList/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> iterable, <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> fn, [<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope], [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> reverse]</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Iterates an array or an iterable value and invoke the given callback function for each item. ...</div><div class='long'><p>Iterates an array or an iterable value and invoke the given callback function for each item.</p>\n\n<pre><code>var countries = ['Vietnam', 'Singapore', 'United States', 'Russia'];\n\nExt.Array.each(countries, function(name, index, countriesItSelf) {\n    console.log(name);\n});\n\nvar sum = function() {\n    var sum = 0;\n\n    Ext.Array.each(arguments, function(value) {\n        sum += value;\n    });\n\n    return sum;\n};\n\nsum(1, 2, 3); // returns 6\n</code></pre>\n\n<p>The iteration can be stopped by returning false in the function callback.</p>\n\n<pre><code>Ext.Array.each(countries, function(name, index, countriesItSelf) {\n    if (name === 'Singapore') {\n        return false; // break here\n    }\n});\n</code></pre>\n\n<p><a href=\"#!/api/Ext-method-each\" rel=\"Ext-method-each\" class=\"docClass\">Ext.each</a> is alias for <a href=\"#!/api/Ext.Array-method-each\" rel=\"Ext.Array-method-each\" class=\"docClass\">Ext.Array.each</a></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>iterable</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/NodeList/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The value to be iterated. If this\nargument is not iterable, the callback function is called once.</p>\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The callback function. If it returns false, the iteration stops and this method returns\nthe current <code>index</code>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>item</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The item at the current <code>index</code> in the passed <code>array</code></p>\n</div></li><li><span class='pre'>index</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The current <code>index</code> within the <code>array</code></p>\n</div></li><li><span class='pre'>allItems</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>The <code>array</code> itself which was passed as the first argument</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>Return false to stop iteration.</p>\n</div></li></ul></div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>The scope (<code>this</code> reference) in which the specified function is executed.</p>\n</div></li><li><span class='pre'>reverse</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>Reverse the iteration order (loop from the end to the beginning)\nDefaults false</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>See description for the <code>fn</code> parameter.</p>\n</div></li></ul></div></div></div><div id='method-emptyFn' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext.html#Ext-method-emptyFn' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-emptyFn' class='name expandable'>emptyFn</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>A reusable empty function ...</div><div class='long'><p>A reusable empty function</p>\n</div></div></div><div id='method-encode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/JSON3.html#Ext-method-encode' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-encode' class='name expandable'>encode</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> o</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Shorthand for Ext.JSON.encode\n\nEncodes an Object, Array or other value ...</div><div class='long'><p>Shorthand for <a href=\"#!/api/Ext.JSON-method-encode\" rel=\"Ext.JSON-method-encode\" class=\"docClass\">Ext.JSON.encode</a></p>\n\n<p>Encodes an Object, Array or other value</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>o</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The variable to encode</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The JSON string</p>\n</div></li></ul></div></div></div><div id='method-escapeRe' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-method-escapeRe' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-escapeRe' class='name expandable'>escapeRe</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> str</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><strong class='deprecated-signature'>deprecated</strong></div><div class='description'><div class='short'>Escapes the passed string for use in a regular expression ...</div><div class='long'><p>Escapes the passed string for use in a regular expression</p>\n<div class='deprecated'><p>This method has been <strong>deprecated</strong> since 4.0.0</p><p>Use <a href=\"#!/api/Ext.String-method-escapeRegex\" rel=\"Ext.String-method-escapeRegex\" class=\"docClass\">Ext.String.escapeRegex</a> instead</p>\n</div><h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>str</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-exclude' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Loader.html#Ext-method-exclude' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-exclude' class='name expandable'>exclude</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[] excludes</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Explicitly exclude files from being loaded. ...</div><div class='long'><p>Explicitly exclude files from being loaded. Useful when used in conjunction with a broad include expression.\nCan be chained with more <code>require</code> and <code>exclude</code> methods, e.g.:</p>\n\n<pre><code>Ext.exclude('Ext.data.*').require('*');\n\nExt.exclude('widget.button*').require('widget.*');\n</code></pre>\n\n<p><a href=\"#!/api/Ext-method-exclude\" rel=\"Ext-method-exclude\" class=\"docClass\">Ext.exclude</a> is alias for <a href=\"#!/api/Ext.Loader-method-exclude\" rel=\"Ext.Loader-method-exclude\" class=\"docClass\">Ext.Loader.exclude</a> for convenience.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>excludes</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>object contains <code>require</code> method for chaining</p>\n\n</div></li></ul></div></div></div><div id='method-extend' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext.html#Ext-method-extend' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-extend' class='name expandable'>extend</a>( <span class='pre'><a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> superclass, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> overrides</span> ) : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><strong class='deprecated-signature'>deprecated</strong></div><div class='description'><div class='short'>This method deprecated. ...</div><div class='long'><p>This method deprecated. Use <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a> instead.</p>\n<div class='deprecated'><p>This method has been <strong>deprecated</strong> since 4.0.0</p><p>Use <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a> instead</p>\n</div><h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superclass</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'>\n</div></li><li><span class='pre'>overrides</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></span><div class='sub-desc'><p>The subclass constructor from the <tt>overrides</tt> parameter, or a generated one if not provided.</p>\n</div></li></ul></div></div></div><div id='method-flatten' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Array3.html#Ext-method-flatten' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-flatten' class='name expandable'>flatten</a>( <span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a> array</span> ) : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><strong class='deprecated-signature'>deprecated</strong></div><div class='description'><div class='short'>Old alias to Ext.Array.flatten\n\nRecursively flattens into 1-d Array. ...</div><div class='long'><p>Old alias to <a href=\"#!/api/Ext.Array-method-flatten\" rel=\"Ext.Array-method-flatten\" class=\"docClass\">Ext.Array.flatten</a></p>\n\n<p>Recursively flattens into 1-d Array. Injects Arrays inline.</p>\n<div class='deprecated'><p>This method has been <strong>deprecated</strong> since 4.0.0</p><p>Use <a href=\"#!/api/Ext.Array-method-flatten\" rel=\"Ext.Array-method-flatten\" class=\"docClass\">Ext.Array.flatten</a> instead</p>\n</div><h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>array</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>The array to flatten</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><div class='sub-desc'><p>The 1-d array.</p>\n</div></li></ul></div></div></div><div id='method-fly' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Element2.html#Ext-method-fly' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-fly' class='name expandable'>fly</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement el, [<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> named]</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Gets the globally shared flyweight Element, with the passed node as the active element. ...</div><div class='long'><p>Gets the globally shared flyweight Element, with the passed node as the active element. Do not store a reference\nto this element - the dom node can be overwritten by other code. <a href=\"#!/api/Ext-method-fly\" rel=\"Ext-method-fly\" class=\"docClass\">fly</a> is alias for\n<a href=\"#!/api/Ext.Element-static-method-fly\" rel=\"Ext.Element-static-method-fly\" class=\"docClass\">Ext.Element.fly</a>.</p>\n\n<p>Use this to make one-time references to DOM elements which are not going to be accessed again either by\napplication code, or by Ext's classes. If accessing an element which will be processed regularly, then <a href=\"#!/api/Ext-method-get\" rel=\"Ext-method-get\" class=\"docClass\">Ext.get</a> will be more appropriate to take advantage of the caching provided by the <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>\nclass.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement<div class='sub-desc'><p>The dom node or id</p>\n</div></li><li><span class='pre'>named</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>Allows for creation of named reusable flyweights to prevent conflicts (e.g.\ninternally Ext uses \"_global\")</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The shared Element object (or null if no matching element was found)</p>\n</div></li></ul></div></div></div><div id='method-get' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Element2.html#Ext-method-get' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-get' class='name expandable'>get</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> el</span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Retrieves Ext.Element objects. ...</div><div class='long'><p>Retrieves <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> objects. <a href=\"#!/api/Ext-method-get\" rel=\"Ext-method-get\" class=\"docClass\">get</a> is an alias for <a href=\"#!/api/Ext.Element-static-method-get\" rel=\"Ext.Element-static-method-get\" class=\"docClass\">Ext.Element.get</a>.</p>\n\n<p><strong>This method does not retrieve <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Component</a>s.</strong> This method retrieves <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>\nobjects which encapsulate DOM elements. To retrieve a Component by its ID, use <a href=\"#!/api/Ext.ComponentManager-method-get\" rel=\"Ext.ComponentManager-method-get\" class=\"docClass\">Ext.ComponentManager.get</a>.</p>\n\n<p>Uses simple caching to consistently return the same object. Automatically fixes if an object was recreated with\nthe same id via AJAX or DOM.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><div class='sub-desc'><p>The id of the node, a DOM Node or an existing Element.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The Element object (or null if no matching element was found)</p>\n</div></li></ul></div></div></div><div id='method-getBody' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-method-getBody' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-getBody' class='name expandable'>getBody</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Returns the current document body as an Ext.Element. ...</div><div class='long'><p>Returns the current document body as an <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>.</p>\n</div></div></div><div id='method-getClass' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/ClassManager.html#Ext-method-getClass' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-getClass' class='name expandable'>getClass</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> object</span> ) : <a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a></div><div class='description'><div class='short'>Get the class of the provided object; returns null if it's not an instance\nof any class created with Ext.define. ...</div><div class='long'><p>Get the class of the provided object; returns null if it's not an instance\nof any class created with Ext.define.</p>\n\n<pre><code>var component = new Ext.Component();\n\nExt.ClassManager.getClass(component); // returns <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>\n</code></pre>\n\n<p><a href=\"#!/api/Ext-method-getClass\" rel=\"Ext-method-getClass\" class=\"docClass\">Ext.getClass</a> is alias for <a href=\"#!/api/Ext.ClassManager-method-getClass\" rel=\"Ext.ClassManager-method-getClass\" class=\"docClass\">Ext.ClassManager.getClass</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>object</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a></span><div class='sub-desc'><p>class</p>\n</div></li></ul></div></div></div><div id='method-getClassName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/ClassManager.html#Ext-method-getClassName' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-getClassName' class='name expandable'>getClassName</a>( <span class='pre'><a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> object</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Get the name of the class by its reference or its instance. ...</div><div class='long'><p>Get the name of the class by its reference or its instance.</p>\n\n<pre><code>Ext.ClassManager.getName(Ext.Action); // returns \"Ext.Action\"\n</code></pre>\n\n<p><a href=\"#!/api/Ext-method-getClassName\" rel=\"Ext-method-getClassName\" class=\"docClass\">Ext.getClassName</a> is alias for <a href=\"#!/api/Ext.ClassManager-method-getName\" rel=\"Ext.ClassManager-method-getName\" class=\"docClass\">Ext.ClassManager.getName</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>object</span> : <a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>className</p>\n</div></li></ul></div></div></div><div id='method-getCmp' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-method-getCmp' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-getCmp' class='name expandable'>getCmp</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> id</span> )</div><div class='description'><div class='short'>This is shorthand reference to Ext.ComponentManager.get. ...</div><div class='long'><p>This is shorthand reference to <a href=\"#!/api/Ext.ComponentManager-method-get\" rel=\"Ext.ComponentManager-method-get\" class=\"docClass\">Ext.ComponentManager.get</a>.\nLooks up an existing <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Component</a> by <a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>id</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The component <a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a></p>\n</div></li></ul></div></div></div><div id='method-getDoc' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-method-getDoc' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-getDoc' class='name expandable'>getDoc</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Returns the current HTML document object as an Ext.Element. ...</div><div class='long'><p>Returns the current HTML document object as an <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>.</p>\n</div></div></div><div id='method-getDom' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-method-getDom' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-getDom' class='name expandable'>getDom</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> el</span> )</div><div class='description'><div class='short'>Return the dom node for the passed String (id), dom node, or Ext.Element. ...</div><div class='long'><p>Return the dom node for the passed String (id), dom node, or <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>.\nOptional 'strict' flag is needed for IE since it can return 'name' and\n'id' elements by using getElementById.\nHere are some examples:</p>\n\n<pre><code>// gets dom node based on id\nvar elDom = Ext.getDom('elId');\n// gets dom node based on the dom node\nvar elDom1 = Ext.getDom(elDom);\n\n// If we don&#39;t know if we are working with an\n// <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> or a dom node use Ext.getDom\nfunction(el){\n    var dom = Ext.getDom(el);\n    // do something with the dom node\n}\n</code></pre>\n\n\n<p><b>Note</b>: the dom node to be found actually needs to exist (be rendered, etc)\nwhen this method is called to be successful.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getHead' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-method-getHead' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-getHead' class='name expandable'>getHead</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Returns the current document head as an Ext.Element. ...</div><div class='long'><p>Returns the current document head as an <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a>.</p>\n</div></div></div><div id='method-getOrientation' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-method-getOrientation' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-getOrientation' class='name expandable'>getOrientation</a>( <span class='pre'></span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Returns the current orientation of the mobile device ...</div><div class='long'><p>Returns the current orientation of the mobile device</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>Either 'portrait' or 'landscape'</p>\n</div></li></ul></div></div></div><div id='method-getScrollBarWidth' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-method-getScrollBarWidth' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-getScrollBarWidth' class='name expandable'>getScrollBarWidth</a>( <span class='pre'>[<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> force]</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><strong class='deprecated-signature'>deprecated</strong></div><div class='description'><div class='short'>Utility method for getting the width of the browser's vertical scrollbar. ...</div><div class='long'><p>Utility method for getting the width of the browser's vertical scrollbar. This\ncan differ depending on operating system settings, such as the theme or font size.</p>\n\n<p>This method is deprected in favor of <a href=\"#!/api/Ext-method-getScrollbarSize\" rel=\"Ext-method-getScrollbarSize\" class=\"docClass\">getScrollbarSize</a>.</p>\n<div class='deprecated'><p>This method has been <strong>deprecated</strong> </p>\n</div><h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>force</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>true to force a recalculation of the value.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>The width of a vertical scrollbar.</p>\n</div></li></ul></div></div></div><div id='method-getScrollbarSize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-method-getScrollbarSize' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-getScrollbarSize' class='name expandable'>getScrollbarSize</a>( <span class='pre'>[<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> force]</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Returns the size of the browser scrollbars. ...</div><div class='long'><p>Returns the size of the browser scrollbars. This can differ depending on\noperating system settings, such as the theme or font size.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>force</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>true to force a recalculation of the value.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>An object containing the width of a vertical scrollbar and the\nheight of a horizontal scrollbar.</p>\n</div></li></ul></div></div></div><div id='method-getStore' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/StoreManager.html#Ext-method-getStore' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-getStore' class='name expandable'>getStore</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> store</span> ) : <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a></div><div class='description'><div class='short'>Shortcut to Ext.data.StoreManager.lookup. ...</div><div class='long'><p>Shortcut to <a href=\"#!/api/Ext.data.StoreManager-method-lookup\" rel=\"Ext.data.StoreManager-method-lookup\" class=\"docClass\">Ext.data.StoreManager.lookup</a>.</p>\n\n<p>Gets a registered Store by id</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>store</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The id of the Store, or a Store instance, or a store configuration</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-htmlDecode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-method-htmlDecode' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-htmlDecode' class='name expandable'>htmlDecode</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> value</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Convert certain characters (&amp;, &lt;, >, and ') from their HTML character equivalents. ...</div><div class='long'><p>Convert certain characters (&amp;, &lt;, >, and ') from their HTML character equivalents.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The string to decode</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The decoded text</p>\n</div></li></ul></div></div></div><div id='method-htmlEncode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-method-htmlEncode' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-htmlEncode' class='name expandable'>htmlEncode</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> value</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Convert certain characters (&amp;, &lt;, >, and ') to their HTML character equivalents for literal display in web pages. ...</div><div class='long'><p>Convert certain characters (&amp;, &lt;, >, and ') to their HTML character equivalents for literal display in web pages.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The string to encode</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The encoded text</p>\n</div></li></ul></div></div></div><div id='method-id' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-method-id' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-id' class='name expandable'>id</a>( <span class='pre'>[HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> el], [<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> prefix]</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Generates unique ids. ...</div><div class='long'><p>Generates unique ids. If the element already has an id, it is unchanged</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> (optional)<div class='sub-desc'><p>The element to generate an id for</p>\n</div></li><li><span class='pre'>prefix</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>Id prefix (defaults \"ext-gen\")</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The generated Id.</p>\n</div></li></ul></div></div></div><div id='method-invoke' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-method-invoke' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-invoke' class='name expandable'>invoke</a>( <span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/NodeList arr, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> methodName, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>... args</span> ) : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><strong class='deprecated-signature'>deprecated</strong></div><div class='description'><div class='short'>Invokes a method on each item in an Array. ...</div><div class='long'><p>Invokes a method on each item in an Array.</p>\n\n<pre><code>// Example:\nExt.invoke(Ext.query(\"p\"), \"getAttribute\", \"id\");\n// [el1.getAttribute(\"id\"), el2.getAttribute(\"id\"), ..., elN.getAttribute(\"id\")]\n</code></pre>\n\n<div class='deprecated'><p>This method has been <strong>deprecated</strong> since 4.0.0</p><p>Will be removed in the next major version</p>\n</div><h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>arr</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/NodeList<div class='sub-desc'><p>The Array of items to invoke the method on.</p>\n</div></li><li><span class='pre'>methodName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The method name to invoke.</p>\n</div></li><li><span class='pre'>args</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>...<div class='sub-desc'><p>Arguments to send into the method invocation.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><div class='sub-desc'><p>The results of invoking the method on each item in the array.</p>\n</div></li></ul></div></div></div><div id='method-isArray' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext.html#Ext-method-isArray' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-isArray' class='name expandable'>isArray</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> target</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Returns true if the passed value is a JavaScript Array, false otherwise. ...</div><div class='long'><p>Returns true if the passed value is a JavaScript Array, false otherwise.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>target</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The target to test</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isBoolean' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext.html#Ext-method-isBoolean' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-isBoolean' class='name expandable'>isBoolean</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> value</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Returns true if the passed value is a boolean. ...</div><div class='long'><p>Returns true if the passed value is a boolean.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The value to test</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isDate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext.html#Ext-method-isDate' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-isDate' class='name expandable'>isDate</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> object</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Returns true if the passed value is a JavaScript Date object, false otherwise. ...</div><div class='long'><p>Returns true if the passed value is a JavaScript Date object, false otherwise.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>object</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The object to test</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isDefined' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext.html#Ext-method-isDefined' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-isDefined' class='name expandable'>isDefined</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> value</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Returns true if the passed value is defined. ...</div><div class='long'><p>Returns true if the passed value is defined.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The value to test</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isElement' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext.html#Ext-method-isElement' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-isElement' class='name expandable'>isElement</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> value</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Returns true if the passed value is an HTMLElement ...</div><div class='long'><p>Returns true if the passed value is an HTMLElement</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The value to test</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isEmpty' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext.html#Ext-method-isEmpty' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-isEmpty' class='name expandable'>isEmpty</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> value, [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> allowEmptyString]</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Returns true if the passed value is empty, false otherwise. ...</div><div class='long'><p>Returns true if the passed value is empty, false otherwise. The value is deemed to be empty if it is either:</p>\n\n<ul>\n<li><code>null</code></li>\n<li><code>undefined</code></li>\n<li>a zero-length array</li>\n<li>a zero-length string (Unless the <code>allowEmptyString</code> parameter is set to <code>true</code>)</li>\n</ul>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The value to test</p>\n</div></li><li><span class='pre'>allowEmptyString</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>true to allow empty strings (defaults to false)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isFunction' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext.html#Ext-method-isFunction' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-isFunction' class='name expandable'>isFunction</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> value</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Returns true if the passed value is a JavaScript Function, false otherwise. ...</div><div class='long'><p>Returns true if the passed value is a JavaScript Function, false otherwise.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The value to test</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isIterable' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext.html#Ext-method-isIterable' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-isIterable' class='name expandable'>isIterable</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> value</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Returns true if the passed value is iterable, false otherwise ...</div><div class='long'><p>Returns true if the passed value is iterable, false otherwise</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The value to test</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isNumber' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext.html#Ext-method-isNumber' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-isNumber' class='name expandable'>isNumber</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> value</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Returns true if the passed value is a number. ...</div><div class='long'><p>Returns true if the passed value is a number. Returns false for non-finite numbers.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The value to test</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isNumeric' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext.html#Ext-method-isNumeric' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-isNumeric' class='name expandable'>isNumeric</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> value</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Validates that a value is numeric. ...</div><div class='long'><p>Validates that a value is numeric.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>Examples: 1, '1', '2.34'</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>True if numeric, false otherwise</p>\n</div></li></ul></div></div></div><div id='method-isObject' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext.html#Ext-method-isObject' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-isObject' class='name expandable'>isObject</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> value</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Returns true if the passed value is a JavaScript Object, false otherwise. ...</div><div class='long'><p>Returns true if the passed value is a JavaScript Object, false otherwise.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The value to test</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isPrimitive' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext.html#Ext-method-isPrimitive' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-isPrimitive' class='name expandable'>isPrimitive</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> value</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Returns true if the passed value is a JavaScript 'primitive', a string, number or boolean. ...</div><div class='long'><p>Returns true if the passed value is a JavaScript 'primitive', a string, number or boolean.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The value to test</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isString' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext.html#Ext-method-isString' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-isString' class='name expandable'>isString</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> value</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Returns true if the passed value is a string. ...</div><div class='long'><p>Returns true if the passed value is a string.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The value to test</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isTextNode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext.html#Ext-method-isTextNode' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-isTextNode' class='name expandable'>isTextNode</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> value</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Returns true if the passed value is a TextNode ...</div><div class='long'><p>Returns true if the passed value is a TextNode</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The value to test</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-iterate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext.html#Ext-method-iterate' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-iterate' class='name expandable'>iterate</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a> object, <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> fn, [<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope]</span> )</div><div class='description'><div class='short'>Iterates either an array or an object. ...</div><div class='long'><p>Iterates either an array or an object. This method delegates to\n<a href=\"#!/api/Ext.Array-method-each\" rel=\"Ext.Array-method-each\" class=\"docClass\">Ext.Array.each</a> if the given value is iterable, and <a href=\"#!/api/Ext.Object-method-each\" rel=\"Ext.Object-method-each\" class=\"docClass\">Ext.Object.each</a> otherwise.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>object</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>The object or array to be iterated.</p>\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The function to be called for each iteration. See and <a href=\"#!/api/Ext.Array-method-each\" rel=\"Ext.Array-method-each\" class=\"docClass\">Ext.Array.each</a> and\n<a href=\"#!/api/Ext.Object-method-each\" rel=\"Ext.Object-method-each\" class=\"docClass\">Ext.Object.each</a> for detailed lists of arguments passed to this function depending on the given object\ntype that is being iterated.</p>\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>The scope (<code>this</code> reference) in which the specified function is executed.\nDefaults to the object being iterated itself.</p>\n</div></li></ul></div></div></div><div id='method-max' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Array3.html#Ext-method-max' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-max' class='name expandable'>max</a>( <span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/NodeList array, [<a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> comparisonFn]</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='deprecated-signature'>deprecated</strong></div><div class='description'><div class='short'>Old alias to Ext.Array.max\n\nReturns the maximum value in the Array. ...</div><div class='long'><p>Old alias to <a href=\"#!/api/Ext.Array-method-max\" rel=\"Ext.Array-method-max\" class=\"docClass\">Ext.Array.max</a></p>\n\n<p>Returns the maximum value in the Array.</p>\n<div class='deprecated'><p>This method has been <strong>deprecated</strong> since 4.0.0</p><p>Use <a href=\"#!/api/Ext.Array-method-max\" rel=\"Ext.Array-method-max\" class=\"docClass\">Ext.Array.max</a> instead</p>\n</div><h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>array</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/NodeList<div class='sub-desc'><p>The Array from which to select the maximum value.</p>\n</div></li><li><span class='pre'>comparisonFn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> (optional)<div class='sub-desc'><p>a function to perform the comparision which determines maximization.\nIf omitted the \">\" operator will be used. Note: gt = 1; eq = 0; lt = -1</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>maxValue The maximum value</p>\n</div></li></ul></div></div></div><div id='method-mean' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Array3.html#Ext-method-mean' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-mean' class='name expandable'>mean</a>( <span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a> array</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><strong class='deprecated-signature'>deprecated</strong></div><div class='description'><div class='short'>Old alias to Ext.Array.mean\n\nCalculates the mean of all items in the array. ...</div><div class='long'><p>Old alias to <a href=\"#!/api/Ext.Array-method-mean\" rel=\"Ext.Array-method-mean\" class=\"docClass\">Ext.Array.mean</a></p>\n\n<p>Calculates the mean of all items in the array.</p>\n<div class='deprecated'><p>This method has been <strong>deprecated</strong> since 4.0.0</p><p>Use <a href=\"#!/api/Ext.Array-method-mean\" rel=\"Ext.Array-method-mean\" class=\"docClass\">Ext.Array.mean</a> instead</p>\n</div><h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>array</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>The Array to calculate the mean value of.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>The mean.</p>\n</div></li></ul></div></div></div><div id='method-merge' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Object2.html#Ext-method-merge' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-merge' class='name expandable'>merge</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>... object</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>A convenient alias method for Ext.Object.merge. ...</div><div class='long'><p>A convenient alias method for <a href=\"#!/api/Ext.Object-method-merge\" rel=\"Ext.Object-method-merge\" class=\"docClass\">Ext.Object.merge</a>.</p>\n\n<p>Merges any number of objects recursively without referencing them or their children.</p>\n\n<pre><code>var extjs = {\n    companyName: 'Ext JS',\n    products: ['Ext JS', 'Ext GWT', 'Ext Designer'],\n    isSuperCool: true\n    office: {\n        size: 2000,\n        location: 'Palo Alto',\n        isFun: true\n    }\n};\n\nvar newStuff = {\n    companyName: 'Sencha Inc.',\n    products: ['Ext JS', 'Ext GWT', 'Ext Designer', 'Sencha Touch', 'Sencha Animator'],\n    office: {\n        size: 40000,\n        location: 'Redwood City'\n    }\n};\n\nvar sencha = Ext.Object.merge(extjs, newStuff);\n\n// extjs and sencha then equals to\n{\n    companyName: 'Sencha Inc.',\n    products: ['Ext JS', 'Ext GWT', 'Ext Designer', 'Sencha Touch', 'Sencha Animator'],\n    isSuperCool: true\n    office: {\n        size: 30000,\n        location: 'Redwood City'\n        isFun: true\n    }\n}\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>object</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>...<div class='sub-desc'><p>Any number of objects to merge.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>merged The object that is created as a result of merging all the objects passed in.</p>\n</div></li></ul></div></div></div><div id='method-min' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Array3.html#Ext-method-min' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-min' class='name expandable'>min</a>( <span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/NodeList array, [<a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> comparisonFn]</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='deprecated-signature'>deprecated</strong></div><div class='description'><div class='short'>Old alias to Ext.Array.min\n\nReturns the minimum value in the Array. ...</div><div class='long'><p>Old alias to <a href=\"#!/api/Ext.Array-method-min\" rel=\"Ext.Array-method-min\" class=\"docClass\">Ext.Array.min</a></p>\n\n<p>Returns the minimum value in the Array.</p>\n<div class='deprecated'><p>This method has been <strong>deprecated</strong> since 4.0.0</p><p>Use <a href=\"#!/api/Ext.Array-method-min\" rel=\"Ext.Array-method-min\" class=\"docClass\">Ext.Array.min</a> instead</p>\n</div><h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>array</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/NodeList<div class='sub-desc'><p>The Array from which to select the minimum value.</p>\n</div></li><li><span class='pre'>comparisonFn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> (optional)<div class='sub-desc'><p>a function to perform the comparision which determines minimization.\nIf omitted the \"&lt;\" operator will be used. Note: gt = 1; eq = 0; lt = -1</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>minValue The minimum value</p>\n</div></li></ul></div></div></div><div id='method-namespace' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/ClassManager.html#Ext-method-namespace' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-namespace' class='name expandable'>namespace</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> namespace1, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> namespace2, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> etc</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Creates namespaces to be used for scoping variables and classes so that they are not global. ...</div><div class='long'><p>Creates namespaces to be used for scoping variables and classes so that they are not global.\nSpecifying the last node of a namespace implicitly creates all other nodes. Usage:</p>\n\n<pre><code>Ext.namespace('Company', 'Company.data');\n\n// equivalent and preferable to the above syntax\nExt.namespace('Company.data');\n\nCompany.Widget = function() { ... };\n\nCompany.data.CustomStore = function(config) { ... };\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>namespace1</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li><li><span class='pre'>namespace2</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li><li><span class='pre'>etc</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>The namespace object. (If multiple arguments are passed, this will be the last namespace created)</p>\n\n</div></li></ul></div></div></div><div id='method-ns' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/ClassManager.html#Ext-method-ns' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-ns' class='name expandable'>ns</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> namespace1, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> namespace2, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> etc</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Convenient alias for Ext.namespace\n\nCreates namespaces to be used for scoping variables and classes so that they are ...</div><div class='long'><p>Convenient alias for <a href=\"#!/api/Ext-method-namespace\" rel=\"Ext-method-namespace\" class=\"docClass\">Ext.namespace</a></p>\n\n<p>Creates namespaces to be used for scoping variables and classes so that they are not global.\nSpecifying the last node of a namespace implicitly creates all other nodes. Usage:</p>\n\n<pre><code>Ext.namespace('Company', 'Company.data');\n\n// equivalent and preferable to the above syntax\nExt.namespace('Company.data');\n\nCompany.Widget = function() { ... };\n\nCompany.data.CustomStore = function(config) { ... };\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>namespace1</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li><li><span class='pre'>namespace2</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li><li><span class='pre'>etc</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>The namespace object. (If multiple arguments are passed, this will be the last namespace created)</p>\n\n</div></li></ul></div></div></div><div id='method-num' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Number4.html#Ext-method-num' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-num' class='name expandable'>num</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> value, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> defaultValue</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><strong class='deprecated-signature'>deprecated</strong></div><div class='description'><div class='short'>Validate that a value is numeric and convert it to a number if necessary. ...</div><div class='long'><p>Validate that a value is numeric and convert it to a number if necessary. Returns the specified default value if\nit is not.</p>\n\n<p>Ext.Number.from('1.23', 1); // returns 1.23\nExt.Number.from('abc', 1); // returns 1</p>\n<div class='deprecated'><p>This method has been <strong>deprecated</strong> since 4.0.0</p><p>Please use <a href=\"#!/api/Ext.Number-method-from\" rel=\"Ext.Number-method-from\" class=\"docClass\">Ext.Number.from</a> instead.</p>\n</div><h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>defaultValue</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The value to return if the original value is non-numeric</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>value, if numeric, defaultValue otherwise</p>\n</div></li></ul></div></div></div><div id='method-onDocumentReady' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/EventManager.html#Ext-method-onDocumentReady' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-onDocumentReady' class='name expandable'>onDocumentReady</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Alias for Ext.EventManager.onDocumentReady ...</div><div class='long'><p>Alias for <a href=\"#!/api/Ext.EventManager-method-onDocumentReady\" rel=\"Ext.EventManager-method-onDocumentReady\" class=\"docClass\">Ext.EventManager.onDocumentReady</a></p>\n</div></div></div><div id='method-onReady' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/EventManager.html#Ext-method-onReady' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-onReady' class='name expandable'>onReady</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> fn, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> options</span> )</div><div class='description'><div class='short'>Alias for Ext.Loader.onReady with withDomReady set to true ...</div><div class='long'><p>Alias for <a href=\"#!/api/Ext.Loader-method-onReady\" rel=\"Ext.Loader-method-onReady\" class=\"docClass\">Ext.Loader.onReady</a> with withDomReady set to true</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fn</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>options</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-override' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext.html#Ext-method-override' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-override' class='name expandable'>override</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> cls, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> overrides</span> )</div><div class='description'><div class='short'>Proxy to Ext.Base.override. ...</div><div class='long'><p>Proxy to <a href=\"#!/api/Ext.Base-static-method-override\" rel=\"Ext.Base-static-method-override\" class=\"docClass\">Ext.Base.override</a>. Please refer <a href=\"#!/api/Ext.Base-static-method-override\" rel=\"Ext.Base-static-method-override\" class=\"docClass\">Ext.Base.override</a> for further details.</p>\n\n<pre><code>Ext.define('My.cool.Class', {\n    sayHi: function() {\n        alert('Hi!');\n    }\n}\n\nExt.override(My.cool.Class, {\n    sayHi: function() {\n        alert('About to say...');\n\n        this.callOverridden();\n    }\n});\n\nvar cool = new My.cool.Class();\ncool.sayHi(); // alerts 'About to say...'\n              // alerts 'Hi!'\n</code></pre>\n\n<p>Please note that <code>this.callOverridden()</code> only works if the class was previously\ncreated with {@link Ext#define)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cls</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The class to override</p>\n</div></li><li><span class='pre'>overrides</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The list of functions to add to origClass. This should be specified as an object literal\ncontaining one or more methods.</p>\n</div></li></ul></div></div></div><div id='method-partition' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-method-partition' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-partition' class='name expandable'>partition</a>( <span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/NodeList arr, [<a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> truth]</span> ) : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><strong class='deprecated-signature'>deprecated</strong></div><div class='description'><div class='short'>Partitions the set into two sets: a true set and a false set. ...</div><div class='long'><p>Partitions the set into two sets: a true set and a false set.\nExample:\nExample2:</p>\n\n<pre><code>// Example 1:\nExt.partition([true, false, true, true, false]); // [[true, true, true], [false, false]]\n\n// Example 2:\nExt.partition(\n    Ext.query(\"p\"),\n    function(val){\n        return val.className == \"class1\"\n    }\n);\n// true are those paragraph elements with a className of \"class1\",\n// false set are those that do not have that className.\n</code></pre>\n\n<div class='deprecated'><p>This method has been <strong>deprecated</strong> since 4.0.0</p><p>Will be removed in the next major version</p>\n</div><h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>arr</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/NodeList<div class='sub-desc'><p>The array to partition</p>\n</div></li><li><span class='pre'>truth</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> (optional)<div class='sub-desc'><p>a function to determine truth.  If this is omitted the element\nitself must be able to be evaluated for its truthfulness.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><div class='sub-desc'><p>[array of truish values, array of falsy values]</p>\n</div></li></ul></div></div></div><div id='method-pass' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Function2.html#Ext-method-pass' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-pass' class='name expandable'>pass</a>( <span class='pre'><a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> fn, <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a> args, [<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope]</span> ) : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></div><div class='description'><div class='short'>Create a new function from the provided fn, the arguments of which are pre-set to args. ...</div><div class='long'><p>Create a new function from the provided <code>fn</code>, the arguments of which are pre-set to <code>args</code>.\nNew arguments passed to the newly created callback when it's invoked are appended after the pre-set ones.\nThis is especially useful when creating callbacks.</p>\n\n<p>For example:</p>\n\n<pre><code>var originalFunction = function(){\n    alert(Ext.Array.from(arguments).join(' '));\n};\n\nvar callback = Ext.Function.pass(originalFunction, ['Hello', 'World']);\n\ncallback(); // alerts 'Hello World'\ncallback('by Me'); // alerts 'Hello World by Me'\n</code></pre>\n\n<p><a href=\"#!/api/Ext-method-pass\" rel=\"Ext-method-pass\" class=\"docClass\">Ext.pass</a> is alias for <a href=\"#!/api/Ext.Function-method-pass\" rel=\"Ext.Function-method-pass\" class=\"docClass\">Ext.Function.pass</a></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The original function</p>\n</div></li><li><span class='pre'>args</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>The arguments to pass to new callback</p>\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>The scope (<code>this</code> reference) in which the function is executed.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></span><div class='sub-desc'><p>The new callback function</p>\n</div></li></ul></div></div></div><div id='method-pluck' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Array3.html#Ext-method-pluck' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-pluck' class='name expandable'>pluck</a>( <span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/NodeList array, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> propertyName</span> ) : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><strong class='deprecated-signature'>deprecated</strong></div><div class='description'><div class='short'>Old alias to Ext.Array.pluck\n\nPlucks the value of a property from each item in the Array. ...</div><div class='long'><p>Old alias to <a href=\"#!/api/Ext.Array-method-pluck\" rel=\"Ext.Array-method-pluck\" class=\"docClass\">Ext.Array.pluck</a></p>\n\n<p>Plucks the value of a property from each item in the Array. Example:</p>\n\n<pre><code>Ext.Array.pluck(Ext.query(\"p\"), \"className\"); // [el1.className, el2.className, ..., elN.className]\n</code></pre>\n<div class='deprecated'><p>This method has been <strong>deprecated</strong> since 4.0.0</p><p>Use <a href=\"#!/api/Ext.Array-method-pluck\" rel=\"Ext.Array-method-pluck\" class=\"docClass\">Ext.Array.pluck</a> instead</p>\n</div><h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>array</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/NodeList<div class='sub-desc'><p>The Array of items to pluck the value from.</p>\n</div></li><li><span class='pre'>propertyName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The property name to pluck from each element.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><div class='sub-desc'><p>The value from each item in the Array.</p>\n</div></li></ul></div></div></div><div id='method-preg' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/PluginManager.html#Ext-method-preg' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-preg' class='name expandable'>preg</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> ptype, <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> cls</span> )</div><div class='description'><div class='short'>Shorthand for Ext.PluginManager.registerType ...</div><div class='long'><p>Shorthand for <a href=\"#!/api/Ext.PluginManager-method-registerType\" rel=\"Ext.PluginManager-method-registerType\" class=\"docClass\">Ext.PluginManager.registerType</a></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>ptype</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The ptype mnemonic string by which the Plugin class\nmay be looked up.</p>\n</div></li><li><span class='pre'>cls</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The new Plugin class.</p>\n</div></li></ul></div></div></div><div id='method-query' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/DomQuery.html#Ext-method-query' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-query' class='name expandable'>query</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> path, [HTMLElement root]</span> ) : HTMLElement[]</div><div class='description'><div class='short'>Shorthand of Ext.DomQuery.select\n\nSelects an array of DOM nodes by CSS/XPath selector. ...</div><div class='long'><p>Shorthand of <a href=\"#!/api/Ext.DomQuery-method-select\" rel=\"Ext.DomQuery-method-select\" class=\"docClass\">Ext.DomQuery.select</a></p>\n\n<p>Selects an array of DOM nodes by CSS/XPath selector.</p>\n\n<p>Uses <a href=\"https://developer.mozilla.org/en/DOM/document.querySelectorAll\">document.querySelectorAll</a> if browser supports that, otherwise falls back to\n<a href=\"#!/api/Ext.DomQuery-method-jsSelect\" rel=\"Ext.DomQuery-method-jsSelect\" class=\"docClass\">Ext.DomQuery.jsSelect</a> to do the work.</p>\n\n<p>Aliased as <a href=\"#!/api/Ext-method-query\" rel=\"Ext-method-query\" class=\"docClass\">query</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>path</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The selector/xpath query</p>\n</div></li><li><span class='pre'>root</span> : HTMLElement (optional)<div class='sub-desc'><p>The start of the query (defaults to document).</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>HTMLElement[]</span><div class='sub-desc'><p>An array of DOM elements (not a NodeList as returned by <code>querySelectorAll</code>).\nEmpty array when no matches.</p>\n</div></li></ul></div></div></div><div id='method-regModel' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/ModelManager.html#Ext-method-regModel' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-regModel' class='name expandable'>regModel</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> name, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> config</span> ) : <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a><strong class='deprecated-signature'>deprecated</strong></div><div class='description'><div class='short'>Old way for creating Model classes. ...</div><div class='long'><p>Old way for creating Model classes.  Instead use:</p>\n\n<pre><code>Ext.define(\"MyModel\", {\n    extend: \"Ext.data.Model\",\n    fields: []\n});\n</code></pre>\n<div class='deprecated'><p>This method has been <strong>deprecated</strong> since 4.0.0</p><p>Use <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">define</a> instead.</p>\n</div><h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>Name of the Model class.</p>\n</div></li><li><span class='pre'>config</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>A configuration object for the Model you wish to create.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a></span><div class='sub-desc'><p>The newly registered Model</p>\n</div></li></ul></div></div></div><div id='method-regStore' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/StoreManager.html#Ext-method-regStore' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-regStore' class='name expandable'>regStore</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> id, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> config</span> )</div><div class='description'><div class='short'>Creates a new store for the given id and config, then registers it with the Store Mananger. ...</div><div class='long'><p>Creates a new store for the given id and config, then registers it with the <a href=\"#!/api/Ext.data.StoreManager\" rel=\"Ext.data.StoreManager\" class=\"docClass\">Store Mananger</a>.\nSample usage:</p>\n\n<pre><code>Ext.regStore('AllUsers', {\n    model: 'User'\n});\n\n// the store can now easily be used throughout the application\nnew Ext.List({\n    store: 'AllUsers',\n    ... other config\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>id</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The id to set on the new store</p>\n</div></li><li><span class='pre'>config</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The store config</p>\n</div></li></ul></div></div></div><div id='method-removeNode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-method-removeNode' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-removeNode' class='name expandable'>removeNode</a>( <span class='pre'>HTMLElement node</span> )</div><div class='description'><div class='short'>Removes a DOM node from the document. ...</div><div class='long'><p>Removes a DOM node from the document.</p>\n\n<p>Removes this element from the document, removes all DOM event listeners, and deletes the cache reference.\nAll DOM event listeners are removed from this element. If <a href=\"#!/api/Ext-property-enableNestedListenerRemoval\" rel=\"Ext-property-enableNestedListenerRemoval\" class=\"docClass\">Ext.enableNestedListenerRemoval</a> is\n<code>true</code>, then DOM event listeners are also removed from all child nodes. The body node\nwill be ignored if passed in.</p>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>node</span> : HTMLElement<div class='sub-desc'><p>The node to remove</p>\n</div></li></ul></div></div></div><div id='method-require' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Loader.html#Ext-method-require' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-require' class='name expandable'>require</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[] expressions, [<a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> fn], [<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope], [<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[] excludes]</span> )</div><div class='description'><div class='short'>Loads all classes by the given names and all their direct dependencies;\noptionally executes the given callback functi...</div><div class='long'><p>Loads all classes by the given names and all their direct dependencies;\noptionally executes the given callback function when finishes, within the optional scope.</p>\n\n<p><a href=\"#!/api/Ext-method-require\" rel=\"Ext-method-require\" class=\"docClass\">Ext.require</a> is alias for <a href=\"#!/api/Ext.Loader-method-require\" rel=\"Ext.Loader-method-require\" class=\"docClass\">Ext.Loader.require</a> for convenience.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>expressions</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]<div class='sub-desc'><p>Can either be a string or an array of string</p>\n\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> (optional)<div class='sub-desc'><p>The callback function</p>\n\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>The execution scope (<code>this</code>) of the callback function</p>\n\n</div></li><li><span class='pre'>excludes</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[] (optional)<div class='sub-desc'><p>Classes to be excluded, useful when being used with expressions</p>\n\n</div></li></ul></div></div></div><div id='method-select' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/CompositeElementLite.html#Ext-method-select' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-select' class='name expandable'>select</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement[] selector, [HTMLElement/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> root]</span> ) : <a href=\"#!/api/Ext.CompositeElementLite\" rel=\"Ext.CompositeElementLite\" class=\"docClass\">Ext.CompositeElementLite</a>/<a href=\"#!/api/Ext.CompositeElement\" rel=\"Ext.CompositeElement\" class=\"docClass\">Ext.CompositeElement</a></div><div class='description'><div class='short'>Selects elements based on the passed CSS selector to enable Element methods\nto be applied to many related elements in...</div><div class='long'><p>Selects elements based on the passed CSS selector to enable <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Element</a> methods\nto be applied to many related elements in one statement through the returned <a href=\"#!/api/Ext.CompositeElement\" rel=\"Ext.CompositeElement\" class=\"docClass\">CompositeElement</a> or\n<a href=\"#!/api/Ext.CompositeElementLite\" rel=\"Ext.CompositeElementLite\" class=\"docClass\">CompositeElementLite</a> object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>selector</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement[]<div class='sub-desc'><p>The CSS selector or an array of elements</p>\n</div></li><li><span class='pre'>root</span> : HTMLElement/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>The root element of the query or id of the root</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.CompositeElementLite\" rel=\"Ext.CompositeElementLite\" class=\"docClass\">Ext.CompositeElementLite</a>/<a href=\"#!/api/Ext.CompositeElement\" rel=\"Ext.CompositeElement\" class=\"docClass\">Ext.CompositeElement</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-sum' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Array3.html#Ext-method-sum' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-sum' class='name expandable'>sum</a>( <span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a> array</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><strong class='deprecated-signature'>deprecated</strong></div><div class='description'><div class='short'>Old alias to Ext.Array.sum\n\nCalculates the sum of all items in the given array. ...</div><div class='long'><p>Old alias to <a href=\"#!/api/Ext.Array-method-sum\" rel=\"Ext.Array-method-sum\" class=\"docClass\">Ext.Array.sum</a></p>\n\n<p>Calculates the sum of all items in the given array.</p>\n<div class='deprecated'><p>This method has been <strong>deprecated</strong> since 4.0.0</p><p>Use <a href=\"#!/api/Ext.Array-method-sum\" rel=\"Ext.Array-method-sum\" class=\"docClass\">Ext.Array.sum</a> instead</p>\n</div><h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>array</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>The Array to calculate the sum value of.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>The sum.</p>\n</div></li></ul></div></div></div><div id='method-syncRequire' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Loader.html#Ext-method-syncRequire' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-syncRequire' class='name expandable'>syncRequire</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[] expressions, [<a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> fn], [<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope], [<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[] excludes]</span> )</div><div class='description'><div class='short'>Synchronously loads all classes by the given names and all their direct dependencies;\noptionally executes the given c...</div><div class='long'><p>Synchronously loads all classes by the given names and all their direct dependencies;\noptionally executes the given callback function when finishes, within the optional scope.</p>\n\n<p><a href=\"#!/api/Ext-method-syncRequire\" rel=\"Ext-method-syncRequire\" class=\"docClass\">Ext.syncRequire</a> is alias for <a href=\"#!/api/Ext.Loader-method-syncRequire\" rel=\"Ext.Loader-method-syncRequire\" class=\"docClass\">Ext.Loader.syncRequire</a> for convenience.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>expressions</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]<div class='sub-desc'><p>Can either be a string or an array of string</p>\n\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> (optional)<div class='sub-desc'><p>The callback function</p>\n\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>The execution scope (<code>this</code>) of the callback function</p>\n\n</div></li><li><span class='pre'>excludes</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[] (optional)<div class='sub-desc'><p>Classes to be excluded, useful when being used with expressions</p>\n\n</div></li></ul></div></div></div><div id='method-toArray' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Array3.html#Ext-method-toArray' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-toArray' class='name expandable'>toArray</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> iterable, [<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> start], [<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> end]</span> ) : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></div><div class='description'><div class='short'>Converts any iterable (numeric indices and a length property) into a true array. ...</div><div class='long'><p>Converts any iterable (numeric indices and a length property) into a true array.</p>\n\n<pre><code>function test() {\n    var args = Ext.Array.toArray(arguments),\n        fromSecondToLastArgs = Ext.Array.toArray(arguments, 1);\n\n    alert(args.join(' '));\n    alert(fromSecondToLastArgs.join(' '));\n}\n\ntest('just', 'testing', 'here'); // alerts 'just testing here';\n                                 // alerts 'testing here';\n\nExt.Array.toArray(document.getElementsByTagName('div')); // will convert the NodeList into an array\nExt.Array.toArray('splitted'); // returns ['s', 'p', 'l', 'i', 't', 't', 'e', 'd']\nExt.Array.toArray('splitted', 0, 3); // returns ['s', 'p', 'l', 'i']\n</code></pre>\n\n<p><a href=\"#!/api/Ext-method-toArray\" rel=\"Ext-method-toArray\" class=\"docClass\">Ext.toArray</a> is alias for <a href=\"#!/api/Ext.Array-method-toArray\" rel=\"Ext.Array-method-toArray\" class=\"docClass\">Ext.Array.toArray</a></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>iterable</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>the iterable object to be turned into a true Array.</p>\n</div></li><li><span class='pre'>start</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>a zero-based index that specifies the start of extraction. Defaults to 0</p>\n</div></li><li><span class='pre'>end</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>a zero-based index that specifies the end of extraction. Defaults to the last\nindex of the iterable value</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><div class='sub-desc'><p>array</p>\n</div></li></ul></div></div></div><div id='method-toSentence' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-method-toSentence' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-toSentence' class='name expandable'>toSentence</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[] items, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> connector</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><strong class='deprecated-signature'>deprecated</strong></div><div class='description'><div class='short'>Turns an array into a sentence, joined by a specified connector - e.g.:\nExt.toSentence(['Adama', 'Tigh', 'Roslin']); ...</div><div class='long'><p>Turns an array into a sentence, joined by a specified connector - e.g.:\nExt.toSentence(['Adama', 'Tigh', 'Roslin']); //'Adama, Tigh and Roslin'\nExt.toSentence(['Adama', 'Tigh', 'Roslin'], 'or'); //'Adama, Tigh or Roslin'</p>\n<div class='deprecated'><p>This method has been <strong>deprecated</strong> since 4.0.0</p><p>Will be removed in the next major version</p>\n</div><h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>items</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]<div class='sub-desc'><p>The array to create a sentence from</p>\n</div></li><li><span class='pre'>connector</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The string to use to connect the last two words. Usually 'and' or 'or' - defaults to 'and'.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The sentence string</p>\n</div></li></ul></div></div></div><div id='method-type' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext.html#Ext-method-type' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-type' class='name expandable'>type</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> value</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><strong class='deprecated-signature'>deprecated</strong></div><div class='description'><div class='short'>Old alias to typeOf\n\nReturns the type of the given variable in string format. ...</div><div class='long'><p>Old alias to <a href=\"#!/api/Ext-method-typeOf\" rel=\"Ext-method-typeOf\" class=\"docClass\">typeOf</a></p>\n\n<p>Returns the type of the given variable in string format. List of possible values are:</p>\n\n<ul>\n<li><code>undefined</code>: If the given value is <code>undefined</code></li>\n<li><code>null</code>: If the given value is <code>null</code></li>\n<li><code>string</code>: If the given value is a string</li>\n<li><code>number</code>: If the given value is a number</li>\n<li><code>boolean</code>: If the given value is a boolean value</li>\n<li><code>date</code>: If the given value is a <code>Date</code> object</li>\n<li><code>function</code>: If the given value is a function reference</li>\n<li><code>object</code>: If the given value is an object</li>\n<li><code>array</code>: If the given value is an array</li>\n<li><code>regexp</code>: If the given value is a regular expression</li>\n<li><code>element</code>: If the given value is a DOM Element</li>\n<li><code>textnode</code>: If the given value is a DOM text node and contains something other than whitespace</li>\n<li><code>whitespace</code>: If the given value is a DOM text node and contains only whitespace</li>\n</ul>\n\n<div class='deprecated'><p>This method has been <strong>deprecated</strong> since 4.0.0</p><p>Use <a href=\"#!/api/Ext-method-typeOf\" rel=\"Ext-method-typeOf\" class=\"docClass\">typeOf</a> instead</p>\n</div><h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-typeOf' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext.html#Ext-method-typeOf' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-typeOf' class='name expandable'>typeOf</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> value</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Returns the type of the given variable in string format. ...</div><div class='long'><p>Returns the type of the given variable in string format. List of possible values are:</p>\n\n<ul>\n<li><code>undefined</code>: If the given value is <code>undefined</code></li>\n<li><code>null</code>: If the given value is <code>null</code></li>\n<li><code>string</code>: If the given value is a string</li>\n<li><code>number</code>: If the given value is a number</li>\n<li><code>boolean</code>: If the given value is a boolean value</li>\n<li><code>date</code>: If the given value is a <code>Date</code> object</li>\n<li><code>function</code>: If the given value is a function reference</li>\n<li><code>object</code>: If the given value is an object</li>\n<li><code>array</code>: If the given value is an array</li>\n<li><code>regexp</code>: If the given value is a regular expression</li>\n<li><code>element</code>: If the given value is a DOM Element</li>\n<li><code>textnode</code>: If the given value is a DOM text node and contains something other than whitespace</li>\n<li><code>whitespace</code>: If the given value is a DOM text node and contains only whitespace</li>\n</ul>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-unique' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Array3.html#Ext-method-unique' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-unique' class='name expandable'>unique</a>( <span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a> array</span> ) : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><strong class='deprecated-signature'>deprecated</strong></div><div class='description'><div class='short'>Old alias to Ext.Array.unique\n\nReturns a new array with unique items ...</div><div class='long'><p>Old alias to <a href=\"#!/api/Ext.Array-method-unique\" rel=\"Ext.Array-method-unique\" class=\"docClass\">Ext.Array.unique</a></p>\n\n<p>Returns a new array with unique items</p>\n<div class='deprecated'><p>This method has been <strong>deprecated</strong> since 4.0.0</p><p>Use <a href=\"#!/api/Ext.Array-method-unique\" rel=\"Ext.Array-method-unique\" class=\"docClass\">Ext.Array.unique</a> instead</p>\n</div><h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>array</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><div class='sub-desc'><p>results</p>\n</div></li></ul></div></div></div><div id='method-urlAppend' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-method-urlAppend' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-urlAppend' class='name expandable'>urlAppend</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> url, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> s</span> )</div><div class='description'><div class='short'>Appends content to the query string of a URL, handling logic for whether to place\na question mark or ampersand. ...</div><div class='long'><p>Appends content to the query string of a URL, handling logic for whether to place\na question mark or ampersand.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>url</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The URL to append to.</p>\n</div></li><li><span class='pre'>s</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The content to append to the URL.</p>\n</div></li></ul></div></div></div><div id='method-urlDecode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Object2.html#Ext-method-urlDecode' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-urlDecode' class='name expandable'>urlDecode</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> queryString, [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> recursive]</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='deprecated-signature'>deprecated</strong></div><div class='description'><div class='short'>Alias for Ext.Object.fromQueryString. ...</div><div class='long'><p>Alias for <a href=\"#!/api/Ext.Object-method-fromQueryString\" rel=\"Ext.Object-method-fromQueryString\" class=\"docClass\">Ext.Object.fromQueryString</a>.</p>\n\n<p>Converts a query string back into an object.</p>\n\n<p>Non-recursive:</p>\n\n<pre><code>Ext.Object.fromQueryString(foo=1&amp;bar=2); // returns {foo: 1, bar: 2}\nExt.Object.fromQueryString(foo=&amp;bar=2); // returns {foo: null, bar: 2}\nExt.Object.fromQueryString(some%20price=%24300); // returns {'some price': '$300'}\nExt.Object.fromQueryString(colors=red&amp;colors=green&amp;colors=blue); // returns {colors: ['red', 'green', 'blue']}\n</code></pre>\n\n<p>Recursive:</p>\n\n<pre><code>  Ext.Object.fromQueryString(\"username=Jacky&amp;dateOfBirth[day]=1&amp;dateOfBirth[month]=2&amp;dateOfBirth[year]=1911&amp;hobbies[0]=coding&amp;hobbies[1]=eating&amp;hobbies[2]=sleeping&amp;hobbies[3][0]=nested&amp;hobbies[3][1]=stuff\", true);\n// returns\n{\n    username: 'Jacky',\n    dateOfBirth: {\n        day: '1',\n        month: '2',\n        year: '1911'\n    },\n    hobbies: ['coding', 'eating', 'sleeping', ['nested', 'stuff']]\n}\n</code></pre>\n<div class='deprecated'><p>This method has been <strong>deprecated</strong> since 4.0.0</p><p>Use <a href=\"#!/api/Ext.Object-method-fromQueryString\" rel=\"Ext.Object-method-fromQueryString\" class=\"docClass\">Ext.Object.fromQueryString</a> instead</p>\n</div><h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>queryString</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The query string to decode</p>\n</div></li><li><span class='pre'>recursive</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>Whether or not to recursively decode the string. This format is supported by\nPHP / Ruby on Rails servers and similar.</p>\n<p>Defaults to: <code>false</code></p></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-urlEncode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Object2.html#Ext-method-urlEncode' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-urlEncode' class='name expandable'>urlEncode</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> object, [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> recursive]</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><strong class='deprecated-signature'>deprecated</strong></div><div class='description'><div class='short'>Alias for Ext.Object.toQueryString. ...</div><div class='long'><p>Alias for <a href=\"#!/api/Ext.Object-method-toQueryString\" rel=\"Ext.Object-method-toQueryString\" class=\"docClass\">Ext.Object.toQueryString</a>.</p>\n\n<p>Takes an object and converts it to an encoded query string.</p>\n\n<p>Non-recursive:</p>\n\n<pre><code>Ext.Object.toQueryString({foo: 1, bar: 2}); // returns \"foo=1&amp;bar=2\"\nExt.Object.toQueryString({foo: null, bar: 2}); // returns \"foo=&amp;bar=2\"\nExt.Object.toQueryString({'some price': '$300'}); // returns \"some%20price=%24300\"\nExt.Object.toQueryString({date: new Date(2011, 0, 1)}); // returns \"date=%222011-01-01T00%3A00%3A00%22\"\nExt.Object.toQueryString({colors: ['red', 'green', 'blue']}); // returns \"colors=red&amp;colors=green&amp;colors=blue\"\n</code></pre>\n\n<p>Recursive:</p>\n\n<pre><code>Ext.Object.toQueryString({\n    username: 'Jacky',\n    dateOfBirth: {\n        day: 1,\n        month: 2,\n        year: 1911\n    },\n    hobbies: ['coding', 'eating', 'sleeping', ['nested', 'stuff']]\n}, true); // returns the following string (broken down and url-decoded for ease of reading purpose):\n// username=Jacky\n//    &amp;dateOfBirth[day]=1&amp;dateOfBirth[month]=2&amp;dateOfBirth[year]=1911\n//    &amp;hobbies[0]=coding&amp;hobbies[1]=eating&amp;hobbies[2]=sleeping&amp;hobbies[3][0]=nested&amp;hobbies[3][1]=stuff\n</code></pre>\n<div class='deprecated'><p>This method has been <strong>deprecated</strong> since 4.0.0</p><p>Use <a href=\"#!/api/Ext.Object-method-toQueryString\" rel=\"Ext.Object-method-toQueryString\" class=\"docClass\">Ext.Object.toQueryString</a> instead</p>\n</div><h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>object</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The object to encode</p>\n</div></li><li><span class='pre'>recursive</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>Whether or not to interpret the object in recursive format.\n(PHP / Ruby on Rails servers and similar).</p>\n<p>Defaults to: <code>false</code></p></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>queryString</p>\n</div></li></ul></div></div></div><div id='method-value' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-method-value' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-value' class='name expandable'>value</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> value, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> defaultValue, [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> allowBlank]</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='deprecated-signature'>deprecated</strong></div><div class='description'><div class='short'>Utility method for returning a default value if the passed value is empty. ...</div><div class='long'><p>Utility method for returning a default value if the passed value is empty.</p>\n\n\n<p>The value is deemed to be empty if it is<div class=\"mdetail-params\"><ul>\n<li>null</li>\n<li>undefined</li>\n<li>an empty array</li>\n<li>a zero length string (Unless the <tt>allowBlank</tt> parameter is <tt>true</tt>)</li>\n</ul></div>\n\n<div class='deprecated'><p>This method has been <strong>deprecated</strong> since 4.0.0</p><p>Use <a href=\"#!/api/Ext-method-valueFrom\" rel=\"Ext-method-valueFrom\" class=\"docClass\">valueFrom</a> instead</p>\n</div><h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The value to test</p>\n</div></li><li><span class='pre'>defaultValue</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The value to return if the original value is empty</p>\n</div></li><li><span class='pre'>allowBlank</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>true to allow zero length strings to qualify as non-empty (defaults to false)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>value, if non-empty, else defaultValue</p>\n</div></li></ul></div></div></div><div id='method-valueFrom' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext.html#Ext-method-valueFrom' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-valueFrom' class='name expandable'>valueFrom</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> value, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> defaultValue, [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> allowBlank]</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Returns the given value itself if it's not empty, as described in isEmpty; returns the default\nvalue (second argument...</div><div class='long'><p>Returns the given value itself if it's not empty, as described in <a href=\"#!/api/Ext-method-isEmpty\" rel=\"Ext-method-isEmpty\" class=\"docClass\">isEmpty</a>; returns the default\nvalue (second argument) otherwise.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The value to test</p>\n</div></li><li><span class='pre'>defaultValue</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The value to return if the original value is empty</p>\n</div></li><li><span class='pre'>allowBlank</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>true to allow zero length strings to qualify as non-empty (defaults to false)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>value, if non-empty, else defaultValue</p>\n</div></li></ul></div></div></div><div id='method-widget' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/ClassManager.html#Ext-method-widget' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-widget' class='name expandable'>widget</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> name, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>... args</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Convenient shorthand to create a widget by its xtype, also see Ext.ClassManager.instantiateByAlias\n\nvar button = Ext....</div><div class='long'><p>Convenient shorthand to create a widget by its xtype, also see <a href=\"#!/api/Ext.ClassManager-method-instantiateByAlias\" rel=\"Ext.ClassManager-method-instantiateByAlias\" class=\"docClass\">Ext.ClassManager.instantiateByAlias</a></p>\n\n<pre><code>var button = Ext.widget('button'); // Equivalent to Ext.create('widget.button')\nvar panel = Ext.widget('panel'); // Equivalent to Ext.create('widget.panel')\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>xtype of the widget to create.</p>\n\n</div></li><li><span class='pre'>args</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>...<div class='sub-desc'><p>arguments for the widget constructor.</p>\n\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>widget instance</p>\n\n</div></li></ul></div></div></div><div id='method-zip' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext' rel='Ext' class='definedIn docClass'>Ext</a><br/><a href='source/Ext-more.html#Ext-method-zip' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext-method-zip' class='name expandable'>zip</a>( <span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/NodeList... arr, [<a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> zipper]</span> ) : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><strong class='deprecated-signature'>deprecated</strong></div><div class='description'><div class='short'>Zips N sets together. ...</div><div class='long'><p>Zips N sets together.</p>\n\n\n<pre><code>// Example 1:\nExt.zip([1,2,3],[4,5,6]); // [[1,4],[2,5],[3,6]]\n// Example 2:\nExt.zip(\n    [ \"+\", \"-\", \"+\"],\n    [  12,  10,  22],\n    [  43,  15,  96],\n    function(a, b, c){\n        return \"$\" + a + \"\" + b + \".\" + c\n    }\n); // [\"$+12.43\", \"$-10.15\", \"$+22.96\"]\n</code></pre>\n\n<div class='deprecated'><p>This method has been <strong>deprecated</strong> since 4.0.0</p><p>Will be removed in the next major version</p>\n</div><h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>arr</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/NodeList...<div class='sub-desc'><p>This argument may be repeated. Array(s) to contribute values.</p>\n</div></li><li><span class='pre'>zipper</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> (optional)<div class='sub-desc'><p>The last item in the argument list. This will drive how the items are zipped together.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><div class='sub-desc'><p>The zipped set.</p>\n</div></li></ul></div></div></div></div></div></div></div>","allMixins":[],"meta":{},"requires":[],"deprecated":null,"extends":null,"inheritable":false,"static":false,"superclasses":[],"singleton":true,"code_type":"assignment","alias":null,"statics":{"property":[],"css_var":[],"css_mixin":[],"cfg":[],"method":[],"event":[]},"subclasses":[],"uses":[],"protected":false,"mixins":[],"members":{"property":[{"tagname":"property","deprecated":null,"static":false,"owner":"Ext","template":null,"required":null,"protected":false,"name":"BLANK_IMAGE_URL","id":"property-BLANK_IMAGE_URL"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext","template":null,"required":null,"protected":false,"name":"SSL_SECURE_URL","id":"property-SSL_SECURE_URL"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext","template":null,"required":null,"protected":false,"name":"USE_NATIVE_JSON","id":"property-USE_NATIVE_JSON"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext","template":null,"required":null,"protected":false,"name":"browser","id":"property-browser"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext","template":null,"required":null,"protected":false,"name":"chromeVersion","id":"property-chromeVersion"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext","template":null,"required":null,"protected":false,"name":"enableFx","id":"property-enableFx"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext","template":null,"required":null,"protected":false,"name":"enableGarbageCollector","id":"property-enableGarbageCollector"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext","template":null,"required":null,"protected":false,"name":"enableListenerCollection","id":"property-enableListenerCollection"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext","template":null,"required":null,"protected":false,"name":"enableNestedListenerRemoval","id":"property-enableNestedListenerRemoval"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext","template":null,"required":null,"protected":false,"name":"enumerables","id":"property-enumerables"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext","template":null,"required":null,"protected":false,"name":"features","id":"property-features"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext","template":null,"required":null,"protected":false,"name":"firefoxVersion","id":"property-firefoxVersion"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext","template":null,"required":null,"protected":false,"name":"ieVersion","id":"property-ieVersion"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext","template":null,"required":null,"protected":false,"name":"isChrome","id":"property-isChrome"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext","template":null,"required":null,"protected":false,"name":"isFF3_0","id":"property-isFF3_0"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext","template":null,"required":null,"protected":false,"name":"isFF3_5","id":"property-isFF3_5"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext","template":null,"required":null,"protected":false,"name":"isFF3_6","id":"property-isFF3_6"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext","template":null,"required":null,"protected":false,"name":"isFF4","id":"property-isFF4"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext","template":null,"required":null,"protected":false,"name":"isFF5","id":"property-isFF5"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext","template":null,"required":null,"protected":false,"name":"isGecko","id":"property-isGecko"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext","template":null,"required":null,"protected":false,"name":"isGecko3","id":"property-isGecko3"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext","template":null,"required":null,"protected":false,"name":"isGecko4","id":"property-isGecko4"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext","template":null,"required":null,"protected":false,"name":"isGecko5","id":"property-isGecko5"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext","template":null,"required":null,"protected":false,"name":"isIE","id":"property-isIE"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext","template":null,"required":null,"protected":false,"name":"isIE6","id":"property-isIE6"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext","template":null,"required":null,"protected":false,"name":"isIE7","id":"property-isIE7"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext","template":null,"required":null,"protected":false,"name":"isIE8","id":"property-isIE8"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext","template":null,"required":null,"protected":false,"name":"isIE9","id":"property-isIE9"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext","template":null,"required":null,"protected":false,"name":"isLinux","id":"property-isLinux"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext","template":null,"required":null,"protected":false,"name":"isMac","id":"property-isMac"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext","template":null,"required":null,"protected":false,"name":"isOpera","id":"property-isOpera"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext","template":null,"required":null,"protected":false,"name":"isOpera10_5","id":"property-isOpera10_5"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext","template":null,"required":null,"protected":false,"name":"isReady","id":"property-isReady"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext","template":null,"required":null,"protected":false,"name":"isSafari","id":"property-isSafari"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext","template":null,"required":null,"protected":false,"name":"isSafari2","id":"property-isSafari2"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext","template":null,"required":null,"protected":false,"name":"isSafari3","id":"property-isSafari3"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext","template":null,"required":null,"protected":false,"name":"isSafari4","id":"property-isSafari4"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext","template":null,"required":null,"protected":false,"name":"isSafari5","id":"property-isSafari5"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext","template":null,"required":null,"protected":false,"name":"isSecure","id":"property-isSecure"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext","template":null,"required":null,"protected":false,"name":"isWebKit","id":"property-isWebKit"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext","template":null,"required":null,"protected":false,"name":"isWindows","id":"property-isWindows"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext","template":null,"required":null,"protected":false,"name":"log","id":"property-log"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext","template":null,"required":null,"protected":false,"name":"operaVersion","id":"property-operaVersion"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext","template":null,"required":null,"protected":false,"name":"os","id":"property-os"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext","template":null,"required":null,"protected":false,"name":"safariVersion","id":"property-safariVersion"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext","template":null,"required":null,"protected":false,"name":"scopeResetCSS","id":"property-scopeResetCSS"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext","template":null,"required":null,"protected":false,"name":"useShims","id":"property-useShims"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext","template":null,"required":null,"protected":false,"name":"webKitVersion","id":"property-webKitVersion"}],"css_var":[],"css_mixin":[],"cfg":[],"method":[{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"addBehaviors","id":"method-addBehaviors"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"application","id":"method-application"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"apply","id":"method-apply"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"applyIf","id":"method-applyIf"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"bind","id":"method-bind"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"callback","id":"method-callback"},{"tagname":"method","deprecated":{"doc":null,"tagname":"deprecated","text":"<p>Use <a href=\"#!/api/Ext.Array-method-clean\" rel=\"Ext.Array-method-clean\" class=\"docClass\">Ext.Array.clean</a> instead</p>\n","version":"4.0.0"},"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"clean","id":"method-clean"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"clone","id":"method-clone"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"copyTo","id":"method-copyTo"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"create","id":"method-create"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"createByAlias","id":"method-createByAlias"},{"tagname":"method","deprecated":{"doc":null,"tagname":"deprecated","text":"<p>Use <a href=\"#!/api/Ext-method-widget\" rel=\"Ext-method-widget\" class=\"docClass\">widget</a> instead.</p>\n","version":"4.0.0"},"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"createWidget","id":"method-createWidget"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"decode","id":"method-decode"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"defer","id":"method-defer"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"define","id":"method-define"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"destroy","id":"method-destroy"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"destroyMembers","id":"method-destroyMembers"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"each","id":"method-each"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"emptyFn","id":"method-emptyFn"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"encode","id":"method-encode"},{"tagname":"method","deprecated":{"doc":null,"tagname":"deprecated","text":"<p>Use <a href=\"#!/api/Ext.String-method-escapeRegex\" rel=\"Ext.String-method-escapeRegex\" class=\"docClass\">Ext.String.escapeRegex</a> instead</p>\n","version":"4.0.0"},"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"escapeRe","id":"method-escapeRe"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"exclude","id":"method-exclude"},{"tagname":"method","deprecated":{"doc":null,"tagname":"deprecated","text":"<p>Use <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a> instead</p>\n","version":"4.0.0"},"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"extend","id":"method-extend"},{"tagname":"method","deprecated":{"doc":null,"tagname":"deprecated","text":"<p>Use <a href=\"#!/api/Ext.Array-method-flatten\" rel=\"Ext.Array-method-flatten\" class=\"docClass\">Ext.Array.flatten</a> instead</p>\n","version":"4.0.0"},"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"flatten","id":"method-flatten"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"fly","id":"method-fly"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"get","id":"method-get"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"getBody","id":"method-getBody"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"getClass","id":"method-getClass"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"getClassName","id":"method-getClassName"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"getCmp","id":"method-getCmp"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"getDoc","id":"method-getDoc"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"getDom","id":"method-getDom"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"getHead","id":"method-getHead"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"getOrientation","id":"method-getOrientation"},{"tagname":"method","deprecated":{"doc":null,"tagname":"deprecated","text":"\n","version":null},"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"getScrollBarWidth","id":"method-getScrollBarWidth"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"getScrollbarSize","id":"method-getScrollbarSize"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"getStore","id":"method-getStore"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"htmlDecode","id":"method-htmlDecode"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"htmlEncode","id":"method-htmlEncode"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"id","id":"method-id"},{"tagname":"method","deprecated":{"doc":null,"tagname":"deprecated","text":"<p>Will be removed in the next major version</p>\n","version":"4.0.0"},"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"invoke","id":"method-invoke"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"isArray","id":"method-isArray"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"isBoolean","id":"method-isBoolean"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"isDate","id":"method-isDate"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"isDefined","id":"method-isDefined"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"isElement","id":"method-isElement"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"isEmpty","id":"method-isEmpty"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"isFunction","id":"method-isFunction"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"isIterable","id":"method-isIterable"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"isNumber","id":"method-isNumber"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"isNumeric","id":"method-isNumeric"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"isObject","id":"method-isObject"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"isPrimitive","id":"method-isPrimitive"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"isString","id":"method-isString"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"isTextNode","id":"method-isTextNode"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"iterate","id":"method-iterate"},{"tagname":"method","deprecated":{"doc":null,"tagname":"deprecated","text":"<p>Use <a href=\"#!/api/Ext.Array-method-max\" rel=\"Ext.Array-method-max\" class=\"docClass\">Ext.Array.max</a> instead</p>\n","version":"4.0.0"},"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"max","id":"method-max"},{"tagname":"method","deprecated":{"doc":null,"tagname":"deprecated","text":"<p>Use <a href=\"#!/api/Ext.Array-method-mean\" rel=\"Ext.Array-method-mean\" class=\"docClass\">Ext.Array.mean</a> instead</p>\n","version":"4.0.0"},"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"mean","id":"method-mean"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"merge","id":"method-merge"},{"tagname":"method","deprecated":{"doc":null,"tagname":"deprecated","text":"<p>Use <a href=\"#!/api/Ext.Array-method-min\" rel=\"Ext.Array-method-min\" class=\"docClass\">Ext.Array.min</a> instead</p>\n","version":"4.0.0"},"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"min","id":"method-min"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"namespace","id":"method-namespace"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"ns","id":"method-ns"},{"tagname":"method","deprecated":{"doc":null,"tagname":"deprecated","text":"<p>Please use <a href=\"#!/api/Ext.Number-method-from\" rel=\"Ext.Number-method-from\" class=\"docClass\">Ext.Number.from</a> instead.</p>\n","version":"4.0.0"},"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"num","id":"method-num"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"onDocumentReady","id":"method-onDocumentReady"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"onReady","id":"method-onReady"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"override","id":"method-override"},{"tagname":"method","deprecated":{"doc":null,"tagname":"deprecated","text":"<p>Will be removed in the next major version</p>\n","version":"4.0.0"},"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"partition","id":"method-partition"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"pass","id":"method-pass"},{"tagname":"method","deprecated":{"doc":null,"tagname":"deprecated","text":"<p>Use <a href=\"#!/api/Ext.Array-method-pluck\" rel=\"Ext.Array-method-pluck\" class=\"docClass\">Ext.Array.pluck</a> instead</p>\n","version":"4.0.0"},"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"pluck","id":"method-pluck"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"preg","id":"method-preg"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"query","id":"method-query"},{"tagname":"method","deprecated":{"doc":null,"tagname":"deprecated","text":"<p>Use <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">define</a> instead.</p>\n","version":"4.0.0"},"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"regModel","id":"method-regModel"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"regStore","id":"method-regStore"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"removeNode","id":"method-removeNode"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"require","id":"method-require"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"select","id":"method-select"},{"tagname":"method","deprecated":{"doc":null,"tagname":"deprecated","text":"<p>Use <a href=\"#!/api/Ext.Array-method-sum\" rel=\"Ext.Array-method-sum\" class=\"docClass\">Ext.Array.sum</a> instead</p>\n","version":"4.0.0"},"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"sum","id":"method-sum"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"syncRequire","id":"method-syncRequire"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"toArray","id":"method-toArray"},{"tagname":"method","deprecated":{"doc":null,"tagname":"deprecated","text":"<p>Will be removed in the next major version</p>\n","version":"4.0.0"},"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"toSentence","id":"method-toSentence"},{"tagname":"method","deprecated":{"doc":null,"tagname":"deprecated","text":"<p>Use <a href=\"#!/api/Ext-method-typeOf\" rel=\"Ext-method-typeOf\" class=\"docClass\">typeOf</a> instead</p>\n","version":"4.0.0"},"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"type","id":"method-type"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"typeOf","id":"method-typeOf"},{"tagname":"method","deprecated":{"doc":null,"tagname":"deprecated","text":"<p>Use <a href=\"#!/api/Ext.Array-method-unique\" rel=\"Ext.Array-method-unique\" class=\"docClass\">Ext.Array.unique</a> instead</p>\n","version":"4.0.0"},"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"unique","id":"method-unique"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"urlAppend","id":"method-urlAppend"},{"tagname":"method","deprecated":{"doc":null,"tagname":"deprecated","text":"<p>Use <a href=\"#!/api/Ext.Object-method-fromQueryString\" rel=\"Ext.Object-method-fromQueryString\" class=\"docClass\">Ext.Object.fromQueryString</a> instead</p>\n","version":"4.0.0"},"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"urlDecode","id":"method-urlDecode"},{"tagname":"method","deprecated":{"doc":null,"tagname":"deprecated","text":"<p>Use <a href=\"#!/api/Ext.Object-method-toQueryString\" rel=\"Ext.Object-method-toQueryString\" class=\"docClass\">Ext.Object.toQueryString</a> instead</p>\n","version":"4.0.0"},"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"urlEncode","id":"method-urlEncode"},{"tagname":"method","deprecated":{"doc":null,"tagname":"deprecated","text":"<p>Use <a href=\"#!/api/Ext-method-valueFrom\" rel=\"Ext-method-valueFrom\" class=\"docClass\">valueFrom</a> instead</p>\n","version":"4.0.0"},"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"value","id":"method-value"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"valueFrom","id":"method-valueFrom"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"widget","id":"method-widget"},{"tagname":"method","deprecated":{"doc":null,"tagname":"deprecated","text":"<p>Will be removed in the next major version</p>\n","version":"4.0.0"},"static":false,"owner":"Ext","template":false,"required":null,"protected":false,"name":"zip","id":"method-zip"}],"event":[]},"private":false,"component":false,"name":"Ext","alternateClassNames":[],"id":"class-Ext","mixedInto":[],"xtypes":{},"files":[{"href":"Ext-more.html#Ext","filename":"Ext-more.js"},{"href":"Ext-more.html#Ext","filename":"Ext-more.js"},{"href":"Ext.html#Ext","filename":"Ext.js"}]});