Ext.data.JsonP.Ext_dd_DragDropManager({"tagname":"class","html":"<div><pre class=\"hierarchy\"><h4>Alternate names</h4><div class='alternate-class-name'>Ext.dd.DragDropMgr</div><div class='alternate-class-name'>Ext.dd.DDM</div><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/Ext.Base' rel='Ext.Base' class='docClass'>Ext.Base</a><div class='subclass '><strong>Ext.dd.DragDropManager</strong></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/Ext.util.Region' rel='Ext.util.Region' class='docClass'>Ext.util.Region</a></div><h4>Uses</h4><div class='dependency'><a href='#!/api/Ext.tip.QuickTipManager' rel='Ext.tip.QuickTipManager' class='docClass'>Ext.tip.QuickTipManager</a></div><h4>Files</h4><div class='dependency'><a href='source/DragDropManager.html#Ext-dd-DragDropManager' target='_blank'>DragDropManager.js</a></div><div class='dependency'><a href='source/DragDropManager.html#Ext-dd-DragDropManager' target='_blank'>DragDropManager.js</a></div></pre><div class='doc-contents'><p>DragDropManager is a singleton that tracks the element interaction for\nall DragDrop items in the window.  Generally, you will not call\nthis class directly, but it does have helper methods that could\nbe useful in your DragDrop implementations.</p>\n</div><div class='members'><div id='m-property'><div class='definedBy'>Defined By</div><h3 class='members-title'>Properties</h3><div class='subsection'><div id='property-INTERSECT' class='member first-child not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDropManager' rel='Ext.dd.DragDropManager' class='definedIn docClass'>Ext.dd.DragDropManager</a><br/><a href='source/DragDropManager.html#Ext-dd-DragDropManager-property-INTERSECT' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDropManager-property-INTERSECT' class='name not-expandable'>INTERSECT</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>In intersect mode, drag and drop interaction is defined by the\noverlap of two or more drag and drop objects.</p>\n</div><div class='long'><p>In intersect mode, drag and drop interaction is defined by the\noverlap of two or more drag and drop objects.</p>\n</div></div></div><div id='property-POINT' class='member  not-inherited'><a href='#' class='side not-expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDropManager' rel='Ext.dd.DragDropManager' class='definedIn docClass'>Ext.dd.DragDropManager</a><br/><a href='source/DragDropManager.html#Ext-dd-DragDropManager-property-POINT' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDropManager-property-POINT' class='name not-expandable'>POINT</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>In point mode, drag and drop interaction is defined by the\nlocation of the cursor during the drag/drop</p>\n</div><div class='long'><p>In point mode, drag and drop interaction is defined by the\nlocation of the cursor during the drag/drop</p>\n</div></div></div><div id='property-clickPixelThresh' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDropManager' rel='Ext.dd.DragDropManager' class='definedIn docClass'>Ext.dd.DragDropManager</a><br/><a href='source/DragDropManager.html#Ext-dd-DragDropManager-property-clickPixelThresh' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDropManager-property-clickPixelThresh' class='name expandable'>clickPixelThresh</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The number of pixels that the mouse needs to move after the\nmousedown before the drag is initiated. ...</div><div class='long'><p>The number of pixels that the mouse needs to move after the\nmousedown before the drag is initiated.  Default=3;</p>\n</div></div></div><div id='property-clickTimeThresh' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDropManager' rel='Ext.dd.DragDropManager' class='definedIn docClass'>Ext.dd.DragDropManager</a><br/><a href='source/DragDropManager.html#Ext-dd-DragDropManager-property-clickTimeThresh' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDropManager-property-clickTimeThresh' class='name expandable'>clickTimeThresh</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The number of milliseconds after the mousedown event to initiate the\ndrag if we don't get a mouseup event. ...</div><div class='long'><p>The number of milliseconds after the mousedown event to initiate the\ndrag if we don't get a mouseup event. Default=350</p>\n</div></div></div><div id='property-mode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDropManager' rel='Ext.dd.DragDropManager' class='definedIn docClass'>Ext.dd.DragDropManager</a><br/><a href='source/DragDropManager.html#Ext-dd-DragDropManager-property-mode' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDropManager-property-mode' class='name expandable'>mode</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The current drag and drop mode. ...</div><div class='long'><p>The current drag and drop mode.  Default: POINT</p>\n</div></div></div><div id='property-preventDefault' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDropManager' rel='Ext.dd.DragDropManager' class='definedIn docClass'>Ext.dd.DragDropManager</a><br/><a href='source/DragDropManager.html#Ext-dd-DragDropManager-property-preventDefault' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDropManager-property-preventDefault' class='name expandable'>preventDefault</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>Flag to determine if we should prevent the default behavior of the\nevents we define. ...</div><div class='long'><p>Flag to determine if we should prevent the default behavior of the\nevents we define. By default this is true, but this can be set to\nfalse if you need the default behavior (not recommended)</p>\n</div></div></div><div id='property-self' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-property-self' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-property-self' class='name expandable'>self</a><span> : <a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a></span><strong class='protected-signature'>protected</strong></div><div class='description'><div class='short'>Get the reference to the current class from which this object was instantiated. ...</div><div class='long'><p>Get the reference to the current class from which this object was instantiated. Unlike <a href=\"#!/api/Ext.Base-method-statics\" rel=\"Ext.Base-method-statics\" class=\"docClass\">statics</a>,\n<code>this.self</code> is scope-dependent and it's meant to be used for dynamic inheritance. See <a href=\"#!/api/Ext.Base-method-statics\" rel=\"Ext.Base-method-statics\" class=\"docClass\">statics</a>\nfor a detailed comparison</p>\n\n<pre><code>Ext.define('My.Cat', {\n    statics: {\n        speciesName: 'Cat' // My.Cat.speciesName = 'Cat'\n    },\n\n    constructor: function() {\n        alert(this.self.speciesName); / dependent on 'this'\n\n        return this;\n    },\n\n    clone: function() {\n        return new this.self();\n    }\n});\n\n\nExt.define('My.SnowLeopard', {\n    extend: 'My.Cat',\n    statics: {\n        speciesName: 'Snow Leopard'         // My.SnowLeopard.speciesName = 'Snow Leopard'\n    }\n});\n\nvar cat = new My.Cat();                     // alerts 'Cat'\nvar snowLeopard = new My.SnowLeopard();     // alerts 'Snow Leopard'\n\nvar clone = snowLeopard.clone();\nalert(Ext.getClassName(clone));             // alerts 'My.SnowLeopard'\n</code></pre>\n</div></div></div><div id='property-stopPropagation' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDropManager' rel='Ext.dd.DragDropManager' class='definedIn docClass'>Ext.dd.DragDropManager</a><br/><a href='source/DragDropManager.html#Ext-dd-DragDropManager-property-stopPropagation' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDropManager-property-stopPropagation' class='name expandable'>stopPropagation</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>Flag to determine if we should stop the propagation of the events\nwe generate. ...</div><div class='long'><p>Flag to determine if we should stop the propagation of the events\nwe generate. This is true by default but you may want to set it to\nfalse if the html element contains other features that require the\nmouse click.</p>\n</div></div></div><div id='property-useCache' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDropManager' rel='Ext.dd.DragDropManager' class='definedIn docClass'>Ext.dd.DragDropManager</a><br/><a href='source/DragDropManager.html#Ext-dd-DragDropManager-property-useCache' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDropManager-property-useCache' class='name expandable'>useCache</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>Set useCache to false if you want to force object the lookup of each\ndrag and drop linked element constantly during a...</div><div class='long'><p>Set useCache to false if you want to force object the lookup of each\ndrag and drop linked element constantly during a drag.</p>\n</div></div></div></div></div><div id='m-method'><div class='definedBy'>Defined By</div><h3 class='members-title'>Methods</h3><div class='subsection'><div id='method-callOverridden' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-method-callOverridden' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-method-callOverridden' class='name expandable'>callOverridden</a>( <span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/Arguments args</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='protected-signature'>protected</strong></div><div class='description'><div class='short'>Call the original method that was previously overridden with override\n\nExt.define('My.Cat', {\n    constructor: functi...</div><div class='long'><p>Call the original method that was previously overridden with <a href=\"#!/api/Ext.Base-static-method-override\" rel=\"Ext.Base-static-method-override\" class=\"docClass\">override</a></p>\n\n<pre><code>Ext.define('My.Cat', {\n    constructor: function() {\n        alert(\"I'm a cat!\");\n\n        return this;\n    }\n});\n\nMy.Cat.override({\n    constructor: function() {\n        alert(\"I'm going to be a cat!\");\n\n        var instance = this.callOverridden();\n\n        alert(\"Meeeeoooowwww\");\n\n        return instance;\n    }\n});\n\nvar kitty = new My.Cat(); // alerts \"I'm going to be a cat!\"\n                          // alerts \"I'm a cat!\"\n                          // alerts \"Meeeeoooowwww\"\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>args</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/Arguments<div class='sub-desc'><p>The arguments, either an array or the <code>arguments</code> object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>Returns the result after calling the overridden method</p>\n</div></li></ul></div></div></div><div id='method-callParent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-method-callParent' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-method-callParent' class='name expandable'>callParent</a>( <span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/Arguments args</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='protected-signature'>protected</strong></div><div class='description'><div class='short'>Call the parent's overridden method. ...</div><div class='long'><p>Call the parent's overridden method. For example:</p>\n\n<pre><code>Ext.define('My.own.A', {\n    constructor: function(test) {\n        alert(test);\n    }\n});\n\nExt.define('My.own.B', {\n    extend: 'My.own.A',\n\n    constructor: function(test) {\n        alert(test);\n\n        this.callParent([test + 1]);\n    }\n});\n\nExt.define('My.own.C', {\n    extend: 'My.own.B',\n\n    constructor: function() {\n        alert(\"Going to call parent's overriden constructor...\");\n\n        this.callParent(arguments);\n    }\n});\n\nvar a = new My.own.A(1); // alerts '1'\nvar b = new My.own.B(1); // alerts '1', then alerts '2'\nvar c = new My.own.C(2); // alerts \"Going to call parent's overriden constructor...\"\n                         // alerts '2', then alerts '3'\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>args</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/Arguments<div class='sub-desc'><p>The arguments, either an array or the <code>arguments</code> object\nfrom the current method, for example: <code>this.callParent(arguments)</code></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>Returns the result from the superclass' method</p>\n</div></li></ul></div></div></div><div id='method-getBestMatch' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDropManager' rel='Ext.dd.DragDropManager' class='definedIn docClass'>Ext.dd.DragDropManager</a><br/><a href='source/DragDropManager.html#Ext-dd-DragDropManager-method-getBestMatch' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDropManager-method-getBestMatch' class='name expandable'>getBestMatch</a>( <span class='pre'><a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a>[] dds</span> ) : <a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a></div><div class='description'><div class='short'>Helper function for getting the best match from the list of drag\nand drop objects returned by the drag and drop event...</div><div class='long'><p>Helper function for getting the best match from the list of drag\nand drop objects returned by the drag and drop events when we are\nin INTERSECT mode.  It returns either the first object that the\ncursor is over, or the object that has the greatest overlap with\nthe dragged element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>dds</span> : <a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a>[]<div class='sub-desc'><p>The array of drag and drop objects\ntargeted</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a></span><div class='sub-desc'><p>The best single match</p>\n</div></li></ul></div></div></div><div id='method-getCss' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDropManager' rel='Ext.dd.DragDropManager' class='definedIn docClass'>Ext.dd.DragDropManager</a><br/><a href='source/DragDropManager.html#Ext-dd-DragDropManager-method-getCss' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDropManager-method-getCss' class='name expandable'>getCss</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> id</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Returns the style property for the DOM element (i.e.,\ndocument.getElById(id).style) ...</div><div class='long'><p>Returns the style property for the DOM element (i.e.,\ndocument.getElById(id).style)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>id</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>the id of the elment to get</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>The style property of the element</p>\n</div></li></ul></div></div></div><div id='method-getDDById' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDropManager' rel='Ext.dd.DragDropManager' class='definedIn docClass'>Ext.dd.DragDropManager</a><br/><a href='source/DragDropManager.html#Ext-dd-DragDropManager-method-getDDById' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDropManager-method-getDDById' class='name expandable'>getDDById</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> id</span> ) : <a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a></div><div class='description'><div class='short'>Returns the DragDrop instance for a given id ...</div><div class='long'><p>Returns the DragDrop instance for a given id</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>id</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>the id of the DragDrop object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a></span><div class='sub-desc'><p>the drag drop object, null if it is not found</p>\n</div></li></ul></div></div></div><div id='method-getElement' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDropManager' rel='Ext.dd.DragDropManager' class='definedIn docClass'>Ext.dd.DragDropManager</a><br/><a href='source/DragDropManager.html#Ext-dd-DragDropManager-method-getElement' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDropManager-method-getElement' class='name expandable'>getElement</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> id</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='deprecated-signature'>deprecated</strong></div><div class='description'><div class='short'>Returns the actual DOM element ...</div><div class='long'><p>Returns the actual DOM element</p>\n<div class='deprecated'><p>This method has been <strong>deprecated</strong> </p><p>use Ext.lib.Ext.getDom instead</p>\n</div><h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>id</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>the id of the elment to get</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>The element</p>\n</div></li></ul></div></div></div><div id='method-getLocation' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDropManager' rel='Ext.dd.DragDropManager' class='definedIn docClass'>Ext.dd.DragDropManager</a><br/><a href='source/DragDropManager.html#Ext-dd-DragDropManager-method-getLocation' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDropManager-method-getLocation' class='name expandable'>getLocation</a>( <span class='pre'><a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a> oDD</span> ) : <a href=\"#!/api/Ext.util.Region\" rel=\"Ext.util.Region\" class=\"docClass\">Ext.util.Region</a></div><div class='description'><div class='short'>Returns a Region object containing the drag and drop element's position\nand size, including the padding configured fo...</div><div class='long'><p>Returns a Region object containing the drag and drop element's position\nand size, including the padding configured for it</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>oDD</span> : <a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a><div class='sub-desc'><p>the drag and drop object to get the location for.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.util.Region\" rel=\"Ext.util.Region\" class=\"docClass\">Ext.util.Region</a></span><div class='sub-desc'><p>a Region object representing the total area\nthe element occupies, including any padding\nthe instance is configured for.</p>\n</div></li></ul></div></div></div><div id='method-getPosX' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDropManager' rel='Ext.dd.DragDropManager' class='definedIn docClass'>Ext.dd.DragDropManager</a><br/><a href='source/DragDropManager.html#Ext-dd-DragDropManager-method-getPosX' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDropManager-method-getPosX' class='name expandable'>getPosX</a>( <span class='pre'>HTMLElement el</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Returns the X position of an html element ...</div><div class='long'><p>Returns the X position of an html element</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : HTMLElement<div class='sub-desc'><p>the element for which to get the position</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>the X coordinate</p>\n</div></li></ul></div></div></div><div id='method-getPosY' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDropManager' rel='Ext.dd.DragDropManager' class='definedIn docClass'>Ext.dd.DragDropManager</a><br/><a href='source/DragDropManager.html#Ext-dd-DragDropManager-method-getPosY' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDropManager-method-getPosY' class='name expandable'>getPosY</a>( <span class='pre'>HTMLElement el</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Returns the Y position of an html element ...</div><div class='long'><p>Returns the Y position of an html element</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : HTMLElement<div class='sub-desc'><p>the element for which to get the position</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>the Y coordinate</p>\n</div></li></ul></div></div></div><div id='method-getRelated' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDropManager' rel='Ext.dd.DragDropManager' class='definedIn docClass'>Ext.dd.DragDropManager</a><br/><a href='source/DragDropManager.html#Ext-dd-DragDropManager-method-getRelated' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDropManager-method-getRelated' class='name expandable'>getRelated</a>( <span class='pre'><a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a> p_oDD, <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> bTargetsOnly</span> ) : <a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a>[]</div><div class='description'><div class='short'>Returns the drag and drop instances that are in all groups the\npassed in instance belongs to. ...</div><div class='long'><p>Returns the drag and drop instances that are in all groups the\npassed in instance belongs to.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>p_oDD</span> : <a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a><div class='sub-desc'><p>the obj to get related data for</p>\n</div></li><li><span class='pre'>bTargetsOnly</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a><div class='sub-desc'><p>if true, only return targetable objs</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a>[]</span><div class='sub-desc'><p>the related instances</p>\n</div></li></ul></div></div></div><div id='method-getScrollLeft' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDropManager' rel='Ext.dd.DragDropManager' class='definedIn docClass'>Ext.dd.DragDropManager</a><br/><a href='source/DragDropManager.html#Ext-dd-DragDropManager-method-getScrollLeft' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDropManager-method-getScrollLeft' class='name expandable'>getScrollLeft</a>( <span class='pre'></span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Gets the scrollLeft ...</div><div class='long'><p>Gets the scrollLeft</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>the document's scrollTop</p>\n</div></li></ul></div></div></div><div id='method-getScrollTop' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDropManager' rel='Ext.dd.DragDropManager' class='definedIn docClass'>Ext.dd.DragDropManager</a><br/><a href='source/DragDropManager.html#Ext-dd-DragDropManager-method-getScrollTop' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDropManager-method-getScrollTop' class='name expandable'>getScrollTop</a>( <span class='pre'></span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Gets the scrollTop ...</div><div class='long'><p>Gets the scrollTop</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>the document's scrollTop</p>\n</div></li></ul></div></div></div><div id='method-getStyle' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDropManager' rel='Ext.dd.DragDropManager' class='definedIn docClass'>Ext.dd.DragDropManager</a><br/><a href='source/DragDropManager.html#Ext-dd-DragDropManager-method-getStyle' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDropManager-method-getStyle' class='name expandable'>getStyle</a>( <span class='pre'>HTMLElement el, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> styleProp</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Returns the specified element style property ...</div><div class='long'><p>Returns the specified element style property</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : HTMLElement<div class='sub-desc'><p>the element</p>\n</div></li><li><span class='pre'>styleProp</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>the style property</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The value of the style property</p>\n</div></li></ul></div></div></div><div id='method-handleWasClicked' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDropManager' rel='Ext.dd.DragDropManager' class='definedIn docClass'>Ext.dd.DragDropManager</a><br/><a href='source/DragDropManager.html#Ext-dd-DragDropManager-method-handleWasClicked' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDropManager-method-handleWasClicked' class='name expandable'>handleWasClicked</a>( <span class='pre'>HTMLElement node</span> )</div><div class='description'><div class='short'>Recursively searches the immediate parent and all child nodes for\nthe handle element in order to determine wheter or ...</div><div class='long'><p>Recursively searches the immediate parent and all child nodes for\nthe handle element in order to determine wheter or not it was\nclicked.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>node</span> : HTMLElement<div class='sub-desc'><p>the html element to inspect</p>\n</div></li></ul></div></div></div><div id='method-initConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-method-initConfig' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-method-initConfig' class='name expandable'>initConfig</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> config</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='protected-signature'>protected</strong></div><div class='description'><div class='short'>Initialize configuration for this class. ...</div><div class='long'><p>Initialize configuration for this class. a typical example:</p>\n\n<pre><code>Ext.define('My.awesome.Class', {\n    // The default config\n    config: {\n        name: 'Awesome',\n        isAwesome: true\n    },\n\n    constructor: function(config) {\n        this.initConfig(config);\n\n        return this;\n    }\n});\n\nvar awesome = new My.awesome.Class({\n    name: 'Super Awesome'\n});\n\nalert(awesome.getName()); // 'Super Awesome'\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>mixins The mixin prototypes as key - value pairs</p>\n</div></li></ul></div></div></div><div id='method-isDragDrop' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDropManager' rel='Ext.dd.DragDropManager' class='definedIn docClass'>Ext.dd.DragDropManager</a><br/><a href='source/DragDropManager.html#Ext-dd-DragDropManager-method-isDragDrop' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDropManager-method-isDragDrop' class='name expandable'>isDragDrop</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> id</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Utility function to determine if a given element has been\nregistered as a drag drop item. ...</div><div class='long'><p>Utility function to determine if a given element has been\nregistered as a drag drop item.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>id</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>the element id to check</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>true if this element is a DragDrop item,\nfalse otherwise</p>\n</div></li></ul></div></div></div><div id='method-isHandle' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDropManager' rel='Ext.dd.DragDropManager' class='definedIn docClass'>Ext.dd.DragDropManager</a><br/><a href='source/DragDropManager.html#Ext-dd-DragDropManager-method-isHandle' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDropManager-method-isHandle' class='name expandable'>isHandle</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> id</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Utility function to determine if a given element has been\nregistered as a drag drop handle for the given Drag Drop ob...</div><div class='long'><p>Utility function to determine if a given element has been\nregistered as a drag drop handle for the given Drag Drop object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>id</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>the element id to check</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>true if this element is a DragDrop handle, false\notherwise</p>\n</div></li></ul></div></div></div><div id='method-isLegalTarget' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDropManager' rel='Ext.dd.DragDropManager' class='definedIn docClass'>Ext.dd.DragDropManager</a><br/><a href='source/DragDropManager.html#Ext-dd-DragDropManager-method-isLegalTarget' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDropManager-method-isLegalTarget' class='name expandable'>isLegalTarget</a>( <span class='pre'><a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a> oDD, <a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a> oTargetDD</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Returns true if the specified dd target is a legal target for\nthe specifice drag obj ...</div><div class='long'><p>Returns true if the specified dd target is a legal target for\nthe specifice drag obj</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>oDD</span> : <a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a><div class='sub-desc'><p>the drag obj</p>\n</div></li><li><span class='pre'>oTargetDD</span> : <a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a><div class='sub-desc'><p>the target</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>true if the target is a legal target for the\ndd obj</p>\n</div></li></ul></div></div></div><div id='method-isLocked' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDropManager' rel='Ext.dd.DragDropManager' class='definedIn docClass'>Ext.dd.DragDropManager</a><br/><a href='source/DragDropManager.html#Ext-dd-DragDropManager-method-isLocked' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDropManager-method-isLocked' class='name expandable'>isLocked</a>( <span class='pre'></span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Is drag and drop locked? ...</div><div class='long'><p>Is drag and drop locked?</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>True if drag and drop is locked, false otherwise.</p>\n</div></li></ul></div></div></div><div id='method-isTypeOfDD' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDropManager' rel='Ext.dd.DragDropManager' class='definedIn docClass'>Ext.dd.DragDropManager</a><br/><a href='source/DragDropManager.html#Ext-dd-DragDropManager-method-isTypeOfDD' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDropManager-method-isTypeOfDD' class='name expandable'>isTypeOfDD</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> the</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>My goal is to be able to transparently determine if an object is\ntypeof DragDrop, and the exact subclass of DragDrop. ...</div><div class='long'><p>My goal is to be able to transparently determine if an object is\ntypeof DragDrop, and the exact subclass of DragDrop.  typeof\nreturns \"object\", oDD.constructor.toString() always returns\n\"DragDrop\" and not the name of the subclass.  So for now it just\nevaluates a well-known variable in DragDrop.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>the</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>object to evaluate</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>true if typeof oDD = DragDrop</p>\n</div></li></ul></div></div></div><div id='method-lock' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDropManager' rel='Ext.dd.DragDropManager' class='definedIn docClass'>Ext.dd.DragDropManager</a><br/><a href='source/DragDropManager.html#Ext-dd-DragDropManager-method-lock' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDropManager-method-lock' class='name expandable'>lock</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Lock all drag and drop functionality ...</div><div class='long'><p>Lock all drag and drop functionality</p>\n</div></div></div><div id='method-moveToEl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDropManager' rel='Ext.dd.DragDropManager' class='definedIn docClass'>Ext.dd.DragDropManager</a><br/><a href='source/DragDropManager.html#Ext-dd-DragDropManager-method-moveToEl' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDropManager-method-moveToEl' class='name expandable'>moveToEl</a>( <span class='pre'>HTMLElement moveEl, HTMLElement targetEl</span> )</div><div class='description'><div class='short'>Sets the x/y position of an element to the location of the\ntarget element. ...</div><div class='long'><p>Sets the x/y position of an element to the location of the\ntarget element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>moveEl</span> : HTMLElement<div class='sub-desc'><p>The element to move</p>\n</div></li><li><span class='pre'>targetEl</span> : HTMLElement<div class='sub-desc'><p>The position reference element</p>\n</div></li></ul></div></div></div><div id='method-numericSort' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDropManager' rel='Ext.dd.DragDropManager' class='definedIn docClass'>Ext.dd.DragDropManager</a><br/><a href='source/DragDropManager.html#Ext-dd-DragDropManager-method-numericSort' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDropManager-method-numericSort' class='name expandable'>numericSort</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> a, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> b</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Numeric array sort function ...</div><div class='long'><p>Numeric array sort function</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>a</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'>\n</div></li><li><span class='pre'>b</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>positive, negative or 0</p>\n</div></li></ul></div></div></div><div id='method-refreshCache' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDropManager' rel='Ext.dd.DragDropManager' class='definedIn docClass'>Ext.dd.DragDropManager</a><br/><a href='source/DragDropManager.html#Ext-dd-DragDropManager-method-refreshCache' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDropManager-method-refreshCache' class='name expandable'>refreshCache</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> groups</span> )</div><div class='description'><div class='short'>Refreshes the cache of the top-left and bottom-right points of the\ndrag and drop objects in the specified group(s). ...</div><div class='long'><p>Refreshes the cache of the top-left and bottom-right points of the\ndrag and drop objects in the specified group(s).  This is in the\nformat that is stored in the drag and drop instance, so typical\nusage is:\n<code>\nExt.dd.DragDropManager.refreshCache(ddinstance.groups);\n</code>\nAlternatively:\n<code>\nExt.dd.DragDropManager.refreshCache({group1:true, group2:true});\n</code>\n@TODO this really should be an indexed array.  Alternatively this\nmethod could accept both.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>groups</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>an associative array of groups to refresh</p>\n</div></li></ul></div></div></div><div id='method-regDragDrop' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDropManager' rel='Ext.dd.DragDropManager' class='definedIn docClass'>Ext.dd.DragDropManager</a><br/><a href='source/DragDropManager.html#Ext-dd-DragDropManager-method-regDragDrop' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDropManager-method-regDragDrop' class='name expandable'>regDragDrop</a>( <span class='pre'><a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a> oDD, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> sGroup</span> )</div><div class='description'><div class='short'>Each DragDrop instance must be registered with the DragDropManager. ...</div><div class='long'><p>Each DragDrop instance must be registered with the DragDropManager.\nThis is executed in DragDrop.init()</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>oDD</span> : <a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a><div class='sub-desc'><p>the DragDrop object to register</p>\n</div></li><li><span class='pre'>sGroup</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>the name of the group this element belongs to</p>\n</div></li></ul></div></div></div><div id='method-regHandle' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDropManager' rel='Ext.dd.DragDropManager' class='definedIn docClass'>Ext.dd.DragDropManager</a><br/><a href='source/DragDropManager.html#Ext-dd-DragDropManager-method-regHandle' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDropManager-method-regHandle' class='name expandable'>regHandle</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> sDDId, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> sHandleId</span> )</div><div class='description'><div class='short'>Each DragDrop handle element must be registered. ...</div><div class='long'><p>Each DragDrop handle element must be registered.  This is done\nautomatically when executing DragDrop.setHandleElId()</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sDDId</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>the DragDrop id this element is a handle for</p>\n</div></li><li><span class='pre'>sHandleId</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>the id of the element that is the drag\nhandle</p>\n</div></li></ul></div></div></div><div id='method-startDrag' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDropManager' rel='Ext.dd.DragDropManager' class='definedIn docClass'>Ext.dd.DragDropManager</a><br/><a href='source/DragDropManager.html#Ext-dd-DragDropManager-method-startDrag' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDropManager-method-startDrag' class='name expandable'>startDrag</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> x, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> y</span> )</div><div class='description'><div class='short'>Fired when either the drag pixel threshol or the mousedown hold\ntime threshold has been met. ...</div><div class='long'><p>Fired when either the drag pixel threshol or the mousedown hold\ntime threshold has been met.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>x</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>the X position of the original mousedown</p>\n</div></li><li><span class='pre'>y</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>the Y position of the original mousedown</p>\n</div></li></ul></div></div></div><div id='method-statics' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='definedIn docClass'>Ext.Base</a><br/><a href='source/Base3.html#Ext-Base-method-statics' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.Base-method-statics' class='name expandable'>statics</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a><strong class='protected-signature'>protected</strong></div><div class='description'><div class='short'>Get the reference to the class from which this object was instantiated. ...</div><div class='long'><p>Get the reference to the class from which this object was instantiated. Note that unlike <a href=\"#!/api/Ext.Base-property-self\" rel=\"Ext.Base-property-self\" class=\"docClass\">self</a>,\n<code>this.statics()</code> is scope-independent and it always returns the class from which it was called, regardless of what\n<code>this</code> points to during run-time</p>\n\n<pre><code>Ext.define('My.Cat', {\n    statics: {\n        totalCreated: 0,\n        speciesName: 'Cat' // My.Cat.speciesName = 'Cat'\n    },\n\n    constructor: function() {\n        var statics = this.statics();\n\n        alert(statics.speciesName);     // always equals to 'Cat' no matter what 'this' refers to\n                                        // equivalent to: My.Cat.speciesName\n\n        alert(this.self.speciesName);   // dependent on 'this'\n\n        statics.totalCreated++;\n\n        return this;\n    },\n\n    clone: function() {\n        var cloned = new this.self;                      // dependent on 'this'\n\n        cloned.groupName = this.statics().speciesName;   // equivalent to: My.Cat.speciesName\n\n        return cloned;\n    }\n});\n\n\nExt.define('My.SnowLeopard', {\n    extend: 'My.Cat',\n\n    statics: {\n        speciesName: 'Snow Leopard'     // My.SnowLeopard.speciesName = 'Snow Leopard'\n    },\n\n    constructor: function() {\n        this.callParent();\n    }\n});\n\nvar cat = new My.Cat();                 // alerts 'Cat', then alerts 'Cat'\n\nvar snowLeopard = new My.SnowLeopard(); // alerts 'Cat', then alerts 'Snow Leopard'\n\nvar clone = snowLeopard.clone();\nalert(Ext.getClassName(clone));         // alerts 'My.SnowLeopard'\nalert(clone.groupName);                 // alerts 'Cat'\n\nalert(My.Cat.totalCreated);             // alerts 3\n</code></pre>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-stopEvent' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDropManager' rel='Ext.dd.DragDropManager' class='definedIn docClass'>Ext.dd.DragDropManager</a><br/><a href='source/DragDropManager.html#Ext-dd-DragDropManager-method-stopEvent' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDropManager-method-stopEvent' class='name expandable'>stopEvent</a>( <span class='pre'>Event e</span> )</div><div class='description'><div class='short'>Utility to stop event propagation and event default, if these\nfeatures are turned on. ...</div><div class='long'><p>Utility to stop event propagation and event default, if these\nfeatures are turned on.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Event<div class='sub-desc'><p>the event as returned by this.getEvent()</p>\n</div></li></ul></div></div></div><div id='method-swapNode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDropManager' rel='Ext.dd.DragDropManager' class='definedIn docClass'>Ext.dd.DragDropManager</a><br/><a href='source/DragDropManager.html#Ext-dd-DragDropManager-method-swapNode' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDropManager-method-swapNode' class='name expandable'>swapNode</a>( <span class='pre'>HTMLElement n1, HTMLElement n2</span> )</div><div class='description'><div class='short'>Swap two nodes. ...</div><div class='long'><p>Swap two nodes.  In IE, we use the native method, for others we\nemulate the IE behavior</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>n1</span> : HTMLElement<div class='sub-desc'><p>the first node to swap</p>\n</div></li><li><span class='pre'>n2</span> : HTMLElement<div class='sub-desc'><p>the other node to swap</p>\n</div></li></ul></div></div></div><div id='method-unlock' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDropManager' rel='Ext.dd.DragDropManager' class='definedIn docClass'>Ext.dd.DragDropManager</a><br/><a href='source/DragDropManager.html#Ext-dd-DragDropManager-method-unlock' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDropManager-method-unlock' class='name expandable'>unlock</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Unlock all drag and drop functionality ...</div><div class='long'><p>Unlock all drag and drop functionality</p>\n</div></div></div><div id='method-verifyEl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.dd.DragDropManager' rel='Ext.dd.DragDropManager' class='definedIn docClass'>Ext.dd.DragDropManager</a><br/><a href='source/DragDropManager.html#Ext-dd-DragDropManager-method-verifyEl' target='_blank' class='viewSource'>view source</a></div><a href='#!/api/Ext.dd.DragDropManager-method-verifyEl' class='name expandable'>verifyEl</a>( <span class='pre'>HTMLElement el</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>This checks to make sure an element exists and is in the DOM. ...</div><div class='long'><p>This checks to make sure an element exists and is in the DOM.  The\nmain purpose is to handle cases where innerHTML is used to remove\ndrag and drop objects from the DOM.  IE provides an 'unspecified\nerror' when trying to access the offsetParent of such an element</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : HTMLElement<div class='sub-desc'><p>the element to check</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>true if the element looks usable</p>\n</div></li></ul></div></div></div></div></div></div></div>","allMixins":[],"meta":{},"requires":["Ext.util.Region"],"deprecated":null,"extends":"Ext.Base","inheritable":false,"static":false,"superclasses":["Ext.Base","Ext.dd.DragDropManager"],"singleton":true,"code_type":"ext_define","alias":null,"statics":{"property":[],"css_var":[],"css_mixin":[],"cfg":[],"method":[],"event":[]},"subclasses":[],"uses":["Ext.tip.QuickTipManager"],"protected":false,"mixins":[],"members":{"property":[{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.dd.DragDropManager","template":null,"required":null,"protected":false,"name":"INTERSECT","id":"property-INTERSECT"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.dd.DragDropManager","template":null,"required":null,"protected":false,"name":"POINT","id":"property-POINT"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.dd.DragDropManager","template":null,"required":null,"protected":false,"name":"clickPixelThresh","id":"property-clickPixelThresh"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.dd.DragDropManager","template":null,"required":null,"protected":false,"name":"clickTimeThresh","id":"property-clickTimeThresh"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.dd.DragDropManager","template":null,"required":null,"protected":false,"name":"mode","id":"property-mode"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.dd.DragDropManager","template":null,"required":null,"protected":false,"name":"preventDefault","id":"property-preventDefault"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.Base","template":null,"required":null,"protected":true,"name":"self","id":"property-self"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.dd.DragDropManager","template":null,"required":null,"protected":false,"name":"stopPropagation","id":"property-stopPropagation"},{"tagname":"property","deprecated":null,"static":false,"owner":"Ext.dd.DragDropManager","template":null,"required":null,"protected":false,"name":"useCache","id":"property-useCache"}],"css_var":[],"css_mixin":[],"cfg":[],"method":[{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Base","template":false,"required":null,"protected":true,"name":"callOverridden","id":"method-callOverridden"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Base","template":false,"required":null,"protected":true,"name":"callParent","id":"method-callParent"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDropManager","template":false,"required":null,"protected":false,"name":"getBestMatch","id":"method-getBestMatch"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDropManager","template":false,"required":null,"protected":false,"name":"getCss","id":"method-getCss"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDropManager","template":false,"required":null,"protected":false,"name":"getDDById","id":"method-getDDById"},{"tagname":"method","deprecated":{"doc":null,"tagname":"deprecated","text":"<p>use Ext.lib.Ext.getDom instead</p>\n","version":null},"static":false,"owner":"Ext.dd.DragDropManager","template":false,"required":null,"protected":false,"name":"getElement","id":"method-getElement"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDropManager","template":false,"required":null,"protected":false,"name":"getLocation","id":"method-getLocation"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDropManager","template":false,"required":null,"protected":false,"name":"getPosX","id":"method-getPosX"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDropManager","template":false,"required":null,"protected":false,"name":"getPosY","id":"method-getPosY"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDropManager","template":false,"required":null,"protected":false,"name":"getRelated","id":"method-getRelated"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDropManager","template":false,"required":null,"protected":false,"name":"getScrollLeft","id":"method-getScrollLeft"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDropManager","template":false,"required":null,"protected":false,"name":"getScrollTop","id":"method-getScrollTop"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDropManager","template":false,"required":null,"protected":false,"name":"getStyle","id":"method-getStyle"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDropManager","template":false,"required":null,"protected":false,"name":"handleWasClicked","id":"method-handleWasClicked"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Base","template":false,"required":null,"protected":true,"name":"initConfig","id":"method-initConfig"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDropManager","template":false,"required":null,"protected":false,"name":"isDragDrop","id":"method-isDragDrop"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDropManager","template":false,"required":null,"protected":false,"name":"isHandle","id":"method-isHandle"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDropManager","template":false,"required":null,"protected":false,"name":"isLegalTarget","id":"method-isLegalTarget"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDropManager","template":false,"required":null,"protected":false,"name":"isLocked","id":"method-isLocked"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDropManager","template":false,"required":null,"protected":false,"name":"isTypeOfDD","id":"method-isTypeOfDD"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDropManager","template":false,"required":null,"protected":false,"name":"lock","id":"method-lock"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDropManager","template":false,"required":null,"protected":false,"name":"moveToEl","id":"method-moveToEl"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDropManager","template":false,"required":null,"protected":false,"name":"numericSort","id":"method-numericSort"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDropManager","template":false,"required":null,"protected":false,"name":"refreshCache","id":"method-refreshCache"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDropManager","template":false,"required":null,"protected":false,"name":"regDragDrop","id":"method-regDragDrop"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDropManager","template":false,"required":null,"protected":false,"name":"regHandle","id":"method-regHandle"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDropManager","template":false,"required":null,"protected":false,"name":"startDrag","id":"method-startDrag"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.Base","template":false,"required":null,"protected":true,"name":"statics","id":"method-statics"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDropManager","template":false,"required":null,"protected":false,"name":"stopEvent","id":"method-stopEvent"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDropManager","template":false,"required":null,"protected":false,"name":"swapNode","id":"method-swapNode"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDropManager","template":false,"required":null,"protected":false,"name":"unlock","id":"method-unlock"},{"tagname":"method","deprecated":null,"static":false,"owner":"Ext.dd.DragDropManager","template":false,"required":null,"protected":false,"name":"verifyEl","id":"method-verifyEl"}],"event":[]},"private":false,"component":false,"name":"Ext.dd.DragDropManager","alternateClassNames":["Ext.dd.DragDropMgr","Ext.dd.DDM"],"id":"class-Ext.dd.DragDropManager","mixedInto":[],"xtypes":{},"files":[{"href":"DragDropManager.html#Ext-dd-DragDropManager","filename":"DragDropManager.js"},{"href":"DragDropManager.html#Ext-dd-DragDropManager","filename":"DragDropManager.js"}]});