/*

This file is part of Ext JS 4

Copyright (c) 2011 Sencha Inc

Contact:  http://www.sencha.com/contact

GNU General Public License Usage
This file may be used under the terms of the GNU General Public License version 3.0 as published by the Free Software Foundation and appearing in the file LICENSE included in the packaging of this file.  Please review the following information to ensure the GNU General Public License version 3.0 requirements will be met: http://www.gnu.org/copyleft/gpl.html.

If you are unsure which license is appropriate for your use, please contact the sales department at http://www.sencha.com/contact.

*/
Ext.ns('Ext.samples');

Ext.samples.samplesCatalog = [
    {
        title: 'Combination Examples',
        samples: [
            {
                text: 'Feed Viewer',
                url:  'feed-viewer/feed-viewer.html',
                icon: 'feeds.gif',
                desc: 'RSS feed reader example application that features a swappable reader panel layout.',
                status: 'updated'
            },
            {
                text: 'Web Desktop',
                url:  'desktop/desktop.html',
                icon: 'desktop.gif',
                desc: 'Demonstrates how one could build a desktop in the browser using Ext components including a module plugin system.',
                status: 'updated'
            },
            {
                text: 'Portal Demo',
                url:  'portal/portal.html',
                icon: 'portal.gif',
                desc: 'A page layout using several custom extensions to provide a web portal interface.',
                status: 'updated'
            },
            {
                text: 'Ext JS 3 & 4 on one page',
                url:  'sandbox/sandbox.html',
                icon: 'sandbox.gif',
                desc: 'This example demonstrates Ext JS 4\'s sandboxing behavior which allows you to run Ext JS 3 & 4 on the same page.',
                status: 'new'
            },
            {
                text: 'Image Viewer',
                url: 'organizer/organizer.html',
                icon: 'organizer.gif',
                desc: 'DataView and TreePanel example that demonstrates dragging data items from a DataView into a TreePanel.'
            },
            {
                text: 'Theme Viewer',
                url: 'themes/index.html',
                icon: 'themes.gif',
                desc: 'View and test every Ext component against bundled Ext themes.'
            }
        ]
    },
    {
        title: 'Accessibility',
        samples: [
            {
                text: 'Keyboard Feed Viewer',
                url: 'key-feed-viewer/feed-viewer.html',
                icon: 'keyboard.gif',
                desc: "Shows Ext JS 4's comprehensive keyboard support for users who have difficulty using a pointing device",
                status: 'new'

            },
            {
                text: 'Binding a Grid to a Form',
                url:  'form/form-grid-access.html',
                icon: 'form-grid-binding-access.gif',
                desc: 'A grid embedded within a FormPanel that uses the Accessibility theme.'
            }
        ]
    },
    {
        title: 'Grids',
        samples: [
            {
                text: 'Basic Array Grid',
                url:  'grid/array-grid.html',
                icon: 'grid-array.gif',
                desc: 'A basic read-only grid loaded from local array data that demonstrates the use of custom column renderer functions.',
                status: 'updated'
            },
            {
                text: 'XML Grid',
                url:  'grid/xml-grid.html',
                icon: 'grid-xml.gif',
                desc: 'A simple read-only grid loaded from XML data.'
            },
            {
                text: 'Paging',
                url:  'grid/paging.html',
                icon: 'grid-paging.gif',
                desc: 'A grid with paging, cross-domain data loading and custom- rendered expandable row bodies.'
            },
            {
                text: 'Sliding Pager',
                url: 'grid/sliding-pager.html',
                icon: 'slider-pager.gif',
                desc: 'A demonstration on the integration of the Slider with the Paging Toolbar using a custom plugin.'
            },
            {
                text: 'Grouping',
                url: 'grid/groupgrid.html',
                icon: 'grid-grouping.gif',
                desc: 'A basic grouping grid showing collapsible data groups that can be customized via the "Group By" header menu option.'
            },
            {
                text: 'Grid Plugins',
                url: 'grid/grid-plugins.html',
                icon: 'grid-plugins.gif',
                desc: 'Multiple grids customized via plugins: expander rows, checkbox selection and row numbering.'
            },
            {
                text: 'Grid Filtering',
                url: 'grid-filtering/grid-filter-local.html',
                icon: 'grid-filter.gif',
                desc: 'Grid feature providing custom data filtering menus that support various data types.',
                status: 'updated'
            },
            {
                text: 'Grid Data Binding (basic)',
                url: 'grid/binding.html',
                icon: 'grid-data-binding.gif',
                desc: 'Data binding a grid to a detail preview panel via the grid\'s RowSelectionModel.'
            },
            {
                text: 'Grid Data Binding (advanced)',
                url: 'grid/binding-with-classes.html',
                icon: 'grid-data-binding.gif',
                desc: 'Refactoring the basic data binding example to use a class-based application design model.'
            },
            {
                text: 'Multiple Sorting',
                url: 'grid/multiple-sorting.html',
                icon: 'grid-multiple-sorting.gif',
                desc: 'An example that shows multi-level sorting in a Grid Panel.'
            },
            {
                text: 'Grid Cell Editing',
                url: 'grid/cell-editing.html',
                icon: 'grid-cell-editing.gif',
                desc: 'An example that shows cell editing in a Grid Panel.',
                status: 'updated'
            },
            {
                text: 'Grouped Header Grid',
                url: 'grid/group-header-grid.html',
                icon: 'grid-grouped-headers.gif',
                desc: 'A basic grouping grid showing collapsible data groups that can be customized via the "Group By" header menu option.',
                status: 'updated'
            },
            {
                text: 'Grid Grouping with Summary',
                url: 'grid/group-summary-grid.html',
                icon: 'grid-summary.gif',
                desc: 'Advanced grouping grid that allows cell editing and includes custom dynamic summary calculations.',
                status: 'updated'
            },
            {
                text: 'Grid with 50,0000 Rows',
                url: 'grid/infinite-scroll.html',
                icon: 'grid-infinite-scroll.gif',
                desc: 'Sample grid which dynamically loads 50,000 rows.',
                status: 'new'
            },
            {
                text: 'Grid with Live Search Capability',
                url: 'grid/live-search-grid.html',
                icon: 'grid-live-search.gif',
                desc: 'Grid with Live Search Capability.',
                status: 'new'
            },
            {
                text: 'Grid with Locking Capability',
                url: 'grid/locking-grid.html',
                icon: 'grid-locking.gif',
                desc: 'An example extension that introduces the ability to add locking columns to the GridPanel.',
                status: 'updated'
            },
            {
                text: 'Grouping with Remote Summary',
                url: 'grid/remote-group-summary-grid.html',
                icon: 'grid-group-summaries.gif',
                desc: 'Advanced grouping grid that allows cell editing and includes remotely loaded dynamic summary calculations.'
            },
            {
                text: 'Grid Row Editing',
                url: 'grid/row-editing.html',
                icon: 'grid-row-editor.gif',
                desc: 'An editable grid which allows the user to make modifications to an entire record at once.',
                status: 'updated'
            },
            {
                text: 'RESTful Store with GridPanel and RowEditor',
                url: 'restful/restful.html',
                icon: 'grid-row-editor.gif',
                desc: 'A RESTful Store with JsonWriter which automatically generates CRUD requests to the server.'
            },
            {
                text: 'Editable Grid with Writable Store',
                url: 'writer/writer.html',
                icon: 'writer-thumb.gif',
                desc: "This Store uses Data's writer to automatically generate CRUD requests to the server through a standard HttpProxy."
            },
            {
                text: 'Buffered Scrolling',
                url: 'grid/buffer-grid.html',
                icon: 'buffer-grid.gif',
                desc: "The new grid uses a virtualized scrolling system to handle potentially infinite data sets without any impact on client side performance.",
                status: 'updated'
            },
            {
                text: 'List View',
                url: 'grid/list-view.html',
                icon: 'list-view.gif',
                desc: "Ext 4 replaces Ext.ListView with the default Ext.grid.Panel.",
                status: 'updated'
            },
            {
                text: 'Progress Bar Pager',
                url: 'grid/progress-bar-pager.html',
                icon: 'progress-bar-pager.gif',
                desc: "Progress Bar Pager Extension."
            },{
                text: 'Property Grid',
                url: 'grid/property.html',
                icon: 'grid-property.gif',
                desc: "Create a property grid from an object."       
            },{
                text: 'Grid From Markup',
                url: 'grid/transform-dom.html',
                icon: 'grid-transform.gif',
                desc: "Create a grid with from an existing, unformatted HTML table."             
            }
        ]
    },
    {
        title: 'Charts',
        samples: [
            {
                text: 'Area Charts',
                url: 'charts/Area.html',
                icon: 'chart-area.gif',
                desc: 'Display 7 sets of random data in an area series. Reload data will randomly generate a new set of data in the store.',
                status: 'new'
            },
            {
                text: 'Custom Area Charts',
                url: 'charts/Area - BrowserStats.html',
                icon: 'area-browsers.gif',
                desc: 'Display browser usage trends in an area series. This chart uses custom gradients for the colors and the legend is interactive.',
                status: 'new'
            },
            {
                text: 'Bar Charts',
                url: 'charts/Bar.html',
                icon: 'chart-bar.gif',
                desc: 'Display a sets of random data in a bar series. Reload data will randomly generate a new set of data in the store.',
                status: 'new'
            },
            {
                text: 'Custom Bar Charts',
                url: 'charts/BarRenderer.html',
                icon: 'chart-bar-renderer.gif',
                desc: 'Displaying a horizontal bar series with a bar renderer that modifies the color of each bar.',
                status: 'new'
            },
            {
                text: 'Complex Dashboard',
                url: 'charts/FormDashboard.html',
                icon: 'form-dashboard.gif',
                desc: 'Showing companies information in a complex dashboard. Edit the information for each record in the form to see live updates in the charts and grid.',
                status: 'new'
            },
            {
                text: 'Rich Tips',
                url: 'charts/TipsChart.html',
                icon: 'rich-tips.gif',
                desc: 'Showing a line series with rich tips. Tips show dynamic information in Grid and Pie chart components.',
                status: 'new'
            },
            {
                text: 'Themed Line Charts',
                url: 'charts/Charts.html',
                icon: 'chart-themed.gif',
                desc: 'Using 3.x theme. Displaying multiple charts and mixed charts with mouse over and click interaction.',
                status: 'new'
            },
            {
                text: 'Column Charts',
                url: 'charts/Column.html',
                icon: 'chart-column.gif',
                desc: 'Display a set of random data in a column series. Reload data will randomly generate a new set of data in the store.',
                status: 'new'
            },
            {
                text: 'Line Charts',
                url: 'charts/Line.html',
                icon: 'chart-line.gif',
                desc: 'Display 2 sets of random data in a line series. Reload data will randomly generate a new set of data in the store.',
                status: 'new'
            },
            {
                text: 'Column Custom Background',
                url: 'charts/Column2.html',
                icon: 'column2.gif',
                desc: 'A Column chart with customized theme and animation transitions',
                status: 'new'
            },
            {
                text: 'Mixed Series Chart',
                url: 'charts/Mixed.html',
                icon: 'chart-mixed.gif',
                desc: 'Display 3 sets of random data using a line, bar, and scatter series. Reload data will randomly generate a new set of data in the store.',
                status: 'new'
            },
            {
                text: 'Pie Charts',
                url: 'charts/Pie.html',
                icon: 'chart-pie.gif',
                desc: 'Display 5 sets of random data using a pie chart. Reload data will randomly generate a new set of data in the store.',
                status: 'new'
            },
            {
                text: 'Custom Pie Charts',
                url: 'charts/PieRenderer.html',
                icon: 'chart-pie-renderer.gif',
                desc: 'Display 5 sets of random data using a pie chart. A renderer has been set up on to dynamically change the length and color of each slice based on the data.',
                status: 'new'
            },
            {
                text: 'Radar Charts',
                url: 'charts/Radar.html',
                icon: 'chart-radar.gif',
                desc: 'Display 3 sets of random data in a radar series. Note this example uses a radial axis.',
                status: 'new'
            },
            {
                text: 'Filled Radar Charts',
                url: 'charts/RadarFill.html',
                icon: 'chart-radar-fill.gif',
                desc: 'Display 3 sets of random data in a filled radar series. Click or hover on the legend items to highlight and remove them from the chart.',
                status: 'new'
            },
            {
                text: 'Scatter Charts',
                url: 'charts/Scatter - Renderer.html',
                icon: 'chart-scatter.gif',
                desc: 'Display 2 sets of random data in a scatter series. A renderer has been set up on to dynamically change the size and color of the items based upon it\'s data.',
                status: 'new'
            },
            {
                text: 'Stacked Bar Charts',
                url: 'charts/StackedBar.html',
                icon: 'chart-bar-stacked.gif',
                desc: 'Showing movie taking by genre as a stacked bar chart sample. Filter the stacks by clicking on the legend items.',
                status: 'new'
            },
            {
                text: 'Live Updated Chart',
                url: 'charts/LiveUpdates.html',
                icon: 'live-updated.gif',
                desc: 'Showing a line series with data updating at a regular interval.',
                status: 'new'
            },
            {
                text: 'Live Animated Chart',
                url: 'charts/LiveAnimated.html',
                icon: 'live-animated.gif',
                desc: 'Showing a line series with smooth transitions on data updating at regular intervals.',
                status: 'new'
            },
            {
                text: 'Gauge Chart',
                url: 'charts/Gauge.html',
                icon: 'gauge.gif',
                desc: 'Display three custom gauge charts bound to different data stores with different configuration options and easings.',
                status: 'new'
            },
            {
                text: 'Grouped Bar',
                url: 'charts/GroupedBar.html',
                icon: 'grouped-bar.gif',
                desc: 'Display 3 sets of random data in a grouped bar series.',
                status: 'new'
            },
            {
                text: 'Reload Chart',
                url: 'charts/ReloadChart.html',
                icon: 'reload-chart.gif',
                desc: 'Display a Column Chart Sample that animates when refreshing the data set',
                status: 'new'
            }
        ]
    },
    {
        title: 'Tabs',
        samples: [
            {
                text: 'Basic Tabs',
                url: 'tabs/tabs.html',
                icon: 'tabs.gif',
                desc: 'Basic tab functionality including autoHeight, tabs from markup, Ajax loading and tab events.'
            },
            {
                text: 'Advanced Tabs',
                url: 'tabs/tabs-adv.html',
                icon: 'tabs-adv.gif',
                desc: 'Advanced tab features including tab scrolling, adding tabs programmatically and a context menu plugin.'
            },
            {
               text: 'Tab overflow menu',
               url: 'tabs/tab-scroller-menu.html',
               icon: 'tabs-adv.gif',
               desc: 'Demonstrates the TabPanel overflow menu extension, which makes management of large numbers of tabs easier',
               status: 'updated'
            }
        ]
    },
    {
        title: 'Windows',
        samples: [
            {
                text: 'Window Variations',
                url: 'window/window.html',
                icon: 'window-layout.gif',
                desc: 'A collection of Windows in different configurations, showing headers attached to any side of the window.',
                status: 'new'
            },
            {
                text: 'Layout Window',
                url: 'window/layout.html',
                icon: 'window.gif',
                desc: 'A window containing a basic BorderLayout with nested TabPanel.'
            },
            {
                text: 'MessageBox',
                url: 'message-box/msg-box.html',
                icon: 'msg-box.gif',
                desc: 'Different styles include confirm, alert, prompt, progress and wait and also support custom icons.'
            }
        ]
    },
    {
        title: 'Trees',
        samples: [
            {
                text: 'Drag and Drop Reordering',
                url: 'tree/reorder.html',
                icon: 'tree-reorder.gif',
                desc: 'A TreePanel loaded asynchronously via a JSON TreeLoader that shows drag and drop with container scroll.'
            },
            {
                text: 'Multiple trees',
                url: 'tree/two-trees.html',
                icon: 'tree-two.gif',
                desc: 'Drag and drop between two different sorted TreePanels.'
            },
            {
                text: 'TreeGrid',
                url: 'tree/treegrid.html',
                icon: 'tree-columns.gif',
                desc: 'The TreeGrid component',
                status: 'updated'
            },
            {
                text: 'Check Tree',
                url: 'tree/check-tree.html',
                icon: 'tree-check.gif',
                desc: 'An example showing simple checkbox selection in a tree.'
            },
            {
                text: 'XML Tree',
                url: 'tree/xml-tree.html',
                icon: 'tree-xml-loader.gif',
                desc: 'A custom TreeLoader implementation that demonstrates loading a tree from an XML document.'
            }
        ]
    },
    {
        title: 'Layout Managers',
        samples: [
            {
                text: 'Layout Browser',
                url:  'layout-browser/layout-browser.html',
                icon: 'layout-browser.gif',
                desc: 'Comprehensive showcase of the standard layout managers as well as several custom and combination layouts and combination examples.'
            },
            {
                text: 'Border Layout',
                url:  'layout/border.html',
                icon: 'border-layout.gif',
                desc: 'A complex BorderLayout implementation that shows nesting multiple components and sub-layouts.',
                status: 'updated'
            },
            {
                text: 'Accordion Layout',
                url:  'layout/accordion.html',
                icon: 'layout-accordion.gif',
                desc: 'A basic accordion layout within a border layout.'
            },
            {
                text: 'Anchor Layout (Form)',
                url:  'form/anchoring.html',
                icon: 'layout-form.gif',
                desc: 'A simple example of form fields utilizing an anchor layout in a window for flexible form resizing.'
            },
            {
                text: 'Anchor Layout (Panel)',
                url:  'layout/anchor.html',
                icon: 'layout-anchor.gif',
                desc: 'An example of Panels anchored in the browser window.'
            },
            {
                text: 'Column Layout',
                url:  'layout/column.html',
                icon: 'layout-column.gif',
                desc: 'An example of Panels managed by a column layout.'
            },
            {
                text: 'Table Layout',
                url:  'layout/table.html',
                icon: 'layout-table.gif',
                desc: 'An example of Panels managed by a table layout.'
            },
            {
               text: 'HBox Layout',
               url:  'layout/hbox.html',
               icon: 'layout-column.gif',
               desc: 'Interactive layout illustrating the capabilities of the HBox Layout.'
            },
            {
                text: 'VBox Layout',
                url:  'layout/vbox.html',
                icon: 'layout-vbox.gif',
                desc: 'Interactive layout illustrating the capabilities of the VBox Layout.'
            },
            {
                text: 'Complex Layout',
                url:  'layout/complex.html',
                icon: 'complex-layout.gif',
                desc: 'A complex layout example.',
                status: 'updated'
            }
        ]
    },
    {
        title: 'Drawing',
        samples: [
            {
                text: 'Resizable Sencha Logo',
                url: 'draw/Sencha.html',
                icon: 'draw-sencha.gif',
                desc: 'Resolution independent Sencha logo in a resizable component.',
                status: 'new'
            },
            {
                text: 'Browser Logos',
                url: 'draw/Logos.html',
                icon: 'draw-logos.gif',
                desc: 'Resolution independent logos of all the popular browsers.',
                status: 'new'
            },
            {
                text: 'Tiger',
                url: 'draw/Tiger.html',
                icon: 'draw-tiger.gif',
                desc: 'The classic SVG Tiger in a floatable, draggable component. Scalable to any size, fully resolution independent.',
                status: 'new'
            },
            {
                text: 'Rotate Text',
                url: 'draw/Rotate Text.html',
                icon: 'draw-rotate-text.gif',
                desc: 'Create text in a Draw Component which can be rotated easily in any browser.',
                status: 'new'
            }
        ]
    },
    {
        title: 'Drag and Drop',
        samples: [
            {
                text: 'Grid to Grid DnD',
                url: 'dd/dnd_grid_to_grid.html',
                icon: 'dd-gridtogrid.gif',
                desc: 'Shows how rows can be easily dragged and dropped between two or more grids'
            },
            {
                text: 'Grid to Form DnD',
                url: 'dd/dnd_grid_to_formpanel.html',
                icon: 'dd-gridtoformpanel.gif',
                desc: 'Enables a user to drag a record from a grid and drop it into a form, where it can be edited'
            },
            {
                text: 'Field to Grid DnD',
                url: 'dd/field-to-grid-dd.html',
                icon: 'dd-fieldtogrid.gif',
                desc: 'Demonstrates dragging a value from a field onto a grid cell'
            },
            {
                text: 'Custom Drag and Drop',
                url: 'dd/dragdropzones.html',
                icon: 'dd-zones.gif',
                desc: 'A completely custom Drag and Drop example showing DnD between a DataView and a grid'
            }
        ]
    },
    {
        title: 'Toolbars and Menus',
        samples: [
            {
                text: 'Basic Toolbar',
                url:  'menu/menus.html',
                icon: 'toolbar.gif',
                desc: 'Toolbar and menus that contain various components like date pickers, color pickers, sub-menus and more.',
                status: 'updated'
            },
            {
                text: 'Toolbar Button Groups',
                url:  'toolbar/toolbars.html',
                icon: 'toolbar-button-groups.gif',
                desc: 'Group buttons together in the toolbar.'
            },
            {
                text: 'Vertical Toolbars',
                url:  'toolbar/vertical-toolbars.html',
                icon: 'toolbar.gif',
                desc: 'Vertical Toolbars on the left and right. Combined vertical and horizontal toolbars.',
                status: 'new'
            },
            {
               text: 'Ext Grid Actions',
               url:  'menu/action-grid.html',
               icon: 'actions-grid.gif',
               desc: 'Bind the same behavior to multiple buttons, toolbar and menu items using the Ext.Action class.',
               status: 'updated'
            },
            {
                text: 'Reorderable Toolbar',
                url:  'toolbar/reorderable.html',
                icon: 'toolbar-reorderable.png',
                desc: 'Items within a toolbar can be reordered using this plugin.'
            },
            {
               text: 'Overflow Toolbar',
               url:  'toolbar/overflow.html',
               icon: 'toolbar-reorderable.png',
               desc: 'Items within a toolbar will be placed into an overflow menu if the toolbar is too narrow.'
            },
            {
                text: 'Status Bar',
                url:  'statusbar/statusbar-demo.html',
                icon: 'statusbar-demo.gif',
                desc: 'A simple StatusBar that can be dropped into the bottom of any panel to display status text and icons.'
            },
            {
                text: 'Status Bar (Advanced)',
                url:  'statusbar/statusbar-advanced.html',
                icon: 'statusbar-adv.gif',
                desc: 'Customizing the StatusBar via a plugin to provide automatic form validation monitoring and error linking.'
            },
            {
                text: 'Ext Toolbar Actions',
                url: 'menu/actions.html',
                icon: 'actions.gif',
                desc: 'Bind the same behavior to multiple buttons, toolbar and menu items using the Ext.Action class.'
            }
            
        ]
    },
    {
        title: 'ComboBox',
        samples: [
            {
                text: 'Basic ComboBox',
                url: 'form/combos.html',
                icon: 'combo.gif',
                desc: 'Basic combos, combos rendered from markup and customized list layout to provide item tooltips.'
            },
            {
                 text: 'ComboBox Templates',
                 url: 'form/forum-search.html',
                 icon: 'combo-custom.gif',
                 desc: 'Customized combo with template-based list rendering, remote loading and paging.'
            }
        ]
    },
    {
        title: 'DataView',
        samples: [{
                text  : 'DataView',
                url: 'view/data-view.html',
                icon  : 'data-view.gif',
                desc  : 'This example shows how to use an Ext.view.View',
                status: 'updated'
            },
            {
                text  : 'Animated DataView',
                url: 'view/animated-dataview.html',
                icon  : 'animated-dataview.png',
                desc  : 'Transition animation plugin applied to a standard DataView'
            },
            {
                text  : 'Multi-sort DataView',
                url: 'view/multisort/multisort.html',
                icon  : 'multisort-dataview.png',
                desc  : 'Example demonstrating the ability to sort a DataView by multiple sorters.'
            },
            {
                text  : 'Advanced DataView',
                url: 'view/chooser/chooser.html',
                icon  : 'advanced-dataview.png',
                desc  : 'DataView which allows you to filter and sort images.'
            }
        ]
    },
    {
        title: 'Forms',
        samples: [
            {
                text: 'Dynamic Forms',
                url: 'form/dynamic.html',
                icon: 'form-dynamic.gif',
                desc: 'Various example forms showing collapsible fieldsets, column layout, nested TabPanels and more.'
            },
            {
                text: 'Ajax with XML Forms',
                url: 'form/xml-form.html',
                icon: 'form-xml.gif',
                desc: 'Ajax-loaded form fields from remote XML data and remote field validation on submit.'
            },
            {
                text: 'Contact Us Form',
                url: 'form/contact-form.html',
                icon: 'form-contact.gif',
                desc: 'An example of a common popup Contact Us form.',
                status: 'new'
            },
            {
                text: 'Custom Search Fields',
                url: 'form/forum-search.html',
                icon: 'form-custom.gif',
                desc: 'A TriggerField search extension combined with an XTemplate for custom results rendering.'
            },
            {
                text: 'Binding a Grid to a Form',
                url:  'form/form-grid.html',
                icon: 'form-grid-binding.gif',
                desc: 'A grid embedded within a FormPanel that automatically loads records into the form on row selection.',
                status: 'updated'
            },
            {
                text: 'Field Types',
                url:  'form/field-types.html',
                icon: 'form-field-types.gif',
                desc: 'This example shows off all of the field types available in Ext JS in lots of different configurations.',
                status: 'updated'
            },
            {
                 text: 'Advanced Validation',
                 url:  'form/adv-vtypes.html',
                 icon: 'form-adv-vtypes.gif',
                 desc: 'Relational form field validation using custom vtypes.'
            },
            {
                 text: 'Checkbox/Radio Groups',
                 url:  'form/check-radio.html',
                 icon: 'form-check-radio.gif',
                 desc: 'Examples showing different checkbox and radio group configurations.'
            },
            {
                text: 'File Upload Field',
                url:  'form/file-upload.html',
                icon: 'form-file-upload.gif',
                desc: 'A demo of how to give standard file upload fields a bit of Ext style using a custom class.',
                status: 'updated'
            },
            {
                text: 'Number Field',
                url:  'form/number.html',
                icon: 'form-spinner.gif',
                desc: 'An example of the Number field, with and without a spinner.',
                status: 'updated'
            },
            {
                text: 'MultiSelect and ItemSelector',
                url:  'multiselect/multiselect-demo.html',
                icon: 'form-multiselect.gif',
                desc: 'Example controls for selecting a list of items in forms.',
                status: 'updated'
            },
            {
                text: 'Registration Form',
                url:  'form/registration.html',
                icon: 'form-registration.gif',
                desc: 'An account registration form, with custom global error message display.',
                status : 'new'
            },
            {
                text: 'Shopping Cart Checkout',
                url:  'form/checkout.html',
                icon: 'form-checkout.gif',
                desc: 'An example of a common shopping cart checkout form.',
                status : 'new'
            },
            {
                text: 'Slider Field',
                url:  'slider/slider-field.html',
                icon: 'form-slider.png',
                desc: 'Example usage of an Ext.Slider to select a number value in a form.'
            },
            {
                text: 'Forms with vBox layout',
                url:  'form/vbox-form.html',
                icon: 'form-vbox.gif',
                desc: 'Example usage of the vBox layout with forms. An added bonus is the FieldReplicator plugin.',
        	    status : 'new'
            },
            {
                text: 'Forms with hBox layout',
                url:  'form/hbox-form.html',
                icon: 'form-hbox.gif',
                desc: 'Example usage of the hBox layout with a form. Includes automatically adjusting validation messages.',
        	    status : 'new'
            },
            {
                 text  : 'Field Containers',
                 url: 'form/fieldcontainer.html',
                 icon  : 'form-fieldcontainer.png',
                 desc  : 'Example usage of the FieldContainer to place several fields on a single form row.',
                 status: 'new'
            },
            {
                text: 'Form with absolute layout',
                url:  'form/absform.html',
                icon: 'form-absolute.gif',
                desc: 'A simple example of form fields utilizing an absolute layout in a window for flexible form resizing.',
                status: 'new'
            },
            {
                text: 'Custom form Field',
                url:  'form/custom-form.html',
                icon: 'form-custom.gif',
                desc: 'A simple example that demonstrate how to create a custom form field.',
                status: 'new'
            }
        ]
    },
    {
        title: 'Direct',
        samples: [
            {
                text: 'Direct',
                url:  'direct/direct.html',
                icon: 'direct.gif',
                desc: 'An example demonstrating Remoting and Polling the server'
            },
            {
                text: 'Direct Form',
                url:  'direct/direct-form.html',
                icon: 'direct.gif',
                desc: 'Ext.Direct Remoting with a Form'
            },
            {
                text: 'Direct Grid',
                url:  'direct/direct-grid.html',
                icon: 'direct.gif',
                desc: 'Ext.Direct Remoting with a Grid'
            },
            {
                text: 'Direct TreeLoader',
                url:  'direct/direct-tree.html',
                icon: 'direct.gif',
                desc: 'Ext.Direct Remoting with a Tree',
                status: 'new'
            },
            {
                text: 'Direct Named Arguments',
                url:  'direct/named-arguments.html',
                icon: 'direct.gif',
                desc: 'Ext.Direct Named Arguments',
                status: 'new'
            }
        ]
    },
    {
        title: 'MVC',
        samples: [
            {
                text: 'Feed Viewer',
                url:  'app/feed-viewer/feed-viewer.html',
                icon: 'feeds.gif',
                desc: 'An MVC application version of the Feed Viewer example. This shows best practice for a small app',
                status: 'new'
            },
            {
                text: 'Nested Loading',
                url:  'app/nested-loading/nested-loading.html',
                icon: 'nested-loading.gif',
                desc: 'An MVC example that shows simple navigation and nested loading with the data package',
                status: 'new'
            }
        ]
    },
    {
        title: 'Miscellaneous',
        samples: [
            {
                text: 'History',
                url: 'history/history.html',
                icon: 'history.gif',
                desc: 'A History manager that allows the user to navigate an Ext UI via browser back/forward.'
            },
            {
                text: 'Google Maps',
                url: 'window/gmap.html',
                icon: 'gmap-panel.gif',
                desc: 'A Google Maps wrapper class that enables easy display of dynamic maps in Ext panels and windows.'
            },
            {
                text: 'Editor',
                url: 'simple-widgets/editor.html',
                icon: 'editor.gif',
                desc: 'An example demonstrating the ease of use of the Ext.editor class to modify DOM elements'
            },
            {
                text: 'Slider',
                url: 'slider/slider.html',
                icon: 'slider.gif',
                desc: 'A slider component that supports vertical mode, snapping, tooltips, customized styles and multiple thumbs.',
                status: 'updated'
            },
            {
                text: 'QuickTips',
                url: 'qtips/qtips.html',
                icon: 'qtips.gif',
                desc: 'Various tooltip and quick tip configuration options including Ajax loading and mouse tracking.',
                status: 'updated'
            },
            {
                text: 'Progress Bar',
                url: 'simple-widgets/progress-bar.html',
                icon: 'progress.gif',
                desc: 'A basic progress bar component shown in various configurations and with custom styles.'
            },
            {
                text: 'Panels',
                url: 'panel/panel.html',
                icon: 'panel.gif',
                desc: 'A basic collapsible panel example.',
                status: 'updated'
            },
            {
                text: 'Resizable',
                url: 'resizer/basic.html',
                icon: 'resizable.gif',
                desc: 'Examples of making any element resizable with various configuration options.'
            },
            {
                text: 'Buttons',
                url: 'button/button.html',
                icon: 'buttons.gif',
                desc: 'Shows buttons in many of their possible configurations'
            },
            {
                text: 'Spotlight',
                url: 'core/spotlight.html',
                icon: 'spotlight.gif',
                desc: 'A utility for masking everything except a single element on the page to visually highlight it.'
            },
            {
                text: 'Keyboard Navigation',
                url: 'keynav/keynav.html',
                icon: 'keyboard.gif',
                desc: 'Shows a custom keyboard navigation using the KeyNav class',
                status: 'new'
            },
            {
                text: 'Localization (static)',
                url: 'locale/dutch-form.html',
                icon: 'locale-dutch.gif',
                desc: 'Demonstrates fully localizing a form by including a custom locale script.'
            },
            {
                text: 'Localization (dynamic)',
                url: 'locale/multi-lang.html',
                icon: 'locale-switch.gif',
                desc: 'Dynamically render various Ext components in different locales by selecting from a locale list.'
            },
            {
                text: 'Browser State Management',
                url: 'state/state.html',
                icon: 'state-saving.gif',
                desc: "An example of storing your application's state.",
                status: 'new'
            },
            {
                text: 'Basic Templating',
                url: 'platform/templates.html',
                icon: 'templates.gif',
                desc: "A basic templating example."
            },
            {
                text: 'Bubble Panel',
                url: 'panel/bubble-panel/bubble-panel.html',
                icon: 'panel-bubble.gif',
                desc: "This is a custom panel UI to achieve a different look and feel while not changing the default appearance of an Ext.Panel.",
                status: 'updated'
            }
        ]
    }
];

