<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet  [
	<!ENTITY nbsp   "&#160;">
  <!ENTITY copy   "&#169;">
]><xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:europass="http://europass.cedefop.europa.eu/Europass/V2.0">
<xsl:template match="/">
<xsl:comment>
  # 
	© European Communities, 2002-2008 http://europass.cedefop.europa.eu
  # http://europass.cedefop.europa.eu/europass/home/botnav/LegalNotice.csp
  # Name      : lp_sv_SE_V2.0.xsl
  # Version   : V2.0
  # Purpose   : Provides a way to show the Europass LP in HTML format.
  # Author(s) : Europass team
  # URL       : http://europass.cedefop.europa.eu/TechnicalResources/XML/xsl/europass-xsl-V2.0/lp_sv_SE_V2.0.xsl
</xsl:comment>
<xsl:variable name="firstNameBefore">
<xsl:choose>
  <xsl:when test="//field[@name='personal.firstName' and @before='personal.lastName']">1</xsl:when>
  <xsl:otherwise>0</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<html>
<head>
  <title>LP - HTML</title>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
  <link href="http://europass.cedefop.europa.eu/instruments/css/html.css" type="text/css" rel="stylesheet"/>
</head>
<body>
  <table class="LP" cellSpacing="0" cellPadding="10" width="740" border="0">
	  <tbody>
	  <tr align="middle">
	    <td width="20%"><img height="53" src="http://europass.cedefop.europa.eu/instruments/images/logos/logo_europass_lp.gif" width="95"/></td>
	    <td style="text-align: center" width="60%">
		  <span class="LabelBold">Europass Språkpass</span>
		  <br/>
		  <span class="Label">Ingår i den Europeiska språkportfolion, som har utvecklats av Europarådet</span>
		</td>
	    <td width="20%"><img height="53" src="http://europass.cedefop.europa.eu/instruments/images/logos/otherlogo_lp.gif" width="95"/></td>
	  </tr>
	  </tbody>
  </table>
  <div class="VerLine_LP">
    <table class="LP" cellSpacing="0" cellPadding="0" width="710" border="0">
    <tbody>
    <tr>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="173"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="516"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="21"/></td>
	</tr>
    <tr>
	  <td class="LabelBold">
	    <xsl:choose>
	      <xsl:when test="$firstNameBefore=0">
	        Efternamn&#160;
	      </xsl:when>
	      <xsl:otherwise>
		    &#160;Efternamn
	      </xsl:otherwise>
	    </xsl:choose>
	  </td>
      <td class="Normal">
	    <xsl:choose>
	      <xsl:when test="$firstNameBefore=0">
            <xsl:value-of select="europass:learnerinfo/identification/lastname" />&#160;<xsl:value-of select="europass:learnerinfo/identification/firstname" />
		  </xsl:when>
	      <xsl:otherwise>
		    <xsl:value-of select="europass:learnerinfo/identification/firstname" />&#160;<xsl:value-of select="europass:learnerinfo/identification/lastname" />
		  </xsl:otherwise>
	    </xsl:choose>
      </td>
      <td>&#160;</td>
	</tr>
    <tr>
      <td colSpan="3"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
	</tr>
    <xsl:if test="//field[@name='personal.birthDate' and @keep='true']">
    <tr>
      <td class="Label">Födelsedatum</td>
      <td class="Normal">
      <xsl:value-of select="substring(europass:learnerinfo/identification/demographics/birthdate, 9, 2)" />/<xsl:value-of select="substring(europass:learnerinfo/identification/demographics/birthdate, 6, 2)" />/<xsl:value-of select="substring(europass:learnerinfo/identification/demographics/birthdate, 1, 4)" />
      </td><td>&#160;</td>
	</tr>
    <tr>
      <td colSpan="3"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
	</tr>
	</xsl:if>
    <tr>
      <td class="Label">Modersmål</td>
      <td class="Normal"><xsl:value-of select="europass:learnerinfo/languagelist/language[@xsi:type='europass:mother']/label" /></td>
      <td>&#160;</td>
	</tr>
    <tr>
      <td colSpan="3"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
	</tr>
    <tr>
      <td class="Label">Annat/andra språk</td>
	  <td class="Normal">
	    <xsl:for-each select="europass:learnerinfo/languagelist/language[@xsi:type='europass:foreign']">
          <xsl:if test="position() != 1">,&#160;</xsl:if>
		  <xsl:value-of select="label" />
	    </xsl:for-each>
	   </td>
      <td>&#160;</td>
	 </tr>
	 </tbody>
     </table>
  </div>
  
  <xsl:for-each select="europass:learnerinfo/languagelist/language[@xsi:type='europass:foreign']">
    <xsl:variable name="indexedLang">
	  <xsl:value-of select="concat('foreignLanguageList[', position()-1, ']')" />
    </xsl:variable>
	
    <br/>
	<div class="VerLine_LP">
    
	<table class="LP" cellSpacing="0" cellPadding="0" width="710" border="0">
    <tbody>
    <tr>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="19"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="25"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="109"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="25"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="109"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="8"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="17"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="108"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="25"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="86"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="23"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="25"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="31"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="79"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="21"/></td>
	</tr>
    <tr>
      <td>&#160;</td>
      <td class="NormalHighlight" colSpan="13"><xsl:value-of select="label" /> </td>
      <td>&#160;</td>
	</tr>
    
	<xsl:if test="//field[@name=concat($indexedLang,'.ass') and @keep='true']">
	<tr>
      <td colSpan="15"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
	</tr>
    <tr>
      <td class="GridHeadingBold" colSpan="14">Självbedömning av språkfärdigheter </td>
      <td>&#160;</td>
	</tr>
    <tr>
      <td>&#160;</td>
      <td class="GridHeadingBold" colSpan="4">Förståelse</td>
      <td class="GridHeadingBold" colSpan="6">Tala</td>
      <td class="GridHeadingBold" colSpan="3">Skriva</td>
      <td>&#160;</td>
	</tr>
    <tr>
      <td>&#160;</td>
      <td class="GridHeading" colspan="2">Höra</td>
      <td class="GridHeading" colspan="2">Läsa</td>
      <td class="GridHeading" colspan="3">Samtal/muntlig interaktion</td>
      <td class="GridHeading" colspan="3">Muntlig produktion</td>
      <td colSpan="3">&#160;</td>
      <td>&#160;</td>
	</tr>
    <tr>
      <td>&#160;</td>
      <td class="NormalCenter"><xsl:value-of select="level/listening" /> </td>
      <td class="NormalCenter">
	    <xsl:if test="level/listening='a1'">Baspresterande språkanvändare</xsl:if>
        <xsl:if test="level/listening='b1'">Självständig språkanvändare</xsl:if>
  	    <xsl:if test="level/listening='c1'">Avancerad språkanvändare</xsl:if>
	    
		<xsl:if test="level/listening='a2'">Baspresterande språkanvändare</xsl:if>
	    <xsl:if test="level/listening='b2'">Självständig språkanvändare</xsl:if>
		<xsl:if test="level/listening='c2'">Avancerad språkanvändare</xsl:if>
	  </td>
      <td class="NormalCenter"><xsl:value-of select="level/reading" /> </td>
      <td class="NormalCenter">
		<xsl:if test="level/reading='a1'">Baspresterande språkanvändare</xsl:if>
		<xsl:if test="level/reading='b1'">Självständig språkanvändare</xsl:if>
		<xsl:if test="level/reading='c1'">Avancerad språkanvändare</xsl:if>
		
		<xsl:if test="level/reading='a2'">Baspresterande språkanvändare</xsl:if>
		<xsl:if test="level/reading='b2'">Självständig språkanvändare</xsl:if>
		<xsl:if test="level/reading='c2'">Avancerad språkanvändare</xsl:if>
	  </td>
      <td class="NormalCenter" colSpan="2"><xsl:value-of select="level/spokeninteraction" /> </td>
      <td class="NormalCenter">
		<xsl:if test="level/spokeninteraction='a1'">Baspresterande språkanvändare</xsl:if>
	    <xsl:if test="level/spokeninteraction='b1'">Självständig språkanvändare</xsl:if>
		<xsl:if test="level/spokeninteraction='c1'">Avancerad språkanvändare</xsl:if>
		
		<xsl:if test="level/spokeninteraction='a2'">Baspresterande språkanvändare</xsl:if>
	    <xsl:if test="level/spokeninteraction='b2'">Självständig språkanvändare</xsl:if>
		<xsl:if test="level/spokeninteraction='c2'">Avancerad språkanvändare</xsl:if>
	  </td>
      <td class="NormalCenter"><xsl:value-of select="level/spokenproduction" /> </td>
      <td class="NormalCenter" colSpan="2">
		<xsl:if test="level/spokenproduction='a1'">Baspresterande språkanvändare</xsl:if>
	    <xsl:if test="level/spokenproduction='b1'">Självständig språkanvändare</xsl:if>
		<xsl:if test="level/spokenproduction='c1'">Avancerad språkanvändare</xsl:if>
		
		<xsl:if test="level/spokenproduction='a2'">Baspresterande språkanvändare</xsl:if>
	    <xsl:if test="level/spokenproduction='b2'">Självständig språkanvändare</xsl:if>
		<xsl:if test="level/spokenproduction='c2'">Avancerad språkanvändare</xsl:if>
	  </td>
	  <td class="NormalCenter"><xsl:value-of select="level/writing" /> </td>
      <td class="NormalCenter" colSpan="2">
		<xsl:if test="level/writing='a1'">Baspresterande språkanvändare</xsl:if>
	    <xsl:if test="level/writing='b1'">Självständig språkanvändare</xsl:if>
		<xsl:if test="level/writing='c1'">Avancerad språkanvändare</xsl:if>
		
		<xsl:if test="level/writing='a2'">Baspresterande språkanvändare</xsl:if>
	    <xsl:if test="level/writing='b2'">Självständig språkanvändare</xsl:if>
		<xsl:if test="level/writing='c2'">Avancerad språkanvändare</xsl:if>
	  </td>
      <td>&#160;</td>
	</tr>
    </xsl:if>
	<tr>
      <td colSpan="15"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
	</tr>
    <tr>
      <td class="GridHeadingBold" colSpan="14">Examensbevis eller slutbetyg </td>
      <td>&#160;</td>
	</tr>
    <tr>
      <td>&#160;</td>
      <td class="GridHeading" colspan="5">Benämning på examensbevis eller slutbetyg</td>
	  <td class="GridHeading" colspan="4">Utfärdande institution</td>
	  <td class="GridHeading" colspan="3">Datum</td>
	  <td class="GridHeading">Europeisk nivå</td>
      <td>&#160;</td>
	</tr>
    
	<xsl:for-each select="diplomalist/diploma">
	  <xsl:variable name="indexedDiploma">
	    <xsl:value-of select="concat('.diplomaList[', position()-1, ']')" />
	  </xsl:variable>
	  <xsl:variable name="indexedBoth">
	    <xsl:value-of select="concat('', $indexedLang, $indexedDiploma)" />
	  </xsl:variable>
	  <xsl:if test="//field[@name=$indexedBoth and @keep='true']">
        <tr>
          <td>&#160;</td>
          <td class="Normal" colSpan="5"><xsl:value-of select="title" /></td>
          <td class="Normal" colSpan="4"><xsl:value-of select="awardingBody" /></td>
          <td class="NormalCenter" colSpan="3">
            <xsl:value-of select="translate(date/day,'-','')" />
            <xsl:if test="string-length(date/day) != 0">/</xsl:if>
            <xsl:value-of select="translate(date/month,'-','')" />
            <xsl:if test="string-length(date/month) != 0">/</xsl:if>
            <xsl:value-of select="translate(date/year,'-','')" />
          </td>
          <td class="NormalCenter"><xsl:value-of select="level" /> </td>
          <td>&#160;</td>
	    </tr>
        <tr>
          <td colSpan="15"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
	    </tr>
	  </xsl:if>
    </xsl:for-each>
  
    <tr>
      <td colSpan="15"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
	</tr>
    <tr>
      <td class="GridHeadingBold" colSpan="14">Språkerfarenhet(er) </td>
      <td>&#160;</td>
	</tr>
    <tr>
      <td>&#160;</td>
      <td class="GridHeading" colspan="9">Beskrivning</td>
	  <td class="GridHeading" colspan="3">Fr.o.m.</td>
	  <td class="GridHeading">T.o.m.</td>
      <td>&#160;</td>
	</tr>
	
    <xsl:for-each select="experiencelist/experience">
	<xsl:variable name="indexedExperience">
	  <xsl:value-of select="concat('.experienceList[', position()-1, ']')" />
	</xsl:variable>
	<xsl:variable name="indexedBoth">
	  <xsl:value-of select="concat('', $indexedLang, $indexedExperience)" />
	</xsl:variable>
    <xsl:if test="//field[@name=$indexedBoth and @keep='true']">
      <tr>
        <td>&#160;</td>
        <td class="Normal" colSpan="9"><xsl:value-of select="description" /></td>
        <td class="NormalCenter" colSpan="3">
          <xsl:value-of select="translate(period/from/day,'-','')" />
		    	<xsl:if test="string-length(period/from/day) != 0">/</xsl:if>
          <xsl:value-of select="translate(period/from/month,'-','')" />
          <xsl:if test="string-length(period/from/month) != 0">/</xsl:if>
          <xsl:value-of select="translate(period/from/year,'-','')" />
	    </td>
        <td class="NormalCenter">
          <xsl:value-of select="translate(period/to/day,'-','')" />
          <xsl:if test="string-length(period/to/day) != 0">/</xsl:if>
          <xsl:value-of select="translate(period/to/month,'-','')" />
          <xsl:if test="string-length(period/to/month) != 0">/</xsl:if>
          <xsl:value-of select="translate(period/to/year,'-','')" />
	    </td>
        <td>&#160;</td>
	  </tr>
      <tr>
        <td colSpan="15"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
      </tr>
	</xsl:if>
	</xsl:for-each>
    <tr>
      <td colSpan="15"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
	</tr>
  
  </tbody>
  </table>
  
  </div>
  </xsl:for-each>
    
  <div class="Asterix">
    (*)Rubriker märkta med en stjärna är valfria.
	(**)Se Skala för självbedömning på baksidan.
	(***)Nivå inom de gemensamma europeiska referensramarna (CEF) om denna anges på det ursprungliga slutbetyget eller examensbeviset.<br/>
  </div>
  <br/>
  <div class="Footnote">
	<b>Förklarande anmärkning</b><br/>
	Europass-språkpasset ingår i den Europeiska språkportfolion som har utvecklats av Europarådet. Den använder de 6 europeiska nivåerna i de gemensamma europeiska referensramarna för språk (CEF) för att i ett standardiserat format registrera nivån på uppnådda språkfärdigheter.<br/>
	Mer information om Europass-språkpasset: http://europass.cedefop.europa.eu - Mer information om den Europeiska språkportfolion: www.coe.int/portfolio<br/>
	Mallen till Europass-språkpasset kan laddas ner kostnadsfritt från ovanstående webbplatser.<br/>
	© Europarådet och Europeiska gemenskaperna, 2004   20060628<br/>
  </div>
  <br/>
  
  <xsl:if test="//field[@name='grid' and @keep='true']">
  <table width="710" border="0" cellspacing="0" cellpadding="0" class="Grid">
	<tr class="spacer">
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="20" height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
	</tr>
	<tr>
		<th colspan="6" class="title">Europeiska nivåer – Skala för självbedömning</th>
	</tr>
	<tr class="level">
		<th>A1</th>
		<td>Jag kan känna igen vanliga ord och mycket enkla fraser som gäller mig själv, min familj och min direkta omgivning, men bara när man talar till mig sakta och tydligt.</td>
		<td>Jag kan förstå vanliga namn, ord och mycket enkla meningar, t.ex. på anslag och affischer eller i kataloger.</td>
		<td>Jag kan samtala på ett enkelt sätt under förutsättning att den andra personen är beredd att tala långsamt och upprepa eller formulera om vad som sagts eller hjälpa mig att formulera vad jag själv vill säga. Jag kan ställa och besvara enkla frågor av omedelbart intresse eller inom vanliga ämnesområden.</td>
		<td>Jag kan använda enkla fraser och meningar för att beskriva var jag bor och människor jag känner.</td>
		<td>Jag kan skriva korta, enkla meddelanden, t.ex. ett vykort med hälsningar. Jag kan fylla i personliga uppgifter som namn, adress och nationalitet i enklare formulär.</td>
	</tr>
	<tr class="level">
		<th>A2</th>
		<td>Jag kan förstå fraser och mycket vanliga ord som gäller mina personliga förhållanden, t.ex. information om mig själv och min familj, närmiljö och vardagliga sysselsättningar samt anställning. Jag kan uppfatta huvudinnehållet i korta, tydliga och enkla budskap och meddelanden.</td>
		<td>Jag kan läsa mycket korta och enkla texter. Jag kan hitta viss information jag behöver i enkelt och vardagligt material som annonser, prospekt, matsedlar och tidtabeller. Jag kan förstå korta och enkla personliga brev.</td>
		<td>Jag kan delta i samtal och rutinuppgifter som kräver ett enkelt och direkt utbyte av information om välkända ämnen och sysselsättningar. Jag kan fungera i mycket korta sociala samtal, men jag förstår i allmänhet inte tillräckligt för att själv hålla liv i samtalet.</td>
		<td>Jag kan använda en rad fraser och meningar för att med enkla medel beskriva min familj och andra människor, människors levnadsvillkor, min utbildning och mina nuvarande och tidigare arbetsuppgifter.</td>
		<td>Jag kan skriva korta, enkla meddelanden och föra enkla anteckningar. Jag kan skriva ett mycket enkelt personligt brev, t.ex. för att tacka någon för något.</td>
	</tr>
	<tr class="level">
		<th>B1</th>
		<td>Jag kan förstå huvudinnehållet i tydligt standardtal om välkända företeelser som man regelbundet stöter på i arbete, i skola, på fritid, osv. Om språket talas relativt långsamt och tydligt kan jag i stora drag förstå många radio- och TV-program om dagsaktuella frågor eller om ämnen av personligt intresse.</td>
		<td>Jag kan förstå texter som till största delen består av högfrekvent språk som hör till vardag och arbete. Jag kan förstå beskrivningar av händelser, känslor och önskemål i personliga brev.</td>
		<td>Jag kan fungera i de flesta situationer som kan uppstå vid resor i länder eller områden där språket talas. Jag kan utan förberedelser gå in i ett samtal om ämnen av personligt intresse eller med anknytning till vardagslivet, t.ex. familj, fritidsintressen, arbete, resor och aktuella händelser.</td>
		<td>Jag kan binda samman fraser på ett enkelt sätt för att beskriva erfarenheter och händelser, mina drömmar, förhoppningar och framtidsplaner. Jag kan kortfattat ge skäl och förklaringar för mina åsikter och planer. Jag kan berätta en historia eller återberätta händelseförloppet i en bok eller film och beskriva mina intryck.</td>
		<td>Jag kan skriva enkel, sammanhängande text om ämnen som är välkända för mig eller av personligt intresse. Jag kan skriva personliga brev som beskriver upplevelser och intryck.</td>
	</tr>
	<tr class="level">
		<th>B2</th>
		<td>Jag kan förstå längre framställningar i t.ex. föreläsningar samt följa med i mer komplicerad argumentation, dock under förutsättning att ämnet är någorlunda bekant. Jag kan förstå det mesta i nyheter och aktuella program på TV. Jag kan förstå de flesta filmer där det talas standardspråk.</td>
		<td>Jag kan läsa artiklar och rapporter som behandlar aktuella problem och som uttrycker attityder och åsikter. Jag kan förstå samtida litterär prosa.</td>
		<td>Jag kan samtala och diskutera så pass flytande och ledigt att jag kan umgås med infödda på ett naturligt sätt. Jag kan ta aktiv del i diskussioner om välkända ämnen och förklara och försvara mina åsikter.</td>
		<td>Jag kan klart och detaljerat beskriva förhållanden inom mina intresse- och erfarenhetsområden. Jag kan förklara en ståndpunkt och ange för- och nackdelar med olika alternativ.</td>
		<td>Jag kan skriva klar och detaljerad text inom mina intresseområden. Jag kan skriva en uppsats eller rapport som förmedlar information eller ger skäl för eller emot en viss ståndpunkt. Jag kan skriva brev som framhäver den personliga innebörden av händelser och erfarenheter.</td>
	</tr>
	<tr class="level">
		<th>C1</th>
		<td>Jag kan förstå mer utvecklat språk även när det inte är klart strukturerat och sammanhanget enbart antyds utan att klart uttryckas. Jag kan förstå TV-program och filmer utan alltför stor ansträngning.</td>
		<td>Jag kan förstå långa och komplicerade faktatexter liksom litterära texter och jag uppfattar skillnader i stil. Jag kan förstå fackartiklar och längre instruktioner även inom områden som ligger utanför mina intressen och erfarenheter.</td>
		<td>Jag kan uttrycka mig flytande och spontant utan att alltför tydligt söka efter rätt uttryck. Jag kan använda språket flexibelt och effektivt för sociala, intresse- och yrkesanknutna ändamål. 
Jag kan formulera idéer och åsikter med viss precision samt med viss skicklighet anpassa mig efter den person jag talar med.</td>
		<td>Jag kan klart och detaljerat beskriva komplicerade ämnesområden med sidoteman och anknytningar. Jag kan utveckla speciella aspekter samt runda av framställningen med en konsekvent slutsats.</td>
		<td>Jag kan uttrycka mig i klar och väl strukturerad text med utförligt angivna synpunkter och förklaringar. Jag kan skriva om komplicerade förhållanden i ett brev, en uppsats eller en rapport och argumentera för vad jag anser är viktigt. Jag kan välja en stil som är anpassad till den tänkte läsaren.</td>
	</tr>
	<tr class="level">
		<th>C2</th>
		<td>Jag har inga svårigheter att förstå något slags talat språk, vare sig i direktkontakt eller via radio, TV och film. Jag förstår även tal i högt tempo som det talas av en infödd under förutsättning att jag hunnit vänja mig vid den regionala variationen i språket.</td>
		<td>Jag kan utan ansträngning läsa praktiskt taget allt skrivet språk, även abstrakta texter som är strukturellt och språkligt komplicerade, t.ex. manualer, fackartiklar eller litterära verk.</td>
		<td>Jag kan utan ansträngning ta del i vilka samtal och diskussioner som helst och därvid effektivt välja vardagliga och idiomatiska uttryck. Jag kan uttrycka mig flytande och överföra nyanser med viss precision. 
Om jag ändå får svårigheter kan jag med omformuleringar kringgå dessa så smidigt att andra knappast märker det.</td>
		<td>Jag kan presentera en klar och flytande beskrivning eller argumentation som i stil passar sammanhanget. Jag kan presentera en effektiv logisk struktur som hjälper mottagaren att lägga märke till och minnas viktiga punkter.</td>
		<td>Jag kan skriva klar och flytande text i en stil som passar tillfället. Jag kan skriva komplexa brev, rapporter eller artiklar som presenterar ett ämne på ett logiskt och effektivt sätt som hjälper läsaren att lägga märke till och minnas viktiga punkter. Jag kan skriva sammanfattningar och översikter över facktexter eller litterära verk.</td>
	</tr>
  </table>
  </xsl:if>
  <img style="display: none" src="http://europass.cedefop.europa.eu/instruments/images/cv_verline.gif"/> <img style="display: none" src="http://europass.cedefop.europa.eu/instruments/images/logos/logo_for_htmlpreview.gif"/>
  <img style="display: none" src="http://europass.cedefop.europa.eu/instruments/images/bg_win4.jpg"/> 
</body>
</html>
  </xsl:template>
</xsl:stylesheet>
