<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet  [
	<!ENTITY nbsp   "&#160;">
  <!ENTITY copy   "&#169;">
]><xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:europass="http://europass.cedefop.europa.eu/Europass/V2.0">
<xsl:template match="/">
<xsl:comment>
  # 
	© European Communities, 2002-2008 http://europass.cedefop.europa.eu
  # http://europass.cedefop.europa.eu/europass/home/botnav/LegalNotice.csp
  # Name      : lp_lt_LT_V2.0.xsl
  # Version   : V2.0
  # Purpose   : Provides a way to show the Europass LP in HTML format.
  # Author(s) : Europass team
  # URL       : http://europass.cedefop.europa.eu/TechnicalResources/XML/xsl/europass-xsl-V2.0/lp_lt_LT_V2.0.xsl
</xsl:comment>
<xsl:variable name="firstNameBefore">
<xsl:choose>
  <xsl:when test="//field[@name='personal.firstName' and @before='personal.lastName']">1</xsl:when>
  <xsl:otherwise>0</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<html>
<head>
  <title>LP - HTML</title>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
  <link href="http://europass.cedefop.europa.eu/instruments/css/html.css" type="text/css" rel="stylesheet"/>
</head>
<body>
  <table class="LP" cellSpacing="0" cellPadding="10" width="740" border="0">
	  <tbody>
	  <tr align="middle">
	    <td width="20%"><img height="53" src="http://europass.cedefop.europa.eu/instruments/images/logos/logo_europass_lp.gif" width="95"/></td>
	    <td style="text-align: center" width="60%">
		  <span class="LabelBold">Europass kalbų pasas</span>
		  <br/>
		  <span class="Label">Europos kalbų aplanko, kurį parengė Europos Taryba, dalis</span>
		</td>
	    <td width="20%"><img height="53" src="http://europass.cedefop.europa.eu/instruments/images/logos/otherlogo_lp.gif" width="95"/></td>
	  </tr>
	  </tbody>
  </table>
  <div class="VerLine_LP">
    <table class="LP" cellSpacing="0" cellPadding="0" width="710" border="0">
    <tbody>
    <tr>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="173"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="516"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="21"/></td>
	</tr>
    <tr>
	  <td class="LabelBold">
	    <xsl:choose>
	      <xsl:when test="$firstNameBefore=0">
	        Pavardė (-ės)&#160;
	      </xsl:when>
	      <xsl:otherwise>
		    &#160;Pavardė (-ės)
	      </xsl:otherwise>
	    </xsl:choose>
	  </td>
      <td class="Normal">
	    <xsl:choose>
	      <xsl:when test="$firstNameBefore=0">
            <xsl:value-of select="europass:learnerinfo/identification/lastname" />&#160;<xsl:value-of select="europass:learnerinfo/identification/firstname" />
		  </xsl:when>
	      <xsl:otherwise>
		    <xsl:value-of select="europass:learnerinfo/identification/firstname" />&#160;<xsl:value-of select="europass:learnerinfo/identification/lastname" />
		  </xsl:otherwise>
	    </xsl:choose>
      </td>
      <td>&#160;</td>
	</tr>
    <tr>
      <td colSpan="3"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
	</tr>
    <xsl:if test="//field[@name='personal.birthDate' and @keep='true']">
    <tr>
      <td class="Label">Gimimo data</td>
      <td class="Normal">
      <xsl:value-of select="substring(europass:learnerinfo/identification/demographics/birthdate, 9, 2)" />/<xsl:value-of select="substring(europass:learnerinfo/identification/demographics/birthdate, 6, 2)" />/<xsl:value-of select="substring(europass:learnerinfo/identification/demographics/birthdate, 1, 4)" />
      </td><td>&#160;</td>
	</tr>
    <tr>
      <td colSpan="3"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
	</tr>
	</xsl:if>
    <tr>
      <td class="Label">Gimtoji kalba (-os)</td>
      <td class="Normal"><xsl:value-of select="europass:learnerinfo/languagelist/language[@xsi:type='europass:mother']/label" /></td>
      <td>&#160;</td>
	</tr>
    <tr>
      <td colSpan="3"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
	</tr>
    <tr>
      <td class="Label">Kita kalba (-os)</td>
	  <td class="Normal">
	    <xsl:for-each select="europass:learnerinfo/languagelist/language[@xsi:type='europass:foreign']">
          <xsl:if test="position() != 1">,&#160;</xsl:if>
		  <xsl:value-of select="label" />
	    </xsl:for-each>
	   </td>
      <td>&#160;</td>
	 </tr>
	 </tbody>
     </table>
  </div>
  
  <xsl:for-each select="europass:learnerinfo/languagelist/language[@xsi:type='europass:foreign']">
    <xsl:variable name="indexedLang">
	  <xsl:value-of select="concat('foreignLanguageList[', position()-1, ']')" />
    </xsl:variable>
	
    <br/>
	<div class="VerLine_LP">
    
	<table class="LP" cellSpacing="0" cellPadding="0" width="710" border="0">
    <tbody>
    <tr>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="19"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="25"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="109"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="25"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="109"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="8"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="17"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="108"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="25"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="86"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="23"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="25"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="31"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="79"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="21"/></td>
	</tr>
    <tr>
      <td>&#160;</td>
      <td class="NormalHighlight" colSpan="13"><xsl:value-of select="label" /> </td>
      <td>&#160;</td>
	</tr>
    
	<xsl:if test="//field[@name=concat($indexedLang,'.ass') and @keep='true']">
	<tr>
      <td colSpan="15"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
	</tr>
    <tr>
      <td class="GridHeadingBold" colSpan="14">Kalbos mokėjimo įsivertinimas </td>
      <td>&#160;</td>
	</tr>
    <tr>
      <td>&#160;</td>
      <td class="GridHeadingBold" colSpan="4">Supratimas</td>
      <td class="GridHeadingBold" colSpan="6">Kalbėjimas</td>
      <td class="GridHeadingBold" colSpan="3">Rašymas</td>
      <td>&#160;</td>
	</tr>
    <tr>
      <td>&#160;</td>
      <td class="GridHeading" colspan="2">Klausymas</td>
      <td class="GridHeading" colspan="2">Skaitymas</td>
      <td class="GridHeading" colspan="3">Bendravimas žodžiu</td>
      <td class="GridHeading" colspan="3">Informacijos pateikimas žodžiu</td>
      <td colSpan="3">&#160;</td>
      <td>&#160;</td>
	</tr>
    <tr>
      <td>&#160;</td>
      <td class="NormalCenter"><xsl:value-of select="level/listening" /> </td>
      <td class="NormalCenter">
	    <xsl:if test="level/listening='a1'">Pradedantis vartotojas</xsl:if>
        <xsl:if test="level/listening='b1'">Pažengęs vartotojas</xsl:if>
  	    <xsl:if test="level/listening='c1'">Įgudęs vartotojas</xsl:if>
	    
		<xsl:if test="level/listening='a2'">Pradedantis vartotojas</xsl:if>
	    <xsl:if test="level/listening='b2'">Pažengęs vartotojas</xsl:if>
		<xsl:if test="level/listening='c2'">Įgudęs vartotojas</xsl:if>
	  </td>
      <td class="NormalCenter"><xsl:value-of select="level/reading" /> </td>
      <td class="NormalCenter">
		<xsl:if test="level/reading='a1'">Pradedantis vartotojas</xsl:if>
		<xsl:if test="level/reading='b1'">Pažengęs vartotojas</xsl:if>
		<xsl:if test="level/reading='c1'">Įgudęs vartotojas</xsl:if>
		
		<xsl:if test="level/reading='a2'">Pradedantis vartotojas</xsl:if>
		<xsl:if test="level/reading='b2'">Pažengęs vartotojas</xsl:if>
		<xsl:if test="level/reading='c2'">Įgudęs vartotojas</xsl:if>
	  </td>
      <td class="NormalCenter" colSpan="2"><xsl:value-of select="level/spokeninteraction" /> </td>
      <td class="NormalCenter">
		<xsl:if test="level/spokeninteraction='a1'">Pradedantis vartotojas</xsl:if>
	    <xsl:if test="level/spokeninteraction='b1'">Pažengęs vartotojas</xsl:if>
		<xsl:if test="level/spokeninteraction='c1'">Įgudęs vartotojas</xsl:if>
		
		<xsl:if test="level/spokeninteraction='a2'">Pradedantis vartotojas</xsl:if>
	    <xsl:if test="level/spokeninteraction='b2'">Pažengęs vartotojas</xsl:if>
		<xsl:if test="level/spokeninteraction='c2'">Įgudęs vartotojas</xsl:if>
	  </td>
      <td class="NormalCenter"><xsl:value-of select="level/spokenproduction" /> </td>
      <td class="NormalCenter" colSpan="2">
		<xsl:if test="level/spokenproduction='a1'">Pradedantis vartotojas</xsl:if>
	    <xsl:if test="level/spokenproduction='b1'">Pažengęs vartotojas</xsl:if>
		<xsl:if test="level/spokenproduction='c1'">Įgudęs vartotojas</xsl:if>
		
		<xsl:if test="level/spokenproduction='a2'">Pradedantis vartotojas</xsl:if>
	    <xsl:if test="level/spokenproduction='b2'">Pažengęs vartotojas</xsl:if>
		<xsl:if test="level/spokenproduction='c2'">Įgudęs vartotojas</xsl:if>
	  </td>
	  <td class="NormalCenter"><xsl:value-of select="level/writing" /> </td>
      <td class="NormalCenter" colSpan="2">
		<xsl:if test="level/writing='a1'">Pradedantis vartotojas</xsl:if>
	    <xsl:if test="level/writing='b1'">Pažengęs vartotojas</xsl:if>
		<xsl:if test="level/writing='c1'">Įgudęs vartotojas</xsl:if>
		
		<xsl:if test="level/writing='a2'">Pradedantis vartotojas</xsl:if>
	    <xsl:if test="level/writing='b2'">Pažengęs vartotojas</xsl:if>
		<xsl:if test="level/writing='c2'">Įgudęs vartotojas</xsl:if>
	  </td>
      <td>&#160;</td>
	</tr>
    </xsl:if>
	<tr>
      <td colSpan="15"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
	</tr>
    <tr>
      <td class="GridHeadingBold" colSpan="14">Diplomai ar pažymėjimai </td>
      <td>&#160;</td>
	</tr>
    <tr>
      <td>&#160;</td>
      <td class="GridHeading" colspan="5">Diplomo (-ų) ar pažymėjimo (-ų) pavadinimas</td>
	  <td class="GridHeading" colspan="4">Išduodanti institucija</td>
	  <td class="GridHeading" colspan="3">Metai</td>
	  <td class="GridHeading">Europos lygmuo</td>
      <td>&#160;</td>
	</tr>
    
	<xsl:for-each select="diplomalist/diploma">
	  <xsl:variable name="indexedDiploma">
	    <xsl:value-of select="concat('.diplomaList[', position()-1, ']')" />
	  </xsl:variable>
	  <xsl:variable name="indexedBoth">
	    <xsl:value-of select="concat('', $indexedLang, $indexedDiploma)" />
	  </xsl:variable>
	  <xsl:if test="//field[@name=$indexedBoth and @keep='true']">
        <tr>
          <td>&#160;</td>
          <td class="Normal" colSpan="5"><xsl:value-of select="title" /></td>
          <td class="Normal" colSpan="4"><xsl:value-of select="awardingBody" /></td>
          <td class="NormalCenter" colSpan="3">
            <xsl:value-of select="translate(date/day,'-','')" />
            <xsl:if test="string-length(date/day) != 0">/</xsl:if>
            <xsl:value-of select="translate(date/month,'-','')" />
            <xsl:if test="string-length(date/month) != 0">/</xsl:if>
            <xsl:value-of select="translate(date/year,'-','')" />
          </td>
          <td class="NormalCenter"><xsl:value-of select="level" /> </td>
          <td>&#160;</td>
	    </tr>
        <tr>
          <td colSpan="15"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
	    </tr>
	  </xsl:if>
    </xsl:for-each>
  
    <tr>
      <td colSpan="15"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
	</tr>
    <tr>
      <td class="GridHeadingBold" colSpan="14">Bendravimo patirtis </td>
      <td>&#160;</td>
	</tr>
    <tr>
      <td>&#160;</td>
      <td class="GridHeading" colspan="9">Apibūdinimas</td>
	  <td class="GridHeading" colspan="3">Nuo</td>
	  <td class="GridHeading">Iki</td>
      <td>&#160;</td>
	</tr>
	
    <xsl:for-each select="experiencelist/experience">
	<xsl:variable name="indexedExperience">
	  <xsl:value-of select="concat('.experienceList[', position()-1, ']')" />
	</xsl:variable>
	<xsl:variable name="indexedBoth">
	  <xsl:value-of select="concat('', $indexedLang, $indexedExperience)" />
	</xsl:variable>
    <xsl:if test="//field[@name=$indexedBoth and @keep='true']">
      <tr>
        <td>&#160;</td>
        <td class="Normal" colSpan="9"><xsl:value-of select="description" /></td>
        <td class="NormalCenter" colSpan="3">
          <xsl:value-of select="translate(period/from/day,'-','')" />
		    	<xsl:if test="string-length(period/from/day) != 0">/</xsl:if>
          <xsl:value-of select="translate(period/from/month,'-','')" />
          <xsl:if test="string-length(period/from/month) != 0">/</xsl:if>
          <xsl:value-of select="translate(period/from/year,'-','')" />
	    </td>
        <td class="NormalCenter">
          <xsl:value-of select="translate(period/to/day,'-','')" />
          <xsl:if test="string-length(period/to/day) != 0">/</xsl:if>
          <xsl:value-of select="translate(period/to/month,'-','')" />
          <xsl:if test="string-length(period/to/month) != 0">/</xsl:if>
          <xsl:value-of select="translate(period/to/year,'-','')" />
	    </td>
        <td>&#160;</td>
	  </tr>
      <tr>
        <td colSpan="15"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
      </tr>
	</xsl:if>
	</xsl:for-each>
    <tr>
      <td colSpan="15"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
	</tr>
  
  </tbody>
  </table>
  
  </div>
  </xsl:for-each>
    
  <div class="Asterix">
    (*)Informacija žvaigždute pažymėtose eilutėse yra neprivaloma
	(**)Žr. įsivertinimo lentelę kitame puslapyje
	(***)Lygmuo pagal Bendruosius kalbų metmenis Europoje, jei nurodyta pažymėjimo ar diplomo originale.<br/>
  </div>
  <br/>
  <div class="Footnote">
	<b>Paaiškinimas</b><br/>
	Europass kalbų pasas yra Europos kalbų aplanko, kurį parengė Europos Taryba, dalis. Siekiant kalbinius gebėjimus apibūdinti standartine forma, naudojama 6 Europinių lygių skalė, kuri yra pateikta dokumente "Bendrieji kalbų metmenys Europoje".<br/>
	Daugiau informacijos apie Europass kalbų pasą pateikiama adresu: http://europass.cedefop.europa.eu - Daugiau informacijos apie Europos kalbų aplanką pateikiama adresu: www.coe.int/portfolio<br/>
	Europass kalbų paso formą galima nemokamai parsisiųsti iš minėtų tinklalapių.<br/>
	© Europos Taryba ir Europos Bendrijos, 2004   20060628<br/>
  </div>
  <br/>
  
  <xsl:if test="//field[@name='grid' and @keep='true']">
  <table width="710" border="0" cellspacing="0" cellpadding="0" class="Grid">
	<tr class="spacer">
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="20" height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
	</tr>
	<tr>
		<th colspan="6" class="title">Europos  lygmenys – įsivertinimo lentelė</th>
	</tr>
	<tr class="level">
		<th>A1</th>
		<td>Gebu suprasti žinomus žodžius ir pačias bendriausias frazes apie save, šeimą bei artimiausią aplinką, jeigu žmonės kalba lėtai ir aiškiai.</td>
		<td>Gebu suprasti įprastinius pavadinimus, žodžius ir labai paprastus sakinius, pvz., iš skelbimų, plakatų ar katalogų.</td>
		<td>Gebu bendrauti paprasta kalba, jeigu pašnekovas pasirengęs pakartoti ar perfrazuoti, pasakyti lėčiau ir padėti suformuluoti mintį. Gebu klausti ir atsakyti į paprastus klausimus apie būtiniausius poreikius arba gerai žinomus dalykus.</td>
		<td>Gebu vartoti paprastas frazes ir sakinius gyvenamajai vietai ir pažįstamiems žmonėms apibūdinti.</td>
		<td>Gebu užrašyti paprastą, trumpą tekstą ant atviruko, pvz., šventinį sveikinimą. Gebu į nustatytos formos dokumentus įrašyti asmens duomenis, pvz., viešbučio registracijos lapelyje įrašyti savo pavardę, tautybę, adresą.</td>
	</tr>
	<tr class="level">
		<th>A2</th>
		<td>Gebu suprasti frazes ir dažniausiai vartojamus žodžius, susijusius su būtiniausiomis reikmėmis, pvz.:  paprastą informaciją apie asmenį ir šeimą, apsipirkimą,  gyvenamąją vietą, įsidarbinimą. Suprantu trumpų, aiškių ir paprastų žinučių bei skelbimų prasmę.</td>
		<td>Gebu skaityti labai trumpus, paprastus tekstus. Gebu rasti specifinę, numatomą informaciją paprastuose kasdieniuose tekstuose: skelbimuose, reklaminiuose lapeliuose, meniu, tvarkaraščiuose, ir gebu suprasti trumpus, paprastus asmeninius laiškus.</td>
		<td>Gebu bendrauti atlikdamas (-a) įprastines nesudėtingas užduotis, kai reikia tiesiogiai pasikeisti informacija gerai žinomomis temomis. Gebu kalbėti trumpais sakiniais buitinėmis temomis, nors ne visada suprantu tiek, kad galėčiau palaikyti pokalbį.</td>
		<td>
	Gebu vartoti paprastų frazių ir sakinių rinkinį apibūdindamas (-a) savo šeimą ir kitus žmones, gyvenimo sąlygas, savo išsilavinimą ir dabartinį arba buvusį darbą.</td>
		<td>Gebu rašyti trumpas, paprastas pastabas ar žinutes. Gebu parašyti labai paprastą asmeninį laišką, pvz., kam nors už ką nors padėkoti.</td>
	</tr>
	<tr class="level">
		<th>B1</th>
		<td>
	Gebu suprasti esmę, kai aiškiai kalbama bendrine kalba gerai žinomomis temomis, kuriomis tenka bendrauti darbe, mokykloje, poilsiaujant ir pan. Gebu suprasti daugelio radijo ir televizijos laidų apie kasdienius dalykus, asmeninėmis ar profesinėmis temomis esmę, kai kalbėjimo tempas santykinai lėtas, o tarimas aiškus.</td>
		<td>
	Gebu suprasti tekstus, kuriuose daug dažnai vartojamų žodžių ir gramatinių formų bei konstrukcijų, susijusių su kasdieniu gyvenimu ar darbu. Gebu suprasti įvykių, jausmų ir norų aprašymus asmeniniuose laiškuose.</td>
		<td>Gebu bendrauti daugelyje situacijų, į kurias galiu patekti keliaudamas po šalį, kurioje kalbama ta kalba. Gebu nepasirengęs įsitraukti į pokalbį žinomomis, dominančiomis arba kasdienio gyvenimo temomis, pvz., apie šeimą, pomėgius, darbą, keliones ir naujausius įvykius.</td>
		<td>Gebu paprastai sieti frazes, kad apibūdinčiau patirtį, įvykius, svajones, viltis ir siekius. Gebu trumpai pateikti nuomonių ir planų priežastis ir paaiškinimus. Gebu pasakoti arba atpasakoti knygos ar filmo siužetą, išreikšti savo požiūrį.</td>
		<td>Gebu parašyti paprastą rišlų tekstą gerai žinomomis ar dominančiomis temomis. Gebu rašyti asmeninius laiškus, apibūdinti patirtį ir įspūdžius.</td>
	</tr>
	<tr class="level">
		<th>B2</th>
		<td>
	Gebu suprasti išplėtotą kalbą ir paskaitas bei sekti net sudėtingą samprotavimą, jeigu tema neblogai žinoma. Gebu suprasti daugumą TV žinių ir laidų apie kasdienius dalykus. Gebu suprasti daugumą filmų bendrine kalba.</td>
		<td>Gebu skaityti straipsnius ir pranešimus, kuriuose keliamos šiuolaikinės problemos, reiškiamas tam tikras rašytojo požiūris ir nuomonė. Gebu suprasti šiuolaikinę prozą.</td>
		<td>Gebu gana laisvai ir spontaniškai bendrauti, todėl galiu normaliai bendrauti su asmenimis, kuriems ta kalba yra gimtoji. Gebu aktyviai dalyvauti diskusijose, kurių kontekstas gerai žinomas, pateikti ir pagrįsti savo nuomonę.</td>
		<td>Gebu aiškiai, detaliai apibūdinti daug dalykų, susijusių su savo interesų sfera. Gebu paaiškinti požiūrį į tam tikrą sritį, pateikti įvairių nuomonių privalumus ir trūkumus.</td>
		<td>
	Gebu parašyti aiškų detalų tekstą daugeliu temų, susijusių su mano interesais. Gebu parašyti rašinį ar ataskaitą ir pateikti duomenis ar priežastis, kurios paremia ar paneigia tam tikrą požiūrį. Gebu rašyti laiškus ir pabrėžti įvykių ir patirties svarbą man.</td>
	</tr>
	<tr class="level">
		<th>C1</th>
		<td>Gebu suprasti išplėtotą kalbą, net jei jos struktūra nėra visiškai aiški, o ryšiai tik numanomi, bet nepateikiami akivaizdžiai. Gebu be didelių pastangų suprasti televizijos programas ir filmus.</td>
		<td>Gebu suprasti ilgus ir sudėtingus informacinius ar grožinės literatūros tekstus, suvokti stilių skirtumus. Gebu suprasti specializuotus straipsnius ir ilgesnes technines instrukcijas, net jei jie nesusiję su mano veiklos sritimi.</td>
		<td>Gebu bendrauti laisvai ir spontaniškai beveik neieškodamas (-a)  posakių. Gebu veiksmingai ir lanksčiai vartoti kalbą socialiniais ir profesiniais tikslais. Gebu tiksliai formuluoti idėjas ir nuomones, sumaniai susieti savo ir  pašnekovų nuomones.</td>
		<td>
	Gebu aiškiai, detaliai apibūdinti sudėtingus reiškinius, sujungti smulkesnes temas, išskirti specifinius aspektus bei apibendrinti, pateikdamas atitinkamas išvadas.</td>
		<td>
	Gebu išreikšti savo mintis aiškiais ir gerai struktūrizuotais tekstais bei gana išsamiai apibūdinti savo požiūrį. Gebu rašyti apie sudėtingus dalykus laiškuose, rašiniuose ir ataskaitose, pabrėžti, mano nuomone, svarbiausius dalykus. Gebu rašyti įvairius tekstus, atsižvelgdamas (-a) į skaitytoją.</td>
	</tr>
	<tr class="level">
		<th>C2</th>
		<td>Nesunkiai suprantu bet kokią sakytinės kalbos atmainą, tiek girdimą tiesiogiai, tiek transliuojamą, net kai kalbama natūraliai greitu tempu, jeigu turiu šiek tiek laiko priprasti prie akcento.</td>
		<td>
	Gebu lengvai skaityti beveik visų rašytinės kalbos atmainų tekstus: santraukas, struktūriškai ar kalbos atžvilgiu sudėtingus tekstus, pvz.: vadovėlius, specialybės straipsnius ar grožinės literatūros tekstus.</td>
		<td>Gebu be pastangų dalyvauti bet kuriame pokalbyje ir diskutuoti vartodamas (-a) idiomas ir šnekamosios kalbos posakius. Gebu laisvai reikšti mintis, tiksliai perteikti reikšmių atspalvius. Jei iškyla sunkumų, gebu pradėti iš naujo ir lengvai persakyti kitaip, kad pašnekovas net nepastebėtų sutrikimo.</td>
		<td>Gebu aiškiai ir sklandžiai apibūdinti ar argumentuoti, pasirinkdamas stilių, kuris atitinka situaciją ir tinkamą, logišką struktūrą, todėl pašnekovas gali pastebėti ir įsiminti svarbiausius dalykus.</td>
		<td>Gebu parašyti aiškų, sklandų tinkamo stiliaus tekstą. Gebu rašyti sudėtingus laiškus, ataskaitas ar straipsnius, kuriuose aiškiai išdėstyta tema, jie yra tinkamos, logiškos struktūros, todėl skaitytojas gali pastebėti ir įsiminti svarbiausius dalykus. Gebu rašyti specialybės ar grožinės literatūros tekstų santraukas ir apžvalgas.</td>
	</tr>
  </table>
  </xsl:if>
  <img style="display: none" src="http://europass.cedefop.europa.eu/instruments/images/cv_verline.gif"/> <img style="display: none" src="http://europass.cedefop.europa.eu/instruments/images/logos/logo_for_htmlpreview.gif"/>
  <img style="display: none" src="http://europass.cedefop.europa.eu/instruments/images/bg_win4.jpg"/> 
</body>
</html>
  </xsl:template>
</xsl:stylesheet>
