<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet  [
	<!ENTITY nbsp   "&#160;">
  <!ENTITY copy   "&#169;">
]><xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:europass="http://europass.cedefop.europa.eu/Europass/V2.0">
<xsl:template match="/">
<xsl:comment>
  # 
	© European Communities, 2002-2008 http://europass.cedefop.europa.eu
  # http://europass.cedefop.europa.eu/europass/home/botnav/LegalNotice.csp
  # Name      : lp_fi_FI_V2.0.xsl
  # Version   : V2.0
  # Purpose   : Provides a way to show the Europass LP in HTML format.
  # Author(s) : Europass team
  # URL       : http://europass.cedefop.europa.eu/TechnicalResources/XML/xsl/europass-xsl-V2.0/lp_fi_FI_V2.0.xsl
</xsl:comment>
<xsl:variable name="firstNameBefore">
<xsl:choose>
  <xsl:when test="//field[@name='personal.firstName' and @before='personal.lastName']">1</xsl:when>
  <xsl:otherwise>0</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<html>
<head>
  <title>LP - HTML</title>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
  <link href="http://europass.cedefop.europa.eu/instruments/css/html.css" type="text/css" rel="stylesheet"/>
</head>
<body>
  <table class="LP" cellSpacing="0" cellPadding="10" width="740" border="0">
	  <tbody>
	  <tr align="middle">
	    <td width="20%"><img height="53" src="http://europass.cedefop.europa.eu/instruments/images/logos/logo_europass_lp.gif" width="95"/></td>
	    <td style="text-align: center" width="60%">
		  <span class="LabelBold">Europass-kielipassi</span>
		  <br/>
		  <span class="Label">Osa Euroopan neuvoston kehittämää eurooppalaista kielisalkkua</span>
		</td>
	    <td width="20%"><img height="53" src="http://europass.cedefop.europa.eu/instruments/images/logos/otherlogo_lp.gif" width="95"/></td>
	  </tr>
	  </tbody>
  </table>
  <div class="VerLine_LP">
    <table class="LP" cellSpacing="0" cellPadding="0" width="710" border="0">
    <tbody>
    <tr>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="173"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="516"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="21"/></td>
	</tr>
    <tr>
	  <td class="LabelBold">
	    <xsl:choose>
	      <xsl:when test="$firstNameBefore=0">
	        Sukunimi&#160;
	      </xsl:when>
	      <xsl:otherwise>
		    &#160;Sukunimi
	      </xsl:otherwise>
	    </xsl:choose>
	  </td>
      <td class="Normal">
	    <xsl:choose>
	      <xsl:when test="$firstNameBefore=0">
            <xsl:value-of select="europass:learnerinfo/identification/lastname" />&#160;<xsl:value-of select="europass:learnerinfo/identification/firstname" />
		  </xsl:when>
	      <xsl:otherwise>
		    <xsl:value-of select="europass:learnerinfo/identification/firstname" />&#160;<xsl:value-of select="europass:learnerinfo/identification/lastname" />
		  </xsl:otherwise>
	    </xsl:choose>
      </td>
      <td>&#160;</td>
	</tr>
    <tr>
      <td colSpan="3"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
	</tr>
    <xsl:if test="//field[@name='personal.birthDate' and @keep='true']">
    <tr>
      <td class="Label">Syntymäaika</td>
      <td class="Normal">
      <xsl:value-of select="substring(europass:learnerinfo/identification/demographics/birthdate, 9, 2)" />/<xsl:value-of select="substring(europass:learnerinfo/identification/demographics/birthdate, 6, 2)" />/<xsl:value-of select="substring(europass:learnerinfo/identification/demographics/birthdate, 1, 4)" />
      </td><td>&#160;</td>
	</tr>
    <tr>
      <td colSpan="3"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
	</tr>
	</xsl:if>
    <tr>
      <td class="Label">Äidinkieli tai -kielet</td>
      <td class="Normal"><xsl:value-of select="europass:learnerinfo/languagelist/language[@xsi:type='europass:mother']/label" /></td>
      <td>&#160;</td>
	</tr>
    <tr>
      <td colSpan="3"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
	</tr>
    <tr>
      <td class="Label">Muut kielet</td>
	  <td class="Normal">
	    <xsl:for-each select="europass:learnerinfo/languagelist/language[@xsi:type='europass:foreign']">
          <xsl:if test="position() != 1">,&#160;</xsl:if>
		  <xsl:value-of select="label" />
	    </xsl:for-each>
	   </td>
      <td>&#160;</td>
	 </tr>
	 </tbody>
     </table>
  </div>
  
  <xsl:for-each select="europass:learnerinfo/languagelist/language[@xsi:type='europass:foreign']">
    <xsl:variable name="indexedLang">
	  <xsl:value-of select="concat('foreignLanguageList[', position()-1, ']')" />
    </xsl:variable>
	
    <br/>
	<div class="VerLine_LP">
    
	<table class="LP" cellSpacing="0" cellPadding="0" width="710" border="0">
    <tbody>
    <tr>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="19"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="25"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="109"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="25"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="109"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="8"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="17"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="108"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="25"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="86"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="23"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="25"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="31"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="79"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="21"/></td>
	</tr>
    <tr>
      <td>&#160;</td>
      <td class="NormalHighlight" colSpan="13"><xsl:value-of select="label" /> </td>
      <td>&#160;</td>
	</tr>
    
	<xsl:if test="//field[@name=concat($indexedLang,'.ass') and @keep='true']">
	<tr>
      <td colSpan="15"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
	</tr>
    <tr>
      <td class="GridHeadingBold" colSpan="14">Kielitaidon itsearviointi </td>
      <td>&#160;</td>
	</tr>
    <tr>
      <td>&#160;</td>
      <td class="GridHeadingBold" colSpan="4">Ymmärtäminen</td>
      <td class="GridHeadingBold" colSpan="6">Puhuminen</td>
      <td class="GridHeadingBold" colSpan="3">Kirjoittaminen</td>
      <td>&#160;</td>
	</tr>
    <tr>
      <td>&#160;</td>
      <td class="GridHeading" colspan="2">Kuullun ymmärtäminen</td>
      <td class="GridHeading" colspan="2">Luetun ymmärtäminen</td>
      <td class="GridHeading" colspan="3">Suullinen vuorovaikutus</td>
      <td class="GridHeading" colspan="3">Puheen tuottaminen</td>
      <td colSpan="3">&#160;</td>
      <td>&#160;</td>
	</tr>
    <tr>
      <td>&#160;</td>
      <td class="NormalCenter"><xsl:value-of select="level/listening" /> </td>
      <td class="NormalCenter">
	    <xsl:if test="level/listening='a1'">Peruskielitaito</xsl:if>
        <xsl:if test="level/listening='b1'">Itsenäisen kielenkäyttäjän kielitaito</xsl:if>
  	    <xsl:if test="level/listening='c1'">Taitavan kielenkäyttäjän kielitaito</xsl:if>
	    
		<xsl:if test="level/listening='a2'">Peruskielitaito</xsl:if>
	    <xsl:if test="level/listening='b2'">Itsenäisen kielenkäyttäjän kielitaito</xsl:if>
		<xsl:if test="level/listening='c2'">Taitavan kielenkäyttäjän kielitaito</xsl:if>
	  </td>
      <td class="NormalCenter"><xsl:value-of select="level/reading" /> </td>
      <td class="NormalCenter">
		<xsl:if test="level/reading='a1'">Peruskielitaito</xsl:if>
		<xsl:if test="level/reading='b1'">Itsenäisen kielenkäyttäjän kielitaito</xsl:if>
		<xsl:if test="level/reading='c1'">Taitavan kielenkäyttäjän kielitaito</xsl:if>
		
		<xsl:if test="level/reading='a2'">Peruskielitaito</xsl:if>
		<xsl:if test="level/reading='b2'">Itsenäisen kielenkäyttäjän kielitaito</xsl:if>
		<xsl:if test="level/reading='c2'">Taitavan kielenkäyttäjän kielitaito</xsl:if>
	  </td>
      <td class="NormalCenter" colSpan="2"><xsl:value-of select="level/spokeninteraction" /> </td>
      <td class="NormalCenter">
		<xsl:if test="level/spokeninteraction='a1'">Peruskielitaito</xsl:if>
	    <xsl:if test="level/spokeninteraction='b1'">Itsenäisen kielenkäyttäjän kielitaito</xsl:if>
		<xsl:if test="level/spokeninteraction='c1'">Taitavan kielenkäyttäjän kielitaito</xsl:if>
		
		<xsl:if test="level/spokeninteraction='a2'">Peruskielitaito</xsl:if>
	    <xsl:if test="level/spokeninteraction='b2'">Itsenäisen kielenkäyttäjän kielitaito</xsl:if>
		<xsl:if test="level/spokeninteraction='c2'">Taitavan kielenkäyttäjän kielitaito</xsl:if>
	  </td>
      <td class="NormalCenter"><xsl:value-of select="level/spokenproduction" /> </td>
      <td class="NormalCenter" colSpan="2">
		<xsl:if test="level/spokenproduction='a1'">Peruskielitaito</xsl:if>
	    <xsl:if test="level/spokenproduction='b1'">Itsenäisen kielenkäyttäjän kielitaito</xsl:if>
		<xsl:if test="level/spokenproduction='c1'">Taitavan kielenkäyttäjän kielitaito</xsl:if>
		
		<xsl:if test="level/spokenproduction='a2'">Peruskielitaito</xsl:if>
	    <xsl:if test="level/spokenproduction='b2'">Itsenäisen kielenkäyttäjän kielitaito</xsl:if>
		<xsl:if test="level/spokenproduction='c2'">Taitavan kielenkäyttäjän kielitaito</xsl:if>
	  </td>
	  <td class="NormalCenter"><xsl:value-of select="level/writing" /> </td>
      <td class="NormalCenter" colSpan="2">
		<xsl:if test="level/writing='a1'">Peruskielitaito</xsl:if>
	    <xsl:if test="level/writing='b1'">Itsenäisen kielenkäyttäjän kielitaito</xsl:if>
		<xsl:if test="level/writing='c1'">Taitavan kielenkäyttäjän kielitaito</xsl:if>
		
		<xsl:if test="level/writing='a2'">Peruskielitaito</xsl:if>
	    <xsl:if test="level/writing='b2'">Itsenäisen kielenkäyttäjän kielitaito</xsl:if>
		<xsl:if test="level/writing='c2'">Taitavan kielenkäyttäjän kielitaito</xsl:if>
	  </td>
      <td>&#160;</td>
	</tr>
    </xsl:if>
	<tr>
      <td colSpan="15"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
	</tr>
    <tr>
      <td class="GridHeadingBold" colSpan="14">Todistukset </td>
      <td>&#160;</td>
	</tr>
    <tr>
      <td>&#160;</td>
      <td class="GridHeading" colspan="5">Todistus</td>
	  <td class="GridHeading" colspan="4">Todistuksen myöntäjä</td>
	  <td class="GridHeading" colspan="3">Päivämäärä</td>
	  <td class="GridHeading">Eurooppalainen taitotaso</td>
      <td>&#160;</td>
	</tr>
    
	<xsl:for-each select="diplomalist/diploma">
	  <xsl:variable name="indexedDiploma">
	    <xsl:value-of select="concat('.diplomaList[', position()-1, ']')" />
	  </xsl:variable>
	  <xsl:variable name="indexedBoth">
	    <xsl:value-of select="concat('', $indexedLang, $indexedDiploma)" />
	  </xsl:variable>
	  <xsl:if test="//field[@name=$indexedBoth and @keep='true']">
        <tr>
          <td>&#160;</td>
          <td class="Normal" colSpan="5"><xsl:value-of select="title" /></td>
          <td class="Normal" colSpan="4"><xsl:value-of select="awardingBody" /></td>
          <td class="NormalCenter" colSpan="3">
            <xsl:value-of select="translate(date/day,'-','')" />
            <xsl:if test="string-length(date/day) != 0">/</xsl:if>
            <xsl:value-of select="translate(date/month,'-','')" />
            <xsl:if test="string-length(date/month) != 0">/</xsl:if>
            <xsl:value-of select="translate(date/year,'-','')" />
          </td>
          <td class="NormalCenter"><xsl:value-of select="level" /> </td>
          <td>&#160;</td>
	    </tr>
        <tr>
          <td colSpan="15"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
	    </tr>
	  </xsl:if>
    </xsl:for-each>
  
    <tr>
      <td colSpan="15"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
	</tr>
    <tr>
      <td class="GridHeadingBold" colSpan="14">Kielitaitoon liittyvät kokemukset </td>
      <td>&#160;</td>
	</tr>
    <tr>
      <td>&#160;</td>
      <td class="GridHeading" colspan="9">Kuvaus</td>
	  <td class="GridHeading" colspan="3">Alkoi</td>
	  <td class="GridHeading">Päättyi</td>
      <td>&#160;</td>
	</tr>
	
    <xsl:for-each select="experiencelist/experience">
	<xsl:variable name="indexedExperience">
	  <xsl:value-of select="concat('.experienceList[', position()-1, ']')" />
	</xsl:variable>
	<xsl:variable name="indexedBoth">
	  <xsl:value-of select="concat('', $indexedLang, $indexedExperience)" />
	</xsl:variable>
    <xsl:if test="//field[@name=$indexedBoth and @keep='true']">
      <tr>
        <td>&#160;</td>
        <td class="Normal" colSpan="9"><xsl:value-of select="description" /></td>
        <td class="NormalCenter" colSpan="3">
          <xsl:value-of select="translate(period/from/day,'-','')" />
		    	<xsl:if test="string-length(period/from/day) != 0">/</xsl:if>
          <xsl:value-of select="translate(period/from/month,'-','')" />
          <xsl:if test="string-length(period/from/month) != 0">/</xsl:if>
          <xsl:value-of select="translate(period/from/year,'-','')" />
	    </td>
        <td class="NormalCenter">
          <xsl:value-of select="translate(period/to/day,'-','')" />
          <xsl:if test="string-length(period/to/day) != 0">/</xsl:if>
          <xsl:value-of select="translate(period/to/month,'-','')" />
          <xsl:if test="string-length(period/to/month) != 0">/</xsl:if>
          <xsl:value-of select="translate(period/to/year,'-','')" />
	    </td>
        <td>&#160;</td>
	  </tr>
      <tr>
        <td colSpan="15"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
      </tr>
	</xsl:if>
	</xsl:for-each>
    <tr>
      <td colSpan="15"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
	</tr>
  
  </tbody>
  </table>
  
  </div>
  </xsl:for-each>
    
  <div class="Asterix">
    (*)Tähdellä merkityt kohdat ovat vapaaehtoisia
	(**)Katso itsearviointilokerikko kääntöpuolella.
	(***)Yleiseurooppalainen viitekehystaso määritetään alkuperäisessä todistuksessa tai tutkintotodistuksessa.<br/>
  </div>
  <br/>
  <div class="Footnote">
	<b>Huomautus</b><br/>
	Europass-kielipassi on osa Euroopan neuvoston kehittämää eurooppalaista kielisalkkua. Siinä käytetään yleiseurooppalaisen kielten opetuksen ja oppimisen viitekehyksen kuusiportaista taitotasoasteikkoa kielitaidon saavutetun tason esittämiseksi standardimuodossa.<br/>
	Lisätietoja Europass-kielipassista: http://europass.cedefop.europa.eu - Lisätietoja eurooppalaisesta kielisalkusta: www.coe.int/portfolio<br/>
	Europass kielipassin kaavake on ilmaiseksi ladattavissa edellä mainituista osoitteista.<br/>
	© Euroopan neuvosto ja Euroopan yhteisöt, 2004   20060628<br/>
  </div>
  <br/>
  
  <xsl:if test="//field[@name='grid' and @keep='true']">
  <table width="710" border="0" cellspacing="0" cellpadding="0" class="Grid">
	<tr class="spacer">
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="20" height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
	</tr>
	<tr>
		<th colspan="6" class="title">Eurooppalainen taso – Itsearviointilokerikko</th>
	</tr>
	<tr class="level">
		<th>A1</th>
		<td>Tunnistan tuttuja sanoja ja kaikkein tavallisimpia sanontoja, jotka koskevat minua itseäni, perhettäni ja lähiympäristöäni, kun minulle puhutaan hitaasti ja selvästi.</td>
		<td>Ymmärrän tuttuja nimiä, sanoja ja hyvin yksinkertaisia lauseita esimerkiksi ilmoituksissa, julisteissa ja luetteloissa.</td>
		<td>Selviydyn kaikkein yksinkertaisimmista keskusteluista, jos puhekumppanini on valmis toistamaan sanottavansa tai ilmaisemaan asian toisin, puhumaan tavallista hitaammin ja auttamaan minua muotoilemaan sen, mitä yritän sanoa. Pystyn esittämään yksinkertaisia kysymyksiä ja vastaamaan sellaisiin arkisia tarpeita tai hyvin tuttuja aiheita käsittelevissä keskusteluissa.</td>
		<td>Osaan käyttää yksinkertaisia sanontoja ja lauseita kuvaamaan, missä asun ja keitä tunnen.</td>
		<td>Pystyn kirjoittamaan lyhyen, yksinkertaisen postikortin, esimerkiksi lomaterveiset. Pystyn täyttämään lomakkeita, joissa kysytään henkilötietoa, esimerkiksi kirjoittamaan nimeni, kansallisuuteni ja osoitteeni hotellin majoittumislomakkeeseen.</td>
	</tr>
	<tr class="level">
		<th>A2</th>
		<td>Ymmärrän muutamia sanontoja ja kaikkein tavallisinta sanastoa, joka liittyy läheisesti omaan elämääni; esimerkiksi aivan keskeinen tieto itsestäni ja perheestäni, ostosten tekeminen, asuinpaikka ja työpaikka. Ymmärrän lyhyiden, selkeiden, yksinkertaisten viestien ja kuulutusten ydinsisällön.</td>
		<td>Pystyn lukemaan hyvin lyhyitä, yksinkertaisia tekstejä. Pystyn löytämään tiettyä, ennustettavissa olevaa tietoa jokapäiväisistä yksinkertaisista teksteistä, esimerkiksi mainoksista, esitteistä, ruokalistoista ja aikatauluista. Ymmärrän lyhyitä, yksinkertaisia henkilökohtaisia kirjeitä.</td>
		<td>Pystyn kommunikoimaan yksinkertaisissa ja rutiininomaisissa tehtävissä, jotka edellyttävät yksinkertaista ja suoraa tiedonvaihtoa tutuista aiheista ja toiminnoista. Selviydyn hyvin lyhyistä keskusteluista, mutta ymmärrän harvoin kylliksi pitääkseni keskustelua itse yllä.</td>
		<td>Pystyn kuvaamaan perhettäni ja muita ihmisiä, elinolojani, koulutustaustaani ja nykyistä tai edellistä työpaikkaani käyttäen, usein luettelomaisesti, aivan yksinkertaisia ilmauksia ja lauseita.</td>
		<td>Pystyn kirjoittamaan lyhyitä, yksinkertaisia muistiinpanoja ja viestejä asioista, jotka liittyvät arkisiin tarpeisiini. Pystyn kirjoittamaan hyvin yksinkertaisen henkilökohtaisen kirjeen esimerkiksi kiittääkseni jotakuta jostakin.</td>
	</tr>
	<tr class="level">
		<th>B1</th>
		<td>Ymmärrän pääkohdat selkeästä yleiskielisestä puheesta, jossa käsitellään esimerkiksi työssä, koulussa tai vapaa-aikana säännöllisesti esiintyviä ja minulle tuttuja aiheita. Tavoitan pääkohdat monista radio- ja tv-ohjelmista, joissa käsitellään ajankohtaisia tai minua henkilökohtaisesti tai ammatillisesti kiinnostavia asioita, kun puhe on melko hidasta ja selvää.</td>
		<td>Ymmärrän tekstejä, joissa on pääasiassa hyvin tavallista arkipäivän kieltä tai työhön liittyvää kieltä. Ymmärrän tapahtumien, tunteiden ja toiveiden kuvaukset henkilökohtaisissa kirjeissä.</td>
		<td>Selviydyn useimmista tilanteista, joita syntyy kohdekielisillä alueilla matkustettaessa. Pystyn osallistumaan valmistautumatta keskusteluun aiheista, jotka ovat tuttuja, itseäni kiinnostavia tai jotka liittyvät arkielämään, esimerkiksi perheeseen, harrastuksiin, työhön, matkustamiseen ja ajankohtaisiin asioihin.</td>
		<td>Osaan liittää yhteen ilmauksia yksinkertaisella tavalla kuvatakseni kokemuksia ja tapahtumia, unelmiani, toiveitani ja pyrkimyksiäni. Pystyn perustelemaan ja selittämään lyhyesti mielipiteitäni ja suunnitelmiani. Pystyn kertomaan tarinan tai selittämään kirjan tai elokuvan juonen sekä kuvailemaan omia reaktioitani.</td>
		<td>Pystyn kirjoittamaan yksinkertaista, yhtenäistä tekstiä aiheista, jotka ovat tuttuja tai itseäni kiinnostavia. Pystyn kirjoittamaan henkilökohtaisia kirjeitä, joissa kuvailen kokemuksia ja vaikutelmia.</td>
	</tr>
	<tr class="level">
		<th>B2</th>
		<td>Ymmärrän pitkähköä puhetta ja luentoja. Pystyn jopa seuraamaan monipolvista perustelua, jos aihe on suhteellisen tuttu. Ymmärrän useimmat tv-uutiset ja ajankohtaisohjelmat. Ymmärrän useimmat yleispuhekielellä esitetyt elokuvat</td>
		<td>Pystyn lukemaan ajankohtaisia ongelmia käsitteleviä artikkeleita ja raportteja ja havaitsemaan niissä kirjoittajien näkökulmat ja kannanotot. Ymmärrän oman aikani kaunokirjallisuutta.</td>
		<td>Pystyn viestimään niin sujuvasti ja spontaanisti, että säännöllinen yhteydenpito syntyperäisten puhujien kanssa on mahdollista ilman että kumpikaan osapuoli kokee sen hankalaksi. Pystyn osallistumaan aktiivisesti tutuista aihepiireistä käytävään keskusteluun, esittämään näkemyksiäni ja puolustamaan niitä.</td>
		<td>Pystyn esittämään selkeitä, yksityiskohtaisia kuvauksia hyvinkin erilaisista minua kiinnostavista aiheista. Pystyn selittämään näkökantani johonkin ajankohtaiseen kysymykseen ja esittämään eri vaihtoehtojen edut ja haitat.</td>
		<td>Pystyn kirjoittamaan selkeitä, myös yksityiskohtia sisältäviä selvityksiä hyvinkin erilaisista aiheista, jotka kiinnostavat minua. Pystyn laatimaan kirjoitelman tai raportin, jossa välitän tietoa tai esitän perusteluja jonkin tietyn näkökannan puolesta tai sitä vastaan. Pystyn kirjoittamaan kirjeitä, joissa korostan tapahtumien tai kokemusten henkilökohtaista merkitystä.</td>
	</tr>
	<tr class="level">
		<th>C1</th>
		<td>Ymmärrän pitkähköä puhetta silloinkin, kun sitä ei ole muotoiltu selkeästi ja kun asioiden välisiin suhteisiin vain viitataan eikä niitä ilmaista täsmällisesti. Ymmärrän tv-ohjelmia ja elokuvia ilman erityisiä ponnistuksia</td>
		<td>Ymmärrän pitkiä ja monipolvisia asia- ja kirjallisuustekstejä ja huomaan tyylieroja. Ymmärrän erityisalojen artikkeleita ja melko pitkiä teknisiä ohjeita silloinkin, kun ne eivät liity omaan alaani.</td>
		<td>Pystyn ilmaisemaan ajatuksiani sujuvasti ja spontaanisti ilman että minun juurikaan tarvitsee hakea ilmauksia. Osaan käyttää kieltä joustavasti ja tehokkaasti sosiaalisiin ja ammatillisiin tarkoituksiin. Osaan muotoilla ajatuksia ja mielipiteitä täsmällisesti ja liittää oman puheenvuoroni taitavasti muiden puhujien puheenvuoroihin.</td>
		<td>Pystyn esittämään selkeitä ja yksityiskohtaisia kuvauksia monipolvisista aiheista ja kehittelemään keskeisiä näkökohtia sekä päättämään esitykseni sopivaan lopetukseen.</td>
		<td>Pystyn ilmaisemaan ajatuksiani ja näkökantojani varsin laajasti selkeässä, hyvin jäsennetyssä tekstissä. Pystyn kirjoittamaan yksityiskohtaisia selvityksiä monipolvisista aiheista kirjeessä, esseessä/kirjoitelmassa tai raportissa sekä korostamaan tärkeimpinä pitämiäni seikkoja. Osaan valita oletetulle lukijalle sopivan tyylin.</td>
	</tr>
	<tr class="level">
		<th>C2</th>
		<td>Ymmärrän vaikeuksitta kaikenlaista elävää ja nauhoitettua puhetta silloinkin, kun on kyse syntyperäisen kielenpuhujan nopeasta puheesta, jos minulla on hiukan aikaa tutustua puhetapaan.</td>
		<td>Pystyn lukemaan vaivatta käytännöllisesti katsoen kaikenlaista kirjoitettua kieltä, myös abstrakteja, rakenteellisesti tai kielellisesti monimutkaisia tekstejä, kuten ohjekirjoja, erityisalojen artikkeleita ja kaunokirjallisuutta.</td>
		<td>Pystyn ottamaan vaivatta osaa asioiden käsittelyyn ja kaikkiin keskusteluihin. Tunnen hyvin kielelle tyypilliset, idiomaattiset ilmaukset ja puhekieliset ilmaukset. Pystyn tuomaan esille ajatuksiani sujuvasti ja välittämään täsmällisesti hienojakin merkitysvivahteita. Osaan perääntyä ja kiertää mahdolliset ongelmat niin sujuvasti, että muut tuskin havaitsevat olleenkaan ongelmia.</td>
		<td>Pystyn esittämään selkeän ja sujuvan kuvauksen tai perustelun asiayhteyteen sopivalla tyylillä. Esityksessäni on tehokas looginen rakenne, joka auttaa vastaanottajaa havaitsemaan ja muistamaan tärkeitä seikkoja.</td>
		<td>Osaan kirjoittaa selkeää, sujuvaa tekstiä asiaankuuluvalla tyylillä. Pystyn kirjoittamaan monimutkaisia kirjeitä, raportteja tai artikkeleita, jotka esittelevät jonkin yksittäisen tapauksen. Käytän tehokkaasti loogisia rakenteita, jotka auttavat vastaanottajaa löytämään ja muistamaan keskeiset seikat. Pystyn kirjoittamaan koosteita ja katsauksia ammattiin tai kaunokirjallisuuteen liittyvistä julkaisuista.</td>
	</tr>
  </table>
  </xsl:if>
  <img style="display: none" src="http://europass.cedefop.europa.eu/instruments/images/cv_verline.gif"/> <img style="display: none" src="http://europass.cedefop.europa.eu/instruments/images/logos/logo_for_htmlpreview.gif"/>
  <img style="display: none" src="http://europass.cedefop.europa.eu/instruments/images/bg_win4.jpg"/> 
</body>
</html>
  </xsl:template>
</xsl:stylesheet>
