<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet  [
	<!ENTITY nbsp   "&#160;">
  <!ENTITY copy   "&#169;">
]>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:europass="http://europass.cedefop.europa.eu/Europass/V2.0">
<xsl:template match="/">
<xsl:comment>
  # 
	© European Communities, 2002-2008 http://europass.cedefop.europa.eu
  # http://europass.cedefop.europa.eu/europass/home/botnav/LegalNotice.csp
  # Name      : cv_lv_LV_V2.0.xsl
  # Version   : V2.0
  # Purpose   : Provides a way to show the Europass CV in HTML format.
  # Author(s) : Europass team
  # URL       : http://europass.cedefop.europa.eu/TechnicalResources/XML/xsl/europass-xsl-V2.0/cv_lv_LV_V2.0.xsl
</xsl:comment>
<xsl:variable name="firstNameBefore">
<xsl:choose>
  <xsl:when test="//field[@name='step1.firstName' and @before='step1.lastName']">1</xsl:when>
  <xsl:otherwise>0</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:variable name="step3Before">
<xsl:choose>
  <xsl:when test="//field[@name='step3List' and @before='step4List']">1</xsl:when>
  <xsl:otherwise>0</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<html>
  <head>
    <title>CV - HTML</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <link href="http://europass.cedefop.europa.eu/instruments/css/html.css" type="text/css" rel="stylesheet"/>
  </head>
<body>
<table width="700" border="0" cellspacing="0" cellpadding="0" class="CV">
  <tr>
    <td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" height="1" width="190"/></td>
    <td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" height="1" width="7"/></td>
	<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" height="1" width="8"/></td>
    <td colspan="11"><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" height="1" width="495"/></td>
  </tr>
  <tr>
    <td class="Logo" rowspan="2">&#160;</td>
	<td style="height:42px;">&#160;</td>
    <td colspan="12" rowspan="2">&#160;</td>
  </tr>
  <tr>
    <td class="Corner">&#160;</td>
  </tr>
  <tr>
    <td class="Heading1">&#160;</td>
    <td class="VerticalLine">&#160;</td>
	<td>&#160;</td>
    <td class="Normal" colspan="11">&#160;</td>
  </tr>
  <tr>
    <td class="Title">
	  Europass<br/>
      Curriculum Vitae
	</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">&#160;</td>
  </tr>
  <tr>
    <td class="Heading1">&#160;</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">&#160;</td>
  </tr>
  <tr>
    <td class="Heading1">Personas dati</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">&#160;</td>
  </tr>
  <tr>
    <td class="Label">
	  <xsl:choose>
	    <xsl:when test="$firstNameBefore=0">
	      Uzvārds&#160;Vārds
	    </xsl:when>
	    <xsl:otherwise>
		  Vārds&#160;Uzvārds
	    </xsl:otherwise>
	  </xsl:choose>
	</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Heading2" colSpan="11">
	  <xsl:choose>
	    <xsl:when test="$firstNameBefore=0">
          <xsl:value-of select="europass:learnerinfo/identification/lastname" />&#160;<xsl:value-of select="europass:learnerinfo/identification/firstname" />
		</xsl:when>
	    <xsl:otherwise>
		  <xsl:value-of select="europass:learnerinfo/identification/firstname" />&#160;<xsl:value-of select="europass:learnerinfo/identification/lastname" />
		</xsl:otherwise>
	  </xsl:choose>
	</td>
  </tr>
  <xsl:if test="//field[@name='step1.addressInfo' and @keep='true']">
  <tr>
    <td class="Label">Adrese</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">
      <xsl:for-each select="europass:learnerinfo/identification/contactinfo/address/addressLine">
        <xsl:value-of select="current()" /><br/>
      </xsl:for-each>
      <xsl:if test="string-length(europass:learnerinfo/identification/contactinfo/address/postalCode) != 0">
      <xsl:value-of select="europass:learnerinfo/identification/contactinfo/address/postalCode" />, </xsl:if>
      <xsl:value-of select="europass:learnerinfo/identification/contactinfo/address/municipality" />
      <xsl:if test="string-length(europass:learnerinfo/identification/contactinfo/address/country/label) != 0"> (<xsl:value-of select="europass:learnerinfo/identification/contactinfo/address/country/label" />)</xsl:if>
    </td>
  </tr>
  </xsl:if>
  <xsl:if test="//field[@name='step1.mobile' and @keep='true']">
  <tr>
    <td class="Label">Tālrunis</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="5">
	  <xsl:value-of select="europass:learnerinfo/identification/contactinfo/telephone" />
	</td>
    <td class="Label" width="15%" colSpan="2">Mobilais tālrunis</td>
    <td class="Normal" colSpan="4">
	  <xsl:value-of select="europass:learnerinfo/identification/contactinfo/mobile" />
	</td>
  </tr>
  </xsl:if>
  <xsl:if test="//field[@name='step1.fax' and @keep='true']">
  <tr>
    <td class="Label">Fakss</td>
    <td class="VerticalLine">&#160;</td>
	<td>&#160;</td>
    <td class="Normal" colspan="11">
	  <xsl:value-of select="europass:learnerinfo/identification/contactinfo/fax" />
	</td>
  </tr>
  </xsl:if>
  <xsl:if test="//field[@name='step1.email' and @keep='true']">
  <tr>
    <td class="Label">E-pasts</td>
    <td class="VerticalLine">&#160;</td>
	<td>&#160;</td>
    <td class="Normal" colspan="11">
	  <xsl:value-of select="europass:learnerinfo/identification/contactinfo/email" />
	</td>
  </tr>
  </xsl:if>
  <xsl:if test="//field[@name='step1.nationality' and @keep='true']">
  <tr>
    <td class="Label">Pilsonība</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">
      <xsl:for-each select="europass:learnerinfo/identification/demographics/nationality/label">
    		<xsl:if test="position() != 1">,&#160;</xsl:if>
        <xsl:value-of select="current()"/>
    	</xsl:for-each>
    </td>
  </tr>
  </xsl:if>
  <xsl:if test="//field[@name='step1.birthDate' and @keep='true']">
  <tr>
    <td class="Label">Dzimšanas datums</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">
    	<xsl:value-of select="substring(europass:learnerinfo/identification/demographics/birthdate, 9, 2)" />/<xsl:value-of select="substring(europass:learnerinfo/identification/demographics/birthdate, 6, 2)" />/<xsl:value-of select="substring(europass:learnerinfo/identification/demographics/birthdate, 1, 4)" />
    </td>
  </tr>
  </xsl:if>
  <xsl:if test="//field[@name='step1.gender' and @keep='true']">
  <tr>
    <td class="Label">Dzimums</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">
	  <xsl:if test="europass:learnerinfo/identification/demographics/gender='M'"><xsl:text>Vīrietis</xsl:text></xsl:if>
	  <xsl:if test="europass:learnerinfo/identification/demographics/gender='F'"><xsl:text>Sieviete</xsl:text></xsl:if>
	</td>
  </tr>
  </xsl:if>
  <xsl:if test="//field[@name='step1.application' and @keep='true']">
  <tr>
    <td class="Heading1">Vēlamā nodarbošanās/ profesionālā joma</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">
	  <PRE><xsl:value-of select="europass:learnerinfo/application/label" /></PRE>
	</td>
  </tr>
  </xsl:if>
  
  
  <xsl:choose>
    <xsl:when test="$step3Before=1">
	  <xsl:if test="//field[@name='step3List' and @keep='true']">
	  <tr>
	    <td class="Heading1">Darba pieredze</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11">&#160;</td>
	  </tr>
	  <xsl:for-each select="europass:learnerinfo/workexperiencelist/workexperience">
		  <tr>
		    <td class="Label">Laika periods</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11">
		    		<xsl:value-of select="translate(period/from/day,'-','')" />
		    		<xsl:if test="string-length(period/from/day) != 0">/</xsl:if>
				<xsl:value-of select="translate(period/from/month,'-','')" />
				<xsl:if test="string-length(period/from/month) != 0">/</xsl:if>
				<xsl:value-of select="translate(period/from/year,'-','')" />
				<xsl:if test="string-length(period/to/day) != 0 or string-length(period/to/month) != 0 or string-length(period/to/year) != 0">
				-
				</xsl:if>
				<xsl:value-of select="translate(period/to/day,'-','')" />
				<xsl:if test="string-length(period/to/day) != 0">/</xsl:if>
				<xsl:value-of select="translate(period/to/month,'-','')" />
				<xsl:if test="string-length(period/to/month) != 0">/</xsl:if>
				<xsl:value-of select="translate(period/to/year,'-','')" />
			</td>
		  </tr>
		  <xsl:variable name="indexedStep3">
			<xsl:value-of select="concat('step3List[', position()-1, ']')" />
		  </xsl:variable>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.position') and @keep='true']">
		  <tr>
		    <td class="Label">Profesija vai ieņemamais amats</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11"><xsl:value-of select="position/label" /></td>
		  </tr>
		  </xsl:if>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.activities') and @keep='true']">
		  <tr>
		    <td class="Label">Galvenie pienākumi</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="activities" /></PRE></td>
		  </tr>
		  </xsl:if>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.company.name') and @keep='true']">
		  <tr>
		    <td class="Label">Darba vietas nosaukums un adrese</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11">
          <PRE><xsl:value-of select="employer/name" /></PRE>
          <xsl:if test="//field[@name=concat($indexedStep3,'.company.addressInfo') and @keep='true']">
            <xsl:for-each select="employer/address/addressLine">
              <xsl:value-of select="current()" /><br/>
            </xsl:for-each>
            <xsl:if test="string-length(employer/address/postalCode) != 0"><xsl:value-of select="employer/address/postalCode" />, </xsl:if>
            <xsl:value-of select="employer/address/municipality" />
            <xsl:if test=" string-length(employer/address/country/label) != 0"> (<xsl:value-of select="employer/address/country/label" />)</xsl:if>
          </xsl:if>
		    </td>
		  </tr>
		  </xsl:if>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.company.sector.label') and @keep='true']">
		  <tr>
		    <td class="Label">Nozare</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11"><xsl:value-of select="employer/sector/label" /></td>
		  </tr>
		  </xsl:if>
		  <tr>
		    <td class="Label">&#160;</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11">&#160;</td>
		  </tr>
	  </xsl:for-each>
	  </xsl:if>
	  <xsl:if test="//field[@name='step4List' and @keep='true']">
	  <tr>
	    <td class="Heading1">Izglītība</td>
	    <td class="VerticalLine">&#160;</td>
		<td>&#160;</td>
	    <td class="Normal" colspan="11">&#160;</td>
	  </tr>
	  <xsl:for-each select="europass:learnerinfo/educationlist/education">
	  <tr>
	    <td class="Label">Laika periods</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11">
			<xsl:value-of select="translate(period/from/day,'-','')" />
	    		<xsl:if test="string-length(period/from/day) != 0">/</xsl:if>
			<xsl:value-of select="translate(period/from/month,'-','')" />
			<xsl:if test="string-length(period/from/month) != 0">/</xsl:if>
			<xsl:value-of select="translate(period/from/year,'-','')" />
			<xsl:if test="string-length(period/to/day) != 0 or string-length(period/to/month) != 0 or string-length(period/to/year) != 0">
			-
			</xsl:if>
			<xsl:value-of select="translate(period/to/day,'-','')" />
			<xsl:if test="string-length(period/to/day) != 0">/</xsl:if>
			<xsl:value-of select="translate(period/to/month,'-','')" />
			<xsl:if test="string-length(period/to/month) != 0">/</xsl:if>
			<xsl:value-of select="translate(period/to/year,'-','')" />
		</td>
	  </tr>
	  <xsl:variable name="indexedStep4">
	    <xsl:value-of select="concat('step4List[', position()-1, ']')" />
	  </xsl:variable>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.title') and @keep='true']">
	  <tr>
	    <td class="Label">Piešķirtā izglītības dokumenta nosaukums/ Piešķirtā kvalifikācija</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11"><xsl:value-of select="title" /></td>
	  </tr>
	  </xsl:if>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.skills') and @keep='true']">
	  <tr>
	    <td class="Label">Galvenie mācību priekšmeti / iegūtās profesionālās prasmes</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="skills" /></PRE></td>
	  </tr>
	  </xsl:if>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.educationalOrg.name') and @keep='true']">
	  <tr>
	    <td class="Label">Izglītības iestādes nosaukums un veids</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11">
        <PRE><xsl:value-of select="organisation/name" /><xsl:if test="string-length(organisation/type) != 0">(<xsl:value-of select="organisation/type" />)</xsl:if></PRE>
        <xsl:if test="//field[@name=concat($indexedStep4,'.educationalOrg.addressInfo') and @keep='true']">
          <xsl:for-each select="organisation/address/addressLine">
            <xsl:value-of select="current()" /><br/>
          </xsl:for-each>
          <xsl:if test="string-length(organisation/address/postalCode) != 0"><xsl:value-of select="organisation/address/postalCode" />, </xsl:if>
          <xsl:value-of select="organisation/address/municipality" />
          <xsl:if test="string-length(organisation/address/country/label) != 0"> (<xsl:value-of select="organisation/address/country/label" />)</xsl:if>
        </xsl:if>
      </td>
	  </tr>
	  </xsl:if>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.level.label') and @keep='true']">
	  <tr>
	    <td class="Label">Līmenis nacionālajā vai starptautiskajā klasifikācijas sistēmā</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11"><xsl:value-of select="level/label" /></td>
	  </tr>
	  </xsl:if>
	  <tr>
	    <td class="Label">&#160;</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11">&#160;</td>
	  </tr>          
	  </xsl:for-each>
	  </xsl:if>
	</xsl:when>
	<xsl:otherwise>
	  <xsl:if test="//field[@name='step4List' and @keep='true']">
	  <tr>
	    <td class="Heading1">Izglītība</td>
	    <td class="VerticalLine">&#160;</td>
		<td>&#160;</td>
	    <td class="Normal" colspan="11">&#160;</td>
	  </tr>
	  <xsl:for-each select="europass:learnerinfo/educationlist/education">
	  <tr>
	    <td class="Label">Laika periods</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11">
			<xsl:value-of select="translate(period/from/day,'-','')" />
	    		<xsl:if test="string-length(period/from/day) != 0">/</xsl:if>
			<xsl:value-of select="translate(period/from/month,'-','')" />
			<xsl:if test="string-length(period/from/month) != 0">/</xsl:if>
			<xsl:value-of select="translate(period/from/year,'-','')" />
			<xsl:if test="string-length(period/to/day) != 0 or string-length(period/to/month) != 0 or string-length(period/to/year) != 0">
			-
			</xsl:if>
			<xsl:value-of select="translate(period/to/day,'-','')" />
			<xsl:if test="string-length(period/to/day) != 0">/</xsl:if>
			<xsl:value-of select="translate(period/to/month,'-','')" />
			<xsl:if test="string-length(period/to/month) != 0">/</xsl:if>
			<xsl:value-of select="translate(period/to/year,'-','')" />
		</td>
	  </tr>
	  <xsl:variable name="indexedStep4">
	    <xsl:value-of select="concat('step4List[', position()-1, ']')" />
	  </xsl:variable>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.title') and @keep='true']">
	  <tr>
	    <td class="Label">Piešķirtā izglītības dokumenta nosaukums/ Piešķirtā kvalifikācija</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11"><xsl:value-of select="title" /></td>
	  </tr>
	  </xsl:if>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.skills') and @keep='true']">
	  <tr>
	    <td class="Label">Galvenie mācību priekšmeti / iegūtās profesionālās prasmes</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="skills" /></PRE></td>
	  </tr>
	  </xsl:if>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.educationalOrg.name') and @keep='true']">
	  <tr>
	    <td class="Label">Izglītības iestādes nosaukums un veids</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11">
                <PRE><xsl:value-of select="organisation/name" /><xsl:if test="string-length(organisation/type) != 0">(<xsl:value-of select="organisation/type" />)</xsl:if></PRE>
            </td>
	  </tr>
	  </xsl:if>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.educationalOrg.addressInfo') and @keep='true']">
		  <tr>
		    <td class="Label">Adrese</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11">
                      <xsl:for-each select="organisation/address/addressLine">
                        <xsl:value-of select="current()" /><br/>
                      </xsl:for-each>
                      <xsl:value-of select="organisation/address/postalCode" /><br/>
                      <xsl:value-of select="organisation/address/municipality" /><br/>
                      <xsl:value-of select="organisation/address/country/label" /><br/>
                    </td>
		  </tr>
          </xsl:if>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.level.label') and @keep='true']">
	  <tr>
	    <td class="Label">Līmenis nacionālajā vai starptautiskajā klasifikācijas sistēmā</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11"><xsl:value-of select="level/label" /></td>
	  </tr>
	  </xsl:if>
	  <tr>
	    <td class="Label">&#160;</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11">&#160;</td>
	  </tr>          
	  </xsl:for-each>
	  </xsl:if>
	  <xsl:if test="//field[@name='step3List' and @keep='true']">
	  <tr>
	    <td class="Heading1">Darba pieredze</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11">&#160;</td>
	  </tr>
	  <xsl:for-each select="europass:learnerinfo/workexperiencelist/workexperience">
		  <tr>
		    <td class="Label">Laika periods</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11">
		    		<xsl:value-of select="translate(period/from/day,'-','')" />
		    		<xsl:if test="string-length(period/from/day) != 0">/</xsl:if>
				<xsl:value-of select="translate(period/from/month,'-','')" />
				<xsl:if test="string-length(period/from/month) != 0">/</xsl:if>
				<xsl:value-of select="translate(period/from/year,'-','')" />
				<xsl:if test="string-length(period/to/day) != 0 or string-length(period/to/month) != 0 or string-length(period/to/year) != 0">
				-
				</xsl:if>
				<xsl:value-of select="translate(period/to/day,'-','')" />
				<xsl:if test="string-length(period/to/day) != 0">/</xsl:if>
				<xsl:value-of select="translate(period/to/month,'-','')" />
				<xsl:if test="string-length(period/to/month) != 0">/</xsl:if>
				<xsl:value-of select="translate(period/to/year,'-','')" />
			</td>
		  </tr>
		  <xsl:variable name="indexedStep3">
			<xsl:value-of select="concat('step3List[', position()-1, ']')" />
		  </xsl:variable>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.position') and @keep='true']">
		  <tr>
		    <td class="Label">Profesija vai ieņemamais amats</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11"><xsl:value-of select="position/label" /></td>
		  </tr>
		  </xsl:if>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.activities') and @keep='true']">
		  <tr>
		    <td class="Label">Galvenie pienākumi</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="activities" /></PRE></td>
		  </tr>
		  </xsl:if>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.company.name') and @keep='true']">
		  <tr>
		    <td class="Label">Darba vietas nosaukums un adrese</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="employer/name" /></PRE></td>
		  </tr>
		  </xsl:if>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.company.addressInfo') and @keep='true']">
		  <tr>
		    <td class="Label">Adrese</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11">
                      <xsl:for-each select="employer/address/addressLine">
                        <xsl:value-of select="current()" /><br/>
                      </xsl:for-each>
                      <xsl:value-of select="employer/address/postalCode" /><br/>
                      <xsl:value-of select="employer/address/municipality" /><br/>
                      <xsl:value-of select="employer/address/country/label" /><br/>
                    </td>
		  </tr>
		  </xsl:if>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.company.sector.label') and @keep='true']">
		  <tr>
		    <td class="Label">Nozare</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11"><xsl:value-of select="employer/sector/label" /></td>
		  </tr>
		  </xsl:if>
		  <tr>
		    <td class="Label">&#160;</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11">&#160;</td>
		  </tr>
	  </xsl:for-each>
	  </xsl:if>
	</xsl:otherwise>
  </xsl:choose>
  
  <tr>
    <td class="Heading1">Prasmes</td>
    <td class="VerticalLine">&#160;</td>
	<td>&#160;</td>
    <td colspan="11" class="Normal">&#160;</td>
  </tr>
  <xsl:if test="//field[@name='step5.motherLanguages' and @keep='true']">
  <tr>
    <td class="Label">Dzimtā valoda</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Heading2" colSpan="11"><xsl:value-of select="europass:learnerinfo/languagelist/language[@xsi:type='europass:mother']/label" /></td>
  </tr>
  </xsl:if>
  <xsl:if test="//field[@name='step5.foreignLanguageList' and @keep='true']">
  <tr>
    <td class="Label">Citas valodas</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">&#160;</td></tr>
  <tr>
    <td class="Label">Pašnovērtējums</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Heading2Center" colSpan="4">Sapratne</td>
    <td class="Heading2Center" colSpan="4">Runāšana</td>
    <td class="Heading2Center" colSpan="2">Rakstīšana</td>
    <td width="1%">&#160;</td>
  </tr>
  <tr>
    <td class="Label">Eiropas līmenis</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="NormalSmall" colSpan="2">Klausīšanās</td>
    <td class="NormalSmall" colSpan="2">Lasīšana</td>
    <td class="NormalSmall" colSpan="2">Dialogs</td>
    <td class="NormalSmall" colSpan="2">Monologs</td>
    <td class="NormalSmall" colSpan="2">&#160;</td>
    <td width="1%">&#160;</td>
  </tr>
    <xsl:for-each select="europass:learnerinfo/languagelist/language[@xsi:type='europass:foreign']">
	  <xsl:variable name="indexedLang">
        <xsl:value-of select="concat('step5.foreignLanguageList[', position()-1, ']')" />
      </xsl:variable>
      <xsl:if test="//field[@name=$indexedLang and @keep='true']">
      <tr>
	    <td class="Heading1Box"><xsl:value-of select="label" /></td>
	    <td class="VerticalLineBox">&#160;</td>
	    <td>&#160;</td>
	    <td class="NormalSmall" width="5%"><xsl:value-of select="level/listening" /></td>
	    <td class="NormalSmall">
			<xsl:if test="level/listening='a1'">Pamatlīmenis</xsl:if>
		    <xsl:if test="level/listening='b1'">Vidējais līmenis</xsl:if>
			<xsl:if test="level/listening='c1'">Augstākais līmenis</xsl:if>
			
			<xsl:if test="level/listening='a2'">Pamatlīmenis</xsl:if>
		    <xsl:if test="level/listening='b2'">Vidējais līmenis</xsl:if>
			<xsl:if test="level/listening='c2'">Augstākais līmenis</xsl:if>
	    </td>
		<td class="NormalSmall" width="5%"><xsl:value-of select="level/reading" /></td>
	    <td class="NormalSmall">
			<xsl:if test="level/reading='a1'">Pamatlīmenis</xsl:if>
			<xsl:if test="level/reading='b1'">Vidējais līmenis</xsl:if>
			<xsl:if test="level/reading='c1'">Augstākais līmenis</xsl:if>
		
			<xsl:if test="level/reading='a2'">Pamatlīmenis</xsl:if>
			<xsl:if test="level/reading='b2'">Vidējais līmenis</xsl:if>
			<xsl:if test="level/reading='c2'">Augstākais līmenis</xsl:if>
		</td>
	    <td class="NormalSmall" width="5%"><xsl:value-of select="level/spokeninteraction" /></td>
	    <td class="NormalSmall">
			<xsl:if test="level/spokeninteraction='a1'">Pamatlīmenis</xsl:if>
			<xsl:if test="level/spokeninteraction='b1'">Vidējais līmenis</xsl:if>
			<xsl:if test="level/spokeninteraction='c1'">Augstākais līmenis</xsl:if>
		
			<xsl:if test="level/spokeninteraction='a2'">Pamatlīmenis</xsl:if>
			<xsl:if test="level/spokeninteraction='b2'">Vidējais līmenis</xsl:if>
			<xsl:if test="level/spokeninteraction='c2'">Augstākais līmenis</xsl:if>
		</td>
		<td class="NormalSmall" width="5%"><xsl:value-of select="level/spokenproduction" /></td>
	    <td class="NormalSmall">
			<xsl:if test="level/spokenproduction='a1'">Pamatlīmenis</xsl:if>
			<xsl:if test="level/spokenproduction='b1'">Vidējais līmenis</xsl:if>
			<xsl:if test="level/spokenproduction='c1'">Augstākais līmenis</xsl:if>
		
			<xsl:if test="level/spokenproduction='a2'">Pamatlīmenis</xsl:if>
			<xsl:if test="level/spokenproduction='b2'">Vidējais līmenis</xsl:if>
			<xsl:if test="level/spokenproduction='c2'">Augstākais līmenis</xsl:if>
		</td>
	    <td class="NormalSmall" width="5%"><xsl:value-of select="level/writing" /></td>
	    <td class="NormalSmall">
			<xsl:if test="level/writing='a1'">Pamatlīmenis</xsl:if>
			<xsl:if test="level/writing='b1'">Vidējais līmenis</xsl:if>
			<xsl:if test="level/writing='c1'">Augstākais līmenis</xsl:if>
		
			<xsl:if test="level/writing='a2'">Pamatlīmenis</xsl:if>
			<xsl:if test="level/writing='b2'">Vidējais līmenis</xsl:if>
			<xsl:if test="level/writing='c2'">Augstākais līmenis</xsl:if>
		</td>
	    <td width="1%">&#160;</td>
	  </tr>
	  </xsl:if>
    </xsl:for-each>
  </xsl:if>
  <tr>
    <td class="Label">&#160;</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">&#160;</td>
  </tr>
  <xsl:if test="//field[@name='step6.socialSkills' and @keep='true']">
  <tr>
    <td class="Label">Sociālās prasmes</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="europass:learnerinfo/skilllist/skill[@type='social']" /></PRE></td>
  </tr>
  </xsl:if>	  
  <xsl:if test="//field[@name='step6.organisationalSkills' and @keep='true']">
  <tr>
    <td class="Label">Organizatoriskas prasmes</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="europass:learnerinfo/skilllist/skill[@type='organisational']" /></PRE></td>
  </tr>
  </xsl:if>	  
  <xsl:if test="//field[@name='step6.technicalSkills' and @keep='true']">
  <tr>
    <td class="Label">Tehniskas prasmes</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="europass:learnerinfo/skilllist/skill[@type='technical']" /></PRE></td>
  </tr>
  </xsl:if>	  
  <xsl:if test="//field[@name='step6.computerSkills' and @keep='true']">
  <tr>
    <td class="Label">Datora lietošanas prasmes</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="europass:learnerinfo/skilllist/skill[@type='computer']" /></PRE></td>
  </tr>
  </xsl:if>	  
  <xsl:if test="//field[@name='step6.artisticSkills' and @keep='true']">
  <tr>
    <td class="Label">Mākslinieciskas prasmes</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="europass:learnerinfo/skilllist/skill[@type='artistic']" /></PRE></td>
  </tr>
  </xsl:if>	  
  <xsl:if test="//field[@name='step6.otherSkills' and @keep='true']">
  <tr>
    <td class="Label">Citas prasmes</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="europass:learnerinfo/skilllist/skill[@type='other']" /></PRE></td>
  </tr>	
  </xsl:if>	  
  <xsl:if test="//field[@name='step6.drivingLicences' and @keep='true']">
  <tr>
    <td class="Label">Vadītāja apliecība</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">
        <xsl:for-each select="europass:learnerinfo/skilllist/structured-skill[@xsi:type='europass:driving']/drivinglicence">
            <xsl:if test="position() != 1">,&#160;</xsl:if>
            <xsl:value-of select="current()" />
        </xsl:for-each>
    </td>
  </tr>
  </xsl:if>	  
  <xsl:if test="//field[@name='step7.additionalInfo' and @keep='true']">
  <tr>
    <td class="Heading1">Papildu informācija</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="europass:learnerinfo/misclist/misc[@type='additional']" /></PRE></td>
  </tr>
  </xsl:if>	  
  <xsl:if test="//field[@name='step7.annexes' and @keep='true']">
  <tr>
    <td class="Heading1">Pielikumi</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="europass:learnerinfo/misclist/misc[@type='annexes']" /></PRE></td>
  </tr>
  </xsl:if>
</table>
<br/>
<xsl:if test="//field[@name='grid' and @keep='true']">
<table width="710" border="0" cellspacing="0" cellpadding="0" class="Grid">
	<tr class="spacer">
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="20" height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
	</tr>
	<tr>
		<th colspan="6" class="title">EIROPAS VALODU PRASMES LĪMEŅI  –  PAŠNOVĒRTĒJUMA TABULA</th>
	</tr>
	<tr class="level">
		<th>A1</th>
		<td>Es saprotu pazīstamus vārdus un dažas ļoti  vienkāršas frāzes, kad lēni un skaidri runā  par mani, manu ģime­ni un tuvāko apkārtni.</td>
		<td>Es saprotu pazīstamus vārdus  un nosauku­mus, kā arī ļoti vien­kāršus teikumus, pie­mēram, paziņoju­mos, plakātos, katalo­gos.</td>
		<td>Es varu vienkāršā veidā sazināties, ja sarunu biedrs teikto  var lēnām atkārtot vai pateikt citiem vārdiem un palīdz man formu­lēt to, ko es cenšos pasacīt. Es varu uzdot vienkāršus jautājumus  un atbildēt uz tiem sarunā par man ļoti labi zināmām tēmām.</td>
		<td>Es varu vienkāršos  tei­kumos pastāstīt par savu dzīvesvietu un cil­vēkiem, kurus pa­zīstu.</td>
		<td>Es protu uzrakstīt īsu, vienkāršu tekstu, pie­mēram, nosūtīt ap­svei­kuma pastkarti. Es protu aizpildīt veid­la­pas ar personas da­tiem, piemēram, ierak­stīt savu vārdu, pilso­nī­bu un adresi vies­nī­cas reģistrācijas lapā.</td>
	</tr>
	<tr class="level">
		<th>A2</th>
		<td>Es saprotu atsevišķas frāzes un biežāk lietotos vārdus izteikumos, kam ir saistība ar mani (pie­mēram, vienkāršu infor­māciju par sevi un ģimeni, iepirkšanos, dzī­vesvietu, darbu). Es varu uztvert galveno domu īsos, vienkāršos un  skaidri izrunātos pa­zi­ņojumos, sludinā­ju­mos.</td>
		<td>Es varu izlasīt ļoti īsus un vienkāršus tekstus. Es varu sameklēt kon­krētu informāciju vien­kāršos, ar ikdienas dzīvi saistītos  tekstos:  sludi­nājumos, reklām­izde­vumos, ēdienkartēs, sa­rak­stos. Es varu saprast  īsas un vienkār­šas  pri­vātās vēstules.</td>
		<td>Es varu sazināties parastās ikdienišķās si­tuācijās, kur notiek vienkārša informācijas apmaiņa  par man zinā­miem tematiem vai dar­bībām. Es varu iesais­tīties ļoti īsā sarunā par sadzīviskiem jautāju­miem, tomēr ma­na va­lo­das prasme ir nepie­tiekama, lai  pat­stā­vīgi veidotu dialogu.</td>
		<td>Es varu vienkāršos tei­ku­mos pastāstīt par  savu ģimeni un citiem cilvēkiem, dzīves ap­stāk­ļiem, savu izglītību un pašreizējo vai iepriek­šējo darbu.</td>
		<td>Es varu uzrakstīt īsas zīmītes un vienkāršus paziņojumus.  Es protu uzrakstīt ļoti vienkāršu vēstuli, piemēram, izsa­kot kādam pateicību.</td>
	</tr>
	<tr class="level">
		<th>B1</th>
		<td>Es saprotu galveno saturu skaidrā un  literāri pareizā runā par pazīstamām tē­mām, ar kurām es sa­skaros darbā, skolā, brīvajā laikā utt. Es saprotu radio un televīzijas raidījumu saturu  tad, kad samērā lēni un skaidri runā  par aktuāliem notikumiem vai tematiem, kuri mani interesē perso­nīgi vai profesionāli.</td>
		<td>Es saprotu tekstus, kuros izmantota  ikdienā bieži lietota  vai ar manu darbu saistīta valoda. Es varu saprast privātajās  vēstulēs aprakstītos  notikumus, izjūtas un vēlmes.</td>
		<td>Es spēju ārzemju ceļojuma laikā sazināties situācijās, kur nepieciešams runāt. Es varu bez iepriekšējas sagatavošanās iesaistīties sarunā par man zināmiem vai mani interesējošiem, kā arī ar  ikdienas dzīvi saistītiem tematiem (pie­mēram, “ģimene”, “vaļas­prieks”, “darbs”,  “ceļo­ša­na”, “jaunākie notiku­mi”).</td>
		<td>Es protu veidot un saistīt kopā izteikumus, lai pa­stāstītu par pieredzēto un dažādiem notikumiem, sa­viem sapņiem, cerībām un vēlmēm. Es varu īsi  pa­matot un paskaidrot savus uzskatus un nodomus. Es varu pastāstīt stāstu, iz­klās­tīt grāmatas vai filmas saturu un izteikt par to savu attieksmi.</td>
		<td>Es protu uzrakstīt vien­kāršu, saistītu tekstu par jautājumiem, kas man ir zināmi vai mani interesē. Es varu uzrakstīt vēstuli, aprakstot  tajā savus pār­dzī­vojumus un iespaidus.</td>
	</tr>
	<tr class="level">
		<th>B2</th>
		<td>Es varu saprast garāku runu un lekcijas, sekot līdzi  pat sarežģītai argu­mentācijai, ja temats ir pietiekami  pazīstams. Es saprotu gandrīz visu televīzijas ziņās un repor­tāžās par jaunāka­jiem notikumiem. Es saprotu gandrīz visas filmas literārajā runā.</td>
		<td>Es varu izlasīt pārskatus un rakstus par aktuālām problēmām, kuros autors pauž noteiktu  attieksmi vai viedokli. Es varu saprast mūsdienu prozas darbus.</td>
		<td>Es varu  diezgan brīvi un bez sagatavošanās sazi­nāties ar dzimtās valodas runātājiem. Es varu aktīvi piedalīties dis­ku­­­­si­jās par man zināmām problēmām, pamatojot un aizstāvot savu  viedokli.</td>
		<td>Es varu skaidru un  vispusīgu dažādu tēmu izklāstu, kas ietilpst ma­nā interešu lokā. Es varu pamatot savus uz­ska­tus par kādu strīdīgu jautā­jumu, izvērtējot at­šķi­rīgos viedokļus.</td>
		<td>Es varu uzrakstīt skaidru, detalizētu tekstu par da­žādiem jautājumiem, kas skar manu interešu loku. Es varu uzrakstīt eseju vai ziņojumu, dot rak­stisku informāciju, kā arī argumentēt vienu vai otru viedokli. Es protu uz­rak­stīt vēstules, izceļot man nozīmīgākos notikumus un  iespaidus.</td>
	</tr>
	<tr class="level">
		<th>C1</th>
		<td>Es varu saprast garāku runu arī tad, ja tai  nav  skaidra uzbūve un ir vāji izteiktas loģiskās sakarības.  Es bez pū­lēm saprotu televīzi­jas raidījumus un filmas.</td>
		<td>Es varu saprast garus un sarežģītus dažāda tipa tekstus, izprotot stila atšķirības. Es varu sa­prast speciālos rak­stus un garākas teh­niskās instrukcijas, pat tad, ja tās neattiecas uz manu darbības jomu.</td>
		<td>Es varu veikli un brīvi izteikties,  piemērotus vārdus un izteicienus īpaši nemeklējot. Es protu prasmīgi lietot valodu gan ikdienas situācijās, gan darba vajadzībām. Es protu precīzi formulēt savas domas un uzskatus un prasmīgi uzturēt sarunu.</td>
		<td>Es varu skaidru un vispusīgu sarežģītu  tēmu izklāstu , iekļaut tajā pakārtotus jautā­jumus, izvērst atse­višķas tēzes un nobeigt ar atbilstošiem  secinā­jumiem.</td>
		<td>Es protu skaidri un loģiski  uzrakstīt savas domas, izteikt savu viedokli. Es varu uzrak­stīt vēstuli, eseju vai ziņojumu par sarežģī­tiem jautājumiem, iz­ceļot to, ko es uzskatu par nozīmīgu un sva­rīgu. Es protu rakstīt konkrētam lasītājam pie­­­mē­rotā  stilā.</td>
	</tr>
	<tr class="level">
		<th>C2</th>
		<td>Es bez grūtībām  sa­pro­tu jebkuru runas veidu – gan tiešā sa­ziņā  teikto, gan pār­raidīto pat tad, ja ātrā tempā runā dzimtās valodas lieto­tājs. Es varu saprast runātājus ar dažādām izrunas īpatnībām.</td>
		<td>Es bez grūtībām varu izlasīt dažāda tipa, uzbūves vai valodas ziņā sarežģītus tek­stus: rokasgrāmatas, speciālos rakstus, lite­rāros darbus.</td>
		<td>Es varu bez grūtībām piedalīties jebkurā sa­runā vai diskusijā, labi pārzinu idiomā­tiskos izteicienus un sarun­valodas vārdus. Es varu runāt pilnīgi brīvi un precīzi izteikt  nozīmes smal­kā­kās nianses. Ja valodas lietojumā man rodas grūtības, es protu tik veikli pār­veidot sacī­to, ka citi to nemana.</td>
		<td>Es varu pilnīgi brīvi, skaidri un argumen­tēti, konkrētajai situā­cijai atbilstošā veidā sniegt kādas tēmas izklāstu.  Es protu vei­dot savu stāstījumu tā, lai klausītājam būtu vieglāk uztvert un iegau­mēt nozīmīgākos jautājumus.</td>
		<td>Es protu uzrakstīt skaidru, loģisku tekstu atbilstošā stilā. Es varu uzrakstīt sarež­ģītas vēstules, referā­tus vai rakstus tā, lai  lasītājam būtu viegli pamanīt un atcerēties svarīgākās  vietas. Es varu uzrakstīt pārska­tus un recenzijas gan par  literārajiem, gan speciālās literatūras dar­biem.</td>
	</tr>
</table>
</xsl:if>		
		<img style="display: none" src="http://europass.cedefop.europa.eu/instruments/images/cv_verline.gif" /> 
		<img style="display: none" src="http://europass.cedefop.europa.eu/instruments/images/logo_for_htmlpreview.gif" /> 
		<img style="display: none" src="http://europass.cedefop.europa.eu/instruments/images/bg_win4.jpg" /> 
	</body>
</html>
</xsl:template>
</xsl:stylesheet>
