<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet  [
	<!ENTITY nbsp   "&#160;">
  <!ENTITY copy   "&#169;">
]>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:europass="http://europass.cedefop.europa.eu/Europass/V2.0">
<xsl:template match="/">
<xsl:comment>
  # 
	© European Communities, 2002-2008 http://europass.cedefop.europa.eu
  # http://europass.cedefop.europa.eu/europass/home/botnav/LegalNotice.csp
  # Name      : cv_fi_FI_V2.0.xsl
  # Version   : V2.0
  # Purpose   : Provides a way to show the Europass CV in HTML format.
  # Author(s) : Europass team
  # URL       : http://europass.cedefop.europa.eu/TechnicalResources/XML/xsl/europass-xsl-V2.0/cv_fi_FI_V2.0.xsl
</xsl:comment>
<xsl:variable name="firstNameBefore">
<xsl:choose>
  <xsl:when test="//field[@name='step1.firstName' and @before='step1.lastName']">1</xsl:when>
  <xsl:otherwise>0</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:variable name="step3Before">
<xsl:choose>
  <xsl:when test="//field[@name='step3List' and @before='step4List']">1</xsl:when>
  <xsl:otherwise>0</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<html>
  <head>
    <title>CV - HTML</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <link href="http://europass.cedefop.europa.eu/instruments/css/html.css" type="text/css" rel="stylesheet"/>
  </head>
<body>
<table width="700" border="0" cellspacing="0" cellpadding="0" class="CV">
  <tr>
    <td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" height="1" width="190"/></td>
    <td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" height="1" width="7"/></td>
	<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" height="1" width="8"/></td>
    <td colspan="11"><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" height="1" width="495"/></td>
  </tr>
  <tr>
    <td class="Logo" rowspan="2">&#160;</td>
	<td style="height:42px;">&#160;</td>
    <td colspan="12" rowspan="2">&#160;</td>
  </tr>
  <tr>
    <td class="Corner">&#160;</td>
  </tr>
  <tr>
    <td class="Heading1">&#160;</td>
    <td class="VerticalLine">&#160;</td>
	<td>&#160;</td>
    <td class="Normal" colspan="11">&#160;</td>
  </tr>
  <tr>
    <td class="Title">
	  Europass-ansioluettelo<br/>
      
<p />
	</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">&#160;</td>
  </tr>
  <tr>
    <td class="Heading1">&#160;</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">&#160;</td>
  </tr>
  <tr>
    <td class="Heading1">Henkilötiedot</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">&#160;</td>
  </tr>
  <tr>
    <td class="Label">
	  <xsl:choose>
	    <xsl:when test="$firstNameBefore=0">
	      Sukunimi&#160;Etunimet
	    </xsl:when>
	    <xsl:otherwise>
		  Etunimet&#160;Sukunimi
	    </xsl:otherwise>
	  </xsl:choose>
	</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Heading2" colSpan="11">
	  <xsl:choose>
	    <xsl:when test="$firstNameBefore=0">
          <xsl:value-of select="europass:learnerinfo/identification/lastname" />&#160;<xsl:value-of select="europass:learnerinfo/identification/firstname" />
		</xsl:when>
	    <xsl:otherwise>
		  <xsl:value-of select="europass:learnerinfo/identification/firstname" />&#160;<xsl:value-of select="europass:learnerinfo/identification/lastname" />
		</xsl:otherwise>
	  </xsl:choose>
	</td>
  </tr>
  <xsl:if test="//field[@name='step1.addressInfo' and @keep='true']">
  <tr>
    <td class="Label">Osoitteet</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">
      <xsl:for-each select="europass:learnerinfo/identification/contactinfo/address/addressLine">
        <xsl:value-of select="current()" /><br/>
      </xsl:for-each>
      <xsl:if test="string-length(europass:learnerinfo/identification/contactinfo/address/postalCode) != 0">
      <xsl:value-of select="europass:learnerinfo/identification/contactinfo/address/postalCode" />, </xsl:if>
      <xsl:value-of select="europass:learnerinfo/identification/contactinfo/address/municipality" />
      <xsl:if test="string-length(europass:learnerinfo/identification/contactinfo/address/country/label) != 0"> (<xsl:value-of select="europass:learnerinfo/identification/contactinfo/address/country/label" />)</xsl:if>
    </td>
  </tr>
  </xsl:if>
  <xsl:if test="//field[@name='step1.mobile' and @keep='true']">
  <tr>
    <td class="Label">Puhelinnumero(t)</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="5">
	  <xsl:value-of select="europass:learnerinfo/identification/contactinfo/telephone" />
	</td>
    <td class="Label" width="15%" colSpan="2">Matkapuhelin</td>
    <td class="Normal" colSpan="4">
	  <xsl:value-of select="europass:learnerinfo/identification/contactinfo/mobile" />
	</td>
  </tr>
  </xsl:if>
  <xsl:if test="//field[@name='step1.fax' and @keep='true']">
  <tr>
    <td class="Label">Faksinumero(t)</td>
    <td class="VerticalLine">&#160;</td>
	<td>&#160;</td>
    <td class="Normal" colspan="11">
	  <xsl:value-of select="europass:learnerinfo/identification/contactinfo/fax" />
	</td>
  </tr>
  </xsl:if>
  <xsl:if test="//field[@name='step1.email' and @keep='true']">
  <tr>
    <td class="Label">Sähköposti</td>
    <td class="VerticalLine">&#160;</td>
	<td>&#160;</td>
    <td class="Normal" colspan="11">
	  <xsl:value-of select="europass:learnerinfo/identification/contactinfo/email" />
	</td>
  </tr>
  </xsl:if>
  <xsl:if test="//field[@name='step1.nationality' and @keep='true']">
  <tr>
    <td class="Label">Kansalaisuus</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">
      <xsl:for-each select="europass:learnerinfo/identification/demographics/nationality/label">
    		<xsl:if test="position() != 1">,&#160;</xsl:if>
        <xsl:value-of select="current()"/>
    	</xsl:for-each>
    </td>
  </tr>
  </xsl:if>
  <xsl:if test="//field[@name='step1.birthDate' and @keep='true']">
  <tr>
    <td class="Label">Syntymäaika</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">
    	<xsl:value-of select="substring(europass:learnerinfo/identification/demographics/birthdate, 9, 2)" />/<xsl:value-of select="substring(europass:learnerinfo/identification/demographics/birthdate, 6, 2)" />/<xsl:value-of select="substring(europass:learnerinfo/identification/demographics/birthdate, 1, 4)" />
    </td>
  </tr>
  </xsl:if>
  <xsl:if test="//field[@name='step1.gender' and @keep='true']">
  <tr>
    <td class="Label">Sukupuoli</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">
	  <xsl:if test="europass:learnerinfo/identification/demographics/gender='M'"><xsl:text>Mies</xsl:text></xsl:if>
	  <xsl:if test="europass:learnerinfo/identification/demographics/gender='F'"><xsl:text>Nainen</xsl:text></xsl:if>
	</td>
  </tr>
  </xsl:if>
  <xsl:if test="//field[@name='step1.application' and @keep='true']">
  <tr>
    <td class="Heading1">Haettu työpaikka / ammattiala</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">
	  <PRE><xsl:value-of select="europass:learnerinfo/application/label" /></PRE>
	</td>
  </tr>
  </xsl:if>
  
  
  <xsl:choose>
    <xsl:when test="$step3Before=1">
	  <xsl:if test="//field[@name='step3List' and @keep='true']">
	  <tr>
	    <td class="Heading1">Työkokemus</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11">&#160;</td>
	  </tr>
	  <xsl:for-each select="europass:learnerinfo/workexperiencelist/workexperience">
		  <tr>
		    <td class="Label">Päivämäärät</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11">
		    		<xsl:value-of select="translate(period/from/day,'-','')" />
		    		<xsl:if test="string-length(period/from/day) != 0">/</xsl:if>
				<xsl:value-of select="translate(period/from/month,'-','')" />
				<xsl:if test="string-length(period/from/month) != 0">/</xsl:if>
				<xsl:value-of select="translate(period/from/year,'-','')" />
				<xsl:if test="string-length(period/to/day) != 0 or string-length(period/to/month) != 0 or string-length(period/to/year) != 0">
				-
				</xsl:if>
				<xsl:value-of select="translate(period/to/day,'-','')" />
				<xsl:if test="string-length(period/to/day) != 0">/</xsl:if>
				<xsl:value-of select="translate(period/to/month,'-','')" />
				<xsl:if test="string-length(period/to/month) != 0">/</xsl:if>
				<xsl:value-of select="translate(period/to/year,'-','')" />
			</td>
		  </tr>
		  <xsl:variable name="indexedStep3">
			<xsl:value-of select="concat('step3List[', position()-1, ']')" />
		  </xsl:variable>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.position') and @keep='true']">
		  <tr>
		    <td class="Label">Toimi tai tehtävä</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11"><xsl:value-of select="position/label" /></td>
		  </tr>
		  </xsl:if>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.activities') and @keep='true']">
		  <tr>
		    <td class="Label">Keskeiset tehtävät ja vastuualat</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="activities" /></PRE></td>
		  </tr>
		  </xsl:if>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.company.name') and @keep='true']">
		  <tr>
		    <td class="Label">Työnantajan nimi ja osoite</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11">
          <PRE><xsl:value-of select="employer/name" /></PRE>
          <xsl:if test="//field[@name=concat($indexedStep3,'.company.addressInfo') and @keep='true']">
            <xsl:for-each select="employer/address/addressLine">
              <xsl:value-of select="current()" /><br/>
            </xsl:for-each>
            <xsl:if test="string-length(employer/address/postalCode) != 0"><xsl:value-of select="employer/address/postalCode" />, </xsl:if>
            <xsl:value-of select="employer/address/municipality" />
            <xsl:if test=" string-length(employer/address/country/label) != 0"> (<xsl:value-of select="employer/address/country/label" />)</xsl:if>
          </xsl:if>
		    </td>
		  </tr>
		  </xsl:if>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.company.sector.label') and @keep='true']">
		  <tr>
		    <td class="Label">Ansiotoiminnan tyyppi tai toimiala</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11"><xsl:value-of select="employer/sector/label" /></td>
		  </tr>
		  </xsl:if>
		  <tr>
		    <td class="Label">&#160;</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11">&#160;</td>
		  </tr>
	  </xsl:for-each>
	  </xsl:if>
	  <xsl:if test="//field[@name='step4List' and @keep='true']">
	  <tr>
	    <td class="Heading1">Yleissivistävä ja ammatillinen koulutus</td>
	    <td class="VerticalLine">&#160;</td>
		<td>&#160;</td>
	    <td class="Normal" colspan="11">&#160;</td>
	  </tr>
	  <xsl:for-each select="europass:learnerinfo/educationlist/education">
	  <tr>
	    <td class="Label">Päivämäärät</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11">
			<xsl:value-of select="translate(period/from/day,'-','')" />
	    		<xsl:if test="string-length(period/from/day) != 0">/</xsl:if>
			<xsl:value-of select="translate(period/from/month,'-','')" />
			<xsl:if test="string-length(period/from/month) != 0">/</xsl:if>
			<xsl:value-of select="translate(period/from/year,'-','')" />
			<xsl:if test="string-length(period/to/day) != 0 or string-length(period/to/month) != 0 or string-length(period/to/year) != 0">
			-
			</xsl:if>
			<xsl:value-of select="translate(period/to/day,'-','')" />
			<xsl:if test="string-length(period/to/day) != 0">/</xsl:if>
			<xsl:value-of select="translate(period/to/month,'-','')" />
			<xsl:if test="string-length(period/to/month) != 0">/</xsl:if>
			<xsl:value-of select="translate(period/to/year,'-','')" />
		</td>
	  </tr>
	  <xsl:variable name="indexedStep4">
	    <xsl:value-of select="concat('step4List[', position()-1, ']')" />
	  </xsl:variable>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.title') and @keep='true']">
	  <tr>
	    <td class="Label">Tutkinnon nimi</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11"><xsl:value-of select="title" /></td>
	  </tr>
	  </xsl:if>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.skills') and @keep='true']">
	  <tr>
	    <td class="Label">Tärkeimmät oppiaineet tai ammattitaidot</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="skills" /></PRE></td>
	  </tr>
	  </xsl:if>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.educationalOrg.name') and @keep='true']">
	  <tr>
	    <td class="Label">Oppilaitoksen nimi ja tyyppi</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11">
        <PRE><xsl:value-of select="organisation/name" /><xsl:if test="string-length(organisation/type) != 0">(<xsl:value-of select="organisation/type" />)</xsl:if></PRE>
        <xsl:if test="//field[@name=concat($indexedStep4,'.educationalOrg.addressInfo') and @keep='true']">
          <xsl:for-each select="organisation/address/addressLine">
            <xsl:value-of select="current()" /><br/>
          </xsl:for-each>
          <xsl:if test="string-length(organisation/address/postalCode) != 0"><xsl:value-of select="organisation/address/postalCode" />, </xsl:if>
          <xsl:value-of select="organisation/address/municipality" />
          <xsl:if test="string-length(organisation/address/country/label) != 0"> (<xsl:value-of select="organisation/address/country/label" />)</xsl:if>
        </xsl:if>
      </td>
	  </tr>
	  </xsl:if>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.level.label') and @keep='true']">
	  <tr>
	    <td class="Label">Koulutuksen taso kansallisessa tai kansainvälisessä luokituksessa</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11"><xsl:value-of select="level/label" /></td>
	  </tr>
	  </xsl:if>
	  <tr>
	    <td class="Label">&#160;</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11">&#160;</td>
	  </tr>          
	  </xsl:for-each>
	  </xsl:if>
	</xsl:when>
	<xsl:otherwise>
	  <xsl:if test="//field[@name='step4List' and @keep='true']">
	  <tr>
	    <td class="Heading1">Yleissivistävä ja ammatillinen koulutus</td>
	    <td class="VerticalLine">&#160;</td>
		<td>&#160;</td>
	    <td class="Normal" colspan="11">&#160;</td>
	  </tr>
	  <xsl:for-each select="europass:learnerinfo/educationlist/education">
	  <tr>
	    <td class="Label">Päivämäärät</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11">
			<xsl:value-of select="translate(period/from/day,'-','')" />
	    		<xsl:if test="string-length(period/from/day) != 0">/</xsl:if>
			<xsl:value-of select="translate(period/from/month,'-','')" />
			<xsl:if test="string-length(period/from/month) != 0">/</xsl:if>
			<xsl:value-of select="translate(period/from/year,'-','')" />
			<xsl:if test="string-length(period/to/day) != 0 or string-length(period/to/month) != 0 or string-length(period/to/year) != 0">
			-
			</xsl:if>
			<xsl:value-of select="translate(period/to/day,'-','')" />
			<xsl:if test="string-length(period/to/day) != 0">/</xsl:if>
			<xsl:value-of select="translate(period/to/month,'-','')" />
			<xsl:if test="string-length(period/to/month) != 0">/</xsl:if>
			<xsl:value-of select="translate(period/to/year,'-','')" />
		</td>
	  </tr>
	  <xsl:variable name="indexedStep4">
	    <xsl:value-of select="concat('step4List[', position()-1, ']')" />
	  </xsl:variable>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.title') and @keep='true']">
	  <tr>
	    <td class="Label">Tutkinnon nimi</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11"><xsl:value-of select="title" /></td>
	  </tr>
	  </xsl:if>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.skills') and @keep='true']">
	  <tr>
	    <td class="Label">Tärkeimmät oppiaineet tai ammattitaidot</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="skills" /></PRE></td>
	  </tr>
	  </xsl:if>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.educationalOrg.name') and @keep='true']">
	  <tr>
	    <td class="Label">Oppilaitoksen nimi ja tyyppi</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11">
                <PRE><xsl:value-of select="organisation/name" /><xsl:if test="string-length(organisation/type) != 0">(<xsl:value-of select="organisation/type" />)</xsl:if></PRE>
            </td>
	  </tr>
	  </xsl:if>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.educationalOrg.addressInfo') and @keep='true']">
		  <tr>
		    <td class="Label">Osoitteet</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11">
                      <xsl:for-each select="organisation/address/addressLine">
                        <xsl:value-of select="current()" /><br/>
                      </xsl:for-each>
                      <xsl:value-of select="organisation/address/postalCode" /><br/>
                      <xsl:value-of select="organisation/address/municipality" /><br/>
                      <xsl:value-of select="organisation/address/country/label" /><br/>
                    </td>
		  </tr>
          </xsl:if>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.level.label') and @keep='true']">
	  <tr>
	    <td class="Label">Koulutuksen taso kansallisessa tai kansainvälisessä luokituksessa</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11"><xsl:value-of select="level/label" /></td>
	  </tr>
	  </xsl:if>
	  <tr>
	    <td class="Label">&#160;</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11">&#160;</td>
	  </tr>          
	  </xsl:for-each>
	  </xsl:if>
	  <xsl:if test="//field[@name='step3List' and @keep='true']">
	  <tr>
	    <td class="Heading1">Työkokemus</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11">&#160;</td>
	  </tr>
	  <xsl:for-each select="europass:learnerinfo/workexperiencelist/workexperience">
		  <tr>
		    <td class="Label">Päivämäärät</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11">
		    		<xsl:value-of select="translate(period/from/day,'-','')" />
		    		<xsl:if test="string-length(period/from/day) != 0">/</xsl:if>
				<xsl:value-of select="translate(period/from/month,'-','')" />
				<xsl:if test="string-length(period/from/month) != 0">/</xsl:if>
				<xsl:value-of select="translate(period/from/year,'-','')" />
				<xsl:if test="string-length(period/to/day) != 0 or string-length(period/to/month) != 0 or string-length(period/to/year) != 0">
				-
				</xsl:if>
				<xsl:value-of select="translate(period/to/day,'-','')" />
				<xsl:if test="string-length(period/to/day) != 0">/</xsl:if>
				<xsl:value-of select="translate(period/to/month,'-','')" />
				<xsl:if test="string-length(period/to/month) != 0">/</xsl:if>
				<xsl:value-of select="translate(period/to/year,'-','')" />
			</td>
		  </tr>
		  <xsl:variable name="indexedStep3">
			<xsl:value-of select="concat('step3List[', position()-1, ']')" />
		  </xsl:variable>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.position') and @keep='true']">
		  <tr>
		    <td class="Label">Toimi tai tehtävä</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11"><xsl:value-of select="position/label" /></td>
		  </tr>
		  </xsl:if>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.activities') and @keep='true']">
		  <tr>
		    <td class="Label">Keskeiset tehtävät ja vastuualat</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="activities" /></PRE></td>
		  </tr>
		  </xsl:if>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.company.name') and @keep='true']">
		  <tr>
		    <td class="Label">Työnantajan nimi ja osoite</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="employer/name" /></PRE></td>
		  </tr>
		  </xsl:if>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.company.addressInfo') and @keep='true']">
		  <tr>
		    <td class="Label">Osoitteet</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11">
                      <xsl:for-each select="employer/address/addressLine">
                        <xsl:value-of select="current()" /><br/>
                      </xsl:for-each>
                      <xsl:value-of select="employer/address/postalCode" /><br/>
                      <xsl:value-of select="employer/address/municipality" /><br/>
                      <xsl:value-of select="employer/address/country/label" /><br/>
                    </td>
		  </tr>
		  </xsl:if>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.company.sector.label') and @keep='true']">
		  <tr>
		    <td class="Label">Ansiotoiminnan tyyppi tai toimiala</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11"><xsl:value-of select="employer/sector/label" /></td>
		  </tr>
		  </xsl:if>
		  <tr>
		    <td class="Label">&#160;</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11">&#160;</td>
		  </tr>
	  </xsl:for-each>
	  </xsl:if>
	</xsl:otherwise>
  </xsl:choose>
  
  <tr>
    <td class="Heading1">Henkilökohtaiset tiedot ja taidot</td>
    <td class="VerticalLine">&#160;</td>
	<td>&#160;</td>
    <td colspan="11" class="Normal">&#160;</td>
  </tr>
  <xsl:if test="//field[@name='step5.motherLanguages' and @keep='true']">
  <tr>
    <td class="Label">Äidinkieli tai -kielet</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Heading2" colSpan="11"><xsl:value-of select="europass:learnerinfo/languagelist/language[@xsi:type='europass:mother']/label" /></td>
  </tr>
  </xsl:if>
  <xsl:if test="//field[@name='step5.foreignLanguageList' and @keep='true']">
  <tr>
    <td class="Label">Muut kielet</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">&#160;</td></tr>
  <tr>
    <td class="Label">Itsearviointi</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Heading2Center" colSpan="4">Ymmärtäminen</td>
    <td class="Heading2Center" colSpan="4">Puhuminen</td>
    <td class="Heading2Center" colSpan="2">Kirjoittaminen</td>
    <td width="1%">&#160;</td>
  </tr>
  <tr>
    <td class="Label">Eurooppalainen taitotaso</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="NormalSmall" colSpan="2">Kuuntelu</td>
    <td class="NormalSmall" colSpan="2">Lukeminen</td>
    <td class="NormalSmall" colSpan="2">Suullinen vuorovaikutus</td>
    <td class="NormalSmall" colSpan="2">Suullinen tuottaminen</td>
    <td class="NormalSmall" colSpan="2">&#160;</td>
    <td width="1%">&#160;</td>
  </tr>
    <xsl:for-each select="europass:learnerinfo/languagelist/language[@xsi:type='europass:foreign']">
	  <xsl:variable name="indexedLang">
        <xsl:value-of select="concat('step5.foreignLanguageList[', position()-1, ']')" />
      </xsl:variable>
      <xsl:if test="//field[@name=$indexedLang and @keep='true']">
      <tr>
	    <td class="Heading1Box"><xsl:value-of select="label" /></td>
	    <td class="VerticalLineBox">&#160;</td>
	    <td>&#160;</td>
	    <td class="NormalSmall" width="5%"><xsl:value-of select="level/listening" /></td>
	    <td class="NormalSmall">
			<xsl:if test="level/listening='a1'">Peruskielitaito</xsl:if>
		    <xsl:if test="level/listening='b1'">Itsenäisen kielenkäyttäjän kielitaito</xsl:if>
			<xsl:if test="level/listening='c1'">Taitavan kielenkäyttäjän kielitaito</xsl:if>
			
			<xsl:if test="level/listening='a2'">Peruskielitaito</xsl:if>
		    <xsl:if test="level/listening='b2'">Itsenäisen kielenkäyttäjän kielitaito</xsl:if>
			<xsl:if test="level/listening='c2'">Taitavan kielenkäyttäjän kielitaito</xsl:if>
	    </td>
		<td class="NormalSmall" width="5%"><xsl:value-of select="level/reading" /></td>
	    <td class="NormalSmall">
			<xsl:if test="level/reading='a1'">Peruskielitaito</xsl:if>
			<xsl:if test="level/reading='b1'">Itsenäisen kielenkäyttäjän kielitaito</xsl:if>
			<xsl:if test="level/reading='c1'">Taitavan kielenkäyttäjän kielitaito</xsl:if>
		
			<xsl:if test="level/reading='a2'">Peruskielitaito</xsl:if>
			<xsl:if test="level/reading='b2'">Itsenäisen kielenkäyttäjän kielitaito</xsl:if>
			<xsl:if test="level/reading='c2'">Taitavan kielenkäyttäjän kielitaito</xsl:if>
		</td>
	    <td class="NormalSmall" width="5%"><xsl:value-of select="level/spokeninteraction" /></td>
	    <td class="NormalSmall">
			<xsl:if test="level/spokeninteraction='a1'">Peruskielitaito</xsl:if>
			<xsl:if test="level/spokeninteraction='b1'">Itsenäisen kielenkäyttäjän kielitaito</xsl:if>
			<xsl:if test="level/spokeninteraction='c1'">Taitavan kielenkäyttäjän kielitaito</xsl:if>
		
			<xsl:if test="level/spokeninteraction='a2'">Peruskielitaito</xsl:if>
			<xsl:if test="level/spokeninteraction='b2'">Itsenäisen kielenkäyttäjän kielitaito</xsl:if>
			<xsl:if test="level/spokeninteraction='c2'">Taitavan kielenkäyttäjän kielitaito</xsl:if>
		</td>
		<td class="NormalSmall" width="5%"><xsl:value-of select="level/spokenproduction" /></td>
	    <td class="NormalSmall">
			<xsl:if test="level/spokenproduction='a1'">Peruskielitaito</xsl:if>
			<xsl:if test="level/spokenproduction='b1'">Itsenäisen kielenkäyttäjän kielitaito</xsl:if>
			<xsl:if test="level/spokenproduction='c1'">Taitavan kielenkäyttäjän kielitaito</xsl:if>
		
			<xsl:if test="level/spokenproduction='a2'">Peruskielitaito</xsl:if>
			<xsl:if test="level/spokenproduction='b2'">Itsenäisen kielenkäyttäjän kielitaito</xsl:if>
			<xsl:if test="level/spokenproduction='c2'">Taitavan kielenkäyttäjän kielitaito</xsl:if>
		</td>
	    <td class="NormalSmall" width="5%"><xsl:value-of select="level/writing" /></td>
	    <td class="NormalSmall">
			<xsl:if test="level/writing='a1'">Peruskielitaito</xsl:if>
			<xsl:if test="level/writing='b1'">Itsenäisen kielenkäyttäjän kielitaito</xsl:if>
			<xsl:if test="level/writing='c1'">Taitavan kielenkäyttäjän kielitaito</xsl:if>
		
			<xsl:if test="level/writing='a2'">Peruskielitaito</xsl:if>
			<xsl:if test="level/writing='b2'">Itsenäisen kielenkäyttäjän kielitaito</xsl:if>
			<xsl:if test="level/writing='c2'">Taitavan kielenkäyttäjän kielitaito</xsl:if>
		</td>
	    <td width="1%">&#160;</td>
	  </tr>
	  </xsl:if>
    </xsl:for-each>
  </xsl:if>
  <tr>
    <td class="Label">&#160;</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">&#160;</td>
  </tr>
  <xsl:if test="//field[@name='step6.socialSkills' and @keep='true']">
  <tr>
    <td class="Label">Sosiaaliset taidot</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="europass:learnerinfo/skilllist/skill[@type='social']" /></PRE></td>
  </tr>
  </xsl:if>	  
  <xsl:if test="//field[@name='step6.organisationalSkills' and @keep='true']">
  <tr>
    <td class="Label">Organisatoriset taidot</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="europass:learnerinfo/skilllist/skill[@type='organisational']" /></PRE></td>
  </tr>
  </xsl:if>	  
  <xsl:if test="//field[@name='step6.technicalSkills' and @keep='true']">
  <tr>
    <td class="Label">Tekniset tiedot ja taidot</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="europass:learnerinfo/skilllist/skill[@type='technical']" /></PRE></td>
  </tr>
  </xsl:if>	  
  <xsl:if test="//field[@name='step6.computerSkills' and @keep='true']">
  <tr>
    <td class="Label">Tietotekniset taidot</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="europass:learnerinfo/skilllist/skill[@type='computer']" /></PRE></td>
  </tr>
  </xsl:if>	  
  <xsl:if test="//field[@name='step6.artisticSkills' and @keep='true']">
  <tr>
    <td class="Label">Taiteelliset taidot</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="europass:learnerinfo/skilllist/skill[@type='artistic']" /></PRE></td>
  </tr>
  </xsl:if>	  
  <xsl:if test="//field[@name='step6.otherSkills' and @keep='true']">
  <tr>
    <td class="Label">Muut tiedot ja taidot</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="europass:learnerinfo/skilllist/skill[@type='other']" /></PRE></td>
  </tr>	
  </xsl:if>	  
  <xsl:if test="//field[@name='step6.drivingLicences' and @keep='true']">
  <tr>
    <td class="Label">Ajokortti</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">
        <xsl:for-each select="europass:learnerinfo/skilllist/structured-skill[@xsi:type='europass:driving']/drivinglicence">
            <xsl:if test="position() != 1">,&#160;</xsl:if>
            <xsl:value-of select="current()" />
        </xsl:for-each>
    </td>
  </tr>
  </xsl:if>	  
  <xsl:if test="//field[@name='step7.additionalInfo' and @keep='true']">
  <tr>
    <td class="Heading1">Lisätietoa</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="europass:learnerinfo/misclist/misc[@type='additional']" /></PRE></td>
  </tr>
  </xsl:if>	  
  <xsl:if test="//field[@name='step7.annexes' and @keep='true']">
  <tr>
    <td class="Heading1">Liitteet</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="europass:learnerinfo/misclist/misc[@type='annexes']" /></PRE></td>
  </tr>
  </xsl:if>
</table>
<br/>
<xsl:if test="//field[@name='grid' and @keep='true']">
<table width="710" border="0" cellspacing="0" cellpadding="0" class="Grid">
	<tr class="spacer">
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="20" height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
	</tr>
	<tr>
		<th colspan="6" class="title">Eurooppalainen taso – Itsearviointilokerikko</th>
	</tr>
	<tr class="level">
		<th>A1</th>
		<td>Tunnistan tuttuja sanoja ja kaikkein tavallisimpia sanontoja, jotka koskevat minua itseäni, perhettäni ja lähiympäristöäni, kun minulle puhutaan hitaasti ja selvästi.</td>
		<td>Ymmärrän tuttuja nimiä, sanoja ja hyvin yksinkertaisia lauseita esimerkiksi ilmoituksissa, julisteissa ja luetteloissa.</td>
		<td>Selviydyn kaikkein yksinkertaisimmista keskusteluista, jos puhekumppanini on valmis toistamaan sanottavansa tai ilmaisemaan asian toisin, puhumaan tavallista hitaammin ja auttamaan minua muotoilemaan sen, mitä yritän sanoa. Pystyn esittämään yksinkertaisia kysymyksiä ja vastaamaan sellaisiin arkisia tarpeita tai hyvin tuttuja aiheita käsittelevissä keskusteluissa.</td>
		<td>Osaan käyttää yksinkertaisia sanontoja ja lauseita kuvaamaan, missä asun ja keitä tunnen.</td>
		<td>Pystyn kirjoittamaan lyhyen, yksinkertaisen postikortin, esimerkiksi lomaterveiset. Pystyn täyttämään lomakkeita, joissa kysytään henkilötietoa, esimerkiksi kirjoittamaan nimeni, kansallisuuteni ja osoitteeni hotellin majoittumislomakkeeseen.</td>
	</tr>
	<tr class="level">
		<th>A2</th>
		<td>Ymmärrän muutamia sanontoja ja kaikkein tavallisinta sanastoa, joka liittyy läheisesti omaan elämääni; esimerkiksi aivan keskeinen tieto itsestäni ja perheestäni, ostosten tekeminen, asuinpaikka ja työpaikka. Ymmärrän lyhyiden, selkeiden, yksinkertaisten viestien ja kuulutusten ydinsisällön.</td>
		<td>Pystyn lukemaan hyvin lyhyitä, yksinkertaisia tekstejä. Pystyn löytämään tiettyä, ennustettavissa olevaa tietoa jokapäiväisistä yksinkertaisista teksteistä, esimerkiksi mainoksista, esitteistä, ruokalistoista ja aikatauluista. Ymmärrän lyhyitä, yksinkertaisia henkilökohtaisia kirjeitä.</td>
		<td>Pystyn kommunikoimaan yksinkertaisissa ja rutiininomaisissa tehtävissä, jotka edellyttävät yksinkertaista ja suoraa tiedonvaihtoa tutuista aiheista ja toiminnoista. Selviydyn hyvin lyhyistä keskusteluista, mutta ymmärrän harvoin kylliksi pitääkseni keskustelua itse yllä.</td>
		<td>Pystyn kuvaamaan perhettäni ja muita ihmisiä, elinolojani, koulutustaustaani ja nykyistä tai edellistä työpaikkaani käyttäen, usein luettelomaisesti, aivan yksinkertaisia ilmauksia ja lauseita.</td>
		<td>Pystyn kirjoittamaan lyhyitä, yksinkertaisia muistiinpanoja ja viestejä asioista, jotka liittyvät arkisiin tarpeisiini. Pystyn kirjoittamaan hyvin yksinkertaisen henkilökohtaisen kirjeen esimerkiksi kiittääkseni jotakuta jostakin.</td>
	</tr>
	<tr class="level">
		<th>B1</th>
		<td>Ymmärrän pääkohdat selkeästä yleiskielisestä puheesta, jossa käsitellään esimerkiksi työssä, koulussa tai vapaa-aikana säännöllisesti esiintyviä ja minulle tuttuja aiheita. Tavoitan pääkohdat monista radio- ja tv-ohjelmista, joissa käsitellään ajankohtaisia tai minua henkilökohtaisesti tai ammatillisesti kiinnostavia asioita, kun puhe on melko hidasta ja selvää.</td>
		<td>Ymmärrän tekstejä, joissa on pääasiassa hyvin tavallista arkipäivän kieltä tai työhön liittyvää kieltä. Ymmärrän tapahtumien, tunteiden ja toiveiden kuvaukset henkilökohtaisissa kirjeissä.</td>
		<td>Selviydyn useimmista tilanteista, joita syntyy kohdekielisillä alueilla matkustettaessa. Pystyn osallistumaan valmistautumatta keskusteluun aiheista, jotka ovat tuttuja, itseäni kiinnostavia tai jotka liittyvät arkielämään, esimerkiksi perheeseen, harrastuksiin, työhön, matkustamiseen ja ajankohtaisiin asioihin.</td>
		<td>Osaan liittää yhteen ilmauksia yksinkertaisella tavalla kuvatakseni kokemuksia ja tapahtumia, unelmiani, toiveitani ja pyrkimyksiäni. Pystyn perustelemaan ja selittämään lyhyesti mielipiteitäni ja suunnitelmiani. Pystyn kertomaan tarinan tai selittämään kirjan tai elokuvan juonen sekä kuvailemaan omia reaktioitani.</td>
		<td>Pystyn kirjoittamaan yksinkertaista, yhtenäistä tekstiä aiheista, jotka ovat tuttuja tai itseäni kiinnostavia. Pystyn kirjoittamaan henkilökohtaisia kirjeitä, joissa kuvailen kokemuksia ja vaikutelmia.</td>
	</tr>
	<tr class="level">
		<th>B2</th>
		<td>Ymmärrän pitkähköä puhetta ja luentoja. Pystyn jopa seuraamaan monipolvista perustelua, jos aihe on suhteellisen tuttu. Ymmärrän useimmat tv-uutiset ja ajankohtaisohjelmat. Ymmärrän useimmat yleispuhekielellä esitetyt elokuvat</td>
		<td>Pystyn lukemaan ajankohtaisia ongelmia käsitteleviä artikkeleita ja raportteja ja havaitsemaan niissä kirjoittajien näkökulmat ja kannanotot. Ymmärrän oman aikani kaunokirjallisuutta.</td>
		<td>Pystyn viestimään niin sujuvasti ja spontaanisti, että säännöllinen yhteydenpito syntyperäisten puhujien kanssa on mahdollista ilman että kumpikaan osapuoli kokee sen hankalaksi. Pystyn osallistumaan aktiivisesti tutuista aihepiireistä käytävään keskusteluun, esittämään näkemyksiäni ja puolustamaan niitä.</td>
		<td>Pystyn esittämään selkeitä, yksityiskohtaisia kuvauksia hyvinkin erilaisista minua kiinnostavista aiheista. Pystyn selittämään näkökantani johonkin ajankohtaiseen kysymykseen ja esittämään eri vaihtoehtojen edut ja haitat.</td>
		<td>Pystyn kirjoittamaan selkeitä, myös yksityiskohtia sisältäviä selvityksiä hyvinkin erilaisista aiheista, jotka kiinnostavat minua. Pystyn laatimaan kirjoitelman tai raportin, jossa välitän tietoa tai esitän perusteluja jonkin tietyn näkökannan puolesta tai sitä vastaan. Pystyn kirjoittamaan kirjeitä, joissa korostan tapahtumien tai kokemusten henkilökohtaista merkitystä.</td>
	</tr>
	<tr class="level">
		<th>C1</th>
		<td>Ymmärrän pitkähköä puhetta silloinkin, kun sitä ei ole muotoiltu selkeästi ja kun asioiden välisiin suhteisiin vain viitataan eikä niitä ilmaista täsmällisesti. Ymmärrän tv-ohjelmia ja elokuvia ilman erityisiä ponnistuksia</td>
		<td>Ymmärrän pitkiä ja monipolvisia asia- ja kirjallisuustekstejä ja huomaan tyylieroja. Ymmärrän erityisalojen artikkeleita ja melko pitkiä teknisiä ohjeita silloinkin, kun ne eivät liity omaan alaani.</td>
		<td>Pystyn ilmaisemaan ajatuksiani sujuvasti ja spontaanisti ilman että minun juurikaan tarvitsee hakea ilmauksia. Osaan käyttää kieltä joustavasti ja tehokkaasti sosiaalisiin ja ammatillisiin tarkoituksiin. Osaan muotoilla ajatuksia ja mielipiteitä täsmällisesti ja liittää oman puheenvuoroni taitavasti muiden puhujien puheenvuoroihin.</td>
		<td>Pystyn esittämään selkeitä ja yksityiskohtaisia kuvauksia monipolvisista aiheista ja kehittelemään keskeisiä näkökohtia sekä päättämään esitykseni sopivaan lopetukseen.</td>
		<td>Pystyn ilmaisemaan ajatuksiani ja näkökantojani varsin laajasti selkeässä, hyvin jäsennetyssä tekstissä. Pystyn kirjoittamaan yksityiskohtaisia selvityksiä monipolvisista aiheista kirjeessä, esseessä/kirjoitelmassa tai raportissa sekä korostamaan tärkeimpinä pitämiäni seikkoja. Osaan valita oletetulle lukijalle sopivan tyylin.</td>
	</tr>
	<tr class="level">
		<th>C2</th>
		<td>Ymmärrän vaikeuksitta kaikenlaista elävää ja nauhoitettua puhetta silloinkin, kun on kyse syntyperäisen kielenpuhujan nopeasta puheesta, jos minulla on hiukan aikaa tutustua puhetapaan.</td>
		<td>Pystyn lukemaan vaivatta käytännöllisesti katsoen kaikenlaista kirjoitettua kieltä, myös abstrakteja, rakenteellisesti tai kielellisesti monimutkaisia tekstejä, kuten ohjekirjoja, erityisalojen artikkeleita ja kaunokirjallisuutta.</td>
		<td>Pystyn ottamaan vaivatta osaa asioiden käsittelyyn ja kaikkiin keskusteluihin. Tunnen hyvin kielelle tyypilliset, idiomaattiset ilmaukset ja puhekieliset ilmaukset. Pystyn tuomaan esille ajatuksiani sujuvasti ja välittämään täsmällisesti hienojakin merkitysvivahteita. Osaan perääntyä ja kiertää mahdolliset ongelmat niin sujuvasti, että muut tuskin havaitsevat olleenkaan ongelmia.</td>
		<td>Pystyn esittämään selkeän ja sujuvan kuvauksen tai perustelun asiayhteyteen sopivalla tyylillä. Esityksessäni on tehokas looginen rakenne, joka auttaa vastaanottajaa havaitsemaan ja muistamaan tärkeitä seikkoja.</td>
		<td>Osaan kirjoittaa selkeää, sujuvaa tekstiä asiaankuuluvalla tyylillä. Pystyn kirjoittamaan monimutkaisia kirjeitä, raportteja tai artikkeleita, jotka esittelevät jonkin yksittäisen tapauksen. Käytän tehokkaasti loogisia rakenteita, jotka auttavat vastaanottajaa löytämään ja muistamaan keskeiset seikat. Pystyn kirjoittamaan koosteita ja katsauksia ammattiin tai kaunokirjallisuuteen liittyvistä julkaisuista.</td>
	</tr>
</table>
</xsl:if>		
		<img style="display: none" src="http://europass.cedefop.europa.eu/instruments/images/cv_verline.gif" /> 
		<img style="display: none" src="http://europass.cedefop.europa.eu/instruments/images/logo_for_htmlpreview.gif" /> 
		<img style="display: none" src="http://europass.cedefop.europa.eu/instruments/images/bg_win4.jpg" /> 
	</body>
</html>
</xsl:template>
</xsl:stylesheet>
