<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet  [
	<!ENTITY nbsp   "&#160;">
  <!ENTITY copy   "&#169;">
]>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:europass="http://europass.cedefop.europa.eu/Europass/V2.0">
<xsl:template match="/">
<xsl:comment>
  # 
	© European Communities, 2002-2008 http://europass.cedefop.europa.eu
  # http://europass.cedefop.europa.eu/europass/home/botnav/LegalNotice.csp
  # Name      : cv_da_DK_V2.0.xsl
  # Version   : V2.0
  # Purpose   : Provides a way to show the Europass CV in HTML format.
  # Author(s) : Europass team
  # URL       : http://europass.cedefop.europa.eu/TechnicalResources/XML/xsl/europass-xsl-V2.0/cv_da_DK_V2.0.xsl
</xsl:comment>
<xsl:variable name="firstNameBefore">
<xsl:choose>
  <xsl:when test="//field[@name='step1.firstName' and @before='step1.lastName']">1</xsl:when>
  <xsl:otherwise>0</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:variable name="step3Before">
<xsl:choose>
  <xsl:when test="//field[@name='step3List' and @before='step4List']">1</xsl:when>
  <xsl:otherwise>0</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<html>
  <head>
    <title>CV - HTML</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <link href="http://europass.cedefop.europa.eu/instruments/css/html.css" type="text/css" rel="stylesheet"/>
  </head>
<body>
<table width="700" border="0" cellspacing="0" cellpadding="0" class="CV">
  <tr>
    <td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" height="1" width="190"/></td>
    <td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" height="1" width="7"/></td>
	<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" height="1" width="8"/></td>
    <td colspan="11"><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" height="1" width="495"/></td>
  </tr>
  <tr>
    <td class="Logo" rowspan="2">&#160;</td>
	<td style="height:42px;">&#160;</td>
    <td colspan="12" rowspan="2">&#160;</td>
  </tr>
  <tr>
    <td class="Corner">&#160;</td>
  </tr>
  <tr>
    <td class="Heading1">&#160;</td>
    <td class="VerticalLine">&#160;</td>
	<td>&#160;</td>
    <td class="Normal" colspan="11">&#160;</td>
  </tr>
  <tr>
    <td class="Title">
	  Europass<br/>
      Curriculum Vitae
	</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">&#160;</td>
  </tr>
  <tr>
    <td class="Heading1">&#160;</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">&#160;</td>
  </tr>
  <tr>
    <td class="Heading1">Personlige oplysninger</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">&#160;</td>
  </tr>
  <tr>
    <td class="Label">
	  <xsl:choose>
	    <xsl:when test="$firstNameBefore=0">
	      Familienavn(e)&#160;Fornavn(e)
	    </xsl:when>
	    <xsl:otherwise>
		  Fornavn(e)&#160;Familienavn(e)
	    </xsl:otherwise>
	  </xsl:choose>
	</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Heading2" colSpan="11">
	  <xsl:choose>
	    <xsl:when test="$firstNameBefore=0">
          <xsl:value-of select="europass:learnerinfo/identification/lastname" />&#160;<xsl:value-of select="europass:learnerinfo/identification/firstname" />
		</xsl:when>
	    <xsl:otherwise>
		  <xsl:value-of select="europass:learnerinfo/identification/firstname" />&#160;<xsl:value-of select="europass:learnerinfo/identification/lastname" />
		</xsl:otherwise>
	  </xsl:choose>
	</td>
  </tr>
  <xsl:if test="//field[@name='step1.addressInfo' and @keep='true']">
  <tr>
    <td class="Label">Adresse(r)</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">
      <xsl:for-each select="europass:learnerinfo/identification/contactinfo/address/addressLine">
        <xsl:value-of select="current()" /><br/>
      </xsl:for-each>
      <xsl:if test="string-length(europass:learnerinfo/identification/contactinfo/address/postalCode) != 0">
      <xsl:value-of select="europass:learnerinfo/identification/contactinfo/address/postalCode" />, </xsl:if>
      <xsl:value-of select="europass:learnerinfo/identification/contactinfo/address/municipality" />
      <xsl:if test="string-length(europass:learnerinfo/identification/contactinfo/address/country/label) != 0"> (<xsl:value-of select="europass:learnerinfo/identification/contactinfo/address/country/label" />)</xsl:if>
    </td>
  </tr>
  </xsl:if>
  <xsl:if test="//field[@name='step1.mobile' and @keep='true']">
  <tr>
    <td class="Label">Telefon</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="5">
	  <xsl:value-of select="europass:learnerinfo/identification/contactinfo/telephone" />
	</td>
    <td class="Label" width="15%" colSpan="2">Mobil</td>
    <td class="Normal" colSpan="4">
	  <xsl:value-of select="europass:learnerinfo/identification/contactinfo/mobile" />
	</td>
  </tr>
  </xsl:if>
  <xsl:if test="//field[@name='step1.fax' and @keep='true']">
  <tr>
    <td class="Label">Fax</td>
    <td class="VerticalLine">&#160;</td>
	<td>&#160;</td>
    <td class="Normal" colspan="11">
	  <xsl:value-of select="europass:learnerinfo/identification/contactinfo/fax" />
	</td>
  </tr>
  </xsl:if>
  <xsl:if test="//field[@name='step1.email' and @keep='true']">
  <tr>
    <td class="Label">E-mail-adresse(r)</td>
    <td class="VerticalLine">&#160;</td>
	<td>&#160;</td>
    <td class="Normal" colspan="11">
	  <xsl:value-of select="europass:learnerinfo/identification/contactinfo/email" />
	</td>
  </tr>
  </xsl:if>
  <xsl:if test="//field[@name='step1.nationality' and @keep='true']">
  <tr>
    <td class="Label">Nationalitet</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">
      <xsl:for-each select="europass:learnerinfo/identification/demographics/nationality/label">
    		<xsl:if test="position() != 1">,&#160;</xsl:if>
        <xsl:value-of select="current()"/>
    	</xsl:for-each>
    </td>
  </tr>
  </xsl:if>
  <xsl:if test="//field[@name='step1.birthDate' and @keep='true']">
  <tr>
    <td class="Label">Fødselsdato</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">
    	<xsl:value-of select="substring(europass:learnerinfo/identification/demographics/birthdate, 9, 2)" />/<xsl:value-of select="substring(europass:learnerinfo/identification/demographics/birthdate, 6, 2)" />/<xsl:value-of select="substring(europass:learnerinfo/identification/demographics/birthdate, 1, 4)" />
    </td>
  </tr>
  </xsl:if>
  <xsl:if test="//field[@name='step1.gender' and @keep='true']">
  <tr>
    <td class="Label">Køn</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">
	  <xsl:if test="europass:learnerinfo/identification/demographics/gender='M'"><xsl:text>Hankøn</xsl:text></xsl:if>
	  <xsl:if test="europass:learnerinfo/identification/demographics/gender='F'"><xsl:text>Hunkøn</xsl:text></xsl:if>
	</td>
  </tr>
  </xsl:if>
  <xsl:if test="//field[@name='step1.application' and @keep='true']">
  <tr>
    <td class="Heading1">Ønsket beskæftigelse / erhvervsområde</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">
	  <PRE><xsl:value-of select="europass:learnerinfo/application/label" /></PRE>
	</td>
  </tr>
  </xsl:if>
  
  
  <xsl:choose>
    <xsl:when test="$step3Before=1">
	  <xsl:if test="//field[@name='step3List' and @keep='true']">
	  <tr>
	    <td class="Heading1">Arbejdserfaring</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11">&#160;</td>
	  </tr>
	  <xsl:for-each select="europass:learnerinfo/workexperiencelist/workexperience">
		  <tr>
		    <td class="Label">Datoer</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11">
		    		<xsl:value-of select="translate(period/from/day,'-','')" />
		    		<xsl:if test="string-length(period/from/day) != 0">/</xsl:if>
				<xsl:value-of select="translate(period/from/month,'-','')" />
				<xsl:if test="string-length(period/from/month) != 0">/</xsl:if>
				<xsl:value-of select="translate(period/from/year,'-','')" />
				<xsl:if test="string-length(period/to/day) != 0 or string-length(period/to/month) != 0 or string-length(period/to/year) != 0">
				-
				</xsl:if>
				<xsl:value-of select="translate(period/to/day,'-','')" />
				<xsl:if test="string-length(period/to/day) != 0">/</xsl:if>
				<xsl:value-of select="translate(period/to/month,'-','')" />
				<xsl:if test="string-length(period/to/month) != 0">/</xsl:if>
				<xsl:value-of select="translate(period/to/year,'-','')" />
			</td>
		  </tr>
		  <xsl:variable name="indexedStep3">
			<xsl:value-of select="concat('step3List[', position()-1, ']')" />
		  </xsl:variable>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.position') and @keep='true']">
		  <tr>
		    <td class="Label">Beskæftigelse eller stilling</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11"><xsl:value-of select="position/label" /></td>
		  </tr>
		  </xsl:if>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.activities') and @keep='true']">
		  <tr>
		    <td class="Label">Vigtigste aktiviteter og ansvarsområder</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="activities" /></PRE></td>
		  </tr>
		  </xsl:if>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.company.name') and @keep='true']">
		  <tr>
		    <td class="Label">Arbejdsgivers navn og adresse</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11">
          <PRE><xsl:value-of select="employer/name" /></PRE>
          <xsl:if test="//field[@name=concat($indexedStep3,'.company.addressInfo') and @keep='true']">
            <xsl:for-each select="employer/address/addressLine">
              <xsl:value-of select="current()" /><br/>
            </xsl:for-each>
            <xsl:if test="string-length(employer/address/postalCode) != 0"><xsl:value-of select="employer/address/postalCode" />, </xsl:if>
            <xsl:value-of select="employer/address/municipality" />
            <xsl:if test=" string-length(employer/address/country/label) != 0"> (<xsl:value-of select="employer/address/country/label" />)</xsl:if>
          </xsl:if>
		    </td>
		  </tr>
		  </xsl:if>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.company.sector.label') and @keep='true']">
		  <tr>
		    <td class="Label">Virksomhed eller sektor</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11"><xsl:value-of select="employer/sector/label" /></td>
		  </tr>
		  </xsl:if>
		  <tr>
		    <td class="Label">&#160;</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11">&#160;</td>
		  </tr>
	  </xsl:for-each>
	  </xsl:if>
	  <xsl:if test="//field[@name='step4List' and @keep='true']">
	  <tr>
	    <td class="Heading1">Almen og erhvervsrettet uddannelse</td>
	    <td class="VerticalLine">&#160;</td>
		<td>&#160;</td>
	    <td class="Normal" colspan="11">&#160;</td>
	  </tr>
	  <xsl:for-each select="europass:learnerinfo/educationlist/education">
	  <tr>
	    <td class="Label">Datoer</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11">
			<xsl:value-of select="translate(period/from/day,'-','')" />
	    		<xsl:if test="string-length(period/from/day) != 0">/</xsl:if>
			<xsl:value-of select="translate(period/from/month,'-','')" />
			<xsl:if test="string-length(period/from/month) != 0">/</xsl:if>
			<xsl:value-of select="translate(period/from/year,'-','')" />
			<xsl:if test="string-length(period/to/day) != 0 or string-length(period/to/month) != 0 or string-length(period/to/year) != 0">
			-
			</xsl:if>
			<xsl:value-of select="translate(period/to/day,'-','')" />
			<xsl:if test="string-length(period/to/day) != 0">/</xsl:if>
			<xsl:value-of select="translate(period/to/month,'-','')" />
			<xsl:if test="string-length(period/to/month) != 0">/</xsl:if>
			<xsl:value-of select="translate(period/to/year,'-','')" />
		</td>
	  </tr>
	  <xsl:variable name="indexedStep4">
	    <xsl:value-of select="concat('step4List[', position()-1, ']')" />
	  </xsl:variable>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.title') and @keep='true']">
	  <tr>
	    <td class="Label">Uddannelsens betegnelse</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11"><xsl:value-of select="title" /></td>
	  </tr>
	  </xsl:if>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.skills') and @keep='true']">
	  <tr>
	    <td class="Label">Vigtigste fag/erhvervskvalifikationer</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="skills" /></PRE></td>
	  </tr>
	  </xsl:if>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.educationalOrg.name') and @keep='true']">
	  <tr>
	    <td class="Label">Uddannelsesinstitutionens betegnelse og type</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11">
        <PRE><xsl:value-of select="organisation/name" /><xsl:if test="string-length(organisation/type) != 0">(<xsl:value-of select="organisation/type" />)</xsl:if></PRE>
        <xsl:if test="//field[@name=concat($indexedStep4,'.educationalOrg.addressInfo') and @keep='true']">
          <xsl:for-each select="organisation/address/addressLine">
            <xsl:value-of select="current()" /><br/>
          </xsl:for-each>
          <xsl:if test="string-length(organisation/address/postalCode) != 0"><xsl:value-of select="organisation/address/postalCode" />, </xsl:if>
          <xsl:value-of select="organisation/address/municipality" />
          <xsl:if test="string-length(organisation/address/country/label) != 0"> (<xsl:value-of select="organisation/address/country/label" />)</xsl:if>
        </xsl:if>
      </td>
	  </tr>
	  </xsl:if>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.level.label') and @keep='true']">
	  <tr>
	    <td class="Label">Niveau efter national eller international klassificering</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11"><xsl:value-of select="level/label" /></td>
	  </tr>
	  </xsl:if>
	  <tr>
	    <td class="Label">&#160;</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11">&#160;</td>
	  </tr>          
	  </xsl:for-each>
	  </xsl:if>
	</xsl:when>
	<xsl:otherwise>
	  <xsl:if test="//field[@name='step4List' and @keep='true']">
	  <tr>
	    <td class="Heading1">Almen og erhvervsrettet uddannelse</td>
	    <td class="VerticalLine">&#160;</td>
		<td>&#160;</td>
	    <td class="Normal" colspan="11">&#160;</td>
	  </tr>
	  <xsl:for-each select="europass:learnerinfo/educationlist/education">
	  <tr>
	    <td class="Label">Datoer</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11">
			<xsl:value-of select="translate(period/from/day,'-','')" />
	    		<xsl:if test="string-length(period/from/day) != 0">/</xsl:if>
			<xsl:value-of select="translate(period/from/month,'-','')" />
			<xsl:if test="string-length(period/from/month) != 0">/</xsl:if>
			<xsl:value-of select="translate(period/from/year,'-','')" />
			<xsl:if test="string-length(period/to/day) != 0 or string-length(period/to/month) != 0 or string-length(period/to/year) != 0">
			-
			</xsl:if>
			<xsl:value-of select="translate(period/to/day,'-','')" />
			<xsl:if test="string-length(period/to/day) != 0">/</xsl:if>
			<xsl:value-of select="translate(period/to/month,'-','')" />
			<xsl:if test="string-length(period/to/month) != 0">/</xsl:if>
			<xsl:value-of select="translate(period/to/year,'-','')" />
		</td>
	  </tr>
	  <xsl:variable name="indexedStep4">
	    <xsl:value-of select="concat('step4List[', position()-1, ']')" />
	  </xsl:variable>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.title') and @keep='true']">
	  <tr>
	    <td class="Label">Uddannelsens betegnelse</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11"><xsl:value-of select="title" /></td>
	  </tr>
	  </xsl:if>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.skills') and @keep='true']">
	  <tr>
	    <td class="Label">Vigtigste fag/erhvervskvalifikationer</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="skills" /></PRE></td>
	  </tr>
	  </xsl:if>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.educationalOrg.name') and @keep='true']">
	  <tr>
	    <td class="Label">Uddannelsesinstitutionens betegnelse og type</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11">
                <PRE><xsl:value-of select="organisation/name" /><xsl:if test="string-length(organisation/type) != 0">(<xsl:value-of select="organisation/type" />)</xsl:if></PRE>
            </td>
	  </tr>
	  </xsl:if>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.educationalOrg.addressInfo') and @keep='true']">
		  <tr>
		    <td class="Label">Adresse(r)</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11">
                      <xsl:for-each select="organisation/address/addressLine">
                        <xsl:value-of select="current()" /><br/>
                      </xsl:for-each>
                      <xsl:value-of select="organisation/address/postalCode" /><br/>
                      <xsl:value-of select="organisation/address/municipality" /><br/>
                      <xsl:value-of select="organisation/address/country/label" /><br/>
                    </td>
		  </tr>
          </xsl:if>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.level.label') and @keep='true']">
	  <tr>
	    <td class="Label">Niveau efter national eller international klassificering</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11"><xsl:value-of select="level/label" /></td>
	  </tr>
	  </xsl:if>
	  <tr>
	    <td class="Label">&#160;</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11">&#160;</td>
	  </tr>          
	  </xsl:for-each>
	  </xsl:if>
	  <xsl:if test="//field[@name='step3List' and @keep='true']">
	  <tr>
	    <td class="Heading1">Arbejdserfaring</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11">&#160;</td>
	  </tr>
	  <xsl:for-each select="europass:learnerinfo/workexperiencelist/workexperience">
		  <tr>
		    <td class="Label">Datoer</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11">
		    		<xsl:value-of select="translate(period/from/day,'-','')" />
		    		<xsl:if test="string-length(period/from/day) != 0">/</xsl:if>
				<xsl:value-of select="translate(period/from/month,'-','')" />
				<xsl:if test="string-length(period/from/month) != 0">/</xsl:if>
				<xsl:value-of select="translate(period/from/year,'-','')" />
				<xsl:if test="string-length(period/to/day) != 0 or string-length(period/to/month) != 0 or string-length(period/to/year) != 0">
				-
				</xsl:if>
				<xsl:value-of select="translate(period/to/day,'-','')" />
				<xsl:if test="string-length(period/to/day) != 0">/</xsl:if>
				<xsl:value-of select="translate(period/to/month,'-','')" />
				<xsl:if test="string-length(period/to/month) != 0">/</xsl:if>
				<xsl:value-of select="translate(period/to/year,'-','')" />
			</td>
		  </tr>
		  <xsl:variable name="indexedStep3">
			<xsl:value-of select="concat('step3List[', position()-1, ']')" />
		  </xsl:variable>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.position') and @keep='true']">
		  <tr>
		    <td class="Label">Beskæftigelse eller stilling</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11"><xsl:value-of select="position/label" /></td>
		  </tr>
		  </xsl:if>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.activities') and @keep='true']">
		  <tr>
		    <td class="Label">Vigtigste aktiviteter og ansvarsområder</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="activities" /></PRE></td>
		  </tr>
		  </xsl:if>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.company.name') and @keep='true']">
		  <tr>
		    <td class="Label">Arbejdsgivers navn og adresse</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="employer/name" /></PRE></td>
		  </tr>
		  </xsl:if>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.company.addressInfo') and @keep='true']">
		  <tr>
		    <td class="Label">Adresse(r)</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11">
                      <xsl:for-each select="employer/address/addressLine">
                        <xsl:value-of select="current()" /><br/>
                      </xsl:for-each>
                      <xsl:value-of select="employer/address/postalCode" /><br/>
                      <xsl:value-of select="employer/address/municipality" /><br/>
                      <xsl:value-of select="employer/address/country/label" /><br/>
                    </td>
		  </tr>
		  </xsl:if>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.company.sector.label') and @keep='true']">
		  <tr>
		    <td class="Label">Virksomhed eller sektor</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11"><xsl:value-of select="employer/sector/label" /></td>
		  </tr>
		  </xsl:if>
		  <tr>
		    <td class="Label">&#160;</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11">&#160;</td>
		  </tr>
	  </xsl:for-each>
	  </xsl:if>
	</xsl:otherwise>
  </xsl:choose>
  
  <tr>
    <td class="Heading1">Personlige færdigheder og kompetencer</td>
    <td class="VerticalLine">&#160;</td>
	<td>&#160;</td>
    <td colspan="11" class="Normal">&#160;</td>
  </tr>
  <xsl:if test="//field[@name='step5.motherLanguages' and @keep='true']">
  <tr>
    <td class="Label">Modersmål</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Heading2" colSpan="11"><xsl:value-of select="europass:learnerinfo/languagelist/language[@xsi:type='europass:mother']/label" /></td>
  </tr>
  </xsl:if>
  <xsl:if test="//field[@name='step5.foreignLanguageList' and @keep='true']">
  <tr>
    <td class="Label">Andre sprog</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">&#160;</td></tr>
  <tr>
    <td class="Label">Egen bedømmelse</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Heading2Center" colSpan="4">Forstå</td>
    <td class="Heading2Center" colSpan="4">Tale</td>
    <td class="Heading2Center" colSpan="2">Skrive</td>
    <td width="1%">&#160;</td>
  </tr>
  <tr>
    <td class="Label">Europæisk niveau</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="NormalSmall" colSpan="2">Lytte</td>
    <td class="NormalSmall" colSpan="2">Læse</td>
    <td class="NormalSmall" colSpan="2">Samtale</td>
    <td class="NormalSmall" colSpan="2">Talefærdighed</td>
    <td class="NormalSmall" colSpan="2">&#160;</td>
    <td width="1%">&#160;</td>
  </tr>
    <xsl:for-each select="europass:learnerinfo/languagelist/language[@xsi:type='europass:foreign']">
	  <xsl:variable name="indexedLang">
        <xsl:value-of select="concat('step5.foreignLanguageList[', position()-1, ']')" />
      </xsl:variable>
      <xsl:if test="//field[@name=$indexedLang and @keep='true']">
      <tr>
	    <td class="Heading1Box"><xsl:value-of select="label" /></td>
	    <td class="VerticalLineBox">&#160;</td>
	    <td>&#160;</td>
	    <td class="NormalSmall" width="5%"><xsl:value-of select="level/listening" /></td>
	    <td class="NormalSmall">
			<xsl:if test="level/listening='a1'">Sprogbruger med basiskundskaber</xsl:if>
		    <xsl:if test="level/listening='b1'">Selvstændig sprogbruger</xsl:if>
			<xsl:if test="level/listening='c1'">Kompetent sprogbruger</xsl:if>
			
			<xsl:if test="level/listening='a2'">Sprogbruger med basiskundskaber</xsl:if>
		    <xsl:if test="level/listening='b2'">Selvstændig sprogbruger</xsl:if>
			<xsl:if test="level/listening='c2'">Kompetent sprogbruger</xsl:if>
	    </td>
		<td class="NormalSmall" width="5%"><xsl:value-of select="level/reading" /></td>
	    <td class="NormalSmall">
			<xsl:if test="level/reading='a1'">Sprogbruger med basiskundskaber</xsl:if>
			<xsl:if test="level/reading='b1'">Selvstændig sprogbruger</xsl:if>
			<xsl:if test="level/reading='c1'">Kompetent sprogbruger</xsl:if>
		
			<xsl:if test="level/reading='a2'">Sprogbruger med basiskundskaber</xsl:if>
			<xsl:if test="level/reading='b2'">Selvstændig sprogbruger</xsl:if>
			<xsl:if test="level/reading='c2'">Kompetent sprogbruger</xsl:if>
		</td>
	    <td class="NormalSmall" width="5%"><xsl:value-of select="level/spokeninteraction" /></td>
	    <td class="NormalSmall">
			<xsl:if test="level/spokeninteraction='a1'">Sprogbruger med basiskundskaber</xsl:if>
			<xsl:if test="level/spokeninteraction='b1'">Selvstændig sprogbruger</xsl:if>
			<xsl:if test="level/spokeninteraction='c1'">Kompetent sprogbruger</xsl:if>
		
			<xsl:if test="level/spokeninteraction='a2'">Sprogbruger med basiskundskaber</xsl:if>
			<xsl:if test="level/spokeninteraction='b2'">Selvstændig sprogbruger</xsl:if>
			<xsl:if test="level/spokeninteraction='c2'">Kompetent sprogbruger</xsl:if>
		</td>
		<td class="NormalSmall" width="5%"><xsl:value-of select="level/spokenproduction" /></td>
	    <td class="NormalSmall">
			<xsl:if test="level/spokenproduction='a1'">Sprogbruger med basiskundskaber</xsl:if>
			<xsl:if test="level/spokenproduction='b1'">Selvstændig sprogbruger</xsl:if>
			<xsl:if test="level/spokenproduction='c1'">Kompetent sprogbruger</xsl:if>
		
			<xsl:if test="level/spokenproduction='a2'">Sprogbruger med basiskundskaber</xsl:if>
			<xsl:if test="level/spokenproduction='b2'">Selvstændig sprogbruger</xsl:if>
			<xsl:if test="level/spokenproduction='c2'">Kompetent sprogbruger</xsl:if>
		</td>
	    <td class="NormalSmall" width="5%"><xsl:value-of select="level/writing" /></td>
	    <td class="NormalSmall">
			<xsl:if test="level/writing='a1'">Sprogbruger med basiskundskaber</xsl:if>
			<xsl:if test="level/writing='b1'">Selvstændig sprogbruger</xsl:if>
			<xsl:if test="level/writing='c1'">Kompetent sprogbruger</xsl:if>
		
			<xsl:if test="level/writing='a2'">Sprogbruger med basiskundskaber</xsl:if>
			<xsl:if test="level/writing='b2'">Selvstændig sprogbruger</xsl:if>
			<xsl:if test="level/writing='c2'">Kompetent sprogbruger</xsl:if>
		</td>
	    <td width="1%">&#160;</td>
	  </tr>
	  </xsl:if>
    </xsl:for-each>
  </xsl:if>
  <tr>
    <td class="Label">&#160;</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">&#160;</td>
  </tr>
  <xsl:if test="//field[@name='step6.socialSkills' and @keep='true']">
  <tr>
    <td class="Label">Sociale færdigheder og kompetencer</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="europass:learnerinfo/skilllist/skill[@type='social']" /></PRE></td>
  </tr>
  </xsl:if>	  
  <xsl:if test="//field[@name='step6.organisationalSkills' and @keep='true']">
  <tr>
    <td class="Label">Organisatoriske færdigheder og kompetencer</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="europass:learnerinfo/skilllist/skill[@type='organisational']" /></PRE></td>
  </tr>
  </xsl:if>	  
  <xsl:if test="//field[@name='step6.technicalSkills' and @keep='true']">
  <tr>
    <td class="Label">Tekniske færdigheder og kompetencer</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="europass:learnerinfo/skilllist/skill[@type='technical']" /></PRE></td>
  </tr>
  </xsl:if>	  
  <xsl:if test="//field[@name='step6.computerSkills' and @keep='true']">
  <tr>
    <td class="Label">Computerfærdigheder og -kompetencer</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="europass:learnerinfo/skilllist/skill[@type='computer']" /></PRE></td>
  </tr>
  </xsl:if>	  
  <xsl:if test="//field[@name='step6.artisticSkills' and @keep='true']">
  <tr>
    <td class="Label">Kunstneriske færdigheder og kompetencer</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="europass:learnerinfo/skilllist/skill[@type='artistic']" /></PRE></td>
  </tr>
  </xsl:if>	  
  <xsl:if test="//field[@name='step6.otherSkills' and @keep='true']">
  <tr>
    <td class="Label">Andre færdigheder og kompetencer</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="europass:learnerinfo/skilllist/skill[@type='other']" /></PRE></td>
  </tr>	
  </xsl:if>	  
  <xsl:if test="//field[@name='step6.drivingLicences' and @keep='true']">
  <tr>
    <td class="Label">Kørekort</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">
        <xsl:for-each select="europass:learnerinfo/skilllist/structured-skill[@xsi:type='europass:driving']/drivinglicence">
            <xsl:if test="position() != 1">,&#160;</xsl:if>
            <xsl:value-of select="current()" />
        </xsl:for-each>
    </td>
  </tr>
  </xsl:if>	  
  <xsl:if test="//field[@name='step7.additionalInfo' and @keep='true']">
  <tr>
    <td class="Heading1">Yderligere informationer</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="europass:learnerinfo/misclist/misc[@type='additional']" /></PRE></td>
  </tr>
  </xsl:if>	  
  <xsl:if test="//field[@name='step7.annexes' and @keep='true']">
  <tr>
    <td class="Heading1">Bilag</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="europass:learnerinfo/misclist/misc[@type='annexes']" /></PRE></td>
  </tr>
  </xsl:if>
</table>
<br/>
<xsl:if test="//field[@name='grid' and @keep='true']">
<table width="710" border="0" cellspacing="0" cellpadding="0" class="Grid">
	<tr class="spacer">
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="20" height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
	</tr>
	<tr>
		<th colspan="6" class="title">Europæiske niveauer - Selvevaluieringsskala</th>
	</tr>
	<tr class="level">
		<th>A1</th>
		<td>Jeg kan forstå meget enkle ytringer om mig selv, mennesker jeg kender og ting omkring mig, når folk taler langsomt og tydeligt.</td>
		<td>Jeg kan forstå dagligdags navne, ord og meget enkle sætninger, fx i annoncer, på opslag og plakater eller i brochurer.</td>
		<td>Jeg kan føre enkle samtaler hvis min samtalepartner er indstillet på at gentage eller at omformulere sine sætninger og  tale langsommeret, samt hjælpe mig med at formulere det, jeg prøver på at sige.
Jeg kan stille og besvare enkle spørgsmål omkring dagligdags emner.</td>
		<td>Jeg kan med enkle sætninger og et begrænset ordforråd beskrive hvor jeg bor og fortælle om folk, jeg kender.</td>
		<td>Jeg kan skrive korte, enkle postkort, fx sende feriehilsner. Jeg kan udfylde formularer med personlige oplysninger, fx skrive navn, nationalitet og  adresse på en hotelregistrering.</td>
	</tr>
	<tr class="level">
		<th>A2</th>
		<td>Jeg kan forstå de mest almindelige ord og udtryk for ting, der er vigtige for mig, fx oplysninger om mig selv, om min familie, om indkøb, mit nærmiljø og mit arbejde. Jeg kan forstå hovedindholdet i korte og klare  beskeder og meddelelser.</td>
		<td>Jeg kan læse meget korte og enkle tekster. Jeg kan finde bestemte oplysninger, jeg leder efter i dagligdags tekster såsom reklamer, brochurer, spisekort og fartplaner, og jeg kan forstå korte, enkle personlige breve.</td>
		<td>Jeg kan deltage i samtale om enkle  hverdagssituationer, der kun lægger op til en udveksling af informationer. 
Jeg kan deltage i en kort meningsudveksling, skønt jeg normalt endnu ikke forstår nok til at kunne uddybe samtalen.</td>
		<td>Jeg kan bruge en række udtryk og enkle vendinger til at beskrive min familie og andre omkring mig, min dagligdag, min uddannelsesmæssige baggrund og mit arbejde – nu eller tidligere.</td>
		<td>Jeg kan skrive korte, enkle notater og beskeder. 
Jeg kan skrive et meget enkelt, personligt brev, fx et takkebrev.</td>
	</tr>
	<tr class="level">
		<th>B1</th>
		<td>Jeg kan forstå hovedindholdet når der er tale om dagligdags emner som fx arbejde, skole, fritid etc. og sproget er klart og præcist.</td>
		<td>Jeg kan forstå tekster, der er skrevet i et dagligdags sprog eller relaterer sig til mit arbejde. Jeg kan forstå indholdet af personlige breve, hvor afsenderen  beskriver sine oplevelser, følelser og ønsker.</td>
		<td>Jeg kan klare de fleste situationer, der opstår ved  rejse i lande eller områder, hvor sproget tales. Jeg kan uforberedt indgå i en samtale om emner af personlig interesse eller  generelle hverdagsemner som fx familie, fritid, arbejde, rejse og aktuelle begivenheder.</td>
		<td>Jeg kan bruge udtryk og vendinger til at redegøre for oplevelser, mine drømme, håb og forventninger. Jeg kan kort  forklare og begrunde mine meninger og planer. Jeg kan fortælle en historie, give et resume af en bog eller af en film og beskrive mine indtryk af dem.</td>
		<td>Jeg kan skrive en enkel og sammenhængende tekst om dagligdags temaer eller om emner, som interesserer mig personligt. 
Jeg kan skrive personlige breve, hvor jeg beskriver oplevelser og indtryk.</td>
	</tr>
	<tr class="level">
		<th>B2</th>
		<td>Jeg kan forstå længere sammenhængende tale og foredrag og kan følge med i en indviklet ordveksling, forudsat at jeg har rimelig indsigt i emnet. Jeg kan forstå de fleste nyhedsudsendelser på tv. Jeg kan forstå de fleste film, hvor sproget forekommer i en standard version.</td>
		<td>Jeg kan læse artikler og rapporter om aktuelle emner i hvilke forfatteren indtager en bestemt holdning til et problem eller udtrykker et bestemt synspunkt. Jeg kan forstå de fleste moderne noveller og lettilgængelige romaner.</td>
		<td>Jeg kan samtale og diskutere så pas flydende og frit, at jeg forholdsvis utvungent kan føre en samtale med ’native speakers’ 
Jeg kan tage aktivt del i diskussioner om dagligdags emner, samt forklare og forsvare mine synspunkter.</td>
		<td>Jeg kan klart og detaljeret redegøre for forhold vedrørende mine interesse- og erfaringsområder. Jeg kan fremlægge et synspunkt om et aktuelt emne og angive fordele og ulemper ved forskellige løsningsmuligheder.</td>
		<td>Jeg kan skrive klare og detaljerede tekster om en lang række emner der interesserer mig. Jeg kan skrive en opgave eller en rapport hvor jeg formidler oplysninger og argumenterer for eller imod et bestemt synspunkt. Jeg kan skrive breve hvor jeg giver udtryk for hændelsers og oplevelsers betydning for mig personligt.</td>
	</tr>
	<tr class="level">
		<th>C1</th>
		<td>Jeg kan forstå et langt foredrag selv når det ikke er klart struktureret, og  ideer og tanker ikke udtrykkes direkte. Jeg kan forstå tv-udsendelser og film uden større besvær.</td>
		<td>Jeg kan forstå lange og indviklede sagprosatekster og litterære tekster og opfatte forskelle i stil. Jeg kan forstå fagsprog i artikler og tekniske instruktioner, også når det ikke er inden for mit fagområde.</td>
		<td>Jeg kan udtrykke mig flydende og spontant uden alt for tydeligt at lede efter ordene. Jeg kan bruge sproget fleksibelt og effektivt i sociale og arbejdsmæssige situationer. 
Jeg kan forholdsvis præcist udtrykke mine synspunkter og ideer på en måde, der er tilpasset efter, hvilken person, jeg taler med.</td>
		<td>Jeg kan klart og detaljeret redegøre for komplekse emner med forgrenede problemfelter. Jeg kan fremføre specielle problemfelter samt afrunde fremstillingen med en konklusion.</td>
		<td>Jeg kan skrive en klar og velstruktureret tekst, hvori jeg kan udtrykke mine synspunkter i detaljer. Jeg kan skrive om indviklede emner i et brev, en opgave eller en rapport og fremhæve det jeg mener er det væsentligste indhold. Jeg kan skrive  tekster i forskellige genrer, tilpasset modtageren.</td>
	</tr>
	<tr class="level">
		<th>C2</th>
		<td>Jeg kan forstå alle former for talesprog, både når jeg hører det i direkte kommunikation, og når jeg hører det i medierne. Jeg kan også forstå en indfødt, der taler hurtigt, hvis jeg har haft tid til at vænne mig til vedkommendes måde at tale på.</td>
		<td>Jeg kan uden problemer læse næsten alle former for tekster, også abstrakte tekster der indeholder svære ord og sætningsstrukturer, f.eks. manualer, fagtekster og litterære tekster.</td>
		<td>Jeg kan uden anstrengelse tage del i hvilken som helst samtale og diskussion og vælge det passende ordforråd og udtryk. Jeg kan udtrykke mig flydende og  nuanceret med en stor grad af præcision. Hvis jeg alligevel har problemer, kan jeg med omformuleringer klare mig så godt, at min samtalepartner næppe lægger mærke til det.</td>
		<td>Jeg kan fremføre en klar og flydende redegørelse eller argumentation med et sprog, som passer til situationen i stil og niveau. Jeg kan redegøre med en effektiv, logisk struktur, som hjælper modtageren med at lægge mærke til og huske vigtige punkter.</td>
		<td>Jeg kan skrive klart og flydende, i en stil der er tilpasset formålet. Jeg kan skrive indviklede breve, rapporter eller artikler på en sådan måde at det hjælper læseren til at lægge mærke til og huske vigtige punkter. Jeg kan skrive sammenfatninger og anmeldelser af faglige eller litterære tekster.</td>
	</tr>
</table>
</xsl:if>		
		<img style="display: none" src="http://europass.cedefop.europa.eu/instruments/images/cv_verline.gif" /> 
		<img style="display: none" src="http://europass.cedefop.europa.eu/instruments/images/logo_for_htmlpreview.gif" /> 
		<img style="display: none" src="http://europass.cedefop.europa.eu/instruments/images/bg_win4.jpg" /> 
	</body>
</html>
</xsl:template>
</xsl:stylesheet>
