<?php
/**
 *
 */
session_cache_limiter('none');          //Initialize session
session_start();
$path = "../libraries/";
require_once $path."configuration.php";

header("Cache-Control: no-cache, must-revalidate"); // HTTP/1.1
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT"); // Date in the past

if (!eF_checkUser($_SESSION['s_login'], $_SESSION['s_password'])) {                                       //Any logged-in user may view an announcement
    eF_printMessage("You must login to access this page");
    exit;
}

if (isset($_GET['id']) && eF_checkParameter($_GET['id'], 'id')) {
    $result = eF_getTableData("logs", "*", "id=".$_GET['id']);    
    if ($result[0]['lessons_ID']) {
        $lessonName = eF_getTableData("lessons", "name", "id=".$result[0]['lessons_ID']);
    }    
    if ($result[0]['action'] == 'content' && $result[0]['comments']) {
        $contentName = eF_getTableData("content", "name", "id=".$result[0]['comments']);
    }
    $logInfo = array('login'      => $result[0]['users_LOGIN'],
                     'timestamp'  => $result[0]['timestamp'],
                     'action'     => $result[0]['action'],
                     'session_ip' => eF_decodeIP($result[0]['session_ip']),
                     'lesson'     => $lessonName[0]['name'],
                     'content'    => $contentName[0]['name']);
    $smarty -> assign("T_LOG_INFO", $logInfo);
}
$smarty -> assign("T_MESSAGE", $message);
$smarty -> assign("T_MESSAGE_TYPE", $message_type);
$smarty -> display("show_log.tpl");
/*
if (isset($_GET['id'])){
    $id = $_GET['id'];
    $sql = "select users_LOGIN, timestamp, action, session_ip, lessons_ID, comments from logs where id=$id";
    $res = ef_execute($sql);
    list($login, $timestamp, $action, $ip, $lid, $comments) = mysql_fetch_row($res);
    if ($lid > 0){
        $res = ef_execute("select name from lessons where id=$lid");
        list($lname) = mysql_fetch_row($res);
    }
    
    if ($action == "content" || $action == "tests"){
        $actionid = $comments;
        $sql = "select name from content where id='$actionid'";
        $res = ef_execute($sql);
        list($cname) = mysql_fetch_row($res);   
        $timespent = ef_getUserContentTime($id,$actionid,$login,$timestamp);
    }
    
    
    $data = "<table class=\"statisticsTable\" width=\"100%\">";
    $data .= "<tr><td width=\"35%\" align=left>"._LOGIN.": </td><td width=\"100%\" align=left>$login</td></tr>";
    $data .= "<tr><td width=\"35%\" align=left>"._ACTION.": </td><td width=\"100%\" align=left>$action</td></tr>";
    $data .= "<tr><td width=\"35%\" align=left>"._DATE.": </td><td width=\"100%\" align=left>".date("d/m/Y h:i:s",$timestamp)."</td></tr>";
    $data .= "<tr><td width=\"35%\" align=left>"._IPADDRESS.": </td><td width=\"100%\" align=left>".ef_decodeIP($ip)."</td></tr>";
    if (isset($lname))
        $data .= "<tr><td width=\"35%\" align=left>"._LESSON.": </td><td width=\"100%\" align=left>$lname</td></tr>";
    if (isset($cname)){
        $data .= "<tr><td width=\"35%\" align=left>"._CONTENT.": </td><td width=\"100%\" align=left>$cname</td></tr>";
        $data .= "<tr><td width=\"35%\" align=left>"._TIMESPENT.": </td><td width=\"100%\" align=left>".$timespent['hours']."hr ".$timespent['minutes']."' ".$timespent['seconds']."''</td></tr>";
    }
    $data .="</table>";
    echo $data;
}
*/

?>