<?php
/**
* View file
* 
* This file offers the user the ability to view a file.
*
* @package efront
* @version 1.0
*/

//General initialization and parameters
session_cache_limiter('none');
session_start();

$path = "../libraries/";

/** Configuration file.*/
include_once $path."configuration.php";

//error_reporting(E_ALL);
if (isset($_GET['file']) && eF_checkParameter($_GET['file'], 'id')) {         //Make sure parameters are valid
    try {
    	($file_type = EfrontFileSystem :: checkId($_GET['file'])) == 'file' ? $file = new eF_File($_GET['file']) : $file = new eF_Directory($_GET['file']);		
	    $file_info = $file -> getInfo();
	    
	    switch ($_GET['action']) {
	    	case 'delete':
	    		$file -> delete();
	    		if (isset($_GET['reload'])) {
	    			echo "<script>parent.location.reload();</script>";
	    		}
	    		break;
	    	case 'download':
	    		if ($file_type == 'file') {
	    			header("content-type:".$file_info['mime_type']);
	    			header('content-disposition: attachment; filename= "'.$file_info['original_name'].'"');
	    			readfile($file -> getFullPath());
	    		}
	    		break;
	    	case 'view': default:
	    		if ($file_type == 'file') {
	    			header("content-type:".$file_info['mime_type']);
	    			header('content-disposition: inline; filename= "'.$file_info['original_name'].'"');
	    			readfile($file -> getFullPath());
	    		}
	    		break;
	    }
    } catch (EfrontFileException $e) {
    	//echo $e -> getMessage();
    }
    
}
?>