<?php
/**
* Review SCORM data stored in the system, concerning a user
* 
* This page retrieves any SCORM data releted to the specified user 
* @package efront
* @version 1.0
*/

//General initialization and parameters
session_cache_limiter('none');
session_start();

$path = "../libraries/";

/** Configuration file.*/
include_once $path."configuration.php";


//error_reporting(E_ALL);
//$db -> debug = true;
//echo "<pre>";print_r($_POST);print_r($_GET);

if (eF_checkUser($_SESSION['s_login'], $_SESSION['s_password']) != "professor") {                       //Only a professor may access this page
    header("location:index.php");
    exit;
}

if (!isset($_GET['lessons_ID']) && !eF_checkParameter($_GET['lessons_ID'], 'id')) {
    eF_printMessage(_LESSONNOTSET);
    exit;
}

$result = eF_getTableDataFlat("users u, users_to_lessons ul", "u.login, u.name, u.surname", "u.login = ul.users_LOGIN and u.active=1 and u.user_type = 'student' and ul.lessons_ID=".$_GET['lessons_ID'], "u.login ASC");
for ($i = 0; $i < sizeof($result['name']); $i++) {
    $student_names[$i] = $result['login'][$i].' ('.$result['surname'][$i].' '.$result['name'][$i].')';
}

$smarty -> assign("T_STUDENTS", $result['login']);
$smarty -> assign("T_STUDENT_NAMES", $student_names);


if (isset($_POST['student_submit']) && eF_checkParameter($_POST['student_select'], 'login')) {
    if (isset($_POST['reset_content_ID']) && eF_checkParameter($_POST['reset_content_ID'], 'id')) {
        eF_deleteTableData("scorm_data", "users_LOGIN = '".$_POST['student_select']."' and content_ID=".$_POST['reset_content_ID']);
    }

    $result = eF_getTableData("scorm_data, content", "content.name, content_ID, entry, total_time, lesson_status, minscore, maxscore, score", "lessons_ID = ".$_SESSION['s_lessons_ID']." and content.id = content_ID and users_LOGIN='".$_POST['student_select']."'");

    $smarty -> assign("T_SCORM_DATA", $result);
}

if (isset($_POST['reset_all_data'])) {
    $result = eF_getTableDataFlat("scorm_data, content", "scorm_data.content_ID", "content.id = scorm_data.content_ID and scorm_data.users_LOGIN = '".$_POST['student_select']."' and content.lessons_ID=".$_SESSION['s_lessons_ID']);
    if (sizeof($result) > 0) {
        eF_deleteTableData("scorm_data", "users_LOGIN = '".$_POST['student_select']."' and content_ID in (".implode(",", $result['content_ID']).")");
    }
}
$smarty -> display("scorm_review.tpl");

?>
