<?php
/**
* Export SCORM data
* 
* This page is used to export a unit to SCORM 1.2 compatible format
*
* @package efront
* @version 1.0
*/

//General initialization and parameters
session_cache_limiter('none');
session_start();

$path = "../libraries/";

/** Configuration file.*/
include_once $path."configuration.php";

//error_reporting(E_ALL);
//echo "<pre>";print_r($_POST);print_r($_GET);

if (eF_checkUser($_SESSION['s_login'], $_SESSION['s_password']) != "professor") {                           //Only a professor may access this page
    header("location:index.php");
    exit;
}

define ('SCORM_FOLDER', "content/scorm_data");
$scorm_filename = "scorm_lesson".$lessons_id.".zip";

if (is_file(SCORM_FOLDER."/".$scorm_filename)) {
    unlink(SCORM_FOLDER."/".$scorm_filename);
}

if (!($lessons_id = $_GET['lessons_ID'])) {
    eF_printMessage(_LESSONNOTSET);
    exit;
}

$lesson_entries = eF_getTableData("content", "id,name,data", "lessons_ID=" . $lessons_id . " and ctg_type!='tests' and active=1");
for ($i = 0; $i < sizeof($lesson_entries); $i++) {
    $lesson_entries[$i]['name'] = eF_makeGreeklish($lesson_entries[$i]['name']);
}

$cur_dir = getcwd();
chdir(G_LESSONSPATH.$lessons_id.'/');
$filelist = eF_getDirContents();
chdir($cur_dir);

create_manifest($lessons_id, $lesson_entries, $filelist);

chdir(SCORM_FOLDER  ."/lesson". $lessons_id);

$d = dir("."); 
$entries = array();
while (false !== ($entry = $d->read())) { 
    if ($entry != "." & $entry != "..")
        array_push($entries, $entry); 
} 
$d->close(); 

$zip = new Archive_zip("../".$scorm_filename);
$zip -> create( $entries );

chdir($cur_dir);

deldir(SCORM_FOLDER  ."/lesson". $lessons_id);

$smarty -> assign("T_SCORM_FILENAME", "$scorm_filename");
$smarty -> assign("T_MESSAGE", $message);
$smarty -> assign("T_MESSAGE_TYPE", $message_type);

$smarty -> display("scorm_export.tpl");


//--------------------------------FUNCTIONS---------------------------------------------------------

function create_manifest1($lessons_id, $lesson_entries, $filelist)
{
    $first_dir_token  = "lesson" . $lessons_id;
    $second_dir_token = "html";
    $third_dir_token  = "content/lessons/$lessons_id";
    
    $main_dirname  = SCORM_FOLDER  ."/". $first_dir_token;
    $html_dirname  = $main_dirname ."/". $second_dir_token;
    $files_dirname = $html_dirname ."/". $third_dir_token;
    
    mkdir($main_dirname);
    mkdir($html_dirname);
    $dir_parts = explode("/", $files_dirname);
    $cur_dir = getcwd();
    foreach ($dir_parts as $value) {
        if (!is_dir($value)) {
            mkdir($value);
        }
        chdir($value);
    }
    chdir($cur_dir);
    
    for ($i = 0; $i < sizeof($lesson_entries); $i++) {
        $content = $lesson_entries[$i]['data'];
        $count   = 0;

        foreach ($filelist as $value) {
            $file_count = 0;
            if (G_DELIMITER == '\\') $value = strtr($value, "\\", "/");
            
            $pattern = "#\"\s*((http:\/\/.*)|(\.\.\/))?content\/lessons\/$lessons_id\/$value\s*\"#";    //***      ,       path      efront.
            if (preg_match($pattern, $content, $matches)) {
                $lesson_entries[$i]['files'][$count++] = basename($value);
                $content = preg_replace($pattern, '"'.$third_dir_token.'/'.$value.'"', $content);
            }
        }
    
        $content = create_html_files($content);
        if ($fp = fopen($html_dirname . "/" . $lesson_entries[$i]['name'] . ".html", "wb")) {
          fwrite($fp, $content);
        }
        fclose($fp);

        $metadata = get_asset_metadata($lesson_entries[$i]);
        if ($fp = fopen($html_dirname . "/" . $lesson_entries[$i]['name'] . ".xml", "wb")) {
            fwrite($fp, $metadata);
        }
        fclose($fp);        
    }

    $file_count = 0;
    foreach ($filelist as $value) {
        if (G_DELIMITER == '\\') $value = strtr($value, "\\", "/");

        $dir_parts = explode("/", dirname($value));
        $cur_dir   = getcwd();
        if (G_DELIMITER == '\\') $cur_dir = strtr($cur_dir, "\\", "/");

        chdir($cur_dir."/".$files_dirname."/");
        foreach($dir_parts as $dir_value) {
            if ($dir_value != '.' & $dir_value != '..' & !is_dir($dir_value)) {
                mkdir($dir_value);
            }
            chdir($dir_value);
        }
        chdir($cur_dir);

        copy(G_LESSONSPATH.$lessons_id.G_DELIMITER.$filelist[$file_count++], $files_dirname . "/" . $value);
        $fp = fopen($files_dirname . "/" . $value . ".xml", "wb");
        fwrite($fp, $metadata);
        fclose($fp);
    }
    
    $prerequisites     = get_prerequisites();
    $organizations_str = build_manifest_organizations($lessons_id, $prerequisites);
    $resources_str     = build_manifest_resources($lesson_entries, $second_dir_token."/".$third_dir_token);
    $metadata_str      = build_manifest_metadata(0);
    $manifest          = build_manifest_main($metadata_str . $organizations_str . $resources_str);

    if ($fp = fopen($main_dirname . "/imsmanifest.xml", "wb")) {
        fwrite ($fp, $manifest);
    }
    fclose($fp);
    
    list($func1, $func2) = get_APIFunctions();
    if ($fp = fopen($main_dirname . "/APIWrapper.js", "wb")) {
        fwrite($fp, $func1);
        fclose($fp);
    }
    if ($fp = fopen($main_dirname . "/SCOFunctions.js", "wb")) {
        fwrite($fp, $func2);
        fclose($fp);
    }    
}

function get_prerequisites1()
{
    $rules = eF_getTableData("rules", "content_ID,rule_content_ID", "rule_type='hasnot_seen'");

    foreach ($rules as $value) {
        $prerequisites[$value['content_ID']] = $value['rule_content_ID'];
    }
    return $prerequisites;

}

/**
*       www.php.net
*/
function deldir1($dir)
{
    if (isset($dir) & $dir != '' & $dir != G_LESSONSPATH) {
        $current_dir = opendir($dir);
        while($entryname = readdir($current_dir)) {
            if(is_dir("$dir/$entryname") and ($entryname != "." and $entryname!="..")) {
                deldir("${dir}/${entryname}");
            }
            elseif($entryname != "." and $entryname!="..") {
                unlink("${dir}/${entryname}");
            }
        }
        closedir($current_dir);
        rmdir(${dir});
    }
}



/**
*
*/
function build_manifest_metadata1($metadata)
{
    $schema         = isset($metadata['schema'])         ? $metadata['schema']         : 'ADL SCORM';
    $schemaversion  = isset($metadata['schemaversion'])  ? $metadata['schemaversion']  : '1.2';
    $adlcp_location = isset($metadata['adlcp_location']) ? $metadata['adlcp_location'] : '';

    $str='
        <metadata>
            <schema>'.
                $schema
            .'</schema>
            <schemaversion>'.
                $schemaversion
            .'</schemaversion>
            <adlcp:location>'.
                $adlcp_location
            .'</adlcp:location>
        </metadata>';

    return $str;
}

function build_manifest_resources1($lesson_entries, $files_dir)
{

    $resource_str   = '';
    $dependency_str = '';

    for ($i = 0 ; $i < sizeof($lesson_entries) ; $i++) {
        $resource_str .= '<resource identifier="' . $lesson_entries[$i]['id'] . '" type="webcontent" adlcp:scormtype="sco" href="html/' . $lesson_entries[$i]['name'] . '.html">';
        $resource_str .= '<metadata></metadata>';
        $resource_str .= '<file href="html/' . $lesson_entries[$i]['name'] . '.html"/>';
        $resource_str .= '<dependency identifierref="dep_SPECIAL"/>';

        for ($j = 0 ; $j < sizeof($lesson_entries[$i]['files']) ; $j++) {
            $resource_str   .= '<dependency identifierref="dep_' . $i . '_' . $j . '"/>';
            $dependency_str .= '<resource identifier="dep_' . $i . '_' . $j . '" type="webcontent" adlcp:scormtype="asset" href="'.$files_dir.'/'. $lesson_entries[$i]['files'][$j] .'">';
            $dependency_str .= '<metadata></metadata>';
            $dependency_str .= '<file href="'.$files_dir.'/' . $lesson_entries[$i]['files'][$j] . '"/>';
            $dependency_str .= '</resource>';
        }
        $resource_str .= '</resource>';
    }

    $SPECIAL_str = '<resource identifier="dep_SPECIAL" adlcp:scormtype="asset"
                    type="webcontent">
             <file href="SCOFunctions.js"/>
             <file href="APIWrapper.js"/>
          </resource>';

    $final_str = '<resources>' . $resource_str . $dependency_str . $SPECIAL_str. '</resources>';
    return $final_str;

}

/**
*
*/
function build_manifest_organizations1($lessons_id, $prerequisites)
{

    $tree = eF_getContentTree($nouse, $lessons_id, 0);

    for ($i = 0 ; $i < sizeof($tree) ; $i++) {
        $levels[$i] = $tree[$i]['level'];
    }

    for ($i = max($levels) ; $i>= 0 ; $i--) {
        for ($j = 0 ; $j < sizeof($tree) ; $j++) {
            if ($tree[$j]["level"] == $i && $tree[$j]["ctg_type"] != "tests") {
                $tree[$j]["string"] = "\n<item identifier=\"item" . $tree[$j]["id"] . "\" identifierref=\"" . $tree[$j]["id"] . "\">\n\t<title>" . ($tree[$j]["name"]) . "</title>\n";

                /*An to antikeimeno exei prerequisites, pros8ese tis katallhles grammes*/
                if ($prerequisites[$tree[$j]["id"]]) {
                    //echo "<br> A".$tree[$j]["id"]; 
                    $tree[$j]["string"] .= "\n<adlcp:prerequisites type=\"aicc_script\">item" . $prerequisites[$tree[$j]["id"]] . "</adlcp:prerequisites>";
                }

                if (isset($tree[$j]["children"])) {
                    for ($k = 1 ; $k <= sizeof($tree[$j]["children"]) ; $k++) {
                        $tree[$j]["string"] .= $tree[$j]["children"][$k];
                    }
                }
                $tree[$j]["string"] .= "\n</item>";
                if ($tree[$j]["parent_id"] == 0) {
                    $final_str .= $tree[$j]["string"];
                } else {
                    for ( $m = 0 ; $m < sizeof($tree) ; $m++) {
                        if ($tree[$m]["id"] == $tree[$j]["parent_id"]) {
                            $tree[$m]["children"][sizeof($tree[$m]["children"]) + 1] = "\t" . $tree[$j]["string"];
                        }
                    }
                }
            }
        }
    }

    //echo "<pre>";print_r($tree);echo "</pre>";
    $content .= "\t" . '<organizations default="org1">' . "\n";
    $content .= "\t<organization identifier=\"Org\" structure=\"hierarchical\"><title>default</title>" . "\n";
    $content .= $final_str . "\t" . '</organization></organizations>' . "\n";

    return $content;


}

/**
*
*/ 
function build_manifest_main1($str)
{
    $manifest = '<?xml version="1.0" encoding="ISO-8859-7"?>
    <manifest identifier="SingleCourseManifest" version="1.1"
              xmlns="http://www.imsproject.org/xsd/imscp_rootv1p1p2"
              xmlns:adlcp="http://www.adlnet.org/xsd/adlcp_rootv1p2"
              xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
              xsi:schemaLocation="http://www.imsproject.org/xsd/imscp_rootv1p1p2 imscp_rootv1p1p2.xsd
                                  http://www.imsglobal.org/xsd/imsmd_rootv1p2p1 imsmd_rootv1p2p1.xsd
                                  http://www.adlnet.org/xsd/adlcp_rootv1p2 adlcp_rootv1p2.xsd">
        ';
    $manifest .= $str;
    $manifest .= '</manifest>';

    return $manifest;
}

/**
*/
function create_html_files1($content)
{
    $page_script = '
        var apiHandle = null;
        var API = null;
        var findAPITries = 0;

        function getAPIHandle()
        {
           if (apiHandle == null)
           {
              apiHandle = getAPI();
           }

           return apiHandle;
        }
        function findAPI(win)
        {
           while ((win.API == null) && (win.parent != null) && (win.parent != win))
           {
              findAPITries++;
              // Note: 7 is an arbitrary number, but should be more than sufficient
              if (findAPITries > 7) 
              {
                 alert("Error finding API -- too deeply nested.");
                 return null;
              }

              win = win.parent;

           }
           return win.API;
        }
        function getAPI()
        {
           var theAPI = findAPI(window);
           if ((theAPI == null) && (window.opener != null) && (typeof(window.opener) != "undefined"))
           {
              theAPI = findAPI(window.opener);
           }
           if (theAPI == null)
           {
              alert("Unable to find an API adapter");
           }
           return theAPI
        }

        function my_finish()
        {
            alert(getAPIHandle().LMSGetLastError());
            getAPIHandle().LMSSetValue("cmi.core.lesson_status","completed");
            alert(getAPIHandle().LMSGetLastError());
            getAPIHandle().LMSFinish("");
            alert(getAPIHandle().LMSGetLastError());
        }

        function my_start()
        {
            alert(getAPIHandle().LMSGetLastError());
            getAPIHandle().LMSInitialize("");
            alert(getAPIHandle().LMSGetLastError());
        }


    ';
    //$page_head='<html><head><script>'.$page_script.'</script></head><body onload="my_start()">';
    $page_head = '<html><head><script language=javascript src="../APIWrapper.js"></script><script language=javascript src="../SCOFunctions.js"></script></head><body onunload="return unloadPage(\'incomplete\')">';
    //$page_tail='<input type="button" value="click" onclick="my_finish()"></body></html>';
    $page_tail = '
        <script language="javascript">
        loadPage();
        //var   studentName = "!";
        //var   lmsStudentName = doLMSGetValue(  "cmi.core.student_name" );

        //if ( lmsStudentName  != "" )
        //{
        //   studentName = " " + lmsStudentName +   "!";
        //}

        //document.write(studentName);
        </script>
    <br><br>
    <input type = "button" value = "  OK  " onClick = "doQuit(\'completed\')" id=button2 name=button2>
    ';

    $overall = $page_head . $content . $page_tail;

    return $overall;
}

/**
*/
function get_APIFunctions1()
{
    $func1 = '
        var startDate;
        var exitPageStatus;

        function loadPage()
        {
           var result = doLMSInitialize();

           var status = doLMSGetValue( "cmi.core.lesson_status" );

           if (status == "not attempted")
           {
              // the student is now attempting the lesson
              doLMSSetValue( "cmi.core.lesson_status", "incomplete" );
           }

           exitPageStatus = false;
           startTimer();
        }


        function startTimer()
        {
           startDate = new Date().getTime();
        }

        function computeTime()
        {
           if ( startDate != 0 )
           {
              var currentDate = new Date().getTime();
              var elapsedSeconds = ( (currentDate - startDate) / 1000 );
              var formattedTime = convertTotalSeconds( elapsedSeconds );
           }
           else
           {
              formattedTime = "00:00:00.0";
           }

           doLMSSetValue( "cmi.core.session_time", formattedTime );
        }

        function doBack()
        {
           doLMSSetValue( "cmi.core.exit", "suspend" );

           computeTime();
           exitPageStatus = true;

           var result;

           result = doLMSCommit();

            // NOTE: LMSFinish will unload the current SCO.  All processing
            //       relative to the current page must be performed prior
            //       to calling LMSFinish.   

           result = doLMSFinish();

        }

        function doContinue( status )
        {
           // Reinitialize Exit to blank
           doLMSSetValue( "cmi.core.exit", "" );

           var mode = doLMSGetValue( "cmi.core.lesson_mode" );

           if ( mode != "review"  &&  mode != "browse" )
           {
              doLMSSetValue( "cmi.core.lesson_status", status );
           }

           computeTime();
           exitPageStatus = true;

           var result;
           result = doLMSCommit();
            // NOTE: LMSFinish will unload the current SCO.  All processing
            //       relative to the current page must be performed prior
            //       to calling LMSFinish.   

           result = doLMSFinish();

        }

        function doQuit( status )
        {
           computeTime();
           exitPageStatus = true;

           var result;

           result = doLMSCommit();

           result = doLMSSetValue("cmi.core.lesson_status", status);

            // NOTE: LMSFinish will unload the current SCO.  All processing
            //       relative to the current page must be performed prior
            //       to calling LMSFinish.   

           result = doLMSFinish();
        }

        function unloadPage( status )
        {

            if (exitPageStatus != true)
            {
                doQuit( status );
            }


        }

        /*******************************************************************************
        ** this function will convert seconds into hours, minutes, and seconds in
        ** CMITimespan type format - HHHH:MM:SS.SS (Hours has a max of 4 digits &
        ** Min of 2 digits
        *******************************************************************************/
        function convertTotalSeconds(ts)
        {
           var sec = (ts % 60);

           ts -= sec;
           var tmp = (ts % 3600);  //# of seconds in the total # of minutes
           ts -= tmp;              //# of seconds in the total # of hours

           // convert seconds to conform to CMITimespan type (e.g. SS.00)
           sec = Math.round(sec*100)/100;

           var strSec = new String(sec);
           var strWholeSec = strSec;
           var strFractionSec = "";

           if (strSec.indexOf(".") != -1)
           {
              strWholeSec =  strSec.mb_substring(0, strSec.indexOf("."));
              strFractionSec = strSec.mb_substring(strSec.indexOf(".")+1, strSec.length);
           }

           if (strWholeSec.length < 2)
           {
              strWholeSec = "0" + strWholeSec;
           }
           strSec = strWholeSec;

           if (strFractionSec.length)
           {
              strSec = strSec+ "." + strFractionSec;
           }


           if ((ts % 3600) != 0 )
              var hour = 0;
           else var hour = (ts / 3600);
           if ( (tmp % 60) != 0 )
              var min = 0;
           else var min = (tmp / 60);

           if ((new String(hour)).length < 2)
              hour = "0"+hour;
           if ((new String(min)).length < 2)
              min = "0"+min;

           var rtnVal = hour+":"+min+":"+strSec;

           return rtnVal;
        }
    ';

    $func2 = '

        var _Debug = false;  // set this to false to turn debugging off
                             // and get rid of those annoying alert boxes.

        // Define exception/error codes
        var _NoError = 0;
        var _GeneralException = 101;
        var _ServerBusy = 102;
        var _InvalidArgumentError = 201;
        var _ElementCannotHaveChildren = 202;
        var _ElementIsNotAnArray = 203;
        var _NotInitialized = 301;
        var _NotImplementedError = 401;
        var _InvalidSetValue = 402;
        var _ElementIsReadOnly = 403;
        var _ElementIsWriteOnly = 404;
        var _IncorrectDataType = 405;


        // local variable definitions
        var apiHandle = null;
        var API = null;
        var findAPITries = 0;


        function doLMSInitialize()
        {
           var api = getAPIHandle();
           if (api == null)
           {
              alert("Unable to locate the LMS API Implementation.\nLMSInitialize was not successful.");
              return "false";
           }

           var result = api.LMSInitialize("");

           if (result.toString() != "true")
           {
              var err = ErrorHandler();
           }

           return result.toString();
        }

        function doLMSFinish()
        {
           var api = getAPIHandle();
           if (api == null)
           {
              alert("Unable to locate the LMS API Implementation.\nLMSFinish was not successful.");
              return "false";
           }
           else
           {
              // call the LMSFinish function that should be implemented by the API

              var result = api.LMSFinish("");
              if (result.toString() != "true")
              {
                 var err = ErrorHandler();
              }

           }

           return result.toString();
        }

        function doLMSGetValue(name)
        {
           var api = getAPIHandle();
           if (api == null)
           {
              alert("Unable to locate the LMS API Implementation.\nLMSGetValue was not successful.");
              return "";
           }
           else
           {
              var value = api.LMSGetValue(name);
              var errCode = api.LMSGetLastError().toString();
              if (errCode != _NoError)
              {
                 // an error was encountered so display the error description
                 var errDescription = api.LMSGetErrorString(errCode);
                 alert("LMSGetValue("+name+") failed. \n"+ errDescription);
                 return "";
              }
              else
              {

                 return value.toString();
              }
           }
        }

        function doLMSSetValue(name, value)
        {
           var api = getAPIHandle();
           if (api == null)
           {
              alert("Unable to locate the LMS API Implementation.\nLMSSetValue was not successful.");
              return;
           }
           else
           {
              var result = api.LMSSetValue(name, value);
              if (result.toString() != "true")
              {
                 var err = ErrorHandler();
              }
           }

           return;
        }

        function doLMSCommit()
        {
           var api = getAPIHandle();
           if (api == null)
           {
              alert("Unable to locate the LMS API Implementation.\nLMSCommit was not successful.");
              return "false";
           }
           else
           {
              var result = api.LMSCommit("");
              if (result != "true")
              {
                 var err = ErrorHandler();
              }
           }

           return result.toString();
        }

        function doLMSGetLastError()
        {
           var api = getAPIHandle();
           if (api == null)
           {
              alert("Unable to locate the LMS API Implementation.\nLMSGetLastError was not successful.");
              return _GeneralError;
           }

           return api.LMSGetLastError().toString();
        }

        function doLMSGetErrorString(errorCode)
        {
           var api = getAPIHandle();
           if (api == null)
           {
              alert("Unable to locate the LMS API Implementation.\nLMSGetErrorString was not successful.");
           }

           return api.LMSGetErrorString(errorCode).toString();
        }

        function doLMSGetDiagnostic(errorCode)
        {
           var api = getAPIHandle();
           if (api == null)
           {
              alert("Unable to locate the LMS API Implementation.\nLMSGetDiagnostic was not successful.");
           }

           return api.LMSGetDiagnostic(errorCode).toString();
        }

        function LMSIsInitialized()
        {

           var api = getAPIHandle();
           if (api == null)
           {
              alert("Unable to locate the LMS API Implementation.\nLMSIsInitialized() failed.");
              return false;
           }
           else
           {
              var value = api.LMSGetValue("cmi.core.student_name");
              var errCode = api.LMSGetLastError().toString();
              if (errCode == _NotInitialized)
              {
                 return false;
              }
              else
              {
                 return true;
              }
           }
        }

        function ErrorHandler()
        {
           var api = getAPIHandle();
           if (api == null)
           {
              alert("Unable to locate the LMS API Implementation.\nCannot determine LMS error code.");
              return;
           }

           // check for errors caused by or from the LMS
           var errCode = api.LMSGetLastError().toString();
           if (errCode != _NoError)
           {
              // an error was encountered so display the error description
              var errDescription = api.LMSGetErrorString(errCode);

              if (_Debug == true)
              {
                 errDescription += "\n";
                 errDescription += api.LMSGetDiagnostic(null);
                 // by passing null to LMSGetDiagnostic, we get any available diagnostics
                 // on the previous error.
              }

              alert(errDescription);
           }

           return errCode;
        }

        function getAPIHandle()
        {
           if (apiHandle == null)
           {
              apiHandle = getAPI();
           }

           return apiHandle;
        }


        function findAPI(win)
        {
           while ((win.API == null) && (win.parent != null) && (win.parent != win))
           {
              findAPITries++;
              // Note: 7 is an arbitrary number, but should be more than sufficient
              if (findAPITries > 7) 
              {
                 alert("Error finding API -- too deeply nested.");
                 return null;
              }

              win = win.parent;

           }
           return win.API;
        }



        function getAPI()
        {
           var theAPI = findAPI(window);
           if ((theAPI == null) && (window.opener != null) && (typeof(window.opener) != "undefined"))
           {
              theAPI = findAPI(window.opener);
           }
           if (theAPI == null)
           {
              alert("Unable to find an API adapter");
           }
           return theAPI
        }
    ';

    return array($func1, $func2);
}

/**
*/
function build_tarfile1($lessons_id)
{
    $main_dirname = SCORM_FOLDER."/lesson" . $lessons_id . "/";
    $filelist     = eF_getDirContents($main_dirname);
    $tarname      = $main_dirname . "../scorm_lesson.tgz";
    $tar          = new Archive_Tar($tarname, true);
    $tar -> createModify($filelist, "", $main_dirname);

    print '<center><table><tr><td align="center">' . _SAVETHE . ' <a href="'.SCORM_FOLDER.'/scorm_lesson.tgz">' . 'scorm file' . '</a> ' . _OFTHELESSONATYOURCOMPUTER;
    print '<BR><BR><input class = "flatButton" type="submit" onClick="window.close()" value="' . _CLOSEWINDOW . '"></td></tr></table></center>';
}

/**
*
*/
function get_asset_metadata1($el) 
{

    $metadata = '<?xml version="1.0" encoding="ISO-8859-1"?>

        <lom xmlns="http://www.imsglobal.org/xsd/imsmd_rootv1p2p1"
             xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
             xsi:schemaLocation="http://www.imsglobal.org/xsd/imsmd_rootv1p2p1 imsmd_rootv1p2p1.xsd">

            <general>
                <identifier>
                </identifier>
                <title>
                </title>
                <catalogentry>
                    <catalog>
                    </catalog>
                    <entry>
                    </entry>
                </catalogentry>
                <language>
                </language>
                <description>
                </description>
                <keyword>
                </keyword>
                <coverage>
                </coverage>
                <structure>
                </structure>
                <aggregationlevel>
                </aggregationlevel>
            </general>

            <lifecycle>
                <version>
                </version>
                <status>
                </status>
                <contribute>
                    <role>
                    </role>
                    <centity>
                    </centity>
                    <date>
                    </date>
                </contribute>
            </lifecycle>

            <metametadata>
                <identifier>
                </identifier>
                <catalogentry>
                    <catalog>
                    </catalog>
                    <entry>
                    </entry>
                </catalogentry>
                <contribute>
                    <role>
                    </role>
                    <centity>
                    </centity>
                    <date>
                    </date>
                </contribute>
                <metadatascheme>        
                </metadatascheme>
                <language>
                </language>
            </metametadata>

            <technical>
                <format>
                </format>
                <size>
                </size>
                <location>
                </location>
                <requirement>
                    <type>
                    </type>
                    <name>
                    </name>
                    <minimumversion>
                    </minimumversion>
                    <maximumversion>
                    </maximumversion>
                </requirement>
                <installationremarks>
                </installationremarks>
                <otherplatformrequirements>
                </otherplatformrequirements>
                <duration>
                </duration>
            </technical>

            <educational>
                <interactivitytype>
                </interactivitytype>
                <learningresourcetype>
                </learningresourcetype>
                <interactivitylevel>
                </interactivitylevel>
                <semanticdensity>
                </semanticdensity>
                <intendedenduserrole>
                </intendedenduserrole>
                <context>
                </context>
                <typicalagerange>
                </typicalagerange>
                <difficulty>
                </difficulty>
                <typicallearningtime>
                </typicallearningtime>
                <description>
                </description>
                <language>
                </language>
            </educational>

            <rights>
                <cost>
                </cost>
                <copyrightandotherrestrictions>
                </copyrightandotherrestrictions>
                <description>
                </description>
            </rights>

            <relation>
                <kind>
                </kind>
                <resource>
                    <identifier>
                    </identifier>
                    <description>
                    </description>
                    <catalogentry>
                        <catalog>
                        </catalog>
                        <entry>
                        </entry>
                    </catalogentry>
                </resource>
            </relation>

            <annotation>
                <person>
                </person>
                <date>
                </date>
                <description>
                </description>
            </annotation>

            <classification>
                <purpose>
                </purpose>
                <taxonpath>
                    <source>
                    </source>
                    <taxon>
                        <id>
                        </id>
                        <entry>
                        </entry>
                        <taxon>
                            <id>
                            </id>
                            <entry>
                            </entry>
                            <taxon>
                            </taxon>
                        </taxon>
                    </taxon>
                </taxonpath>
                <description>
                </description>
                <keyword>
                </keyword>
            </classification>


        </lom>

    ';

    return $metadata;
}

?>
