<?php
/**
* Manage groups
*
* This page provides groups functionality
*
* @package efront
* @version 0.1
*/
session_cache_limiter('none');
session_start();

$path = "../../libraries/";

/** Configuration file.*/
include_once $path."configuration.php";

if (!eF_checkUser($_SESSION['s_login'], $_SESSION['s_password'])) {                   //Only a valid user may access this page
    header("location: index.php");
    exit;
}

//echo "<pre>";print_r($_POST);print_r($_GET);echo "</re>";
//error_reporting(E_ALL);

eF_printHeader();

print '<br/><br/>';

if (sizeof($_POST) > 0) {
    if (isset($_POST['submit_add']) && isset($_POST['user_select']) && isset($_GET['groups'])) {
        if (eF_checkParameter($_POST['user_select'], 'login') && eF_checkParameter($_GET['groups'], 'id')) {
            $group_users = eF_getTableData("groups", "name, users_list", "users_LOGIN = '".$_SESSION['s_login']."' and id=".$_GET['groups']);
            if (sizeof($group_users) > 0) {
                if ($group_users[0]['users_list'] != '') {
                    $group_users = unserialize($group_users[0]['users_list']);
                    $group_users[] = $_POST['user_select'];
                } else {
                    $group_users = array(0 => $_POST['user_select']);
                }
                eF_updateTableData("groups", array("users_list" => serialize($group_users)), "id=".$_GET['groups']);
                eF_printMessage(_SUCCESSFULLYUPDATEDGROUP, true, 'success');
            } else {
                eF_printMessage(_THISGROUPDOESNOTEXIST);
            }
        } else {
            eF_printMessage(_INVALIDPARAMETER);
        }
    } 
}

$new_group_str = '';
if (isset($_GET['action'])) {
    if ($_GET['action'] == 'delete' && isset($_GET['user']) && isset($_GET['groups']) ) {
        if (eF_checkParameter($_GET['groups'], 'id') && eF_checkParameter($_GET['user'], 'login')) {
            $group_users = eF_getTableData("groups", "name, users_list", "users_LOGIN = '".$_SESSION['s_login']."' and id=".$_GET['groups']);
            if (sizeof($group_users) > 0) {
                $group_users = unserialize($group_users[0]['users_list']);
                unset($group_users[array_search($_GET['user'], $group_users)]);
                eF_updateTableData("groups", array("users_list" => serialize(array_values($group_users))), "id=".$_GET['groups']);
                eF_printMessage(_SUCCESSFULLYUPDATEDGROUP, true, 'success');
            } else {
                eF_printMessage(_THISGROUPDOESNOTEXIST);
            }
        } else {
            eF_printMessage(_INVALIDPARAMETER);
        }
    }
    
    if ($_GET['action'] == 'new_personal') {
        if (isset($_POST['new_personal_group_submit'])) {
            if ($_POST['new_personal_group']) {
                if (!eF_checkParameter($_POST['new_personal_group'], 'alnum')) {
                    eF_printMessage(_INVALIDGROUPNAME.': "'.$_POST['new_personal_group'].'"');
                } else {
                    $fields_insert = array("name"        => $_POST['new_personal_group'],
                                           "users_list"  => "",
                                           "users_LOGIN" => $_SESSION['s_login'],
                                           "lessons_ID"  => 0,
                                           "type"        => 'private');
                    if (eF_insertTableData("groups", $fields_insert)) {
                        eF_printMessage(_SUCCESSFULLYINSERTEDGROUP, true, "success");
                    } else {
                        eF_printMessage(_PROBLEMOCCUREDCHECK);
                    }
                }
            }
            
        } else {
            $new_group_str = '
            <form name = "new_group_form" method = "post" action = "'.$_SERVER['PHP_SELF'].'?action=new_personal">
            <table border = "0" cellpadding = "3" align = "center">
                <tr><td><b>'._NEWGROUPNAME.': </b></td>
                    <td><input type = "text" name = "new_personal_group" /></td></tr>
                <tr><td colspan = "2" align = "center"><input type = "submit" name = "new_personal_group_submit" value = "'._CREATE.'" ></td></tr>
            </table>
            </form>';
        }
    }

    if ($_GET['action'] == 'new_public' && $_SESSION['s_type'] == 'administrator') {        
        if (isset($_POST['new_public_group_submit'])) {
            if ($_POST['new_public_group']) {
                if (!eF_checkParameter($_POST['new_public_group'], 'alnum_with_spaces') || !eF_checkParameter($_POST['select_lesson'], 'id')) {
                    eF_printMessage(_INVALIDPARAMETER);
                } else {
                    $fields_insert = array("name"        => $_POST['new_public_group'],
                                           "users_list"  => "",
                                           "users_LOGIN" => $_SESSION['s_login'],
                                           "lessons_ID"  => $_POST['select_lesson'],
                                           "type"        => 'public');
                    if (eF_insertTableData("groups", $fields_insert)) {
                        eF_printMessage(_SUCCESSFULLYINSERTEDGROUP, true, "success");
                    } else {
                        eF_printMessage(_PROBLEMOCCUREDCHECK);
                    }
                }
            }
            
        } else {
            $directions = eF_getTableData("directions", "name,id");
            $lessons_str = '
                <select name = "select_lesson">
                    <option value = "0">'._ALLLESSONS.'</option>';
            foreach ($directions as $direction) {
                $lessons_str .= '
                    <option value = "-1">---------------------</option>';
                $lessons = eF_getTableData("lessons", "name, id", "directions_ID=".$direction['id']);
                foreach ($lessons as $lesson) {
                    $lessons_str .= '
                        <option value = "'.$lesson['id'].'">&nbsp;&nbsp;'.$lesson['name'].'</option>';
                }
            }
            $lessons_str .= '
                </select>';
            
            $new_group_str = '
            <form name = "new_group_form" method = "post" action = "'.$_SERVER['PHP_SELF'].'?action=new_public">
            <table border = "0" cellpadding = "3" align = "center">
                <tr><td><b>'._NEWGROUPNAME.': </b></td>
                    <td><input type = "text" name = "new_public_group" /></td></tr>
                <tr><td><b>'._AVAILABLEIN.': </b></td>
                    <td>'.$lessons_str.'</td></tr>
                <tr><td colspan = "2" align = "center"><input type = "submit" name = "new_public_group_submit" value = "'._CREATE.'" ></td></tr>
            </table>
            </form>';
        }
    }
    
    if ($_GET['action'] == 'delete_group' && isset($_GET['group']) && eF_checkParameter($_GET['group'], 'id')) {
        $group = eF_getTableData("groups", "users_LOGIN", "id=".$_GET['group']);
        if (sizeof($group) == 0) {
            eF_printMessage(_THISGROUPDOESNOTEXIST);
        } elseif ($_SESSION['s_type'] != 'administrator' && $group[0]['users_LOGIN'] != $_SESSION['s_login']) {
            eF_printMessage(_YOUCANNOTDELETETHISGROUP);
        } else {
            eF_deleteTableData("groups", "id=".$_GET['group']);
            eF_printMessage(_SUCCESSFULLYDELETEDGROUP, true, "success");
        }
    }

    if ($_GET['action'] == 'edit_group' && isset($_GET['group']) && eF_checkParameter($_GET['group'], 'id')) {        
        $group = eF_getTableData("groups", "name, users_LOGIN, type, lessons_ID", "id=".$_GET['group']);
        if (sizeof($group) == 0) {
            eF_printMessage(_THISGROUPDOESNOTEXIST);
        } elseif ($_SESSION['s_type'] != 'administrator' && $group[0]['users_LOGIN'] != $_SESSION['s_login']) {
            eF_printMessage(_YOUCANNOTEDITTHISGROUP);
        } else {
            if (isset($_POST['group_edit_submit'])) {
                if (eF_checkParameter($_POST['group_name'], 'alnum_with_spaces')) {
                    $fields_update = array("name" => $_POST['group_name']);
                    if ($_SESSION['s_type'] == 'administrator') {
                        $fields_update['lessons_ID'] = $_POST['select_lesson'];
                    }
                    eF_updateTableData("groups", $fields_update, "id=".$_GET['group']);
                    eF_printMessage(_SUCCESSFULLYUPDATEDGROUPNAME, true, "success");
                } else {
                    eF_printMessage(_INVALIDGROUPNAME);
                }
            } else {
                $lessons_str = '';
                if ($_SESSION['s_type'] == 'administrator' && $group[0]['type'] == 'public') {
                    $directions = eF_getTableData("directions", "name,id");
                    $lessons_str = '
                    <tr><td><b>'._AVAILABLEIN.': </b></td>
                        <td><select name = "select_lesson">
                            <option value = "0">'._ALLLESSONS.'</option>';
                    foreach ($directions as $direction) {
                        $lessons_str .= '
                            <option value = "-1">---------------------</option>';
                        $lessons = eF_getTableData("lessons", "name, id", "directions_ID=".$direction['id']);
                        foreach ($lessons as $lesson) {
                            $selected = '';
                            if ($lesson['id'] == $group[0]['lessons_ID']) {
                                $selected = 'selected';
                            }
                            $lessons_str .= '
                                <option value = "'.$lesson['id'].'" '.$selected.'>&nbsp;&nbsp;'.$lesson['name'].'</option>';
                        }
                    }
                    $lessons_str .= '
                        </select></td></tr>';                            
                }
                $new_group_str = '
                <form name = "edit_group_form" method = "post" action = "'.$_SERVER['PHP_SELF'].'?action=edit_group&group='.$_GET['group'].'">
                <table border = "0" cellpadding = "3" align = "center">
                    <tr><td><b>'._GROUPNAME.': </b></td>
                        <td><input type = "text" name = "group_name" value = "'.$group[0]['name'].'" /></td></tr>
                    '.$lessons_str.'
                    <tr><td colspan = "2" align = "center"><input type = "submit" name = "group_edit_submit" value = "'._CHANGE.'" ></td></tr>
                </table>
                </form>';
            }
        }
    }
}

if (isset($_SESSION['s_lessons_ID']) && $_SESSION['s_lessons_ID']) {
    $personal_groups = eF_getTableData("groups", "*", "users_LOGIN='".$_SESSION['s_login']."' and (lessons_ID=0 or lessons_ID=".$_SESSION['s_lessons_ID'].")");
    $public_groups   = eF_getTableData("groups", "*", "type='public' and (lessons_ID=0 or lessons_ID=".$_SESSION['s_lessons_ID'].")");
} elseif ($_SESSION['s_type'] != 'administrator') {
    $personal_groups = eF_getTableData("groups", "*", "users_LOGIN='".$_SESSION['s_login']."' and lessons_ID=0");
    $public_groups   = eF_getTableData("groups", "*", "type='public' and lessons_ID=0");
} else {
    $personal_groups = eF_getTableData("groups", "*", "users_LOGIN='".$_SESSION['s_login']."' and type = 'private'");
    $public_groups   = eF_getTableData("groups", "*", "type='public'");
}

if (sizeof($public_groups) > 0) {
    $public_groups_str = '<table border = "0" width = "100%" celpadding = "1">';
    foreach ($public_groups as $group) {
        if (isset($_GET['groups']) && $_GET['groups'] == $group['id']) {
            $public_groups_str .= '<tr><td><b><a href = "'.$_SERVER['PHP_SELF'].'?groups='.$group['id'].'">'.$group['name'].'</a></b></td>';
        } else {
            $public_groups_str .= '<tr><td><a href = "'.$_SERVER['PHP_SELF'].'?groups='.$group['id'].'">'.$group['name'].'</a> </td>';
        }
        if ($_SESSION['s_type'] == 'administrator') {
            $public_groups_str .= '<td width = "100"><a href = "'.$_SERVER['PHP_SELF'].'?action=edit_group&group='.$group['id'].'" style = "color:green">('._EDIT.')</a> <a href = "'.$_SERVER['PHP_SELF'].'?action=delete_group&group='.$group['id'].'" onclick = "return confirm(\''._AREYOUSURETODELETEGROUP.'&quot;'.$group['name'].'&quot;?\')" style = "color:red">('._DELETE.')</a></td></tr>';
        } else {
            $public_groups_str .= '</tr>';
        }
    }
    $public_groups_str .= '</table>';
} else {
    $public_groups_str = _NOPUBLICGROUPSDEFINED;
}

if (sizeof($personal_groups) > 0) {
    $personal_groups_str = '<table border = "0" width = "100%" celpadding = "1">';
    foreach ($personal_groups as $group) {
        if (isset($_GET['groups']) && $_GET['groups'] == $group['id']) {
            $personal_groups_str .= '<tr><td><b><a href = "'.$_SERVER['PHP_SELF'].'?groups='.$group['id'].'">'.$group['name'].'</a></b></td>';
        } else {
            $personal_groups_str .= '<tr><td><a href = "'.$_SERVER['PHP_SELF'].'?groups='.$group['id'].'">'.$group['name'].'</a> </td>';
        }
        $personal_groups_str .= '<td width = "100"><a href = "'.$_SERVER['PHP_SELF'].'?action=edit_group&group='.$group['id'].'" style = "color:green">('._EDIT.')</a> <a href = "'.$_SERVER['PHP_SELF'].'?action=delete_group&group='.$group['id'].'" onclick = "return confirm(\''._AREYOUSURETODELETEGROUP.'&quot;'.$group['name'].'&quot;?\')" style = "color:red">('._DELETE.')</a></td></tr>';
    }
    $personal_groups_str .= '</table>';
} else {
    $personal_groups_str = _NOPERSONALGROUPSDEFINED;
}

$new_public_group_str = '';
if ($_SESSION['s_type'] == 'administrator') {
    $new_public_group_str = '<a href = "'.$_SERVER['PHP_SELF'].'?action=new_public" class = "inner">'._NEWPUBLICGROUP.'</a>';
} 

print '
    <table border = "0" width = "100%" celpadding = "2">
        <tr><td width = "50%" valign = "top">
            '.eF_printInnerTable(_PUBLICGROUPS, $public_groups_str, $new_public_group_str, '', 'users1.png').'
        </td><td width = "50%" valign = "top">
            '.eF_printInnerTable(_PERSONALGROUPS, $personal_groups_str, '<a href = "'.$_SERVER['PHP_SELF'].'?action=new_personal" class = "inner">'._NEWPERSONALGROUP.'</a>', true, 'users3.png').'
        </td></tr>
    </table>
';

if (isset($_GET['groups'])) {
    if (eF_checkParameter($_GET['groups'], 'id')) {
        $res = eF_getTableData("groups", "*", "id=".$_GET['groups']);
        if (sizeof($res) == 0 || ($res[0]['users_LOGIN'] != $_SESSION['s_login'] && $res[0]['type'] != 'public')) {
            eF_printMessage(_YOUCANNOTSEETHISGROUP);
        } else {
            $users_list = unserialize($res[0]['users_list']);
            $administrators = array();
            $professors     = array();            
            $students       = array();
            
            print '
            <br/><br/>
            <table width = "100%" cellpadding = "4" align = "center" border = "1" rules = "none">
                <tr style = "background-color:#dddddd; border-bottom: 1px solid black">
                    <th colspan = "6" align = "center"><b>'._USERSFORGROUP.' &quot;'.$res[0]['name'].'&quot;</b></td></tr>
                <tr style = "background-color:#eeeeee; border-bottom: 1px solid black">
                    <td colspan = "2" align = "center" width = "33%"><b>'._STUDENTS.'</b></td>
                    <td colspan = "2" align = "center" width = "33%" style = "border-left:1px solid black"><b>'._PROFESSORS.'</b></td>
                    <td colspan = "2" align = "center" width = "33%" style = "border-left:1px solid black"><b>'._ADMINISTRATORS.'</b></td></tr>';
                        
            for($i = 0; $i < sizeof($users_list) && isset($users_list[$i]); $i++) {
                $user = eF_getTableData("users", "name, user_type", "login='".$users_list[$i]."'");
                switch ($user[0]['user_type']) {
                    case "administrator":
                        $administrators[] = $users_list[$i];
                        break;
                    case "professor":
                        $professors[] = $users_list[$i];
                        break;
                    case "student":
                        $students[] = $users_list[$i];
                        break;
                    default: break;
                }
                
            }
            
            if ($res[0]['users_LOGIN'] == $_SESSION['s_login']) {
                for ($i = 0; $i < max(sizeof($administrators), sizeof($professors), sizeof($students)); $i++) {
                    fmod($i, 2) ? $color = '#eeeeee' : $color = '#dddddd';
                    print '
                    <tr style = "background-color:'.$color.'">
                        <td align = "center">'.(isset($students[$i]) ? $students[$i].'</td><td><a href = "'.$_SERVER['PHP_SELF'].'?groups='.$_GET['groups'].'&action=delete&user='.$students[$i].'"><img src = "../images/16x16/delete.png" border = "no" alt = '._REMOVEFROMLIST.' title = '._REMOVEFROMLIST.'></a>' : '</td><td>').' </td>
                        <td align = "center" style = "border-left:1px solid black">'.(isset($professors[$i]) ? $professors[$i].'</td><td><a href = "'.$_SERVER['PHP_SELF'].'?groups='.$_GET['groups'].'&action=delete&user='.$professors[$i].'"><img src = "../images/16x16/delete.png" border = "no" alt = '._REMOVEFROMLIST.' title = '._REMOVEFROMLIST.'></a>' : '</td><td>').'</td>
                        <td align = "center" style = "border-left:1px solid black">'.(isset($administrators[$i]) ? $administrators[$i].'</td><td><a href = "'.$_SERVER['PHP_SELF'].'?groups='.$_GET['groups'].'&action=delete&user='.$administrators[$i].'"><img src = "../images/16x16/delete.png" border = "no" alt = '._REMOVEFROMLIST.' title = '._REMOVEFROMLIST.'></a>' : '</td><td>').'</td></tr>';
                }

                $all_students       = eF_getUsers("", "student");
                $non_students       = array_values(array_diff($all_students['login'], $students));
                $all_professors     = eF_getUsers("", "professor");
                $non_professors     = array_values(array_diff($all_professors['login'], $professors));
                $all_administrators = eF_getUsers("", "administrator");
                $non_administrators = array_values(array_diff($all_administrators['login'], $administrators));
                
                $lessons = eF_getTableData("users_to_lessons", "lessons_ID", "users_LOGIN='".$_SESSION['s_login']."'");

                fmod($i, 2) ? $color = '#eeeeee' : $color = '#dddddd';
                print '                
                    <tr style = "background-color:'.$color.'; border-top: 1px solid black">
                        <td colspan = "2" align = "center" valign = "top">
                            <form name = "add_user" method = "post" action = "'.$_SERVER['PHP_SELF'].'?groups='.$_GET['groups'].'">
                            <select name = "user_select">'.eF_printSelect($non_students).'</select> 
                            <input type = "submit" name = "submit_add" value = '._ADD.' style = "border:1px solid black;font-family:verdana;font-size:10px"></td>
                            </form>
                        <td colspan = "2" align = "center" valign = "top" style = "border-left:1px solid black">
                            <form name = "add_user" method = "post" action = "'.$_SERVER['PHP_SELF'].'?groups='.$_GET['groups'].'">
                            <select name = "user_select">'.eF_printSelect($non_professors).'</select> 
                            <input type = "submit" name = "submit_add" value = '._ADD.' style = "border:1px solid black;font-family:verdana;font-size:10px"></td>
                            </form>
                        <td colspan = "2" align = "center" valign = "top" style = "border-left:1px solid black">
                            <form name = "add_user" method = "post" action = "'.$_SERVER['PHP_SELF'].'?groups='.$_GET['groups'].'">
                            <select name = "user_select">'.eF_printSelect($non_administrators).'</select> 
                            <input type = "submit" name = "submit_add" value = '._ADD.' style = "border:1px solid black;font-family:verdana;font-size:10px"></td>
                            </form></tr>';
            } else {
                for ($i = 0; $i < max(sizeof($administrators), sizeof($professors), sizeof($students)); $i++) {
                    fmod($i, 2) ? $color = '#eeeeee' : $color = '#dddddd';
                    print '
                    <tr style = "background-color:'.$color.'">
                        <td align = "center">'.(isset($students[$i]) ? $students[$i].'</td><td width="1%">' : '</td><td width="1%">').' </td>
                        <td align = "center" style = "border-left:1px solid black">'.(isset($professors[$i]) ? $professors[$i].'</td><td width="1%">' : '</td><td width="1%">').'</td>
                        <td align = "center" style = "border-left:1px solid black">'.(isset($administrators[$i]) ? $administrators[$i].'</td><td width="1%">' : '</td><td width="1%">').'</td></tr>';
                }
            }
            
            print '
            </table>
            <br/><br/>';
        }
    } else {
        eF_printMessage(_INVALIDID);
    }
}

print $new_group_str;



?>