<?php
/**
* Manage access rules.
* 
* Here we can add, delete and manage access rules.
* @package efront
* @version 1.0
*/


session_cache_limiter('none');
session_start();

$path = "../libraries/";


include_once $path."configuration.php";

eF_printHeader(); 
//error_reporting(E_ALL);
//echo "<pre>";print_r($_POST);print_r($_GET);

if (isset($_GET['close'])) {                      
    print '<SCRIPT LANGUAGE="JavaScript">self.opener.location="professor.php?ctg=lessons&op=lesson_rules&refresh=1"; window.close();</script>';
}

if (eF_checkUser($_SESSION['s_login'], $_SESSION['s_password'], $_SESSION['s_lessons_ID']) != "professor" || $_SESSION['s_role_options']['content'] != 1) {                               
    header("location:index.php");
    exit;
}

if (isset($_GET['id']) && (eF_checkParameter($_GET['id'], 'uint') === false)) {  
    eF_printMessage(_INVALIDID);
    exit;
}

if (isset($_GET['op']) && $_GET['op'] == "delete") {                                                            //Delete a rule
    eF_deleteTableData("rules", "id=".$_GET['id']);
    eF_printMessage(_SUCCESFULLYDELETEDRULECLOSE5SECONDS);
    eF_printCloseButton();
    print '<META HTTP-EQUIV="refresh" CONTENT="5;URL=add_rule.php?close=true"/>';
    exit;
}
if (isset($_GET['op']) && $_GET['op'] == "change") {                                                            //Change a rule
    if(!isset($_POST['submit'])) {
        $result          = eF_getTableData("rules", "*", "id=".$_GET['id']);
        $users_LOGIN     = $result[0]['users_LOGIN'];
        $content_ID      = $result[0]['content_ID'];
        $rule_type       = $result[0]['rule_type'];
        $rule_content_ID = $result[0]['rule_content_ID'];
        $rule_option     = 100 * $result[0]['rule_option'];
    }
    $submit_name = _RULEUPDATE;
} else {
    $submit_name = _RULEADD;
}


if (isset($_POST['submit'])) {
    $rule_type = $_POST['rule_type'];
    if ($rule_type == "hasnot_passed" AND (!isset($_POST['rule_option']) || !is_numeric($_POST['rule_option']) || $_POST['rule_option'] < 0 || $_POST['rule_option'] > 100)) {     //Check whether a correct score threshold has been set
        $rule_option = "";
        $message     = _RATEMUSTBEBETWEEN0100;
    } elseif ($rule_type == "hasnot_passed" && !isset($_POST['rule_content_ID'])) {
        $message = _YOUCANNOTADDSUCHRULEBECAUSENOTESTSDEFINEDYET;
    } else {
        $fields_insert['users_LOGIN']     = htmlspecialchars($_POST['users_LOGIN'], ENT_QUOTES);
        $fields_insert['content_ID']      = $_POST['content_ID'];
        $fields_insert['rule_type']       = $rule_type;
        $fields_insert['rule_content_ID'] = $_POST['rule_content_ID'];
        isset($_POST['rule_option']) ? $fields_insert['rule_option'] = $_POST['rule_option'] / 100 : '';    //This POST variable exists only when the specific rule type is selected
        
        if ($_POST['id'] == "") {
            $ok = eF_insertTableData("rules",$fields_insert);
        } else {
            $ok = eF_updateTableData("rules",$fields_insert,"id=".$_POST['id']);
        }
        if ($ok) {
            eF_printMessage(_SUCCESFULLYUPDATEDRULECLOSE5SECONDS);
            eF_printCloseButton();
            print '<META HTTP-EQUIV="refresh" CONTENT="5;URL=add_rule.php?close=true"/>';
            exit;
        }
    }
}

eF_printMessage($message); 

$users        = eF_getTableData("users_to_lessons, users", "users_LOGIN", "users_to_lessons.lessons_ID=".$_SESSION['s_lessons_ID']." AND users_to_lessons.users_LOGIN=users.login AND users.user_type='student'", "users_LOGIN");       //Get every student of this lesson
$users_option = '<option value = "*" selected>'._ALLOFTHEM.'</option>';

for ($i = 0; $i < sizeof($users); $i++) {                                               //Show every student in this lesson
    $users_option .= '<option value = "'.$users[$i]['users_LOGIN'].'"';
    if (isset($users_LOGIN) && $users_LOGIN == $users[$i]['users_LOGIN']) {             
        $users_option .= ' selected';                                                   //If we are changing an existing rule, then mark as selected the user for whom this rule is about
    }
    $users_option .= '>'.$users[$i]['users_LOGIN'].'</option>';
}

$tree = eF_getContentTree($nouse, $_SESSION['s_lessons_ID'], 0, false, false);          //Get this lesson's units

$tree_option1 = '';
for ($i = 0; $i < sizeof($tree); $i++) {                                                //Show every unit in this lesson. It is used for single exclusion rules, of the form "exclude <student> from <unit>"
    $name = eF_printContentPrestring($tree[$i]).$tree[$i]['name'];
    $tree_option1 .= '<option value = "'.$tree[$i]['id'].'"';
    if (isset($content_ID) && $content_ID == $tree[$i]['id']) {
        $tree_option1 .= ' selected';                                                   //If we are changing an existing rule, then mark as selected the unit for which this rule is about
    }
    $tree_option1 .='>'.$name.'</option>';
}

$tree_option2 = '';
for ($i = 0; $i < sizeof($tree); $i++) {                                                //Show every unit in this lesson. It is used for double exclusion rules, of the form "exclude <student> from <unit1> if he hasn't seen <unit2>"
    $name = eF_printContentPrestring($tree[$i]).$tree[$i]['name'];
    $tree_option2 .= '<option value = "'.$tree[$i]['id'].'"';
    if (isset($rule_content_ID) && $rule_content_ID == $tree[$i]['id']) {                
        $tree_option2 .= ' selected';                                                   //If we are changing an existing rule, then mark as selected the unit for which this rule is about
    }
    $tree_option2 .='>'.$name.'</option>';
}

$tree_tests = eF_getContentTree($nouse, $_SESSION['s_lessons_ID'], 0, "tests", false);  //Get this lesson's tests\
$tree_tests_option = '';
for ($i = 0; $i < sizeof($tree_tests); $i++) {                                          //Show every test in this lesson. It is used for exclusion rules of the form "exclude <student> from <unit> if he hasn't passed <test>"
    if ($tree_tests[$i]['ctg_type'] == "tests") {
        $tree_tests_option .= '<option value = "'.$tree_tests[$i]['id'].'"';
        if (isset($rule_content_ID) && $rule_content_ID == $tree_tests[$i]['id']) {
            $tree_tests_option .= ' selected';                                          //If we are changing an existing rule, then mark as selected the test for which this rule is about
        }
        $tree_tests_option .='>'.$tree_tests[$i]['name'].'</option>';
    }
}

isset($_GET['op'])   ? $op          = $_GET['op'] : $op = '';                                      //Variable initializations
isset($_GET['id'])   ? $id          = $_GET['id'] : $id = '';

!isset($rule_type)   ? $rule_type   = '' : null;                                                   //Variable initializations
!isset($rule_option) ? $rule_option = '' : null;

$str = '<center><br/><br/><table width="100%">';
if ($op != "change" | $rule_type == "always") {
    $str .= '
    <tr><td>
        <form action = "" method = "post">
        <table>
            <tr><td>'._VALIDFOR.' </td><td><select name="users_LOGIN">'.$users_option.'</select></td></tr>
            <tr><td>'.$TRANSLATION['always'].'</td></tr>
            <tr><td>'._TOBEEXCLUDEDFROMUNIT.' </td><td><select name="content_ID">'.$tree_option1.'</select></td></tr>
        </table>
        <input type = "hidden" name = "rule_type" value = "always"/>
        <input type = "hidden" name = "id" value = "'.$id.'"/>
        <input class = "flatButton" type = "submit" name = "submit" value = "'.$submit_name.'"/>
        </form>
    </td></tr>
    <tr><td class = "horizontalSeparator"></td></tr>';
}

if (($op != "change") | $rule_type=="hasnot_seen") {
    $str .= '
    <tr><td>
        <form action = "" method = "post">
        <table>
            <tr><td>'._VALIDFOR.' </td><td><select name = "users_LOGIN">'.$users_option.'</select></td></tr>
            <tr><td>'.$TRANSLATION['hasnot_seen'].' '._THEUNIT.' </td><td><select name = "rule_content_ID">'.$tree_option2.'</select></td></tr>
            <tr><td>'._THENTOBEEXCLUDEDFROMUNIT.' </td><td><select name = "content_ID">'.$tree_option1.'</select></td></tr>
        </table>
        <input type = "hidden" name = "rule_type" value = "hasnot_seen"/>
        <input type = "hidden" name = "id" value = "'.$id.'"/>
        <input class = "flatButton" type = "submit" name = "submit" value = "'.$submit_name.'"/>
        </form>
    </td></tr>
    <tr><td class = "horizontalSeparator"></td></tr>';
}

if (( ($op != "change") | $rule_type=="hasnot_passed") & (isset($_SESSION['s_lesson_options']['tests']))) {
    $str .= '
        <tr><td>
            <form action = "" method = "post">
            <table>
                <tr><td>'._VALIDFOR.' </td><td><select name = "users_LOGIN">'.$users_option.'</select></td></tr>
                <tr><td>'.$TRANSLATION['hasnot_passed'].' '._THEUNIT.' </td><td><select name = "rule_content_ID">'.$tree_tests_option.'</select></td></tr>
                <tr><td>'._WITHRATEBIGGERTHAN.' </td><td><input type = "text" name = "rule_option" size = "5" value = "'.$rule_option.'"/> %</td></tr>
                <tr><td>'._THENTOBEEXCLUDEDFROMUNIT.' </td><td><select name = "content_ID">'.$tree_option1.'</select></td></tr>
            </table>
            <input type = "hidden" name = "rule_type" value = "hasnot_passed"/>
            <input type = "hidden" name = "id" value = "'.$id.'"/>
            <input class = "flatButton" type = "submit" name = "submit" value = "'.$submit_name.'"/>
            </form>
        </td></tr>';
}

$str .= '
        <tr><td align="center"><input class = "flatButton" type="submit" onClick="javascript:window.location=window.location+\'?close=true\'" value="'._CLOSEWINDOW.'"/></td></tr>
</center>';

echo $str;

?>