/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.widgets;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jpt.common.ui.WidgetFactory;
import org.eclipse.jpt.common.ui.internal.widgets.TriStateCheckBox;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class FormWidgetFactory
implements WidgetFactory {
    private final FormToolkit widgetFactory;

    public FormWidgetFactory(FormToolkit widgetFactory) {
        Assert.isNotNull((Object)widgetFactory, (String)"The widget factory cannot be null");
        this.widgetFactory = widgetFactory;
    }

    protected Composite createBorderContainer(Composite container) {
        return this.createBorderContainer(container, 2, 1);
    }

    protected Composite createBorderContainer(Composite container, int marginHeight, int marginWidth) {
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = marginHeight;
        layout.marginWidth = marginWidth;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        container = this.widgetFactory.createComposite(container);
        container.setLayoutData((Object)gridData);
        container.setLayout((Layout)layout);
        return container;
    }

    public Button createButton(Composite parent, String text) {
        return this.createButton(parent, text, 0);
    }

    protected Button createButton(Composite parent, String text, int style) {
        return this.widgetFactory.createButton(parent, text, 0x800000 | style);
    }

    @Deprecated
    public CCombo createCCombo(Composite parent) {
        return this.createCCombo(parent, 8);
    }

    protected CCombo createCCombo(Composite parent, int style) {
        parent = this.createBorderContainer(parent, 1, 1);
        CCombo combo = new CCombo(parent, style);
        this.widgetFactory.adapt((Control)combo, true, false);
        if (this.widgetFactory.getBorderStyle() == 2048) {
            combo.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        }
        return combo;
    }

    public Button createCheckBox(Composite parent, String text) {
        return this.createButton(parent, text, 32);
    }

    public Combo createCombo(Composite parent) {
        return new Combo(parent, 0x800008);
    }

    public Composite createComposite(Composite parent) {
        return this.widgetFactory.createComposite(parent);
    }

    public DateTime createDateTime(Composite parent, int style) {
        parent = this.createBorderContainer(parent);
        DateTime dateTime = new DateTime(parent, style | 0x800000);
        dateTime.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.widgetFactory.adapt((Control)dateTime, true, false);
        return dateTime;
    }

    @Deprecated
    public CCombo createEditableCCombo(Composite parent) {
        return this.createCCombo(parent, 0);
    }

    public Combo createEditableCombo(Composite parent) {
        Combo combo = new Combo(parent, 0x800000);
        return combo;
    }

    public Group createGroup(Composite parent, String title) {
        Group group = new Group(parent, 0);
        group.setText(title);
        return group;
    }

    public Hyperlink createHyperlink(Composite parent, String text) {
        return this.widgetFactory.createHyperlink(parent, text, 0x800000);
    }

    public Label createLabel(Composite container, String labelText) {
        return this.widgetFactory.createLabel(container, labelText, 64);
    }

    public List createList(Composite container, int style) {
        List list = new List(container, 0x800000 | style);
        list.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        return list;
    }

    public FormText createMultiLineLabel(Composite parent, String labelText) {
        Composite container = this.widgetFactory.createComposite(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        container.setLayoutData((Object)gridData);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 1;
        layout.bottomMargin = 0;
        layout.leftMargin = 0;
        layout.rightMargin = 0;
        layout.topMargin = 0;
        container.setLayout((Layout)layout);
        FormText text = this.widgetFactory.createFormText(container, true);
        text.setLayoutData((Object)new TableWrapData(256));
        text.setText(labelText, false, false);
        return text;
    }

    public Text createMultiLineText(Composite parent) {
        return this.createText(parent, 514);
    }

    public Text createPasswordText(Composite parent) {
        return this.createText(parent, 0x400000);
    }

    public Button createPushButton(Composite parent, String text) {
        return this.createButton(parent, text, 8);
    }

    public Button createRadioButton(Composite parent, String text) {
        return this.createButton(parent, text, 16);
    }

    public Section createSection(Composite parent, int style) {
        return this.widgetFactory.createSection(parent, 0x800000 | style);
    }

    public Spinner createSpinner(Composite parent) {
        parent = this.createBorderContainer(parent);
        Spinner spinner = new Spinner(parent, 0x800000);
        spinner.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.widgetFactory.adapt((Control)spinner, true, false);
        return spinner;
    }

    public Table createTable(Composite parent, int style) {
        Table table = this.widgetFactory.createTable(parent, 0x800 | style);
        table.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        return table;
    }

    public Text createText(Composite parent) {
        return this.createText(parent, 0);
    }

    protected Text createText(Composite parent, int style) {
        return this.widgetFactory.createText(parent, null, 0x800800 | style);
    }

    public Button createTriStateCheckBox(Composite parent, String text) {
        TriStateCheckBox checkBox = new TriStateCheckBox(parent, text, this);
        return checkBox.getCheckBox();
    }

    public FormToolkit getWidgetFactory() {
        return this.widgetFactory;
    }
}

