/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.util;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jpt.common.ui.internal.listeners.SWTPropertyChangeListenerWrapper;
import org.eclipse.jpt.common.ui.internal.util.LabeledControl;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LabeledControlUpdater {
    private LabeledControl labeledControl;

    public LabeledControlUpdater(LabeledControl labeledControl, PropertyValueModel<String> textHolder) {
        this(labeledControl, textHolder, null);
    }

    public LabeledControlUpdater(LabeledControl labeledControl, PropertyValueModel<String> textHolder, PropertyValueModel<Image> imageHolder) {
        this.initialize(labeledControl, textHolder, imageHolder);
    }

    private PropertyChangeListener buildIconListener() {
        return new SWTPropertyChangeListenerWrapper(this.buildIconListener_());
    }

    private PropertyChangeListener buildIconListener_() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                LabeledControlUpdater.this.setImage((Image)e.getNewValue());
            }

            public String toString() {
                return "LabeledControlUpdater.imageListener";
            }
        };
    }

    private PropertyChangeListener buildTextListener() {
        return new SWTPropertyChangeListenerWrapper(this.buildTextListener_());
    }

    private PropertyChangeListener buildTextListener_() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                LabeledControlUpdater.this.setText((String)e.getNewValue());
            }

            public String toString() {
                return "LabeledControlUpdater.textListener";
            }
        };
    }

    private void initialize(LabeledControl labeledControl, PropertyValueModel<String> textHolder, PropertyValueModel<Image> imageHolder) {
        Assert.isNotNull((Object)labeledControl, (String)"The LabeledControl cannot be null");
        this.labeledControl = labeledControl;
        if (textHolder != null) {
            textHolder.addPropertyChangeListener("value", this.buildTextListener());
            this.setText((String)textHolder.getValue());
        }
        if (imageHolder != null) {
            imageHolder.addPropertyChangeListener("value", this.buildIconListener());
            this.setImage((Image)imageHolder.getValue());
        }
    }

    private void setImage(Image icon) {
        this.labeledControl.setImage(icon);
    }

    private void setText(String text) {
        if (text == null) {
            text = "";
        }
        this.labeledControl.setText(text);
    }
}

