/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.NumberIntegerExpressionConverter;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.Type;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkTimeOfDayAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceEclipseLinkTimeOfDayAnnotation
extends SourceAnnotation<Type>
implements EclipseLinkTimeOfDayAnnotation {
    private final DeclarationAnnotationElementAdapter<Integer> hourDeclarationAdapter;
    private final AnnotationElementAdapter<Integer> hourAdapter;
    private Integer hour;
    private final DeclarationAnnotationElementAdapter<Integer> minuteDeclarationAdapter;
    private final AnnotationElementAdapter<Integer> minuteAdapter;
    private Integer minute;
    private final DeclarationAnnotationElementAdapter<Integer> secondDeclarationAdapter;
    private final AnnotationElementAdapter<Integer> secondAdapter;
    private Integer second;
    private final DeclarationAnnotationElementAdapter<Integer> millisecondDeclarationAdapter;
    private final AnnotationElementAdapter<Integer> millisecondAdapter;
    private Integer millisecond;

    public SourceEclipseLinkTimeOfDayAnnotation(JavaResourceNode parent, Type type, DeclarationAnnotationAdapter daa) {
        super(parent, (AnnotatedElement)type, daa);
        this.hourDeclarationAdapter = SourceEclipseLinkTimeOfDayAnnotation.buildHourAdapter(daa);
        this.hourAdapter = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)type, this.hourDeclarationAdapter);
        this.minuteDeclarationAdapter = SourceEclipseLinkTimeOfDayAnnotation.buildMinuteAdapter(daa);
        this.minuteAdapter = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)type, this.minuteDeclarationAdapter);
        this.secondDeclarationAdapter = SourceEclipseLinkTimeOfDayAnnotation.buildSecondAdapter(daa);
        this.secondAdapter = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)type, this.secondDeclarationAdapter);
        this.millisecondDeclarationAdapter = SourceEclipseLinkTimeOfDayAnnotation.buildMillisecondAdapter(daa);
        this.millisecondAdapter = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)type, this.millisecondDeclarationAdapter);
    }

    public String getAnnotationName() {
        return "org.eclipse.persistence.annotations.TimeOfDay";
    }

    public void initialize(CompilationUnit astRoot) {
        this.hour = this.buildHour(astRoot);
        this.minute = this.buildMinute(astRoot);
        this.second = this.buildSecond(astRoot);
        this.millisecond = this.buildMillisecond(astRoot);
    }

    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncHour(this.buildHour(astRoot));
        this.syncMinute(this.buildMinute(astRoot));
        this.syncSecond(this.buildSecond(astRoot));
        this.syncMillisecond(this.buildMillisecond(astRoot));
    }

    public boolean isUnset() {
        return super.isUnset() && this.hour == null && this.minute == null && this.second == null && this.millisecond == null;
    }

    @Override
    public Integer getHour() {
        return this.hour;
    }

    @Override
    public void setHour(Integer hour) {
        if (this.attributeValueHasChanged(this.hour, hour)) {
            this.hour = hour;
            this.hourAdapter.setValue((Object)hour);
        }
    }

    private void syncHour(Integer astHour) {
        Integer old = this.hour;
        this.hour = astHour;
        this.firePropertyChanged("hour", old, astHour);
    }

    private Integer buildHour(CompilationUnit astRoot) {
        return (Integer)this.hourAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getHourTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.hourDeclarationAdapter, astRoot);
    }

    @Override
    public Integer getMinute() {
        return this.minute;
    }

    @Override
    public void setMinute(Integer minute) {
        if (this.attributeValueHasChanged(this.minute, minute)) {
            this.minute = minute;
            this.minuteAdapter.setValue((Object)minute);
        }
    }

    private void syncMinute(Integer astMinute) {
        Integer old = this.minute;
        this.minute = astMinute;
        this.firePropertyChanged("minute", old, astMinute);
    }

    private Integer buildMinute(CompilationUnit astRoot) {
        return (Integer)this.minuteAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getMinuteTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.minuteDeclarationAdapter, astRoot);
    }

    @Override
    public Integer getSecond() {
        return this.second;
    }

    @Override
    public void setSecond(Integer newSecond) {
        if (this.attributeValueHasChanged(this.second, newSecond)) {
            this.second = newSecond;
            this.secondAdapter.setValue((Object)newSecond);
        }
    }

    private void syncSecond(Integer astSecond) {
        Integer old = this.second;
        this.second = astSecond;
        this.firePropertyChanged("second", old, astSecond);
    }

    private Integer buildSecond(CompilationUnit astRoot) {
        return (Integer)this.secondAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getSecondTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.secondDeclarationAdapter, astRoot);
    }

    @Override
    public Integer getMillisecond() {
        return this.millisecond;
    }

    @Override
    public void setMillisecond(Integer millisecond) {
        if (this.attributeValueHasChanged(this.millisecond, millisecond)) {
            this.millisecond = millisecond;
            this.millisecondAdapter.setValue((Object)millisecond);
        }
    }

    private void syncMillisecond(Integer astMillisecond) {
        Integer oldMillisecond = this.millisecond;
        this.millisecond = astMillisecond;
        this.firePropertyChanged("millisecond", oldMillisecond, astMillisecond);
    }

    private Integer buildMillisecond(CompilationUnit astRoot) {
        return (Integer)this.millisecondAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getMillisecondTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.millisecondDeclarationAdapter, astRoot);
    }

    private static DeclarationAnnotationElementAdapter<Integer> buildHourAdapter(DeclarationAnnotationAdapter daa) {
        return new ConversionDeclarationAnnotationElementAdapter(daa, "hour", NumberIntegerExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<Integer> buildMinuteAdapter(DeclarationAnnotationAdapter daa) {
        return new ConversionDeclarationAnnotationElementAdapter(daa, "minute", NumberIntegerExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<Integer> buildSecondAdapter(DeclarationAnnotationAdapter daa) {
        return new ConversionDeclarationAnnotationElementAdapter(daa, "second", NumberIntegerExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<Integer> buildMillisecondAdapter(DeclarationAnnotationAdapter daa) {
        return new ConversionDeclarationAnnotationElementAdapter(daa, "millisecond", NumberIntegerExpressionConverter.instance());
    }
}

