/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm;

import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.core.internal.utility.JDTTools;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.context.XmlContextNode;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkStructConverter;
import org.eclipse.jpt.jpa.eclipselink.core.internal.DefaultEclipseLinkJpaValidationMessages;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.OrmEclipseLinkConverter;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.OrmEclipseLinkConverterClassConverter;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.EclipseLinkOrmFactory;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlConverterHolder;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlNamedConverter;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlStructConverter;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrmEclipseLinkStructConverter
extends OrmEclipseLinkConverterClassConverter<XmlStructConverter>
implements EclipseLinkStructConverter {
    public OrmEclipseLinkStructConverter(XmlContextNode parent, XmlStructConverter xmlConverter) {
        super(parent, xmlConverter);
        this.converterClass = xmlConverter.getConverter();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setConverterClass_(((XmlStructConverter)this.xmlConverter).getConverter());
    }

    @Override
    public void setConverterClass(String converterClass) {
        this.setConverterClass_(converterClass);
        ((XmlStructConverter)this.xmlConverter).setConverter(converterClass);
    }

    public Class<EclipseLinkStructConverter> getType() {
        return EclipseLinkStructConverter.class;
    }

    @Override
    protected TextRange getXmlConverterClassTextRange() {
        return ((XmlStructConverter)this.xmlConverter).getConverterClassTextRange();
    }

    @Override
    protected ReplaceEdit createRenameEdit(IType originalType, String newName) {
        return ((XmlStructConverter)this.xmlConverter).createRenameEdit(originalType, newName);
    }

    @Override
    protected ReplaceEdit createRenamePackageEdit(String newName) {
        return ((XmlStructConverter)this.xmlConverter).createRenamePackageEdit(newName);
    }

    @Override
    protected void validateConverterClass(List<IMessage> messages) {
        IJavaProject javaProject = this.getJpaProject().getJavaProject();
        if (StringTools.stringIsEmpty((String)this.converterClass)) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "CONVERTER_CLASS_DEFINED", this, this.getConverterClassTextRange()));
            return;
        }
        if (!this.converterClassExists(javaProject)) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "CONVERTER_CLASS_EXISTS", new String[]{this.converterClass}, this, this.getConverterClassTextRange()));
            return;
        }
        if (!this.converterClassImplementsInterface(javaProject, "org.eclipse.persistence.platform.database.converters.StructConverter")) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "STRUCT_CONVERTER_CLASS_IMPLEMENTS_STRUCT_CONVERTER", new String[]{this.converterClass}, this, this.getConverterClassTextRange()));
        }
    }

    private boolean converterClassExists(IJavaProject javaProject) {
        return this.converterClass != null && JDTTools.findType((IJavaProject)javaProject, (String)this.converterClass) != null;
    }

    private boolean converterClassImplementsInterface(IJavaProject javaProject, String interfaceName) {
        return this.converterClass != null && JDTTools.typeNamedImplementsInterfaceNamed((IJavaProject)javaProject, (String)this.converterClass, (String)interfaceName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Adapter
    extends OrmEclipseLinkConverter.AbstractAdapter {
        private static final Adapter INSTANCE = new Adapter();

        public static Adapter instance() {
            return INSTANCE;
        }

        private Adapter() {
        }

        public Class<EclipseLinkStructConverter> getConverterType() {
            return EclipseLinkStructConverter.class;
        }

        @Override
        public XmlStructConverter getXmlConverter(XmlConverterHolder xmlConverterContainer) {
            return xmlConverterContainer.getStructConverter();
        }

        public OrmEclipseLinkStructConverter buildConverter(XmlNamedConverter xmlConverter, XmlContextNode parent) {
            return new OrmEclipseLinkStructConverter(parent, (XmlStructConverter)xmlConverter);
        }

        @Override
        protected XmlStructConverter buildXmlConverter() {
            return EclipseLinkOrmFactory.eINSTANCE.createXmlStructConverter();
        }

        @Override
        public void setXmlConverter(XmlConverterHolder xmlConverterContainer, XmlNamedConverter xmlConverter) {
            xmlConverterContainer.setStructConverter((XmlStructConverter)xmlConverter);
        }
    }
}

