/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.relations;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.propertypage.JPADiagramPropertyPage;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.IRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.ManyToManyRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.UnidirectionalRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;

public class ManyToManyUniDirRelation
extends ManyToManyRelation
implements UnidirectionalRelation {
    public ManyToManyUniDirRelation(IJPAEditorFeatureProvider fp, JavaPersistentType owner, JavaPersistentType inverse, String ownerAttributeName, boolean createAttribs, ICompilationUnit ownerCU, ICompilationUnit inverseCU) {
        super(owner, inverse);
        this.ownerAttributeName = ownerAttributeName;
        if (createAttribs) {
            this.createRelation(fp, ownerCU, inverseCU);
        }
    }

    public JavaPersistentAttribute getAnnotatedAttribute() {
        return this.ownerAnnotatedAttribute;
    }

    public void setAnnotatedAttribute(JavaPersistentAttribute annotatedAttribute) {
        this.ownerAnnotatedAttribute = annotatedAttribute;
    }

    private void createRelation(IJPAEditorFeatureProvider fp, ICompilationUnit ownerCU, ICompilationUnit inverseCU) {
        String name = JPAEditorUtil.returnSimpleName(this.inverse.getName());
        String actName = JPAEditorUtil.returnSimpleName(JpaArtifactFactory.instance().getEntityName(this.inverse));
        String nameWithNonCapitalLetter = JPAEditorUtil.decapitalizeFirstLetter(name);
        String actNameWithNonCapitalLetter = JPAEditorUtil.decapitalizeFirstLetter(actName);
        if (JpaArtifactFactory.instance().isMethodAnnotated(this.owner)) {
            nameWithNonCapitalLetter = JPAEditorUtil.produceValidAttributeName(name);
            actNameWithNonCapitalLetter = JPAEditorUtil.produceValidAttributeName(actName);
        }
        nameWithNonCapitalLetter = JPAEditorUtil.produceUniqueAttributeName(this.owner, nameWithNonCapitalLetter);
        actNameWithNonCapitalLetter = JPAEditorUtil.produceUniqueAttributeName(this.owner, actNameWithNonCapitalLetter);
        boolean isMap = JPADiagramPropertyPage.isMapType(this.owner.getJpaProject().getProject());
        this.ownerAnnotatedAttribute = JpaArtifactFactory.instance().addAttribute(fp, this.owner, this.inverse, isMap ? JpaArtifactFactory.instance().getIdType(this.inverse) : null, nameWithNonCapitalLetter, actNameWithNonCapitalLetter, true, ownerCU, inverseCU);
        JpaArtifactFactory.instance().addManyToManyUnidirectionalRelation(fp, this.owner, this.ownerAnnotatedAttribute, isMap);
    }

    public IRelation.RelDir getRelDir() {
        return IRelation.RelDir.UNI;
    }
}

