/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.feature;

import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.impl.DeleteContext;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.features.DefaultDeleteFeature;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.ClickRemoveAttributeButtonFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.i18n.JPAEditorMessages;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.AbstractRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.BidirectionalRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.IRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.UnidirectionalRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.IJPAEditorUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class DeleteRelationFeature
extends DefaultDeleteFeature {
    private static IJPAEditorUtil ut = null;

    public DeleteRelationFeature(IJPAEditorFeatureProvider fp) {
        super((IFeatureProvider)fp);
        ut = fp.getJPAEditorUtil();
    }

    public boolean canDelete(IDeleteContext context) {
        return true;
    }

    public boolean isAvailable(IContext context) {
        return true;
    }

    public boolean canExecute(IContext context) {
        return true;
    }

    protected String getQuestionToUser() {
        return JPAEditorMessages.DeleteRelationFeature_deleteRelationQuestion;
    }

    public void delete(IDeleteContext context) {
        ClickRemoveAttributeButtonFeature feat;
        IRelation relation;
        PictogramElement pe = context.getPictogramElement();
        Object businessObjectForPictogramElement = this.getBusinessObjectForPictogramElement(pe);
        if (businessObjectForPictogramElement != null && !this.getUserDecision(context)) {
            return;
        }
        this.preDelete(context);
        AbstractRelation rel = (AbstractRelation)businessObjectForPictogramElement;
        if (rel instanceof UnidirectionalRelation) {
            relation = (UnidirectionalRelation)((Object)rel);
            feat = new ClickRemoveAttributeButtonFeature(this.getFeatureProvider());
            JavaPersistentAttribute attribute = relation.getAnnotatedAttribute();
            PictogramElement textShape = this.getFeatureProvider().getPictogramElementForBusinessObject(attribute);
            DeleteContext delCtx = new DeleteContext(textShape);
            feat.delete((IDeleteContext)delCtx, false);
        }
        if (rel instanceof BidirectionalRelation) {
            relation = (BidirectionalRelation)((Object)rel);
            feat = new ClickRemoveAttributeButtonFeature(this.getFeatureProvider());
            JavaPersistentAttribute ownerAttribute = relation.getOwnerAnnotatedAttribute();
            PictogramElement ownerAttributeTextShape = this.getFeatureProvider().getPictogramElementForBusinessObject(ownerAttribute);
            DeleteContext deleteOwnerAttributeContext = new DeleteContext(ownerAttributeTextShape);
            feat.delete((IDeleteContext)deleteOwnerAttributeContext, false);
            JavaPersistentAttribute inverseAttribute = relation.getInverseAnnotatedAttribute();
            PictogramElement inverseAttributeTextShape = this.getFeatureProvider().getPictogramElementForBusinessObject(inverseAttribute);
            DeleteContext deleteInverseAttributeContext = new DeleteContext(inverseAttributeTextShape);
            feat.delete((IDeleteContext)deleteInverseAttributeContext, false);
        }
        this.postDelete(context);
    }

    public void postDelete(IDeleteContext context) {
        PictogramElement pe = context.getPictogramElement();
        Object businessObjectForPictogramElement = this.getBusinessObjectForPictogramElement(pe);
        IRelation rel = (IRelation)businessObjectForPictogramElement;
        IWorkbenchPartSite ws = ((IEditorPart)this.getDiagramEditor()).getSite();
        ICompilationUnit cu = this.getFeatureProvider().getCompilationUnit(rel.getOwner());
        ut.organizeImports(cu, (IWorkbenchSite)ws);
        if (rel instanceof BidirectionalRelation) {
            cu = this.getFeatureProvider().getCompilationUnit(rel.getInverse());
            ut.organizeImports(cu, (IWorkbenchSite)ws);
        }
    }

    public IJPAEditorFeatureProvider getFeatureProvider() {
        return (IJPAEditorFeatureProvider)super.getFeatureProvider();
    }

    protected boolean getUserDecision(IDeleteContext context) {
        return MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)JPAEditorMessages.DeleteFeature_deleteConfirm, (String)JPAEditorMessages.DeleteRelationFeature_deleteRelationQuestion);
    }
}

