/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.feature;

import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IMultiDeleteInfo;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.features.DefaultDeleteFeature;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.i18n.JPAEditorMessages;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class DeleteJPAEntityFeature
extends DefaultDeleteFeature {
    private String entityClassName = null;
    private String entityName = null;

    public DeleteJPAEntityFeature(IFeatureProvider fp) {
        super(fp);
    }

    public void delete(final IDeleteContext context) {
        PictogramElement pe = context.getPictogramElement();
        JavaPersistentType jpt = (JavaPersistentType)this.getFeatureProvider().getBusinessObjectForPictogramElement(pe);
        this.entityClassName = jpt.getName();
        this.entityName = JPAEditorUtil.returnSimpleName(JpaArtifactFactory.instance().getEntityName(jpt));
        TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)pe);
        ted.getCommandStack().execute((Command)new RecordingCommand(ted){

            protected void doExecute() {
                DeleteJPAEntityFeature.this.deleteEl(context);
            }
        });
    }

    public void deleteEl(IDeleteContext context) {
        super.delete(context);
    }

    protected void deleteBusinessObject(Object bo) {
        JavaPersistentType jpt = null;
        if (bo instanceof JavaPersistentType) {
            jpt = (JavaPersistentType)bo;
            JpaProject jpaProject = jpt.getJpaProject();
            String name = jpt.getName();
            JpaArtifactFactory.instance().forceSaveEntityClass(jpt, this.getFeatureProvider());
            JpaArtifactFactory.instance().deleteEntityClass(jpt, this.getFeatureProvider());
            if (!JptJpaCorePlugin.discoverAnnotatedClasses((IProject)jpt.getJpaProject().getProject())) {
                JPAEditorUtil.createUnregisterEntityFromXMLJob(jpaProject, name);
            }
        }
    }

    public String getQuestionToUser() {
        return MessageFormat.format(JPAEditorMessages.DeleteJPAEntityFeature_deleteJPAEntityQuestion, this.entityName, this.entityClassName);
    }

    public IJPAEditorFeatureProvider getFeatureProvider() {
        return (IJPAEditorFeatureProvider)super.getFeatureProvider();
    }

    protected boolean getUserDecision(IDeleteContext context) {
        String msg = "";
        IMultiDeleteInfo multiDeleteInfo = context.getMultiDeleteInfo();
        if (multiDeleteInfo != null) {
            msg = JPAEditorMessages.DeleteJPAEntityFeature_deleteJPAEntitiesQuestion;
        } else if (this.entityClassName != null && this.entityClassName.length() > 0) {
            msg = MessageFormat.format(JPAEditorMessages.DeleteJPAEntityFeature_deleteJPAEntityQuestion, this.entityName, this.entityClassName);
        }
        return MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)JPAEditorMessages.DeleteFeature_deleteConfirm, (String)msg);
    }
}

