/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.binary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jpt.common.core.internal.utility.JDTTools;
import org.eclipse.jpt.common.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.common.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.common.utility.internal.iterators.TransformationIterator;
import org.eclipse.jpt.jpa.core.JpaAnnotationProvider;
import org.eclipse.jpt.jpa.core.internal.resource.java.binary.BinaryPackageFragment;
import org.eclipse.jpt.jpa.core.internal.resource.java.binary.RootBinaryNode;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePackageFragment;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePackageFragmentRoot;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BinaryPackageFragmentRoot
extends RootBinaryNode
implements JavaResourcePackageFragmentRoot {
    private final IPackageFragmentRoot packageFragmentRoot;
    private final Vector<JavaResourcePackageFragment> packageFragments = new Vector();

    public BinaryPackageFragmentRoot(IPackageFragmentRoot packageFragmentRoot, JpaAnnotationProvider annotationProvider) {
        super(null, annotationProvider);
        this.packageFragmentRoot = packageFragmentRoot;
        this.packageFragments.addAll(this.buildPackageFragments());
    }

    private Collection<JavaResourcePackageFragment> buildPackageFragments() {
        IJavaElement[] jdtChildren = this.getJDTChildren();
        ArrayList<JavaResourcePackageFragment> result = new ArrayList<JavaResourcePackageFragment>(jdtChildren.length);
        IJavaElement[] iJavaElementArray = jdtChildren;
        int n = jdtChildren.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement child = iJavaElementArray[n2];
            result.add(new BinaryPackageFragment(this, (IPackageFragment)child));
            ++n2;
        }
        return result;
    }

    @Override
    public IFile getFile() {
        return (IFile)this.packageFragmentRoot.getResource();
    }

    @Override
    public void update() {
        super.update();
        this.updatePackageFragments();
    }

    private void updatePackageFragments() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<JavaResourcePersistentType> persistentTypes() {
        return new CompositeIterator(this.persistedTypesLists());
    }

    private Iterator<Iterator<JavaResourcePersistentType>> persistedTypesLists() {
        return new TransformationIterator<JavaResourcePackageFragment, Iterator<JavaResourcePersistentType>>(this.packageFragments()){

            protected Iterator<JavaResourcePersistentType> transform(JavaResourcePackageFragment fragment) {
                return fragment.persistedTypes();
            }
        };
    }

    @Override
    public Iterator<JavaResourcePackageFragment> packageFragments() {
        return new CloneIterator(this.packageFragments);
    }

    @Override
    public int packageFragmentsSize() {
        return this.packageFragments.size();
    }

    private IJavaElement[] getJDTChildren() {
        return JDTTools.getChildren((IParent)this.packageFragmentRoot);
    }
}

